Rem
Rem $Header: rdbms/admin/dbmspdb.sql /st_rdbms_12.1.0.1/7 2013/05/08 21:25:19 krajaman Exp $
Rem
Rem dbmspdb.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmspdb.sql - dbms_pdb utility package
Rem
Rem    DESCRIPTION
Rem      This package containes procedures to examine and manipulate data
Rem      about pluggable databases
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    krajaman    05/06/13 - krajaman_security_bugs_1
Rem    gravipat    04/12/13 - Add public synonym for dbms_pdb
Rem    sankejai    04/01/13 - 16530655: add dbms_pdb.noncdb_to_pdb
Rem    thbaby      02/08/13 - add dbms_pdb.update_cdbvw_stats
Rem    thbaby      01/21/13 - lrg 8818133: sql injection in getlong
Rem    thbaby      01/16/13 - 15827913: add function getlong
Rem    gravipat    01/02/13 - 16040080: change sigature of dbms_pdb.recover
Rem    cxie        11/19/12 - change check_plug_compatibility to take pdb_name
Rem    cxie        09/20/12 - add procedure DBMS_PDB.RECOVER
Rem    thbaby      04/24/12 - add routine to perform smon task
Rem    gravipat    01/09/12 - 12991119: Add procedure check_plug_compatibility
Rem    sursridh    12/05/11 - bug 13425408: add exec_as_oracle_script.
Rem    gravipat    01/26/11 - Created
Rem


create or replace package dbms_pdb authid current_user is

  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  procedure describe(pdb_descr_file varchar2,
                     pdb_name varchar2 DEFAULT NULL);
  -- Generate an XML which describes the various tablespaces and the datafiles
  -- that belong to the pluggable database
  --  Input arguments:
  --    pdb_descr_file - path of the XML file which will contain description
  --                     of a Pluggable Database.
  --    pdb_name - name of a Pluggable Database to be described. If pdb_name
  --               is omitted, the Pluggable Database to which the session
  --               is connected will be described. If pdb_name is omitted,
  --               and the session is connected to the Root, an error will
  --               be returned.

  function check_plug_compatibility(pdb_descr_file IN varchar2,
                                    pdb_name IN varchar2 DEFAULT NULL)
           return boolean;
  -- Determine whether a pluggable database described by file pdb_descr_file
  -- is compatibile with the current cdb
  --  Input arguments:
  --    pdb_descr_file - path of the XML file which will contain description
  --                     of a Pluggable Database.
  --    pdb_name       - name of the Pluggable Database to be used for the
  --                     check. If pdb_name is omitted, PDB name in the
  --                     XML file will be used.  

  procedure exec_as_oracle_script(sql_stmt varchar2);
  -- NAME: 
  --   exec_as_oracle_script - execute a statement as oracle script
  --
  -- DESCRIPTION:
  --   This procedure enables execution of certain restricted statements
  --   (most DDLs) on metadata-linked objects, from within a pdb.  This is
  --   accomplished by running the statement as an oracle script (i.e. with
  --   the parameter _oracle_script set to TRUE).  This is for use by Oracle
  --   internal packages only.
  --
  -- PARAMETERS:
  --   sql_stmt (IN) - sql statement to execute
  --
  -- NOTE
  --   ************************************************************************
  --   ************************************************************************
  --   IMPORTANT, PLEASE READ!
  --   This procedure is not meant to be documented.  It is supplied for use by
  --   Oracle internal packages only to bypass some restrictions for pluggable
  --   databases.  Please talk to the package owners to determine if it is
  --   appropriate to use this procedure in your particular usage scenario.
  --   ************************************************************************
  --   ************************************************************************

  --   The following routine is related to operations done in SMON 
  --   until 11.2. But, with the introduction of PDBs in 12c and with 
  --   the possibility of having multiple PDBs in a single
  --   CDB, we want to move this cleanup out of SMON so that SMON is not 
  --   overloaded with work that can be done in some other background process. 
  --   The goal is to move everything except transaction recovery out of SMON. 

  function cleanup_task(task_id number)
    return number;

  -- NAME:
  -- cleanup_task - cleanup task previously done in SMON
  --
  -- DESCRIPTION:
  --   This procedure performs cleanup task previously done in SMON
  --
  -- PARAMETERS:
  -- task_id  - Task Id
  -- 
  -- RETURNS:
  -- 0 - if the next scheduled time for job does not need to be changed.
  -- N - if the next scheduled time for job should be N seconds from now
  -- 
  -- NOTE
  --   ************************************************************************
  --   ************************************************************************
  --   IMPORTANT, PLEASE READ!
  --   This procedure is not meant to be documented.  It is supplied for use by
  --   Oracle internal scripts only. Please talk to the package owners to 
  --   determine if it is appropriate to use this procedure in your particular 
  --   usage scenario.
  --   ************************************************************************

  procedure sync_pdb;
  -- NAME:
  -- sync_pdb - sync PDB with CDB
  --
  -- DESCRIPTION:
  --   After plug, syncs the PDB with the CDB, so that it will be ready for use.
  --   ************************************************************************

  procedure recover(pdb_descr_file varchar2, pdb_name varchar2, filenames varchar2);
  -- Recover the PDB XML file from datafile headers
  --  Input arguments:
  --    pdb_descr_file - path of the XML file which will contain description
  --                     of a Pluggable Database.
  --    pdb_name - pluggable database name to use in the XML file
  --    filenames - full path of the datafile belongs to the PDB. If there are
  --                multiple datafiles, a comma (ie ',') seperator should be
  --                inserted between two datafile paths.
  --   ************************************************************************

  function update_cdbvw_stats
    return number;

  -- NAME:
  -- update_cdbvw_stats - update CDB View Stats
  --
  -- DESCRIPTION:
  --   This procedure updates CDB View Stats
  --
  -- PARAMETERS:
  -- 
  -- RETURNS:
  -- 0 - if the next scheduled time for job does not need to be changed.
  -- N - if the next scheduled time for job should be N seconds from now
  -- 
  -- NOTE
  --   ************************************************************************
  --   ************************************************************************
  --   IMPORTANT, PLEASE READ!
  --   This procedure is not meant to be documented.  It is supplied for use by
  --   Oracle internal scripts only. Please talk to the package owners to 
  --   determine if it is appropriate to use this procedure in your particular 
  --   usage scenario.
  --   ************************************************************************

  procedure noncdb_to_pdb(phase number);

  -- NAME: 
  --   noncdb_to_pdb - Helper procedure for noncdb_to_pdb.sql
  --
  -- DESCRIPTION:
  --   This procedure is internally used by noncdb_to_pdb.sql
  --
  -- PARAMETERS:
  --   phase  (IN)  - phase of script
  --

end;
/
grant execute on dbms_pdb to execute_catalog_role
/

------------------------- dbms_pdb_exec_sql -----------------------------------
-- NAME: 
--   dbms_pdb_exec_sql - execute a sql statement within pdb
--
-- DESCRIPTION:
--   This procedure is a wrapper around dbms_pdb.exec_as_oracle_script
--
-- PARAMETERS:
--   sql_stmt (IN) - sql statement to execute
--
-- NOTE:
--   Internal developers who need to run restricted sql statements from within
--   PDBs need to use this procedure to do so.
-------------------------------------------------------------------------------
create or replace procedure dbms_pdb_exec_sql (sql_stmt varchar2)
as
begin
  dbms_pdb.exec_as_oracle_script(sql_stmt);
end;
/

create or replace public synonym dbms_pdb_exec_sql for dbms_pdb_exec_sql
/

create or replace function getlong( opcode  in number,
                                    p_rowid in rowid ) return varchar2
as
    l_cursor    integer default dbms_sql.open_cursor;
    l_n         number;
    l_long_val  varchar2(4000);
    l_long_len  number;
    l_buflen    number := 4000;
    l_curpos    number := 0;
begin
    if (opcode = 1) then 
      dbms_sql.parse( l_cursor,
              'select t.TEXT from SYS.VIEW$ t where t.rowid = :x',
              dbms_sql.native );
      dbms_sql.bind_variable( l_cursor, ':x', p_rowid );

      dbms_sql.define_column_long(l_cursor, 1);
      l_n := dbms_sql.execute(l_cursor);

      if (dbms_sql.fetch_rows(l_cursor)>0) then 
        dbms_sql.column_value_long(l_cursor, 1, l_buflen, l_curpos ,
                                   l_long_val, l_long_len );
      end if;
      dbms_sql.close_cursor(l_cursor);
    elsif (opcode = 2) then
      dbms_sql.parse( l_cursor,
              'select t.CONDITION from SYS.CDEF$ t where t.rowid = :x',
              dbms_sql.native );
      dbms_sql.bind_variable( l_cursor, ':x', p_rowid );

      dbms_sql.define_column_long(l_cursor, 1);
      l_n := dbms_sql.execute(l_cursor);

      if (dbms_sql.fetch_rows(l_cursor)>0) then 
        dbms_sql.column_value_long(l_cursor, 1, l_buflen, l_curpos ,
                                   l_long_val, l_long_len );
      end if;
      dbms_sql.close_cursor(l_cursor);
    else
      l_long_val := '';
    end if;

    return l_long_val;
end getlong;
/

create or replace public synonym dbms_pdb for sys.dbms_pdb
/
grant execute on dbms_pdb to execute_catalog_role
/
