Rem
Rem $Header: rdbms/admin/dbmsqopi.sql /main/6 2012/10/15 23:13:45 dkoppar Exp $
Rem
Rem dbmsqopi.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      dbmsqopi.sql - dbms_opatch package specification
Rem
Rem    DESCRIPTION
Rem      Creation of dbms_opatch package specification and sequences
Rem
Rem    NOTES
Rem      .
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dkoppar     10/04/12 - add sqlpatch API
Rem    dkoppar     09/19/12 - #14633786 add xslt
Rem    tbhukya     09/18/12 - Add set_debug
Rem    tbhukya     07/13/12 - Add new apis
Rem    tbhukya     05/08/12 - Add opatch_run_stop_job() api
Rem    tbhukya     06/19/11 - Created
Rem

-- Creation of package dbms_qopatch
CREATE OR REPLACE PACKAGE dbms_qopatch AUTHID DEFINER AS

  xslt      xmltype := NULL;

  -- Refresh opatch inventory
  PROCEDURE refresh_opatch_data;

   --Provides ORACLE_HOME details
  function  get_opatch_install_info   return xmltype;

  --Provides top level patch info for patch
  function  GET_OPATCH_DATA           (pnum IN varchar2) return xmltype;

  --Provides bugs list in a patch or all the patches
  function  GET_OPATCH_BUGS           (pnum IN varchar2 DEFAULT NULL) return xmltype;

  --Provides list of files modified by a patch or all the patches
  function  GET_OPATCH_FILES          (pnum IN varchar2) return xmltype;

  --Provides installed patches total count
  function  GET_OPATCH_COUNT           return xmltype;

  -- Get list of patches installed
  function  GET_OPATCH_LIST           return xmltype;

  --Provides prerequisite patches for a patch
  function  GET_OPATCH_PREQS          (pnum IN varchar2) return xmltype;

  --Provides overlay patches for a patch
  function  GET_OPATCH_OLAYS          (pnum IN varchar2) return xmltype;

  --Detects patch conflicts for given files
  function  PATCH_CONFLICT_DETECTION   (fileName IN varchar2) return xmltype;

  --  Provides list of patches installed
  function  IS_PATCH_INSTALLED        (pnum IN VARCHAR2) return xmltype;

  -- Get sql patch status of all RAC instances
  function GET_PENDING_ACTIVITY return xmltype;

  -- Set current node, instance name in case of RAC
  PROCEDURE set_current_opinst(node_name IN VARCHAR2 DEFAULT NULL,
                               inst_name IN VARCHAR2 DEFAULT NULL);

  -- To call job to refresh the inventory
  PROCEDURE opatch_inv_refresh_job;

  -- To enable and run the job
  PROCEDURE opatch_run_job;

  -- To create jobs on RAC instances
  PROCEDURE config_oinv_jobs;

  -- To get the stylesheet for result presentation
  function  get_opatch_xslt return xmltype;

  --To get the full opatch lsinventory
  function get_opatch_lsinventory return xmltype;

  -- To create job on newly added node
  FUNCTION add_oinv_job(nname VARCHAR2, iname VARCHAR2) RETURN BOOLEAN;

  -- To drop job on deleted node
  FUNCTION drop_oinv_job(nname VARCHAR2, iname VARCHAR2) RETURN BOOLEAN;

  -- Replaces log ans script directories with correct path
  PROCEDURE replace_logscrpt_dirs;
  PROCEDURE replace_dirs_int(pf_id  NUMBER);

  -- sqlpatch description from sql registry
  PROCEDURE get_sqlpatch_status(pnum varchar2 default NULL);

  -- Turn on debug 
  PROCEDURE set_debug(debug IN BOOLEAN);

END dbms_qopatch;
/
