Rem
Rem $Header: rdbms/admin/execsqlt.sql /main/5 2012/11/09 22:15:20 msabesan Exp $
Rem
Rem execsqlt.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      execsqlt.sql - EXECutable code for SQL Tuning to run during catproc
Rem
Rem    DESCRIPTION
Rem      This script contains some procedural logic we run during catproc.
Rem
Rem    NOTES
Rem      This must be called AFTER prvtsqlt is loaded.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    msabesan    11/06/12 - lrg 8469208 non CDB check added with schedular
Rem                           program
Rem    ddas        05/30/12 - #(13790095) add separate checks for auto sqltune
Rem                           and auto SPM evolve
Rem    arbalakr    05/23/12 - lrg 7000350: Ignore 65040 errors while creating
Rem                           sqltune tasks during db creation(for cdb)
Rem    ddas        09/02/11 - Proj 28394: add SPM evolve advisor
Rem    pbelknap    05/26/06 - Created
Rem

Rem Create the automatic SQL Tuning and automatic SPM evolve tasks
Rem   If the tasks already exist (catproc is being re-run), do not error.
begin
  sys.dbms_sqltune_internal.i_create_auto_tuning_task;
exception
  when others then
    if (sqlcode = -13607 OR    -- task already exists
        sqlcode = -65040) -- operation not allowed inside PDB(lrg 7000350)
    then
      null;
    else
      raise;
    end if;
end;
/

begin
  sys.dbms_spm_internal.i_create_auto_evolve_task;
exception
  when others then
    if (sqlcode = -13607)     -- task already exists
    then
      null;
    else
      raise;
    end if;
end;
/

Rem Create our scheduler program
Rem   If the prog already exists (catproc is being re-run), do not error.
begin
  dbms_scheduler.create_program(
    program_name => 'AUTO_SQL_TUNING_PROG',
    program_type => 'PLSQL_BLOCK',
    program_action => 
      'DECLARE 
         ename             VARCHAR2(30);
         exec_task         BOOLEAN;
       BEGIN
         -- check if tuning pack is enabled
         exec_task := prvt_advisor.is_pack_enabled(
                        dbms_management_packs.TUNING_PACK);

         -- check if we are in a pdb, 
         -- since auto sqltune is not run in a pdb
         IF (exec_task AND -- tuning pack enabled
         sys_context(''userenv'', ''con_id'') <> 0 AND -- not in non-cdb
         sys_context(''userenv'', ''con_id'') <> 1  ) THEN -- not in root
           exec_task := FALSE;
         END IF;

         -- execute auto sql tuning task
         IF (exec_task) THEN
           ename := dbms_sqltune.execute_tuning_task(
                      ''SYS_AUTO_SQL_TUNING_TASK'');
         END IF;

         -- check whether we are in non-CDB or a PDB
         -- auto SPM evolve only runs in a non-CDB or a PDB, not the root.
         IF (sys_context(''userenv'', ''con_id'') = 0 OR
             sys_context(''userenv'', ''con_id'') > 2) THEN
           exec_task := TRUE;
         ELSE
           exec_task := FALSE;
         END IF;

         -- execute auto SPM evolve task
         IF (exec_task) THEN
           ename := dbms_spm.execute_evolve_task(''SYS_AUTO_SPM_EVOLVE_TASK'');
         END IF;
       END;',
    number_of_arguments => 0,
    enabled => TRUE,
    comments => 'Program to run automatic sql tuning and SPM evolve tasks, see dbmssqlt.sql and dbmsspm.sql');
exception
  when others then
    if (sqlcode = -27477) then   -- program already exists
      null;
    else
      raise;
    end if;
end;
/
