Rem
Rem $Header: rdbms/admin/execsvrm.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:45 surman Exp $
Rem
Rem execsvrm.sql
Rem
Rem Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      execsvrm.sql - EXECute SerVeR Manageablity PL/SQL blocks
Rem
Rem    DESCRIPTION
Rem      
Rem
Rem    NOTES
Rem      
Rem
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/execsvrm.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/execsvrm.sql
Rem SQL_PHASE: CATPEXEC_MAIN
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpexec.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    surman      03/27/12 - 13615447: Add SQL patching tags
Rem    shjoshi     02/27/12 - Insert row in wrp$_reports_control table
Rem    gravipat    12/05/11 - Create cdbview using CDB$VIEW function
Rem    gngai       09/19/11 - added create_staging_schema
Rem    ilistvin    07/13/11 - create CDB views for dictionary tables
Rem    ilistvin    03/15/11 - set LAST_CHANGE to NULL for Autotask
Rem    ilistvin    11/10/08 - set default thresholds for temp and undo
Rem                           tablespaces
Rem    ilistvin    01/05/07 - move procedure invocations from prvtawr.sql
Rem    ilistvin    11/15/06 - register feature usage here
Rem    ilistvin    11/08/06 - merge in catmwin.sql
Rem    ilistvin    11/08/06 - merge in AUTOTASK init code
Rem    mlfeng      10/31/06 - merge in Alert initialization
Rem    rburns      09/16/06 - execute SVRM packages
Rem    rburns      09/16/06 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

-- Set the default database thresholds
BEGIN
dbms_server_alert.set_threshold(9000,null,null,null,null,1,1,'',5,'');
EXCEPTION
  when others then
    if sqlcode = -00001 then NULL;         -- unique constraint error
    else raise;
    end if;
END;
/
Rem 
Rem For all UNDO and TEMPORARY tablespaces for which there is no
Rem explicit threshold set, create an explicit "Do Not Check" threshold
Rem
DECLARE
  tbsname VARCHAR2(30);
  CURSOR tbs IS
    SELECT tablespace_name 
      FROM dba_tablespaces
     WHERE extent_management = 'LOCAL'
       AND contents IN ('TEMPORARY','UNDO')
       AND tablespace_name NOT IN 
                  (SELECT object_name
                     FROM table(dbms_server_alert.view_thresholds)
                    WHERE object_type = 5
                      AND object_name IS NOT NULL
                      AND metrics_id IN (9000, 9001));
BEGIN
  OPEN tbs;
  LOOP
    FETCH tbs INTO tbsname;
    EXIT WHEN tbs%NOTFOUND;
    BEGIN
      dbms_server_alert.set_threshold(dbms_server_alert.TABLESPACE_PCT_FULL
                                    , dbms_server_alert.OPERATOR_DO_NOT_CHECK
                                    , '<SYSTEM-GENERATED THRESHOLD>'  
                                    , dbms_server_alert.OPERATOR_DO_NOT_CHECK
                                    , '0'  -- critical value
                                    , 0    -- observation period 
                                    , 0    -- consecutive occurrences 
                                    , NULL -- instance name
                                    , dbms_server_alert.OBJECT_TYPE_TABLESPACE
                                    , tbsname);
    EXCEPTION WHEN OTHERS THEN 
      RAISE;
    END;
  END LOOP;
  CLOSE tbs;
EXCEPTION WHEN OTHERS THEN RAISE;
END;
/  
  
-- Register export package as a sysstem export action
DELETE FROM exppkgact$ WHERE package = 'DBMS_SERVER_ALERT_EXPORT'
/
INSERT INTO exppkgact$ (package, schema, class, level#)
  VALUES ('DBMS_SERVER_ALERT_EXPORT', 'SYS', 1, 1000)
/
commit
/


DECLARE
  DUPLICATE_KEY exception;
  pragma EXCEPTION_INIT(DUPLICATE_KEY, -1);
BEGIN
--
-- Initialize AUTOTASK status
-- (dummy_key prevents > 1 row from being inserted)
--
 INSERT INTO KET$_AUTOTASK_STATUS(DUMMY_KEY, AUTOTASK_STATUS,ABA_STATE)
 VALUES (99999, 2, 99);
EXCEPTION
  WHEN DUPLICATE_KEY THEN NULL;
  WHEN OTHERS THEN RAISE;
END;
/

DECLARE
  DUPLICATE_KEY exception;
  pragma EXCEPTION_INIT(DUPLICATE_KEY, -1);
BEGIN
 dbms_auto_task_admin.default_reset('ALL');
EXCEPTION
  WHEN DUPLICATE_KEY THEN NULL;
  WHEN OTHERS THEN RAISE;
END;
/

Rem
Rem Setup the advisor repository
Rem

execute dbms_advisor.setup_repository;


Rem SQL Tuning Advisor initialization of Automatic Task
@@execsqlt.sql

/* register all the features and high water marks */
begin
  DBMS_FEATURE_REGISTER_ALLFEAT;
  DBMS_FEATURE_REGISTER_ALLHWM;
end;
/
--
-- Execute call to register the local DBID in AWR
--
BEGIN
  /* register the local database into AWR */
  dbms_swrf_internal.register_local_dbid;
END;
/

--
-- (Commented out for now)
-- Execute the call to create the SYSAWR user
--
-- BEGIN
--  /* create SYSAWR User */
--  dbms_swrf_internal.create_sysawr_user;
-- END;
-- /

--
-- Execute the call to create the AWR Staging schema.
--
BEGIN
  /* create Staging tables */
  dbms_swrf_internal.create_staging_schema;
END;
/

--
-- Execute the call to insert the baseline details
-- We call this because we introduce the new WRM$_BASELINE_DETAILS table
-- in 11g, and rows need to be inserted during upgrade (catproc.sql)
--
BEGIN
  /* insert the baseline details */
  dbms_swrf_internal.insert_baseline_details;
END;
/

/* AWR Snapshots require CDB view over ts$ */
create or replace view awri$_cdb_ts$ as
          select * from cdb$view(ts$);

grant select on awri$_cdb_ts$ to SELECT_CATALOG_ROLE;

-- insert the row in the wrp reports control table
-- This row indicates the mode of execution of the report capture
-- service, where 0 => Regular and 1 => Full capture
BEGIN
  insert into wrp$_reports_control
    select dbid, 0 from v$database;
EXCEPTION
  when others then
    if sqlcode = -00001 then 
      NULL;             -- unique constraint error
    else 
      raise;
    end if;
END;
/

@?/rdbms/admin/sqlsessend.sql
