@@?/rdbms/admin/sqlsessstart.sql
execute dbms_registry.removing('XDB');
@@catnozxs.sql
drop trigger sys.xdb_installation_trigger;
drop trigger sys.dropped_xdb_instll_trigger;
drop table dropped_xdb_instll_tab;
drop trigger SYS.XDB_PI_TRIG;
drop user xdb cascade;
DECLARE
   c NUMBER;
   CURSOR c1 IS SELECT unique owner, object_name, object_type FROM xdb_installation_tab;
BEGIN
   FOR item IN c1 LOOP
     IF (item.object_type = 'FUNCTION' or
            item.object_type = 'INDEX' or
            item.object_type = 'PACKAGE' or
            item.object_type = 'PACKAGE BODY' or
            item.object_type = 'PROCEDURE' or
            item.object_type = 'SYNONYM' or
            item.object_type = 'TABLE' or
            item.object_type = 'TABLESPACE' or
            item.object_type = 'TYPE' or
            item.object_type = 'VIEW' or
            item.object_type = 'USER' or
            item.object_type = 'TYPE BODY' or
            item.object_type = 'TRIGGER' or
            item.object_type = 'SEQUENCE')
     THEN
       BEGIN
         IF item.owner = 'PUBLIC' and item.object_type = 'SYNONYM' THEN
            execute immediate 'DROP PUBLIC SYNONYM "'||item.object_name||'"';
         ELSIF item.object_type = 'TABLE' THEN
            select count(*) into c from all_objects
            where owner = item.owner and object_name = item.object_name
            and object_type = item.object_type;

            
            
            IF c != 0 or substr(item.object_name,1,8) != 'SYS_TEMP' THEN
               execute immediate 'DROP '||item.object_type||' "'||item.owner||'"."'||item.object_name||'"';
            END IF;
         ELSE    
            execute immediate 'DROP '||item.object_type||' "'||item.owner||'"."'||item.object_name||'"';
         END IF;
       EXCEPTION
           when others then 
              null;
       END;
     ELSE
       raise_application_error(-20000, 'Drop of object in xdb_installation_tab of object '||item.owner||'.'||item.object_name||', type '||item.object_type||' is not handled.');
     END IF;  
   END LOOP;
END;
/
DECLARE
  c number;
BEGIN
  select count(*) into c
  from ALL_SCHEDULER_JOBS
  where JOB_NAME = 'XMLDB_NFS_CLEANUP_JOB';
            
  if c != 0 then
    dbms_scheduler.drop_job('SYS.XMLDB_NFS_CLEANUP_JOB' , true);
  end if;

  select count(*) into c
  from ALL_SCHEDULER_JOB_CLASSES
  where JOB_CLASS_NAME = 'XMLDB_NFS_JOBCLASS';

  if c != 0 then
    dbms_scheduler.drop_job_class('SYS.XMLDB_NFS_JOBCLASS', TRUE);
  end if;
  execute immediate 'delete from noexp$ where name = :1' using 'XMLDB_NFS_JOBCLASS';
end;       
/
drop table xdb_installation_tab;
@@catxdbdv.sql
@?/rdbms/admin/sqlsessend.sql
