@@?/rdbms/admin/sqlsessstart.sql
DECLARE
  blobval BLOB;
  clobval CLOB;
  nclobval NCLOB;
  fpval    NUMBER;
BEGIN
  DBMS_LOB.CREATETEMPORARY(blobval,TRUE);
  DBMS_LOB.CREATETEMPORARY(clobval,TRUE);
  DBMS_LOB.CREATETEMPORARY(nclobval,TRUE);

  DBMS_LOB.WRITE(blobval, 10, 1, UTL_RAW.CAST_TO_RAW('[redacted]'));
  DBMS_LOB.WRITE(clobval, 10, 1, '[redacted]');
  DBMS_LOB.WRITE(nclobval, 10, 1, N'[redacted]');
  
  select fpver into fpval from sys.radm_fptm_lob$;
  
  if fpval = 0 then
    update sys.radm_fptm_lob$
    set blobcol=blobval,
        clobcol=clobval,
        nclobcol=nclobval,
        fpver=1
    where fpver=0;

    commit;
  end if;

  DBMS_LOB.FREETEMPORARY(blobval);
  DBMS_LOB.FREETEMPORARY(clobval);
  DBMS_LOB.FREETEMPORARY(nclobval);
EXCEPTION
  when too_many_rows then
    delete from sys.radm_fptm_lob$
    where fpver < 2;

    insert into sys.radm_fptm_lob$ 
    values (blobval,
            clobval,
            nclobval,
            1);
    commit;
    
    DBMS_LOB.FREETEMPORARY(blobval);
    DBMS_LOB.FREETEMPORARY(clobval);
    DBMS_LOB.FREETEMPORARY(nclobval);
  when no_data_found then
    insert into sys.radm_fptm_lob$ 
    values (blobval,
            clobval,
            nclobval,
            1);
    commit;
    DBMS_LOB.FREETEMPORARY(blobval);
    DBMS_LOB.FREETEMPORARY(clobval);
    DBMS_LOB.FREETEMPORARY(nclobval);
END;
/
CREATE OR REPLACE LIBRARY dbms_redact_lib wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
16
2b 61
Q7rRMxW3WwEtyoW5JnbNK7R/NR4wg04I9Z7AdBjDWqGXYkqW8i6hWdH0cvpZCee9nrLLUjLM
pXQr58tSdAj1Ycmmpnu6skg=

/
CREATE OR REPLACE PACKAGE dbms_redact_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
10dd 36c
iiiy6P66Wm7b9z6FnhZBMFvoXy4wg0OcLiC2fy9ArcHqzufT5t33GNax2qFZNGEB0AXoHwpj
dlfd+5K1Au0Zz1cTVTKJ5TbzbAdfiy2aiBeHICEB1UWmm86lhsS1gc0I+R63tflO9GnaE/Ob
wLuls2B/TZD75h6D9mxXugd8qGRcgUQEI9mnUGnCEFKh4iY4DCciYUIgmHqh/cqRFJY7TG7q
1gFA9l3yHIsyXbByonuo05WJuPB2uhBGe1JkvrdWiyNx9oUz5VMayc2+olSp9MNMKjz9TT5q
v075nuzsDgSvtKwQ7iv9S5+MwEvWyt5swt9+gT5sqUgIS3urW/RlNZs7yxh8hfdjpIoWHaNp
ORlR7sDM8t4BrbmNx6DWLGWif4tf+/pwNkJPqLLpYWgyI+YFEwqTr0t3YCms3j52pxWTrVn9
iZJ4aIRGPIdGqmlAB7YJIZCztfEsboYWnB6yC8fOT3LkQr//3sNrnbj9AOTAYhteE9FuDP5q
WZtxeO6A4OqhYpyDa0/Vtj94CytDpVqHlmI7ny4C/WLFSCw5xmRwc1/prTpkiTLUVQPVMSns
Zs4RT5CNYB5+6YN3NinsxXEuqKDz8WYatZfo2lRHcRYYpL6CkN97lz2XlUIRr6ScUdZxitcr
AdmV56hee5hhSFC8+HS4ZZp8MwERam7ZeF9oUECIsUFeKw9fWbEHn9AnrV2yVBrwQY9IpdEK
IMZVuHFhD/qQ8bi4P+Zcvv8EWDz6I3bVBpHLYcF8phxo72NhcPsQtUD90inTt9FSffGqnxKt
sARVh+lzDFMafJs0jaRCK3aXiOIilK15QlbkAoKAy3e8Ee4IU2c8+CgtCFKK/D0s2VXWaw==


/
show errors;
CREATE OR REPLACE PACKAGE BODY dbms_redact_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
2be5 8a6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/
show errors;
CREATE OR REPLACE PACKAGE BODY dbms_redact wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
3712 77a
WWfoNyIePZD9rjHwEBwXBclrK0wwg82jDCCG3y+5rZ2sB0TTHW0OBQsdHw4+eyvvzOGhbAiH
RmEFC5Z5tSTyCSjAFpcbjRpSNP84a3TBhniCbu4LwiobKM5BUS6NzbPEmrWSsHP4ciCdcwiW
FQaea+zqRsmysOcXk7rq6dwz8l9QLg06jdMxnsKMbGCGrv9Q74uRBzqu7V3BKuAuzAR3wRyV
uKHznlF77Uo+o5aMrKU0p0KV4NjKXLOJilCKW2n0cQVA8zsFlxAu+7EbF3W7BW6hI66+YAET
CaBuyXWFBc31QKvHAS0acaKlJcHsXqg51RfvWogZjsp0jBBcXGl6FT2K8XighFIBm8c7VvGX
dm/9rxyV3kxw5rqoQv+5C8wybMApU7Zfjx+mJufeV7BfUB3ILPsa2/GKfhrQtGEJtYtF3N/S
IhdgiSBzg4UC+9jIaLPcW6gtH8T/J/YSSO2e2sMBHg/SdGImif1ym4tF88O+OjBzOkXHVGGj
wO2rSezVeir3guA9F/yuJtrvtjKdIdh7BC1TWObDVxeRURwOvfBUaFmyxXYEvaZw+r6mF9sG
yRjc7orjjKTRADt5YNiLWb4+LldlNc5jyfO4kfJDXBOEPdBZyj8Nk+OkWKnkIwPKIBqA4rlH
W2I2EA0J4e+c8b6JR0KNX2KrpyaGKbknerDhWOgoCvLcKNhTC2Jx8KyXn/IyPAduLCNLC+2f
idw/tZ6ijK7ptRJZ19250tQmrQHkuIiSQBdq2dMjk36abGS1mgQ52WeqMf1fMWTN2nqGXKQI
L7+aYvOWpYVbU2Qz5bssmgMow0JSxCWiW5rvc8FIntkriY6OTt1rG//HEA9dub3Yn/5DkSbE
gY/mTMWuS73j9NJPKMxi3+3Gn5jSDIOssAWP2ndZ+P/9v5b2drBrh8ShfbGPCs1robouJWCC
6g7yvv2+o7j+8oppGoFJ4iUTtiayBwLNQF3JaqwraiVgasJBPMJvXJEsfCaj5oClY8XRXAgI
5WZ3zCnrsofmFS6wDMG7JToSxP+afkHcTvklOTSg+3I0sn1xcORgcNHSDzRK7cZeqzd/lqXE
efvcEHud0XDC0LDrq+HoEjq0c/szERIWJn+kPdMj619uIzKfvViKBvpd70toDMZ5TOWZvjB9
ZX8XMu8FeZU9pADIK1zvkAj6uAc/2+mEhKEm3ne6GhAO+Gl7Ud4iQKf7BHp/kwKVlF9kXnBT
yw3VBKAOc4bDYHx9Z0mJSu+4Dx97udYmN8h4iu3WvBgoxAuKKVs0gjyZQl4XVCUr/vESwdK3
VaX1coH9PIn9MgJpUTgDihQRkh1hhi7/YekCAdCgpFTvAOPZ5WCcY/ujcUmQlSkN/TshV2I1
fXWQc8IoUN7VnznGymtK2Xao2zXm8BPvNlcD3N0kYq25T47Ll4+RhwmoUpMsrwD6ZN0kbRKX
Q//kGLwrXyMe6sP9EbCndsS3WbgUnsbKUNhqdKVaXgDDQ4AeCwmo5S87cE1cVHTyROd2YkmB
2mLVBP3ayrvSma+UdKN82YlvL3SjfPQNKeJwd+FUO0OeOWJ1DvLZnjmUdW3yROfYpxNCYNnz
X6/h2eLWQ57UcDqjFBpEx4VGr/PdGbQwLPWnELmqbzIx1lf/l5+62Zu2CdAxIgB3mEjNWQig
jIs2zxrPc0Nnvx0U3Ku7pj1HcOwdaNFktxP626RhF58bGGscgmLwXGoh7ufQ7sC22vDigCdg
v/G0MgGZ3jFnl/HkkdmkAUqwViU9979otiVXDVlO8KW0SzP9WasTd5ZL4FULhiZATMWNLoZ7
FThAfVVwtOjgPrpEfW0JEFgjdujjQxTZraFyoQmtMZlaMd2X4BHXlhrF2XHLnMGEv6ZEfPCy
EnlT+O4kaleQKg==

/
show errors;
@?/rdbms/admin/sqlsessend.sql
