SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
WHENEVER SQLERROR EXIT;
DECLARE
  host_port                  NUMBER;
BEGIN
  host_port := dbms_xdb.gethttpport();
END;
/
DECLARE
  epg_attrib                 VARCHAR2(100);
BEGIN
  epg_attrib := dbms_epg.get_global_attribute('log-level');
END;
/
SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM DUAL
WHERE USER != 'SYS';
WHENEVER SQLERROR CONTINUE;
CREATE OR REPLACE PACKAGE dbms_isched_remote_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
55d 299
HaVei8J3Jw8moH65gMZDCO9IRFcwg/C3ACAFfC9A2vjquFmpUYQ8WY5Cp3VagIEwoIZWBzx/
yMs1N1O1LGxiMQmRMfQbDHIQnWS6eRwyvfxD/gWH+YrEZJgfQprtc3PEtw8FzUid6tFWb2JC
Hd/TTS9t1C16zubn5titaFaJl2RN/WlzAyWRxS6/mhKnwtwwl+SrN8mb4fbgLez45YqrWprs
Kzuk6gfqgYrzwFbpiSFBycF/xnuRDo3ijT39lYdEfBx5SiF5iQTdHEntdr2iQTYLXvWGMp05
FaXbwV74hXld+0qIr3J1Ky+xvyzFJ/aV7iVyVWQzASlLiasraaqFnoq9Gh5NG9vy7GVDcFhI
Kqg+C+ZvxP6x6bzZxUlPygxDHXIKaMZBf9IR3Dx1fLb0wD2M/ws8gf3PMpEDatFMsvbX6Kv4
ZcEYG/KDHBy6ITVmmIMIi4AAUGhiWMpK1paVi7nZ44uPDVKx3Gh3pFAZXdWkG79XR5B23fdp
lBmxDghqqzHhVRU541UlWM/3NNsmd0eBYGuxKNpgO8s4zfryY4QqNUHOrAm2lMbnUIXvfotp
kmjEzE+FEqK2lmAUFkxatSW5eifU9A9Nkvqh4lZ47Pl+Rxr1wbYfWUTf9Jow3CJ/OeZTtTMs
rq5p3Q==

/
CREATE OR REPLACE PACKAGE BODY dbms_isched_remote_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
7d4a 227c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==

/
show errors
begin
  
  dbms_epg.create_dad('REMOTE_SCHEDULER_AGENT_DAD',
    '/remote_scheduler_agent/*');
  dbms_epg.set_dad_attribute('REMOTE_SCHEDULER_AGENT_DAD',
    'database-username', 'REMOTE_SCHEDULER_AGENT');
  dbms_epg.set_dad_attribute('REMOTE_SCHEDULER_AGENT_DAD',
    'request-validation-function', 'remote_scheduler_agent.restrict_access');
end;
/
begin
  execute immediate 
    'create user remote_scheduler_agent identified by remote_scheduler_agent';
exception
  when others then
    if sqlcode = -1920 then NULL;
    else raise;
    end if;
end;
/
alter user remote_scheduler_agent account lock ;
alter user remote_scheduler_agent password expire ;
update user$ set password=null,spare4=null where name='REMOTE_SCHEDULER_AGENT';
commit;
grant execute on dbms_isched_remote_access to remote_scheduler_agent;
CREATE OR REPLACE FUNCTION remote_scheduler_agent.restrict_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
1a1 134
t7sl5UY2U9HAnI7dxwyw7OVlDo0wgwLILiisfHRAAE7VI4TT3IetLhZFom1YjzL7bhjMX37b
nbsUJ3Q/gSUazfigIIZfFYlJNvAl6Cby707Cw6PapmoCWuZfZTfxtHY4laJXAeBdN90htjaG
FFio748MF1+23Csd3Qt9KVevUD15UthfaE+e3ngNW4xMLGhgedV5w+9OO+XwHr9GcgjKfuXW
RV3oaBDBXz/Wh73BPIO898PtvDcZcuQd9h5BW2QT3LBarjFzTCaFfH0YV7rgnf2CujTEPsIg
dHYT1q+UX2y45g==

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_job_results wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
4a1 2c5
4MI/cbCNgiXZrkuo5Wavz9y+7K0wgxDxmiCDfC/G/kcPUhKeTTcC5SUh5QB1zvIJlZ8n2nOv
bVzKuljhWNObPCQ/QOYVq90YihS/mphOVUmnFYDsWkbC7Dun/U5JT1hmYgp+Xp/acLHtBP0I
28xIJMpdptCikvv3sUh5wUaocUsKkTS/3gWNGwn98iFBPNlG/brKs2uPsIo/bnWiqACcLGOO
JaVG8MTqVxexztiuHulRhqIsdtx3Byi9xXnmI6OuFiqonbbB/APtOGs5EQUSL8UeZdShhb/i
N0pbLXS+uXtRMJAXPk06ukVNwqCmWOKbLp7+OnSRDTkkD3PXJddlD9rtBf/cVdstoQ93qUpY
ZWubHRpgZrarsggQwyelzPEx3NxR8mY7RQc+mMZO9doHwvZa7A+jBKRlBYgV4IywTMb9M7u9
uyiqz/7dTmCYW+JhmOtNIpYHJSK2NLXgHzavgdfjAu9jZ67W90HCDPIcJqQrG2bP8ci9+Vmx
nQMBOovSj+Wnk3ygDpfflEPv9EWySppAQcG+j4kpeg+WbkESK8dfEQxcHfz5B+C2O/tQAEDX
AGbZOz7AeZsWJ7ufhSyzSgTeA6bl7HLrwuRcAQ+Q7TZPEF/EjbsdekSFNX2mY83CEGQeNHY6
uTJYY217/En7b+mHX903/r9pKPftZdoawfXGsABr11XNnKoy5Wyf

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_job_results2 wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
283 1be
aBZhb7Y3aa4JzGwDm1hEcyBnzrwwgxBp2UgVfC+KWGS0QeEJ2zcLrWz/pzbz2oF7EG5W5+Ly
lFqNxvDQZKiyGmz8HORQiopH3GZEasqN51wDMbsnc5N+9d7lG2QKMTA2YTREwGOENfzSbVfd
A0mTffpYEtScFbHTPkw+q9u+j3RrCrpuYwlBjuGu7i8Z/MeW1DgiYz92Jms6tuOFYc5T486+
KsP6Iffz6guAiR5WeGcxBzHfvj417BDM/VRv/cjX+1QttZcu7dXL/5EiewNkx9h9/S4dJBuk
85l/S/vb5mszBIRR3vah/vFY8GR/RYz/fmSvecfAqpXuM6fE0aMJIPS6A2cup1jlIyCbEsEH
rGR0tpT0//gM43ZGnszTtLcPiuQkOlLt2dczZYEo+9nCFizdN4bzfd4CCdSQeijcKBKvZ9FO
mCALu+i3

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_filewatch_results wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1fb 199
HcrTeYJ0/yTnDfDUfPx9AvradG4wgwLQ19xGZy9GAE6Ozb3ff3qpbnARkdP5bhyi3DYxMVa9
4+5JhzPukEw84/T9wVAHJuLiZGX3ZdLHN3xiIBDa6gdhXk+BaHYKzC4MeK5wiKb0/QtDnu6n
uEK8H16NDBxSk4Oz0JIOvw9oFprRmoNV+0lqaklBEV4Wgtq2evenWEoy6z4Oi00zDLBgL+Us
yUQ3G9YGXzl+fSR7KsRqmL7HdHm1Ih1nbDGcotxWop3TBLAJSWVAot9Dh0cBlKXnmerCadmJ
gPFfDacN3sLNa4T/mzmbrgQOY953IaSnuRk0MKWNOBtCRcKUqBvIly9EN0H6KoGaAzU7nf6L
jQac+8ZSBCyvRuu9fa3mqAYqVwikhChTPbS++OFUDNAx

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.filewatch_request_resend wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
23f 1c2
2R065p0Kovm07Sd273ZjjceHgYcwg43ILUjWfC9A2k6OxPdaXEBKNaTndpXTtNvBifXm81fy
FKvDdCcHes+yvXl7kX31PDrkEJ2Wt2bduO/zM8ajqrlFm2mgkoyx6AM9fV5EglvKbxpTT2am
hqX82cozQ+t2BDGYFpa42Vrz2EZaUMFBAxUf1AcXxbqR8VIqx+mY1faywxz1PbFFRCaaE9yE
kQ3IKIcFiO1hy4e/ua1vf2tIANkXBNqm0mBtuI0Jrxbjf1YU6OY47lv702Jmp3C5Csphc4E5
oTHyhWox0qQKBBZWRTcKBDqNP7aql8mSwnfUiviSUmgEX9UdczIhkFJkelnntfBNq3mPd/Uf
PCgYB98ZuNR5qVjgBtPRxD41tNib8QS5+JLrZFIV+YjbYXmDbFO4Ih07tollpMbYBcdApv4z
fQDPHbm8jNA=

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.unregister_agent wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
24b 1a9
g/etB8gZUbUrSlEuFcEBhqfrgvUwgwLIDCAVfC9GEv9ktEHhCY70HNn6V7p2Ji1eZOvGPhis
a1rzWkBozgjXHea9jfzWEM6fPIK3J5V/lyHm7cefAwB2O9lt8FWkSRymulEhvmmRDgC7Wcev
0l58yvrTNIR660UC84JX5gmhGZm5w6z3qRJdLqjoOZa4iAxkbBUaOOUL3hu8wOmTkw6bBeL8
l3twO8eF/8xxUmi5v0sZ2nXXFZOucyloHjNxeOFQHwKzZmt6G9F8lyobl3D/V4BRfLdFWGzW
e7vgruLtNhmPzoNauF41ULDLRUbXwXPSZI6q7OhFVs3uS+IKgLVWFa5KJvQ9ldIHZ72X53c2
12Jb1bXNPz5hjUyyEoDT9Ui7Qa8H6719zZQN3NE5kXcysTR8uZH5pR12Wexi

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.register_agent wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
245 1b6
La4FizLO5XplELKl9UwTuuNiubgwgxDIACAVfC9A2sHqcbCpjuljC1hfEI9a26G7Wd6wFp5A
ZunKiLTOCLJGuyuBuByHOgj4cdxYoiqoNrtv2dc8OlFxUz1htqZ9XzvzPuYSIjahYn0qJ2b0
kbc4ZgKVD7NG5/BiwxNVYL5wQckanmJUD4wOmb14CKaA9L3LenlOV7DbtNx1OsLlpLiBzcmY
g0IvByNnxmG8aNGx1XVkANIjUmTXFUgkVwnieqb5BlSyCdHTp6tcNXXJb5mobGXG5ibmX8s7
INt7F7V926nau33/IUWcbY9s4YKI0K5OZexIYilgCCjvGVyNBX6LmJKtegCvrvS+LsIDs8OM
N0cnFEDJ7Az6tfpqwJOYMQKSpabtD/h45zidWz8s78wj+RlNhqMT/U2TVroanxdzsCyWjezF


/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.register_agent2 wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3ac 268
j/+mTBDl+kdHETD64k7v7HiGVEAwgxDxryATfI7Uv4tkMNr38nQ7cXs7g68qlkQ7LVjN4h69
a9uOIY4UhKBclywkHahSPE27j9aqm/68/joBrF5fLESss5Yysfa3H5YjBYCZKMruCX/C5nX8
SfMhqGaeVlEWw0VZPszOOQCeN1lDCNtxifM+T1PjTkaFXSTbAqxevuNSYAhl5mBOu87PvTEe
hBN442go+Uq314WYrMOjzwf+Pk458U1WR6KXdxXB6FR4q11FJRNMjLLIqBsvCyfofR6fmQH2
j5J7XxuLD1UjjJehKGci2Xy8uvp6jSGvVx9TBp7H5j7yiPFX/0nH3LxtOv3hu3U31tYD3dZO
X9Z/sXAYfHWGwEaLieFJjh4SrP/OH+iNmIGjv0y+9iKSB0nObeDoCSKu+InKHeLTjtOK+koQ
muqHbzKMeIA9ayVshSwoicbnmo9e0kOLi06+Blgbq+vsZGdheQ8xZKt4qxjUfeBOnpJkzXc3
zevqMltcBYGPu/5KJSbkJDIPNfsTRVYNiFw5O6XEPwIl7PViBtbbv83OS5ooXg4v1f6kbc0w
B6aTetHXuEmKg1oC4IPjfTNqJJvZu5g=

/
begin
  dbms_epg.deauthorize_dad('REMOTE_SCHEDULER_AGENT_DAD');
  dbms_epg.authorize_dad('REMOTE_SCHEDULER_AGENT_DAD',
    'REMOTE_SCHEDULER_AGENT');
end;
/
commit;
DECLARE
  number_pdbs                   NUMBER;
  srcpdb_name                   VARCHAR2(30);
BEGIN
  select count(*) into number_pdbs from v$pdbs;

  IF number_pdbs = 0 THEN
       execute immediate 'alter user anonymous account unlock';
  ELSE
       execute immediate 'select sys_context(''USERENV'',''CON_NAME'') 
                          from dual' into srcpdb_name;
       execute immediate 'alter session set container = CDB$ROOT';
       execute immediate 'alter user anonymous account unlock container=all';
       execute immediate 'alter session set container = ' || srcpdb_name;
  END IF;
END;
/
commit;
