@@?/rdbms/admin/sqlsessstart.sql
create or replace view sys_uncompressed_segs_base
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE, SEGMENT_TYPE_ID, HEADER_FILE, HEADER_BLOCK,
     TABLESPACE_ID, TABLESPACE_NAME, BLOCKSIZE,
     BUFFER_POOL_ID, EXTENTS, BLOCKS,
     RELATIVE_FNO, SEGMENT_FLAGS, SEGMENT_OBJD, segment_objn) 
as
select NVL(u.name, 'SYS'), o.name, o.subname,
       so.object_type, s.type#, s.file#, s.block#,
       ts.ts#, ts.name, ts.blocksize,
       bitand(s.cachehint, 3), s.extents, s.blocks,
       s.file#, NVL(s.spare1,0), 
       decode(bitand(s.spare1, 1), 1, s.hwmincr, o.dataobj#), o.obj#
from sys.user$ u, sys.obj$ o, sys.ts$ ts, sys.sys_objects so, sys.seg$ s
where s.file# = so.header_file
  and s.block# = so.header_block
  and s.ts# = so.ts_number
  and s.ts# = ts.ts#
  and ts.bitmapped <> 0
  and ts.name not in ('SYSTEM', 'SYSAUX') -- exclude admin tablespaces
  and o.obj# = so.object_id
  and bitand(o.flags, 128) != 128 -- exclude bin objects
  and o.owner# = u.user# (+)
  and u.name <> 'SYS' -- exclude sys owned objects
  and s.type# = so.segment_type_id
  and o.type# = so.object_type_id
  and so.object_type in ('TABLE', 'TABLE PARTITION')
  and bitand(s.spare1, 2048) != 2048 -- exclude compressed segments
/
grant select on sys_uncompressed_segs_base to select_catalog_role
/
create or replace view sys_uncompressed_segs (tabowner, tabname, partname, tsname, tbsid,
segsize, segobjd, segobjn, segment_type, total_indexes) as 
select 
  uncmp.owner, uncmp.segment_name, uncmp.partition_name, 
  uncmp.tablespace_name, uncmp.tablespace_id, 
  decode(bitand(segment_flags, 131072), 131072, blocks,
         (decode(bitand(segment_flags,1),1,
         dbms_space_admin.segment_number_blocks(tablespace_id, header_file,
         header_block, segment_type_id, buffer_pool_id, segment_flags,
         segment_objd, blocks), blocks)))*blocksize,
  uncmp.segment_objd, uncmp.segment_objn, 
  uncmp.segment_type,
  count(i.obj#)
from obj$ o, sys_uncompressed_segs_base uncmp, ind$ i
where 
  uncmp.segment_name = o.name and
  o.obj# = i.bo# 
group by 
  uncmp.owner, uncmp.segment_name, uncmp.partition_name, 
  uncmp.tablespacE_name, uncmp.tablespace_id, 
  decode(bitand(segment_flags, 131072), 131072, blocks,
         (decode(bitand(segment_flags,1),1,
         dbms_space_admin.segment_number_blocks(tablespace_id, header_file,
         header_block, segment_type_id, buffer_pool_id, segment_flags,
         segment_objd, blocks), blocks)))*blocksize,
  uncmp.segment_objd, uncmp.segment_objn, uncmp.segment_type
/
grant select on sys_uncompressed_segs to select_catalog_role
/
create or replace package body dbms_space wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
26d69 812d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==


/
show errors;
create or replace package body DBMS_HEAT_MAP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
6f98 1a0f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/
show errors;
@?/rdbms/admin/sqlsessend.sql
