Rem
Rem $Header: rdbms/admin/secconf.sql /st_rdbms_12.1.0.1/1 2013/03/13 09:38:23 amunnoli Exp $
Rem
Rem secconf.sql
Rem
Rem Copyright (c) 2006, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      secconf.sql - SECure CONFiguration script
Rem
Rem    DESCRIPTION
Rem      Secure configuration settings for the database include a reasonable
Rem      default password profile, password complexity checks, audit settings
Rem      (enabled, with admin actions audited), and as many revokes from PUBLIC
Rem      as possible. In the first phase, only the default password profile is
Rem      included.
Rem
Rem
Rem    NOTES
Rem      Only invoked for newly created databases, not for upgraded databases
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    amunnoli    03/05/13 - XbranchMerge amunnoli_bug-16310544 from main
Rem    vpriyans    06/05/12 - Bug 12904308: Audit CREATE DIRECTORY by default
Rem    vpriyans    03/22/12 - Bug 13413683: Rename predefined audit policies
Rem                           and add few more actions and privileges
Rem    nkgopal     09/08/11 - Bug 12794116: Configure Audit based on input
Rem                           argument
Rem    apsrivas    09/30/08 - bug 7428539: Add missing audit settings
Rem    asurpur     06/16/06 - audit changes for sec config 
Rem    rburns      06/12/06 - secure configuration script 
Rem    rburns      06/12/06 - Created
Rem

Rem Secure configuration settings. Currently, only the default password
Rem profile is included, without the password complexity check and has
Rem the recommended audit settings. We will add the revokes from PUBLIC, and 
Rem the password complexity checks.

-- Create password profile without a password complexity routine, for backward
-- compatibility. Add the routine if possible without breaking tests

ALTER PROFILE DEFAULT LIMIT
PASSWORD_LIFE_TIME 180
PASSWORD_GRACE_TIME 7
PASSWORD_REUSE_TIME UNLIMITED
PASSWORD_REUSE_MAX UNLIMITED
FAILED_LOGIN_ATTEMPTS 10
PASSWORD_LOCK_TIME 1
;

-- Turn on auditing options

PROMPT Do you wish to configure 11g style Audit Configuration OR
PROMPT Do you wish to configure 12c Unified Audit Policies?
PROMPT Enter RDBMS_11G for former or RDBMS_UNIAUD for latter

DECLARE
  USER_CHOICE               VARCHAR2(100);
  RDBMS11_CHOICE  CONSTANT  VARCHAR2(20) := 'RDBMS_11G';
  UNIAUD_CHOICE   CONSTANT  VARCHAR2(20) := 'RDBMS_UNIAUD';
BEGIN

  USER_CHOICE := '&1';

  -- Audit policy to audit user account and privilege management
  EXECUTE IMMEDIATE 
    'CREATE AUDIT POLICY ORA_ACCOUNT_MGMT ' ||
                 'ACTIONS CREATE USER, ALTER USER, DROP USER, ' ||
                         'CREATE ROLE, DROP ROLE, ALTER ROLE, ' ||
                         'SET ROLE, GRANT, REVOKE';

  -- Audit policy to audit Database parameter settings
  EXECUTE IMMEDIATE 
    'CREATE AUDIT POLICY ORA_DATABASE_PARAMETER '||
                 'ACTIONS ALTER DATABASE, ALTER SYSTEM, CREATE SPFILE';

  -- Audit policy containing all Secure Configuration audit-options
  EXECUTE IMMEDIATE 
    'CREATE AUDIT POLICY ORA_SECURECONFIG ' ||
                 'PRIVILEGES ALTER ANY TABLE, CREATE ANY TABLE, ' ||
                            'DROP ANY TABLE, CREATE ANY PROCEDURE, ' ||
                            'DROP ANY PROCEDURE, ALTER ANY PROCEDURE, '||
                            'GRANT ANY PRIVILEGE, ' ||
                            'GRANT ANY OBJECT PRIVILEGE, GRANT ANY ROLE, '||
                            'AUDIT SYSTEM, CREATE EXTERNAL JOB, ' || 
                            'CREATE ANY JOB, CREATE ANY LIBRARY, ' ||
                            'EXEMPT ACCESS POLICY, CREATE USER, ' ||
                            'DROP USER, ALTER DATABASE, ALTER SYSTEM, '||
                            'CREATE PUBLIC SYNONYM, DROP PUBLIC SYNONYM, ' ||
                            'CREATE SQL TRANSLATION PROFILE, ' ||
                            'CREATE ANY SQL TRANSLATION PROFILE, ' ||
                            'DROP ANY SQL TRANSLATION PROFILE, ' ||
                            'ALTER ANY SQL TRANSLATION PROFILE, ' ||
                            'TRANSLATE ANY SQL, ' ||
                            'CREATE ANY SQL TRANSLATION PROFILE, ' ||
                            'DROP ANY SQL TRANSLATION PROFILE, ' ||
                            'ALTER ANY SQL TRANSLATION PROFILE, ' ||
                            'TRANSLATE ANY SQL, EXEMPT REDACTION POLICY, ' ||
                            'PURGE DBA_RECYCLEBIN, LOGMINING, ' ||
                            'ADMINISTER KEY MANAGEMENT ' ||
                 'ACTIONS ALTER USER, CREATE ROLE, ALTER ROLE, DROP ROLE, '||
                         'SET ROLE, CREATE PROFILE, ALTER PROFILE, ' ||
                         'DROP PROFILE, CREATE DATABASE LINK, ' ||
                         'ALTER DATABASE LINK, DROP DATABASE LINK, '||
                         'LOGON, LOGOFF, CREATE DIRECTORY, DROP DIRECTORY, '||
                         'CREATE PLUGGABLE DATABASE, ' ||
                         'DROP PLUGGABLE DATABASE, '||
                         'ALTER PLUGGABLE DATABASE ';

  IF USER_CHOICE = RDBMS11_CHOICE THEN
    -- 11g Secure Audit Configuration

    EXECUTE IMMEDIATE 'AUDIT ALTER ANY TABLE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE ANY TABLE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DROP ANY TABLE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE ANY PROCEDURE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DROP ANY PROCEDURE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER ANY PROCEDURE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT GRANT ANY PRIVILEGE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT GRANT ANY OBJECT PRIVILEGE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT GRANT ANY ROLE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT AUDIT SYSTEM BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE EXTERNAL JOB BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE ANY JOB BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE ANY LIBRARY BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE PUBLIC DATABASE LINK BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT EXEMPT ACCESS POLICY BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER USER BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE USER BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ROLE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE SESSION BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DROP USER BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER DATABASE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER SYSTEM BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DROP PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DATABASE LINK BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT SYSTEM AUDIT BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT PUBLIC SYNONYM BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT SYSTEM GRANT BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE SQL TRANSLATION PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT CREATE ANY SQL TRANSLATION PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DROP ANY SQL TRANSLATION PROFILE BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ALTER ANY SQL TRANSLATION PROFILE BY ACCESS'; 
    EXECUTE IMMEDIATE 'AUDIT TRANSLATE ANY SQL BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT PURGE DBA_RECYCLEBIN BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT LOGMINING BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT EXEMPT REDACTION POLICY BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT ADMINISTER KEY MANAGEMENT BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT DIRECTORY BY ACCESS';
    EXECUTE IMMEDIATE 'AUDIT PLUGGABLE DATABASE BY ACCESS';

  ELSIF USER_CHOICE = UNIAUD_CHOICE THEN
    -- 12c Secure Audit Configuration

     -- Enable ORA_SECURECONFIG for all users
     EXECUTE IMMEDIATE 'AUDIT POLICY ORA_SECURECONFIG';

  ELSE
    DBMS_OUTPUT.PUT_LINE('Invalid Input "' || USER_CHOICE ||
                         '". Please try again');
  END IF;

END;
/


