Rem
Rem $Header: rdbms/admin/tsdpend.sql /st_rdbms_12.1.0.1/1 2013/01/03 10:52:45 surman Exp $
Rem
Rem tsdpend.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      tsdpend.sql - TSDP END script
Rem
Rem    DESCRIPTION
Rem      This script registers the XML schemas for TSDP.
Rem
Rem    NOTES
Rem      Called by catpend.sql
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/tsdpend.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/tsdpend.sql
Rem SQL_PHASE: TSDPEND
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpend.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      12/10/12 - XbranchMerge surman_bug-12876907 from main
Rem    surman      11/14/12 - 12876907: Add ORACLE_SCRIPT
Rem    surman      04/12/12 - 13615447: Add Add SQL patching tags
Rem    dgraj       03/19/12 - ER 13485095: Make SENSITIVE_INFO optional for
Rem                           sensitivedata_12_1.xsd
Rem    dgraj       10/31/11 - Project 32079: Transparent Sensitive Data
Rem                           Protection (TSDP)
Rem    dgraj       10/31/11 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql


BEGIN

  begin
  -- Register the schema for Sensitive Data
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://xmlns.oracle.com/sdm/sensitivedata_12_1.xsd',
    SCHEMADOC => '<schema elementFormDefault="qualified"
                          targetNamespace="http://xmlns.oracle.com/sdm/sensitive_data_12.1"
                          xmlns="http://www.w3.org/2001/XMLSchema"
                          xmlns:tsdm="http://xmlns.oracle.com/sdm/sensitive_data_12.1">

<!-- annotation>
	<documentation xml:lang="en">
		Sensitive Data import.	
		Copyright Oracle 2011. All rights reserved.
	</documentation>
</annotation -->

	<element name="DDRM" type="tsdm:DDRMType"/>
		<complexType name="DDRMType">
			<sequence>
				<element name="NAME" 	 	   type="string"/>
				<element name="APP_SUITE_NAME"   type="string"/>
				<element name="VERSION_INFO" 	   type="string"/>
				<element name="SOURCE" 	 	   type="string"/>
				<element name="SENSITIVE_TYPE"   type="tsdm:SENSITIVE_TYPEType" minOccurs="0" maxOccurs="unbounded"/>
				<element name="APPLICATION" 	   type="tsdm:APPLICATIONType" minOccurs="0" maxOccurs="unbounded"/>
			</sequence>
			<attribute name="META_VER" type="string" use="optional"/>
			<attribute name="PROD_VER" type="string" use="optional"/>
		</complexType>

<!-- annotation>
	<documentation xml:lang="en">
		SENSITIVE_TYPE defines a sensitive type.
	</documentation>
</annotation -->

	<complexType name="SENSITIVE_TYPEType">
		<sequence>
			<element name="NAME"   			type="string"/>
			<element name="OWNER"  			type="string"/>
			<element name="COL_NAME_PATTERN"  	type="string"/>
			<element name="COL_COMMENT_PATTERN" type="string"/>
			<element name="DATA_REGEX"  		type="string"/>
			<element name="DESCRIPTION"	  	type="string"/>
			<element name="OPERATOR"	  	type="string"/>
		</sequence>
		<attribute name="IS_SYS_DEFINED" use="optional">
			<simpleType>
				<restriction  base="string">
					<enumeration value = "Y"/>
					<enumeration value = "N"/>
				</restriction>
			</simpleType>
		</attribute>
	</complexType> 

<!-- annotation>
	<documentation xml:lang="en">
		APPLICATION contains the list of sensitive columns for an Application/Schema
	</documentation>
</annotation -->

	<element name="APPLICATION" type="tsdm:APPLICATIONType"/>
		<complexType name="APPLICATIONType">
			<sequence>
				<element name="NAME"    	      type="string" /> 
				<element name="SHORT_NAME"    	type="string" /> 
				<element name="SCHEMA_NAME"    	type="string" /> 
				<element name="SOURCE" 		   	type="string" />
				<element name="SENSITIVE_INFO"     	type="tsdm:SENSITIVE_INFOType" maxOccurs="unbounded"/>
			</sequence>
		</complexType>

<!-- annotation>
	<documentation xml:lang="en">
		SENSITIVE_INFO defines a sensitive column.
	</documentation>
</annotation -->

	<complexType name="SENSITIVE_INFOType">
		<sequence>
			<element name="SHORT_NAME"   type="string"/>
			<element name="COMMENT"      type="string"/>
			<element name="TABLE_NAME"    type="string"/>
			<element name="COLUMN"    type="string"/>
			<element name="SOURCE"    type="string"/>
			<element name="TYPE"    type="string"/>
		</sequence>
	</complexType>          
                    
</schema>',
 LOCAL     => FALSE,
 GENTYPES  => TRUE,
 GENTABLES => FALSE,
 ENABLEHIERARCHY => DBMS_XMLSCHEMA.ENABLE_HIERARCHY_NONE);


-- Register the schema for Sensitive Column Types
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://xmlns.oracle.com/sdm/sensitivetypes_12_1.xsd',
    SCHEMADOC => '<schema elementFormDefault="qualified"
                          targetNamespace="http://xmlns.oracle.com/sdm/sensitive_types_12.1"
                          xmlns="http://www.w3.org/2001/XMLSchema"
                          xmlns:tsdm="http://xmlns.oracle.com/sdm/sensitive_types_12.1">

<!-- annotation>
	<documentation xml:lang="en">
		Sensitive Types import.	
		Copyright Oracle 2011. All rights reserved.
	</documentation>
</annotation -->

	<element name="DDRM" type="tsdm:DDRMType"/>
		<complexType name="DDRMType">
			<sequence>
				<element name="NAME" 	 	   type="string"/>
				<element name="APP_SUITE_NAME"   type="string"/>
				<element name="VERSION_INFO" 	   type="string"/>
				<element name="SOURCE" 	 	   type="string"/>
				<element name="SENSITIVE_TYPE" 	type="tsdm:SENSITIVE_TYPEType" minOccurs="1" maxOccurs="unbounded"/>
			</sequence>
			<attribute name="META_VER" type="string" use="optional"/>
			<attribute name="PROD_VER" type="string" use="optional"/>
		</complexType>           
       
<!-- annotation>
	<documentation xml:lang="en">
		SENSITIVE_TYPE defines a sensitive type.
	</documentation>
</annotation -->

	<complexType name="SENSITIVE_TYPEType">
		<sequence>
			<element name="NAME"   			type="string"/>
			<element name="OWNER"  			type="string"/>
			<element name="COL_NAME_PATTERN"  	type="string"/>
			<element name="COL_COMMENT_PATTERN" type="string"/>
			<element name="DATA_REGEX"  		type="string"/>
			<element name="DESCRIPTION"	  	type="string"/>
			<element name="OPERATOR"	  	type="string"/>
		</sequence>
		<attribute name="IS_SYS_DEFINED" use="optional">
			<simpleType>
				<restriction  base="string">
					<enumeration value = "Y"/>
					<enumeration value = "N"/>
				</restriction>
			</simpleType>
		</attribute>
	</complexType>    

</schema>',
 LOCAL     => FALSE,
 GENTYPES  => TRUE,
 GENTABLES => FALSE,
 ENABLEHIERARCHY => DBMS_XMLSCHEMA.ENABLE_HIERARCHY_NONE);

exception
  when others then
   null;

end;

END;
/



@?/rdbms/admin/sqlsessend.sql
