Rem
Rem $Header: rdbms/admin/utl32k.sql /st_rdbms_12.1.0.1/2 2013/03/29 00:51:50 geadon Exp $
Rem
Rem utl32k.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      utl32k.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    geadon      02/26/13 - bug 16237862: long col names for describe_columns
Rem    geadon      09/24/12 - bug 13824121: fix PROPS$ property name
Rem    geadon      03/14/12 - bug 13332548: enforce utl32k upgrade for
Rem                           max_sql_string_size
Rem    geadon      12/28/11 - script to set MAX_SQL_STRING_SIZE=EXTENDED
Rem    geadon      12/28/11 - Created
Rem

Rem Exit immediately if Any failure in this script
WHENEVER SQLERROR EXIT;

alter session set current_schema = SYS;

DOC
#######################################################################
#######################################################################
   The following statement will cause an "ORA-01722: invalid number"
   error if the database has not been opened for UPGRADE.  

   Perform a "SHUTDOWN ABORT"  and 
   restart using UPGRADE.
#######################################################################
#######################################################################
#
SELECT TO_NUMBER('MUST_BE_OPEN_UPGRADE') FROM v$instance
WHERE status != 'OPEN MIGRATE';

DOC
#######################################################################
#######################################################################
   The following statement will cause an "ORA-01722: invalid number"
   error if the database does not have compatible >= 12.0.0

   Set compatible >= 12.0.0 and retry.
#######################################################################
#######################################################################
#

DECLARE
  dummy number;
BEGIN
  SELECT CASE WHEN TO_NUMBER(SUBSTR(value,1,2)) < 12
              THEN TO_NUMBER('COMPATIBLE_12.1.0_REQUIRED')
              ELSE NULL
              END INTO dummy
  FROM v$parameter WHERE name = 'compatible';
END;
/

alter session set "_oracle_script" = TRUE;

---------------------------------------------------------------------------
-- invalidate views that have VARCHAR or NVARCHAR columns >= 4000 bytes or 
-- RAW columns >= 2000 bytes because these columns could change when
-- 32k VARCHAR2, NVARCHAR2, and RAW are enabled.

update obj$ o
  set status = 6
  where type# IN (4)
    and status not in (5, 6)
    and bitand(flags, 196608) = 0                     /* not a common object */
    and exists (select * from col$ c
                  where c.obj# = o.obj# 
                    and ( (c.type# = 1 and c.length >= 4000) or
                          (c.type# = 23 and c.length >= 2000) ));

commit;

alter system flush shared_pool;

---------------------------------------------------------------------------
-- invalidate views and synonyms that depend on views that have been
-- invalided

begin
  loop
    update obj$ o_outer set status = 6
    where     type# in (4, 5)
          and status not in (5, 6)
          and bitand(flags, 196608) = 0               /* not a common object */
          and linkname is null
          and ((subname is null) or (subname <> 'DBMS_DBUPGRADE_BABY'))
          and exists (select o.obj# from obj$ o, dependency$ d
                      where     d.d_obj# = o_outer.obj#
                            and d.p_obj# = o.obj#
                            and (bitand(d.property, 1) = 1)
                            and o.status > 1);
    exit when sql%notfound;
  end loop;
end;
/

commit;

alter system flush shared_pool;

---------------------------------------------------------------------------
-- Now, update virtual columns if their length has changed as a result
-- of enabling 32k types.

alter session set "_modify_column_index_unusable" = TRUE;

DECLARE
  cursor candidate_columns is
    select u.name UNAME,
           o.name TNAME,
           o.obj# OBJ#,
           DECODE(c.type#,
                    1, DECODE(c.charsetform, 2, 'NVARCHAR2', 'VARCHAR2'),
                   23, 'RAW') DATA_TYPE,
           c.spare3 DATA_LEN,
           decode(bitand(c.property, 8388608), 0, 'BYTE', 'CHAR') CHAR_USED,
           c.name CNAME,
           c.intcol# INTCOL#,
           decode(c.segcol#, 0, 'Y', 'N') VIRTUAL,
           decode(bitand(t.flags, 262144), 0, 'N', 'Y') MV
     from sys.tab$ t, sys.obj$ o, sys.user$ u, sys.col$ c
     where t.obj# = o.obj# and o.owner# = u.user# and c.obj# = t.obj#
       and bitand(o.flags, 196608) = 0               -- not a common object
       and (c.segcol# = 0 or                      -- virtual column
            bitand(c.property, 8388608) != 0 or   -- CHAR length semantics
            bitand(t.flags, 262144) != 0)         -- materialized view tbl
       and ( (c.type# = 1  and c.length >= 4000) or
             (c.type# = 23 and c.length >= 2000) );

  schema_table varchar2(512);         /* "SCHEMA"."TABLE" for SQL generation */
  data_type    varchar2(128);
  cur          integer;
  col_cnt      integer;
  len          integer;
  off          integer;
  discard      integer;
  str          varchar2(32767);
  strlen       integer;
  col_desc     DBMS_SQL.DESC_TAB;
  col_expr     clob;
  sqlstr       clob;
  long_chunk_sz constant int := 256;
BEGIN
  cur := DBMS_SQL.OPEN_CURSOR;

  for target in candidate_columns loop
    schema_table := DBMS_ASSERT.ENQUOTE_NAME(target.UNAME, FALSE) || '.'
                 || DBMS_ASSERT.ENQUOTE_NAME(target.TNAME, FALSE);

    IF (target.virtual = 'Y') THEN
      DBMS_SQL.PARSE(cur,
        'select deflength, default$ from col$ where obj# = :1 and name = :2',
        DBMS_SQL.NATIVE);
      DBMS_SQL.BIND_VARIABLE(cur, ':1', target.obj#);
      DBMS_SQL.BIND_VARIABLE(cur, ':2', target.cname);
      DBMS_SQL.DEFINE_COLUMN(cur, 1, len);
      DBMS_SQL.DEFINE_COLUMN_LONG(cur, 2);
      discard := DBMS_SQL.EXECUTE(cur);
      discard := DBMS_SQL.FETCH_ROWS(cur);

      DBMS_SQL.COLUMN_VALUE(cur, 1, len);
      col_expr := '';
      off := 0;
      WHILE len > 0 LOOP
        DBMS_SQL.COLUMN_VALUE_LONG(cur, 2, long_chunk_sz, off, str, strlen);
        col_expr := col_expr || str;
        off := off + strlen;
        len := len - strlen;
      END LOOP;

      /* Bug 16237862: use an alias for the column to avoid column
       * name overflow errors in dbms_sql.describe_columns.
       */
      sqlstr := 'SELECT ' || col_expr || ' expr FROM ' || schema_table;
      DBMS_SQL.PARSE(cur, sqlstr, DBMS_SQL.NATIVE);
      DBMS_SQL.DESCRIBE_COLUMNS(cur, col_cnt, col_desc);

      data_type := target.DATA_TYPE || '(' || col_desc(1).col_max_len || ')';  

    ELSIF (target.mv = 'Y') THEN
      DBMS_SQL.PARSE(cur,
        'select sumtextlen, sumtext from sys.sum$ where containerobj# = :1',
        DBMS_SQL.NATIVE);
      DBMS_SQL.BIND_VARIABLE(cur, ':1', target.obj#);
      DBMS_SQL.DEFINE_COLUMN(cur, 1, len);
      DBMS_SQL.DEFINE_COLUMN_LONG(cur, 2);
      discard := DBMS_SQL.EXECUTE(cur);
      discard := DBMS_SQL.FETCH_ROWS(cur);

      DBMS_SQL.COLUMN_VALUE(cur, 1, len);
      sqlstr := '';
      off := 0;
      WHILE len > 0 LOOP
        DBMS_SQL.COLUMN_VALUE_LONG(cur, 2, long_chunk_sz, off, str, strlen);
        sqlstr := sqlstr || str;
        off := off + strlen;
        len := len - strlen;
      END LOOP;

      execute immediate
        'alter session set current_schema = '
        || DBMS_ASSERT.ENQUOTE_NAME(target.UNAME, FALSE);

      DBMS_SQL.PARSE(cur, sqlstr, DBMS_SQL.NATIVE);
      DBMS_SQL.DESCRIBE_COLUMNS(cur, col_cnt, col_desc);

      data_type := target.DATA_TYPE 
                || '(' || col_desc(target.intcol#).col_max_len || ')';  

      execute immediate
       'alter session set current_schema = SYS';

    ELSE
      IF (target.DATA_TYPE = 'NVARCHAR2') THEN
        data_type := target.DATA_TYPE 
                  || '(' || target.DATA_LEN || ')';
      ELSE
        data_type := target.DATA_TYPE 
                  || '(' || target.DATA_LEN || ' ' || target.CHAR_USED || ')';
      END IF;
    END IF;

    sqlstr := 'ALTER TABLE ' || schema_table 
           || ' MODIFY (' || DBMS_ASSERT.ENQUOTE_NAME(target.CNAME, FALSE)
           || ' ' || data_type || ')';
    dbms_output.put_line(sqlstr);
    EXECUTE IMMEDIATE sqlstr;
      
  end loop;

  DBMS_SQL.CLOSE_CURSOR(cur);
END;
/
show errors;

alter session set "_modify_column_index_unusable" = FALSE;

-- update PROPS$ to indicate that we've completed migration in this container
DECLARE
  mss_typ    binary_integer;    -- type of max_string_size parameter
  mss_len    binary_integer;    -- length of max_string_size parameter
  mss_prm    varchar2(80);      -- max_string_size parameter
BEGIN
  -- get the MAX_STRING_SIZE parameter
  mss_typ := SYS.DBMS_UTILITY.GET_PARAMETER_VALUE('MAX_STRING_SIZE',
                                                  mss_len, mss_prm);

  update props$ set value$ = mss_prm where name = 'MAX_STRING_SIZE';
END;
/

commit;

---------------------------------------------------------------------------
-- Finally, recompile all invalid objects
alter package sys.dbms_registry_sys compile;
@@utlrp

Rem Continue even if there are SQL errors 
WHENEVER SQLERROR CONTINUE;  

