Rem
Rem $Header: rdbms/admin/utlusts.sql /st_rdbms_12.1.0.1/1 2013/01/12 21:15:13 jerrede Exp $
Rem
Rem utlusts.sql
Rem
Rem Copyright (c) 2004, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      utlusts.sql - UTiLity Upgrade STatuS
Rem
Rem    DESCRIPTION
Rem      Presents Post-upgrade Status in either TEXT or XML
Rem
Rem    NOTES
Rem      Invoked by utlu112s.sql with TEXT parameter
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jerrede     01/10/13 - Fix Bug 16097914 Update registry with OPTION OFF
Rem                           for RUL and EXF Components
Rem    jerrede     12/09/11 - Parallel Upgrade Change Status from Valid to
Rem                           Upgraded
Rem    jerrede     11/01/11 - Fix bug 13252372
Rem    mdietric    03/23/11 - remove gathering stats - bug 11901407
Rem    cmlim       03/17/11 - bug 11842119: support version 12.1
Rem    jerrede     03/10/11 - Fix bug #11837389
Rem    cmlim       03/01/11 - display latest status from dba_registry
Rem    cdilling    12/01/08 - change banner to 11.2
Rem    cdilling    04/18/07 - add stats gathering time
Rem    rburns      08/14/06 - limit error output lines
Rem    cdilling    06/08/06 - add support for error logging 
Rem    rburns      05/24/06 - parallel upgrade 
Rem    rburns      07/21/04 - add elapsed time 
Rem    rburns      06/22/04 - rburns_pre_upgrade_util
Rem    rburns      06/16/04 - Created
Rem

SET SERVEROUTPUT ON
SET VERIFY OFF

DECLARE

   display_mode       VARCHAR2(4) := '&1';
   display_xml        BOOLEAN := FALSE;
   comp_name          registry$.cname%type;
   prev_comp_name   registry$.cname%type := 'Oracle Server';
   p_id               registry$.cid%type;
   status             VARCHAR2(30);
   catproc_status     number    := 0;
   catalog_status     number    := 0;
   start_time         TIMESTAMP; 
   end_time           TIMESTAMP; 
   up_start_time      TIMESTAMP := NULL;
   up_end_time        TIMESTAMP := NULL; 
   actions_start_time TIMESTAMP := NULL;
   actions_end_time   TIMESTAMP := NULL;
   message            VARCHAR2(128);
   elapsed_time       INTERVAL DAY TO SECOND(9) := 
                      INTERVAL '0 00:00:00.00' DAY TO SECOND; 
   time_result        VARCHAR2(30);
   b_no_data_found    BOOLEAN := FALSE;  -- No Data Found (flag) in dba_registry
                                         -- when looking up component

BEGIN
   IF display_mode = 'XML' THEN
      display_xml := TRUE;
      DBMS_OUTPUT.PUT_LINE('<RDBMSUP version="12.1">');
      DBMS_OUTPUT.PUT_LINE('<Components>');
   ELSE
      DBMS_OUTPUT.PUT_LINE('.');
      DBMS_OUTPUT.PUT_LINE(
             'Oracle Database 12.1 Post-Upgrade Status Tool    ' ||
             LPAD(TO_CHAR(SYSDATE, 'MM-DD-YYYY HH24:MI:SS'),26));
      DBMS_OUTPUT.PUT_LINE('.');
      DBMS_OUTPUT.PUT_LINE(RPAD('Component', 40) || RPAD('Current',16) ||
              RPAD('Version', 9) || RPAD('Elapsed Time', 15));
      DBMS_OUTPUT.PUT_LINE(RPAD('Name', 40) || RPAD('Status',16) ||
              RPAD('Number', 9) || RPAD('HH:MM:SS', 15));
      DBMS_OUTPUT.PUT_LINE('.');
   END IF;

   BEGIN
      -- get upgrade start/end times
      SELECT optime INTO up_start_time 
      FROM dba_registry_log
      WHERE comp_id='UPGRD_BGN';
      start_time := up_start_time;
	
      SELECT optime INTO up_end_time 
      FROM dba_registry_log
      WHERE comp_id='UPGRD_END';

      -- get 'final actions' start/end times
      SELECT optime INTO actions_start_time 
      FROM dba_registry_log
      WHERE comp_id='ACTIONS_BGN';
	
      SELECT optime INTO actions_end_time 
      FROM dba_registry_log
      WHERE comp_id='ACTIONS_END';

      -- get RDBMS end time
      SELECT optime, operation, message INTO end_time, status, message
      FROM dba_registry_log
      WHERE comp_id='RDBMS' AND 
            optime = (SELECT MAX(optime) FROM dba_registry_log
                      WHERE comp_id = 'RDBMS');

      -- get RDBMS (catproc) status
      SELECT status INTO catproc_status 
      FROM registry$
      WHERE cid = 'CATPROC';

      -- get RDBMS (catalog) status
      SELECT status INTO catalog_status 
      FROM registry$
      WHERE cid = 'CATALOG';

   EXCEPTION
      WHEN NO_DATA_FOUND THEN NULL;
   END;
  
   IF start_time IS NOT NULL AND end_time IS NOT NULL THEN
      elapsed_time := end_time - start_time;
      time_result := to_char(elapsed_time);
   ELSE
      time_result := NULL;
   END IF;

   IF display_xml THEN
       DBMS_OUTPUT.PUT_LINE ('<Component id="Oracle Server"' ||
                   '" cid="RDBMS"' ||
                   '">');
   ELSE
      DBMS_OUTPUT.PUT_LINE(rpad('Oracle Server',35));
   END IF;

   FOR err in (SELECT message FROM sys.registry$error
               WHERE (identifier = 'CATALOG' OR identifier = 'CATPROC')
               AND    ROWNUM < 25
               ORDER BY timestamp)
   LOOP
      IF display_xml THEN
         DBMS_OUTPUT.PUT_LINE ('"error="' || err.message || '" ');
      ELSE
         DBMS_OUTPUT.PUT_LINE('.   ' || err.message);
      END IF;
   END LOOP; -- registry$error loop

   --
   -- Set initial status to catproc_status as the default.
   -- This will set the RDBMS Server as Upgraded (catupgrd.sql)
   -- or Valid (utlrp), if we succeeded.
   -- 
   status := sys.dbms_registry.status_name(catproc_status);

   --
   -- If either catproc or catalog are invalid then mark
   -- the RDBMS Server as Invalid.
   --
   IF (catproc_status = 0 OR catalog_status = 0) THEN
       status := sys.dbms_registry.status_name(0);
   END IF;


   IF display_xml THEN
       DBMS_OUTPUT.PUT_LINE ('" status="' || status ||
                   '" upgradeTime="' || substr(time_result,5,8) ||
                   '">');
   ELSE
      DBMS_OUTPUT.PUT_LINE('.' ||
                        LPAD(status,46) || ' ' ||
                        LPAD(substr(message,1,15),15) ||
                        LPAD(substr(time_result,5,8),10));
   END IF;

   -- look for all SERVER components 
   FOR i IN 1..SYS.dbms_registry_server.component.last LOOP
      p_id := dbms_registry_server.component(i);
      IF p_id != 'ODM' THEN  -- ODM has status REMOVED
         start_time := NULL;
         end_time := NULL;
         FOR log IN (SELECT operation, optime, message
               FROM dba_registry_log WHERE namespace = 'SERVER' AND
               comp_id = p_id ORDER BY optime) LOOP

            comp_name :=  dbms_registry.comp_name(p_id);

            --
            -- Always display component name but only when
            -- the component changes.  In dba_registry_log
            -- you will have component with multiple operations.
            -- For example JAVAVM is the p_id (component) and
            -- START and VALID are the operations.
            -- We only display the corresponding component
            -- name associated with the p_id once.  In this
            -- example the component name is JServer JAVA Virtual
            -- Machine that is assocatied with the p_id JAVAVM.
            --
            IF (prev_comp_name != comp_name) THEN
               prev_comp_name :=  comp_name;
               IF display_xml THEN
                  DBMS_OUTPUT.PUT_LINE ('<Component id="' || comp_name ||
                         '" cid="' || p_id || '" ');
               ELSE
                  DBMS_OUTPUT.PUT_LINE(rpad(comp_name,35));
               END IF;
            END IF;

            IF log.operation = 'START' THEN
               start_time := log.optime;

	       -- For each Component output up to 25 upgrade errors	
               FOR err in (SELECT message FROM sys.registry$error
                           WHERE identifier = p_id AND ROWNUM < 25
                           ORDER BY timestamp) LOOP
                  IF display_xml THEN
                    DBMS_OUTPUT.PUT_LINE ('"error="' || err.message || '" ');
                  ELSE
                     DBMS_OUTPUT.PUT_LINE('.   ' || err.message);
                  END IF;
               END LOOP; -- registry$error loop
            ELSE
               BEGIN
                 SELECT status into status
                 FROM dba_registry
                 WHERE namespace = 'SERVER' AND comp_id = p_id;
                 EXCEPTION
                   WHEN NO_DATA_FOUND THEN
                     b_no_data_found := TRUE;
               END;

               --
               -- Check for No Data found in dba_registry
               -- If Component does not exist in the database
               -- Move to the next component
               --
               IF (b_no_data_found) THEN
                   b_no_data_found := FALSE;
                   continue;
               END IF;

               --
               -- No Start time then no elapsed time
               -- Set time results to display zero
               --
               IF (start_time IS NULL) THEN

                 time_result := '    00:00:00';

               ELSE

                 elapsed_time := log.optime - start_time;
                 time_result := to_char(elapsed_time);

               END IF;

               IF display_xml THEN
                  DBMS_OUTPUT.PUT_LINE ('" status="' || LOWER(status) ||
                         '" upgradeTime="' || substr(time_result,5,8) ||
                         '">');
               ELSE
                  DBMS_OUTPUT.PUT_LINE('.' ||
                                    LPAD(status,46) || ' ' ||
                                    LPAD(substr(log.message,1,15),15) ||
                                    LPAD(substr(time_result,5,8),10));
               END IF;
            END IF;
        
         END LOOP;  -- log loop 
      END IF;  -- not ODM
   END LOOP;  -- component loop

   IF actions_end_time IS NOT NULL THEN
      elapsed_time := actions_end_time - actions_start_time; 
      time_result := to_char(elapsed_time);
      IF display_xml THEN
         DBMS_OUTPUT.PUT_LINE ('<Component id="Final Actions"' ||
                   '" cid="ACTIONS"');
      ELSE
         DBMS_OUTPUT.PUT_LINE(rpad('Final Actions',35));
      END IF;
      -- For 'Final Actions' phase -  output up to 25 upgrade errors	
      FOR err in (SELECT message FROM sys.registry$error
                  WHERE identifier = 'ACTIONS' AND ROWNUM < 25
                  ORDER BY timestamp) LOOP
          IF display_xml THEN
             DBMS_OUTPUT.PUT_LINE ('"error="' || err.message || '" ');
          ELSE
             DBMS_OUTPUT.PUT_LINE('.   ' || err.message);
          END IF;
      END LOOP; -- registry$error loop
      -- Output final actions time
      IF display_xml THEN
         DBMS_OUTPUT.PUT_LINE (
                         '" upgradeTime="' || substr(time_result,5,8) ||
                         '">');
      ELSE
         DBMS_OUTPUT.PUT_LINE('.' ||
                              LPAD(' ',46) || ' ' ||
                              LPAD(' ',15) ||
                              LPAD(substr(time_result,5,8),10));
      END IF;
   END IF; -- actions_end_time is not null

   IF up_end_time IS NOT NULL THEN
      elapsed_time := up_end_time - up_start_time; 
      time_result := to_char(elapsed_time); 
      IF display_xml THEN
         DBMS_OUTPUT.PUT_LINE('<totalUpgrade time="' || 
                  substr(time_result, 5,8) || '">');
      ELSE
         DBMS_OUTPUT.PUT_LINE('Total Upgrade Time: ' || 
                  substr(time_result, 5,8));
      END IF;
   ELSE
      IF display_xml THEN
            DBMS_OUTPUT.PUT_LINE('<Upgrade incomplete/>');
      ELSE
         DBMS_OUTPUT.PUT_LINE('Upgrade Incomplete');
      END IF;
   END IF;
      IF display_xml THEN
       DBMS_OUTPUT.PUT_LINE('</Components>');
         DBMS_OUTPUT.PUT_LINE('</RDBMSUP>');
      END IF;
END;
/

SET SERVEROUTPUT OFF
SET VERIFY ON
