Rem
Rem
Rem xdbeu112.sql
Rem
Rem Copyright (c) 2011, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      xdbeu112.sql - XDB User data downgrade
Rem
Rem    DESCRIPTION
Rem      This script downgrades XDB User Data to 11.2.0
Rem
Rem    NOTES
Rem      It is invoked from the top-level XDB downgrade script (xdbe112.sql)
Rem      and from the 10.2 data downgrade script (xdbeu111.sql)
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    prthiaga    10/26/12 - LRG-7246788: No need to re-register xmltr schema
Rem    stirmizi    04/11/12 - re-register xdblog, ftplog, httplog, xmltr
Rem    stirmizi    04/11/12 - re-create xdb$workspace
Rem    stirmizi    04/11/12 - registration of XInclude.xsd added
Rem    molagapp    16/08/11 - lrg# 5062435
Rem    juding      07/29/11 - bug 12622803: move
Rem                                         drop function sys.getUserIdOnTarget
Rem                                         to xdbes112.sql
Rem    juding      07/29/11 - bug 12622803: add split of xdbe112.sql
Rem    thbaby      07/21/11 - remove white-list
Rem    swerthei    06/23/11 - recovery server downgrade
Rem    spetride    06/20/11 - drop sys.getUserIdOnTarget
Rem    yxie        05/06/11 - remove em express servlet
Rem    yxie        05/06/11 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

Rem ================================================================
Rem BEGIN XDB downgrade for XDB Repository export/ import
Rem ================================================================

create or replace type sv as varray(18) of varchar2(2000);
/

declare
  stmt_tbl   sv := sv('XDB.XDB$SCHEMA_EXPORT_VIEW_TBL',
                      'XDB.XDB$RESOURCE_EXPORT_VIEW_TBL',
                      'DBA_TYPE_XMLSCHEMA_DEP_TBL',
                      'DBA_XML_SCHEMA_DEPENDENCY_TBL',
                      'xdb.xdb$simple_type_view_tbl',
                      'xdb.xdb$complex_type_view_tbl',
                      'xdb.xdb$all_model_view_tbl',
                      'xdb.xdb$choice_model_view_tbl',
                      'xdb.xdb$sequence_model_view_tbl',
                      'xdb.xdb$group_def_view_tbl',
                      'xdb.xdb$group_ref_view_tbl',
                      'xdb.xdb$attribute_view_tbl',
                      'xdb.xdb$element_view_tbl',
                      'xdb.xdb$any_view_tbl',
                      'xdb.xdb$anyattr_view_tbl',
                      'xdb.xdb$attrgroup_def_view_tbl',
                      'xdb.xdb$attrgroup_ref_view_tbl',
                      'SYS.XML_TABNAME2OID_VIEW_TBL');
  stmt_view  sv := sv('XDB.XDB$SCHEMA_EXPORT_VIEW',
                      'XDB.XDB$RESOURCE_EXPORT_VIEW',
                      'DBA_TYPE_XMLSCHEMA_DEP',
                      'xdb.xdb$simple_type_view',
                      'xdb.xdb$complex_type_view',
                      'xdb.xdb$all_model_view',
                      'xdb.xdb$choice_model_view',
                      'xdb.xdb$sequence_model_view',
                      'xdb.xdb$group_def_view',
                      'xdb.xdb$group_ref_view',
                      'xdb.xdb$attribute_view',
                      'xdb.xdb$element_view',
                      'xdb.xdb$any_view',
                      'xdb.xdb$anyattr_view',
                      'xdb.xdb$attrgroup_def_view',
                      'xdb.xdb$attrgroup_ref_view',
                      'SYS.XML_TABNAME2OID_VIEW');
  i      number;
  stmt   varchar2(2000);
  previous_version varchar2(30);
begin
  select prv_version into previous_version
  from registry$
  where cid = 'XDB';

  /* If XDB was installed during a upgrade, previous_version will be NULL.
   * When that happens, get previous_version from CATPROC.
   */
  if previous_version is NULL
  then
    select prv_version into previous_version
    from registry$
    where cid = 'CATPROC';
  end if;

  if not (previous_version like '11.2.0.2%' or
          previous_version like '11.2.0.1%' or
          previous_version like '11.2.0.0%' or
          previous_version like '11.1%' or
          previous_version like '11.0%' or
          previous_version like '10.%' or
          previous_version like '9.%')
  then
    return;
  end if;

  for i in 1..18 loop
    begin
      stmt := 'drop table ' || upper(stmt_tbl(i));
      --dbms_output.put_line(stmt);
      execute immediate stmt;
      exception
         when OTHERS then
            null;
    end; 
  end loop;
  for i in 1..17 loop
    begin
      stmt := 'drop view ' || upper(stmt_view(i));
      --dbms_output.put_line(stmt);
      execute immediate stmt;
      exception
         when OTHERS then
            null;
    end;    
  end loop;

  begin
    stmt := 'delete from sys.impcalloutreg$ where tgt_schema = ''' || 
            'XDB' || ''' ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
  begin
    stmt := 'delete from sys.exppkgact$ where package = ''' || 
            'DBMS_XDBUTIL_INT' || ''' and schema=''' || 'XDB' || ''' ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
end;
/

begin
  execute immediate 'drop type sv';
exception
   when others then
     NULL;
end;
/


Rem ================================================================
Rem END XDB downgrade for XDB Repository export/ import
Rem ================================================================

Rem ==== Create xdb.xdb$workspace ==================================
declare
  exist number;
begin
  select count(*) into exist from DBA_TABLES where table_name = 'XDB$WORKSPACE'
  and owner = 'XDB';

  if exist = 0 then
    execute immediate
        'create table xdb.xdb$workspace(wsname        varchar2(1024),
                                        wsid          raw(16),
                                        vr_wsid       raw(16),
                                        flags         raw(4),
                                        vh_bitmap     blob,
                                        res_bitmap    blob,
                                        vh_to_res_map blob,
                                        checkout_set  blob)';
  end if;
end;
/

Rem ================================================================
Rem BEGIN XDBCONFIG file downgrade
Rem ================================================================

Rem
Rem Add report framework servlet and delete EM Express servlet
Rem

declare
  cfg_data XMLTYPE;
  scount   NUMBER := 0;
begin
  cfg_data := dbms_xdb.cfg_get();

  -- Add Report framework servlet mapping
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''ReportFmwkServlet'']')  
    INTO scount 
    FROM dual;

  IF (scount = 0) THEN
    SELECT appendchildxml(
                cfg_data, 
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings', 
                xmltype(
                  '<servlet-mapping xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">  
                     <servlet-pattern>/orarep/*</servlet-pattern>
                     <servlet-name>ReportFmwkServlet</servlet-name>
                   </servlet-mapping>'))
      INTO cfg_data
      FROM dual;
  END IF;

  -- Add Report framework servlet 
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''ReportFmwkServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 0) THEN
    SELECT appendchildxml(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list',
                xmltype(
                  '<servlet xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
                     <servlet-name>ReportFmwkServlet</servlet-name>
                     <servlet-language>C</servlet-language>
                     <display-name>REPT</display-name>
                     <description>Servlet for accessing reports</description>
                     <security-role-ref>
                       <role-name>authenticatedUser</role-name>
                       <role-link>authenticatedUser</role-link>
                     </security-role-ref>
                   </servlet>'))
      INTO cfg_data
      FROM dual;
  END IF;


  -- Delete EM Express servlet mapping
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''EMExpressServlet'']')  
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''EMExpressServlet'']')
      INTO cfg_data
      FROM dual; 
  END IF;


  -- Delete EM Express serlvet
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''EMExpressServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''EMExpressServlet'']')
       INTO cfg_data
       FROM dual; 
  END IF;

  SELECT existsNode(
            cfg_data,
            '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
            '/servletconfig/servlet-mappings/' ||
            'servlet-mapping[servlet-name=''ORSServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
             cfg_data,
             '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
             '/servletconfig/servlet-mappings/' ||
             'servlet-mapping[servlet-name=''ORSServlet'']')
    INTO   cfg_data
    FROM   dual;
  END IF;

  SELECT existsNode(
            cfg_data,
            '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
            '/servletconfig/servlet-list/' ||
            'servlet[servlet-name=''ORSServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
              cfg_data,
              '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
              '/servletconfig/servlet-list/' ||
              'servlet[servlet-name=''ORSServlet'']')
    INTO   cfg_data
    FROM   dual;
  END IF;

  -- update xdbconfig file
  dbms_xdb.cfg_update(cfg_data);

end;
/

COMMIT;

Rem
Rem Remove white-list
Rem

declare
  cfg_data XMLTYPE;
  scount   NUMBER := 0;
begin
  cfg_data := dbms_xdb.cfg_get();
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/white-list')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/white-list')
       INTO cfg_data
       FROM dual; 
  END IF;

  -- update xdbconfig file
  dbms_xdb.cfg_update(cfg_data);

end;
/

COMMIT;

-- Register standard schemas (catxdbst.sql)
declare
 c      NUMBER;
 XLURL VARCHAR2(2000) :=
  'http://xmlns.oracle.com/xdb/log/xdblog.xsd';
 FLURL VARCHAR2(2000) :=
  'http://xmlns.oracle.com/xdb/log/ftplog.xsd';
 HLURL VARCHAR2(2000) :=
  'http://xmlns.oracle.com/xdb/log/httplog.xsd';

 XLXSD VARCHAR2(4000) :=
'<schema
targetNamespace="http://xmlns.oracle.com/xdb/log"
     xmlns="http://www.w3.org/2001/XMLSchema"
     xmlns:xdb="http://xmlns.oracle.com/xdb"
     xmlns:xl="http://xmlns.oracle.com/xdb/log"
     version="1.0" elementFormDefault="qualified">

<complexType name="xdb-log-entry-type">
  <sequence>
    <!-- TODO: Need to change to enumerated types -->
    <!-- TEMP : change date to dateTime -->
    <element name="Date-and-Time" type="date"/>
    <element name="Module" type="string"/> <!-- XDBCORE, FTP or HTTP -->
    <element name="Description" type="string"/>
    <element name="User-ID" type="string"/> <!-- eg., SCOTT -->
    <element name="Type" type="string"/> <!-- ERROR, WARNING, INFO or DEBUG -->
  </sequence>
</complexType>

<element name="xdb-log">
<complexType>
  <sequence> 
    <element name="xdb-log-entry" type="xl:xdb-log-entry-type"
             maxOccurs="unbounded"/>
  </sequence>
</complexType>
</element>

</schema>';

FLXSD VARCHAR2(4000) :=
 '<schema
 targetNamespace="http://xmlns.oracle.com/xdb/log"
     xmlns="http://www.w3.org/2001/XMLSchema"
     xmlns:xdb="http://xmlns.oracle.com/xdb"
     xmlns:xl="http://xmlns.oracle.com/xdb/log"
     version="1.0" elementFormDefault="qualified">

<complexType name="ftp-log-entry-type">
  <sequence>      
      <!-- TODO: Need to change to enumerated types -->
      <element name="Date-and-Time" type="date"/>
      <element name="Module" type="string"/> <!-- XDBCORE, FTP or HTTP -->
      <element name="Description" type="string"/>
      <element name="User-ID" type="string"/> <!-- eg., SCOTT -->
      <element name="Type" type="string"/> <!-- ERROR, WARNING, INFO or 
                                                DEBUG -->
      <element name="Client-IP" type="string"/>
      <element name="Request-Command" type="string"/>
      <element name="Response">
        <complexType> <sequence>
          <element name="Code" type="string"/> <!-- eg., "200" -->
          <element name="Message" type="string"/> <!-- eg., "PORT command 
                                                            successful" -->
        </sequence> </complexType>
      </element>
  </sequence>
</complexType>

<element name="ftp-log">
<complexType>
  <sequence>
    <element name="ftp-log-entry" type="xl:ftp-log-entry-type" 
             maxOccurs="unbounded"/>
  </sequence>
</complexType>
</element>

</schema>';

HLXSD VARCHAR2(4000) :=
 '<schema
targetNamespace="http://xmlns.oracle.com/xdb/log"
     xmlns="http://www.w3.org/2001/XMLSchema"
     xmlns:xdb="http://xmlns.oracle.com/xdb"
     xmlns:xl="http://xmlns.oracle.com/xdb/log"
     version="1.0" elementFormDefault="qualified">

<complexType name="http-log-entry-type">
    <sequence>
      <!-- TODO: Need to change to enumerated types -->
      <element name="Date-and-Time" type="date"/>
      <element name="Module" type="string"/> <!-- XDBCORE, FTP or HTTP -->
      <element name="Description" type="string"/>
      <element name="User-ID" type="string"/> <!-- eg., SCOTT -->
      <element name="Type" type="string"/> <!-- ERROR, WARNING, INFO or 
                                                DEBUG -->
      <element name="Client-IP" type="string"/>
      <element name="Request">
        <complexType> <sequence>
          <element name="Method" type="string"/> <!-- eg., "GET" -->
          <element name="Resource-Path" type="string"/> <!-- eg., "/file1" -->
          <element name="Version" type="string"/> <!-- 1.0 or 1.1 -->
          <element name="Headers" type="string"/>
          <element name="Body" type="base64Binary"/>
        </sequence> </complexType>
      </element>
      <element name="Response">
        <complexType> <sequence>
          <element name="Code" type="string"/> <!-- eg., "404" -->
          <element name="Message" type="string"/> <!-- eg., "Not found" -->
          <element name="Headers" type="string"/>
          <element name="Body" type="base64Binary"/>
        </sequence> </complexType>
      </element>
    </sequence>
</complexType>

<element name="http-log">
<complexType>
  <sequence>
    <element name="http-log-entry" type="xl:http-log-entry-type" 
             maxOccurs="unbounded"/>
  </sequence>
</complexType>
</element>

</schema>';

begin

  select count(*) into c from xdb.xdb$schema s
  where s.xmldata.schema_url = XLURL;
  if c = 0 then
    xdb.dbms_xmlschema.registerSchema(XLURL, XLXSD, FALSE, FALSE, FALSE,
                                      FALSE, FALSE, 'XDB');
  end if;

  select count(*) into c from xdb.xdb$schema s
  where s.xmldata.schema_url = FLURL;
  if c = 0 then
    xdb.dbms_xmlschema.registerSchema(FLURL, FLXSD, FALSE, FALSE, FALSE,
                                      FALSE, FALSE, 'XDB');
  end if;

  select count(*) into c from xdb.xdb$schema s
  where s.xmldata.schema_url = HLURL;
  if c = 0 then
    xdb.dbms_xmlschema.registerSchema(HLURL, HLXSD, FALSE, FALSE, FALSE,
                                      FALSE, FALSE, 'XDB');
  end if;
end;
/

@@catxdbh

exec dbms_metadata_hack.cre_dir;

drop package dbms_metadata_hack;

commit;

-- Register OR version of XInclude.xsd
declare
  c number;
  schema_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(schema_exists,-31085);
  XINCLUDEXSD VARCHAR2(31000) :=
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
      xmlns:xi="http://www.w3.org/2001/XInclude" 
      targetNamespace="http://www.w3.org/2001/XInclude" 
      finalDefault="extension" 
      xmlns:xdb="http://xmlns.oracle.com/xdb">

  <xs:element name="include" type="xi:includeType" xdb:defaultTable=""/>

  <xs:complexType name="includeType" mixed="true">
    <xs:choice minOccurs="0" maxOccurs="unbounded" >
      <xs:element ref="xi:fallback" />
      <xs:any namespace="##other" processContents="lax" />
      <xs:any namespace="##local" processContents="lax" />
    </xs:choice>

    <xs:attribute name="href" use="optional" type="xs:anyURI"/>
    <xs:attribute name="parse" use="optional" default="xml" type="xi:parseType" />
    <xs:attribute name="xpointer" use="optional" type="xs:string"/>
    <xs:attribute name="encoding" use="optional" type="xs:string"/>
    <xs:attribute name="accept" use="optional" type="xs:string"/>
    <xs:attribute name="accept-language" use="optional" type="xs:string"/>
    <xs:anyAttribute namespace="##other" processContents="lax"/>
  </xs:complexType>

  <xs:simpleType name="parseType">
     <xs:restriction base="xs:token">
      <xs:enumeration value="xml"/>
      <xs:enumeration value="text"/>
    </xs:restriction>
  </xs:simpleType>

  <xs:element name="fallback" type="xi:fallbackType" xdb:defaultTable=""/>

  <xs:complexType name="fallbackType" mixed="true">
    <xs:choice minOccurs="0" maxOccurs="unbounded">
      <xs:element ref="xi:include"/>
      <xs:any namespace="##other" processContents="lax"/>
      <xs:any namespace="##local" processContents="lax"/>
    </xs:choice>
    <xs:anyAttribute namespace="##other" processContents="lax" />
  </xs:complexType>

</xs:schema>';

  XINCLUDEURL VARCHAR2(2000) := 'http://www.w3.org/2001/XInclude.xsd';

begin

select count(*) into c
from resource_view
where equals_path(RES, '/sys/schemas/PUBLIC/www.w3.org/2001/XInclude.xsd')=1;

if c = 0 then
  xdb.dbms_xmlschema.registerSchema(XINCLUDEURL, XINCLUDEXSD, FALSE, FALSE,
                                    FALSE, FALSE, FALSE, 'XDB');
end if;

exception
  when schema_exists then
    NULL;
end;
/

Rem ================================================================
Rem END XDBCONFIG file downgrade
Rem ================================================================

