Rem
Rem $Header: rdbms/admin/xdbu112.sql /st_rdbms_12.1.0.1/1 2013/01/18 17:01:03 hxzhang Exp $
Rem
Rem xdbu112.sql
Rem
Rem Copyright (c) 2011, 2013, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      xdbu112.sql - XDB Upgrade from 11.2.0
Rem
Rem    DESCRIPTION
Rem      This script performs upgrade actions to upgrade from 11.2.0
Rem      to the current release
Rem
Rem    NOTES
Rem      It is invoked by xdbdbmig.sql and by xdbu111.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    hxzhang     01/17/13 - remove servlet element, bug16092359
Rem    prthiaga    10/26/12 - LRG-7246788: not removing xmltr schema during upgrade
Rem    stirmizi    10/23/12 - add xdb.xdb$import_tt_info for token table merge
Rem    bhammers    04/15/12 - bug 13647232, remove dupliucates in TTSET 
Rem    stirmizi    04/11/12 - remove xdblog, ftplog, httplog, xmltr schemas
Rem    stirmizi    04/11/12 - drop table xdb$workspace
Rem    stirmizi    04/11/12 - delete registration of XInclude.xsd, re-register
Rem                           csx.XInclude.xsd with genTables=false
Rem    dmelinge    02/03/12 - Remove unnecessary privileges on DOCUMENT_LINKS
Rem    aamirish    01/05/12 - Bug 12843902: Grant EXECUTE to XDB on
Rem                           User-defined Types that are  used in the
Rem                           predicate returned by XDB VPD Policy Functions.
Rem    bhammers    10/12/11 - undo  catxdbvfexp
Rem    thbaby      10/13/11 - drop procedure sys.set_tablespace
Rem    sipatel     10/15/11 - #(11883969) - IAS for xidx_part_tab
Rem    thbaby      10/14/11 - cache for xmllob
Rem    hxzhang     10/17/11 - move xdb managibility package xdbptrl2
Rem    hxzhang     10/11/11 - install the xdb managibility package
Rem    sipatel     09/15/11 - add dxptab(nbpendtabobj#, nberrtabobj#)
Rem    sipatel     09/05/11 - #(11883969) - add xidx_part_tab and
Rem                           dxptab(tablespace, table_attrs)
Rem    thbaby      09/08/11 - drop indexes on acl table
Rem    qyu         09/01/11 - call xdbs112.sql
Rem    thbaby      08/03/11 - add session-state-cache-param for EM Express
Rem    thbaby      07/21/11 - add white-list
Rem    vhosur      07/19/11 - Create the dbfs virtual folder
Rem    jheng       06/26/11 - grant to xdb
Rem    swerthei    06/23/11 - add new servlets for Recovery Server
Rem    spetride    06/20/11 - add sys.getUserIdOnTarget
Rem    yxie        05/06/11 - add em express servlet
Rem    yxie        05/06/11 - Created
Rem
-- temporarily run "s" script here; move to xdbdbmig with re-org
@@xdbs112.sql

Rem ================================================================
Rem BEGIN XDB User Data upgrade from 11.2.0
Rem ================================================================

/* Grant EXECUTE to XDB on User-defined Types that are used in the predicate 
 * returned by XDB VPD Policy Functions.
 */
DECLARE   
  stmt          CLOB;
  TYPE          refcurs IS REF CURSOR;
  curs          refcurs;
  type_name     VARCHAR2(128);
  schema_name   VARCHAR2(128);
  sqltxt        VARCHAR2(300);
BEGIN
  stmt := 'select distinct po.name, u.name from' ||
          ' dependency$ dep, dba_xml_schemas x, obj$ do, obj$ po, user$ u' ||
          ' where do.obj#=dep.d_obj# and po.obj#=dep.p_obj# and do.type#=55' ||
          ' and do.name=x.int_objname and po.type#=13 and po.owner#=u.user#';
  OPEN curs FOR stmt;
  LOOP
    FETCH curs INTO type_name,schema_name;
    EXIT WHEN curs%NOTFOUND;
      sqltxt := 'grant execute on ' || 
                 dbms_assert.enquote_name(schema_name, FALSE) || '.' || 
                 dbms_assert.enquote_name(type_name, FALSE) || ' to xdb';
      EXECUTE IMMEDIATE sqltxt;
  END LOOP;
END;
/

grant execute on dbms_priv_capture to xdb;

-- temporarily run first part of reload here (redundantly on earlier upgrades)
@@xdbptrl1.sql

--bug16092359, remove the servlet element XDBStandard schema using copy evolve
--Need to make sure DBMS_XDBUTIL_INT is valid, this has be run after a reload
--that's why it is added here
select OBJECT_NAME, STATUS from dba_objects where owner = 'XDB' and OBJECT_NAME like '%XDBUTIL%';

select OBJECT_NAME, STATUS from dba_invalid_objects where owner = 'XDB' and OBJECT_NAME like '%XDBUTIL%';

-- Drop table xdb.servlet 
begin
  execute immediate 'drop table xdb.servlet';
  commit;
  exception
     when others then
          null;
end;
/
--evlove the schema and remove servlet element
declare
     newsch   XMLSequenceType;
     urls     XDB$STRING_LIST_T;
     schowner XDB$STRING_LIST_T;
     sch      VARCHAR2(4000) :=
'<schema xmlns="http://www.w3.org/2001/XMLSchema"       
        targetNamespace="http://xmlns.oracle.com/xdb/XDBStandard"
        xmlns:xdb="http://xmlns.oracle.com/xdb"
        version="1.0" elementFormDefault="qualified">

  <element name = "LINK" xdb:SQLType="XDB_LINK_TYPE" xdb:SQLSchema="XDB" xdb:defaultTable="">
   <complexType>
    <sequence>
     <element name="ParentName">
       <simpleType>
         <restriction base = "string">
           <length value = "256"/>
         </restriction>
       </simpleType>
     </element>
     <element name="ChildName">
       <simpleType>
         <restriction base = "string">
           <length value = "1024"/>
         </restriction>
       </simpleType> 
     </element>
     <element name= "Name">
       <simpleType>
         <restriction base = "string">
           <length value = "256"/>
         </restriction>
       </simpleType>
     </element>
     <element name= "Flags">
       <simpleType>
         <restriction base = "base64Binary">
           <length value = "4"/>
         </restriction>
       </simpleType>
     </element>
     <element name="ParentOid">
       <simpleType>
         <restriction base = "base64Binary">
           <length value = "16"/>
         </restriction>
       </simpleType>
     </element>
     <element name="ChildOid">
       <simpleType>
         <restriction base = "base64Binary">
           <length value = "16"/>
         </restriction>
       </simpleType>
    </element>
    <element name="LinkType">
      <simpleType>
        <restriction base="string">
          <enumeration value="Hard"/>
          <enumeration value="Weak"/>
          <enumeration value="Symbolic"/>
        </restriction>
      </simpleType>
    </element>
    </sequence>
   </complexType>
  </element>

</schema>';

begin
     urls := XDB$STRING_LIST_T('http://xmlns.oracle.com/xdb/XDBStandard.xsd');
     newsch := XMLSequenceType(xmltype(sch)) ;
     schowner  := XDB$STRING_LIST_T('XDB');
     dbms_xmlschema.CopyEvolve(urls, newsch, NULL, FALSE, NULL,TRUE,
       FALSE, schowner);
end;
/

select OBJECT_NAME, STATUS from dba_objects where owner = 'XDB' and OBJECT_NAME like '%SERVLET%';

--reload again, to make sure path_view is valid
@@xdbptrl1.sql

select OBJECT_NAME, STATUS from dba_objects where owner = 'XDB' and OBJECT_NAME like '%PATH_VIEW%';

select OBJECT_NAME, STATUS from dba_invalid_objects where owner = 'XDB' and OBJECT_NAME like '%PATH_VIEW%';

Rem ===============
Rem alter xdb.xdb$resource to enable the CACHE option on XMLLOB
Rem This is done to avoid poor performance of repository read
Rem operations in MTS (Shared Server) mode. See bug 13083410 
Rem for details.
Rem ===============
alter table xdb.xdb$resource modify lob (xmldata.xmllob) (cache);

Rem ================================================================
Rem BEGIN resecure DOCUMENT_LINKS
Rem ================================================================

Rem
Rem DOCUMENT_LINKS was incorrectly granted insert, update, and delete
Rem permissions for PUBLIC.  Revoke them.  Bug 13019222.
Rem

BEGIN
EXECUTE IMMEDIATE 'revoke insert on xdb.document_links from PUBLIC';
EXCEPTION
WHEN others THEN
  IF sqlcode = -1927 THEN NULL;
       -- suppress error if not found
  ELSE raise;
  END IF;
END;
/

BEGIN
EXECUTE IMMEDIATE 'revoke update on xdb.document_links from PUBLIC';
EXCEPTION
WHEN others THEN
  IF sqlcode = -1927 THEN NULL;
       -- suppress error if not found
  ELSE raise;
  END IF;
END;
/

BEGIN
EXECUTE IMMEDIATE 'revoke delete on xdb.document_links from PUBLIC';
EXCEPTION
WHEN others THEN
  IF sqlcode = -1927 THEN NULL;
       -- suppress error if not found
  ELSE raise;
  END IF;
END;
/
show errors;

Rem ================================================================
Rem END resecure DOCUMENT_LINKS
Rem ================================================================

Rem ================================================================
Rem BEGIN XDBCONFIG file upgrade
Rem ================================================================

Rem
Rem Add EM Express servlet and remove report framework servlet
Rem

declare
  cfg_data XMLTYPE;
  scount   NUMBER := 0;
begin
  cfg_data := dbms_xdb.cfg_get();

  -- Add EM Express servlet mapping
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''EMExpressServlet'']')  
    INTO scount 
    FROM dual;

  IF (scount = 0) THEN
    SELECT appendchildxml(
                cfg_data, 
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings', 
                xmltype(
                  '<servlet-mapping xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
                     <servlet-pattern>/em/*</servlet-pattern>
                     <servlet-name>EMExpressServlet</servlet-name>
                   </servlet-mapping>'))
      INTO cfg_data
      FROM dual;
  END IF;

  -- Add EM Express servlet
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''EMExpressServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 0) THEN
    SELECT appendchildxml(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list',
                xmltype(
                  '<servlet xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
                     <servlet-name>EMExpressServlet</servlet-name>
                     <servlet-language>C</servlet-language>
                     <display-name>EM Express Servlet</display-name>
                     <description>Servlet for EM Express</description>
                     <session-state-cache-param>
                        <cache-size>128</cache-size>
                        <expiration-timeout>360000</expiration-timeout>
                     </session-state-cache-param>
                   </servlet>'))
      INTO cfg_data
      FROM dual;
  END IF;

  -- Delete report framework servlet mapping
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                '/webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''ReportFmwkServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-mappings/' ||
                'servlet-mapping[servlet-name=''ReportFmwkServlet'']')
      INTO cfg_data
      FROM dual; 
  END IF;

  -- Delete report framework servlet
  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''ReportFmwkServlet'']')
    INTO scount 
    FROM dual;

  IF (scount = 1) THEN
    SELECT deleteXML(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/' ||
                'webappconfig/servletconfig/servlet-list/' ||
                'servlet[servlet-name=''ReportFmwkServlet'']')
      INTO cfg_data
      FROM dual; 
  END IF;

  -- ORS servlet
  SELECT appendchildxml(
           cfg_data,
           '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
             '/servletconfig/servlet-mappings',
           xmltype(
            '<servlet-mapping xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
               <servlet-pattern>/orssv/*</servlet-pattern>
               <servlet-name>ORSServlet</servlet-name>
             </servlet-mapping>'))
  INTO   cfg_data
  FROM   dual;

  SELECT appendchildxml(
           cfg_data,
           '/xdbconfig/sysconfig/protocolconfig/httpconfig/webappconfig' ||
             '/servletconfig/servlet-list',
           xmltype(
             '<servlet xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
                <servlet-name>ORSServlet</servlet-name>
                <servlet-language>C</servlet-language>
                <display-name>ORS Servlet</display-name>
                <description>Servlet for accessing ORS</description>
                <security-role-ref>
                  <role-name>authenticatedUser</role-name>
                  <role-link>authenticatedUser</role-link>
                </security-role-ref>
              </servlet>'))
  INTO   cfg_data
  FROM   dual;

  -- update xdbconfig file
  dbms_xdb.cfg_update(cfg_data);

end;
/

COMMIT;

REM
REM Add white-list 
REM

declare
  cfg_data XMLTYPE;
  scount   NUMBER := 0;
begin
  cfg_data := dbms_xdb.cfg_get();

  SELECT existsNode(
                cfg_data,
                '/xdbconfig/sysconfig/protocolconfig/httpconfig/white-list')
    INTO scount 
    FROM dual;

  IF (scount = 0) THEN
    SELECT appendchildxml(
                cfg_data, 
                '/xdbconfig/sysconfig/protocolconfig/httpconfig',
                xmltype(
              '<white-list xmlns="http://xmlns.oracle.com/xdb/xdbconfig.xsd">
                 <white-list-pattern>/*</white-list-pattern>
               </white-list>'))
      INTO cfg_data
      FROM dual;
  END IF;

  -- update xdbconfig file
  dbms_xdb.cfg_update(cfg_data);

end;
/

COMMIT;

-- Remove OR version of XInclude.xsd
declare
 c NUMBER;
 xinurl VARCHAR2(2000) := 'http://www.w3.org/2001/XInclude.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = xinurl;

  if c > 0 then
    dbms_xmlschema.deleteschema(xinurl, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then null;
end;
/

-- First remove csx.XInclude.xsd and then re-register it with genTables false
declare
 c NUMBER;
 csxxinurl VARCHAR2(2000) := 'http://www.w3.org/2001/csx.XInclude.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = csxxinurl;

  if c > 0 then
    dbms_xmlschema.deleteschema(csxxinurl, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then null;
end;
/

declare
  c number;
  schema_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(schema_exists,-31085);
  XINCLUDEXSD VARCHAR2(31000) :=
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xi="http://www.w3.org/2001/XInclude" targetNamespace="http://www.w3.org/2001/XInclude" finalDefault="extension">

  <xs:element name="include" type="xi:includeType" />

  <xs:complexType name="includeType" mixed="true">
    <xs:choice minOccurs="0" maxOccurs="unbounded" >
      <xs:element ref="xi:fallback" />
      <xs:any namespace="##other" processContents="lax" />
      <xs:any namespace="##local" processContents="lax" />
    </xs:choice>

    <xs:attribute name="href" use="optional" type="xs:anyURI"/>
    <xs:attribute name="parse" use="optional" default="xml" type="xi:parseType" />
    <xs:attribute name="xpointer" use="optional" type="xs:string"/>
    <xs:attribute name="encoding" use="optional" type="xs:string"/>
    <xs:attribute name="accept" use="optional" type="xs:string"/>
    <xs:attribute name="accept-language" use="optional" type="xs:string"/>
    <xs:anyAttribute namespace="##other" processContents="lax"/>
  </xs:complexType>

  <xs:simpleType name="parseType">
    <xs:restriction base="xs:token">
      <xs:enumeration value="xml"/>
      <xs:enumeration value="text"/>
    </xs:restriction>
  </xs:simpleType>

  <xs:element name="fallback" type="xi:fallbackType" />

  <xs:complexType name="fallbackType" mixed="true">
    <xs:choice minOccurs="0" maxOccurs="unbounded">
      <xs:element ref="xi:include"/>
      <xs:any namespace="##other" processContents="lax"/>
      <xs:any namespace="##local" processContents="lax"/>
    </xs:choice>
    <xs:anyAttribute namespace="##other" processContents="lax" />
  </xs:complexType>

</xs:schema>';

  CSX_XINCLUDEURL VARCHAR2(2000) := 'http://www.w3.org/2001/csx.XInclude.xsd';

begin

select count(*) into c from xdb.xdb$schema s
where s.xmldata.schema_url = CSX_XINCLUDEURL;

if c = 0 then
  xdb.dbms_xmlschema.registerSchema(CSX_XINCLUDEURL, XINCLUDEXSD, FALSE, FALSE, FALSE, FALSE, FALSE, 'XDB', options=>DBMS_XMLSCHEMA.REGISTER_BINARYXML);
end if;

exception
  when schema_exists then
    NULL;
end;
/

COMMIT;

Rem ================================================================
Rem END XDBCONFIG file upgrade
Rem ================================================================

Rem ======= Remove xdb.xdb$workspace ===============================

declare
  exist number;
begin
  select count(*) into exist from DBA_TABLES where table_name = 'XDB$WORKSPACE'
  and owner = 'XDB';

  if exist = 1 then
    execute immediate
        'drop table xdb.xdb$workspace';
  end if;
end;
/

-- NOTE NOTE NOTE: This should be moved to xdbs112.sql when that file gets created!
--
-- This function is meant to be called after a full database import, 
-- to find the user id on the target for a user, given the user id on the source database. 
-- The userid is returned in a format compatible to userid columns in various XDB owned tables 
-- (like CREATORID, OWNERID, LASTMODIFIERID in XDB.XDB$RESOURCE) and to the OWNERID column in
-- tables enabled for hierarchy.
-- 
-- This function is created as SYS because it accesses user$. XDB is granted execute permissions
-- on it because the function is used to update userid columns in the above mentioned tables
-- owned by XDB, part of a full XDB import callout. Such callouts are executed as XDB.
create or replace function getUserIdOnTarget(userid raw) return raw as 
   usrnum_exp   NUMBER;
   usrname_exp  VARCHAR2(100);
   usrnum_imp   NUMBER;
   usrid_imp    RAW(16);
begin
  if (rawtohex(userid) =  '00000000') then
     usrnum_exp := 0;
  else
     usrnum_exp := to_number(trim (leading '0' from rawtohex(userid)), 'XXXXXXXX');
  end if;
  execute immediate 'select name from  SYS.KU$_USER_MAPPING_VIEW where user#=:1' into usrname_exp using usrnum_exp;
  execute immediate 'select user# from user$ where name = :1' into usrnum_imp using usrname_exp;
  usrid_imp := hextoraw(lpad(ltrim(to_char(usrnum_imp, 'XXXXXXXX')), 8, '0'));
  return usrid_imp;
end;
/

show errors;

grant execute on getUserIdOnTarget to XDB;

----------------------------------------------------------------------------
-- during upgrade from 11.2.0.x, drop procedure sys.set_tablespace
-- since movexdb_tablespace does not rely on sys.set_tablespace
-- in 12cR1
-- 
begin
  execute immediate 'drop procedure sys.set_tablespace';
  exception
     when others then
        if (SQLCODE != -4043) then
          raise;
        end if;
end;
/

-----------------------------------------------------------------------------
-- upgrade XMLIndex from 11.2
-- #(11883969) add xidx_part_tab and  dxptab(tablespace, table_attrs)
-- add dxptab(nbpendtabobj#, nberrtabobj#)
-----------------------------------------------------------------------------
DECLARE
  exist_ex EXCEPTION;
  PRAGMA EXCEPTION_INIT(exist_ex, -955);
  colexist_ex EXCEPTION;
  PRAGMA EXCEPTION_INIT(colexist_ex, -1430);
  keyexist_ex EXCEPTION;
  PRAGMA EXCEPTION_INIT(keyexist_ex, -1);
BEGIN
  BEGIN
    EXECUTE IMMEDIATE
      'create table xdb.xdb$xidx_part_tab(
         idxobj#         number not null,       -- object # of XMLIndex
         part_name       varchar2(128) not null,-- partition name 
         tablespace      varchar2(128),         -- partition tablespace 
         partition_attrs varchar2(4000),        -- partition physical attributes 
           constraint xdb$xidx_part_tab_pk primary key (idxobj#, part_name))';
    EXCEPTION WHEN exist_ex THEN NULL;
  END;

  -- insert index obj# and partition name into xidx_part_tab.
  -- tablespace==null => user did not specify any tablespace.
  BEGIN
    EXECUTE IMMEDIATE
      'insert into xdb.xdb$xidx_part_tab(idxobj#, part_name)
          select dxptab.idxobj# as idxobj#, o.subname as part_name
          from xdb.xdb$dxptab dxptab, sys.indpart$ ip, sys.obj$ o
          where dxptab.idxobj#=ip.BO# and ip.obj#=o.obj#';
      commit;
    EXCEPTION WHEN keyexist_ex THEN NULL;
  END;

  BEGIN
    EXECUTE IMMEDIATE 'alter table xdb.xdb$dxptab add (tablespace varchar2(128))';
    EXCEPTION WHEN colexist_ex THEN NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'alter table xdb.xdb$dxptab add (table_attrs varchar2(4000))';
    EXCEPTION WHEN colexist_ex THEN NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'alter table xdb.xdb$dxptab add (nbpendtabobj# number)';
    EXCEPTION WHEN colexist_ex THEN NULL;
  END;
  BEGIN
    EXECUTE IMMEDIATE 'alter table xdb.xdb$dxptab add (nberrtabobj# number)';
    EXCEPTION WHEN colexist_ex THEN NULL;
  END;
END;
/

-- Drop all indexes on xdb.xdb$acl
begin
  execute immediate 'drop index xdb.xdb$acl_spidx';
  commit;
  exception
     when others then
          null;
end;
/

begin
  execute immediate 'drop index xdb.xdb$acl_xidx force';
  commit;
  exception
     when others then
          null;
end;
/

begin
  execute immediate 'drop package xdb.xdb$acl_pkg_int';
  commit;
  exception 
     when others then
          null;
end;
/

Rem create dbfs_virtual_folder table if it does not exist
declare
 exist number;
begin
  select count(*) into exist from DBA_TABLES where table_name ='XDB$DBFS_VIRTUAL_FOLDER'
  and owner ='XDB';
 
  if exist = 0 then
   execute immediate 'CREATE TABLE XDB.XDB$DBFS_VIRTUAL_FOLDER (
   hidden_def         NUMBER default 1,
   mount_path         VARCHAR2(4000) NOT NULL,
   CONSTRAINT snglerow UNIQUE  (hidden_def))';
  end if;
end;
/   
SHOW ERRORS;

declare
ret boolean;
dbfs_path varchar2(1000) := NULL;
tab_path varchar2(1000);
insertrow boolean := TRUE;
num_entries NUMBER :=0;
begin
  -- See if we have a entry in the table for vf 
  select count(*) into num_entries from xdb.xdb$dbfs_virtual_folder where hidden_def = 1;
  if num_entries <> 0 then
    insertrow := FALSE;
    select mount_path into tab_path from xdb.xdb$dbfs_virtual_folder where hidden_def = 1;
  end if;
  -- We will not insert a new row if one already exists. Instead we will create a folder
  -- same as the entry in the table. 
  if insertrow = FALSE then
    if dbms_xdb.existsResource(tab_path) = FALSE then
       ret := xdb.dbms_xdbutil_int.createSystemVirtualFolder(tab_path);
       if ret then
         dbms_xdb.setacl(tab_path, '/sys/acls/all_all_acl.xml');
       end if;
    end if;
  else
    if dbms_xdb.existsResource( '/dbfs' ) = FALSE then
     dbfs_path := '/dbfs';
    end if;
  end if;
  -- Create the folder if we have identified the path
  if dbfs_path IS NOT NULL then
    ret := xdb.dbms_xdbutil_int.createSystemVirtualFolder(dbfs_path);
    if ret then
      dbms_xdb.setacl(dbfs_path, '/sys/acls/all_all_acl.xml');
    end if;
    if insertrow = TRUE then 
      begin
       execute immediate 'insert into XDB.XDB$DBFS_VIRTUAL_FOLDER values (1, :1)' using dbfs_path;
      exception
       when others then raise;
      end;   
    end if;  
  end if; 
  
end;
/
commit;

Rem ================================================================
Rem Remove Views and callout registries for XDB datapump export/import
Rem ================================================================

-- remove registered callouts 
declare
  stmt varchar2(10000);
begin
  begin
    stmt := 
       'delete from sys.impcalloutreg$ where tag = ''XDB_REPOSITORY''';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
  begin
    stmt := 'delete from sys.exppkgact$ where package = ''' || 
            'DBMS_XDBUTIL_INT' || ''' and schema=''' || 'XDB' || ''' ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
end;
/


-- remove views. tables, public synonyms, function
declare
  stmt varchar2(10000);
begin
  begin
    stmt := 
       'drop table SYS.XML_TABNAME2OID_VIEW_TBL';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
  begin
    stmt := 
       'drop public synonym XML_TABNAME2OID_VIEW';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view SYS.XML_TABNAME2OID_VIEW ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table XDB.XDB$RESOURCE_EXPORT_VIEW_TBL ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
  begin
    stmt := 
       'drop view XDB.XDB$RESOURCE_EXPORT_VIEW';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table DBA_XML_SCHEMA_DEPENDENCY_TBL';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table DBA_TYPE_XMLSCHEMA_DEP_TBL ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
  begin
    stmt := 
       'drop public synonym DBA_TYPE_XMLSCHEMA_DEP';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view DBA_TYPE_XMLSCHEMA_DEP';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$attrgroup_ref_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$attrgroup_ref_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$attrgroup_def_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$attrgroup_def_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$anyattr_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$anyattr_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$any_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$any_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$element_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$element_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$attribute_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$attribute_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$group_ref_view_tbl ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$group_ref_view ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$group_def_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop view xdb.xdb$group_def_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$sequence_model_view_tbl ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop view xdb.xdb$sequence_model_view ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;


  begin
    stmt := 
       'drop table xdb.xdb$choice_model_view_tbl ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop  view xdb.xdb$choice_model_view ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop  table xdb.xdb$all_model_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop view xdb.xdb$all_model_view ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$complex_type_view_tbl ';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop view xdb.xdb$complex_type_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table xdb.xdb$simple_type_view_tbl';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop view xdb.xdb$simple_type_view';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

  begin
    stmt := 
       'drop table XDB.XDB$SCHEMA_EXPORT_VIEW_TBL';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
   begin
    stmt := 
       'drop view XDB.XDB$SCHEMA_EXPORT_VIEW';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;

   begin
    stmt := 
       'drop function getUserIdOnTarget';
    execute immediate stmt;
    exception
       when OTHERS then
         NULL;
  end;
 
end;
/

-- Remove standard schemas (catxdbst.sql)
declare
 c      NUMBER;
 XLURL  VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/log/xdblog.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = XLURL;

  if c > 0 then
    dbms_xmlschema.deleteschema(XLURL, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then null;
end;
/

declare
 c     NUMBER;
 FLURL VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/log/ftplog.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = FLURL;

  if c > 0 then
    dbms_xmlschema.deleteschema(FLURL, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then null;
end;
/

declare
 c     NUMBER;
 HLURL VARCHAR2(2000) := 'http://xmlns.oracle.com/xdb/log/httplog.xsd';
begin
  select count(*) into c from xdb.xdb$schema s
   where s.xmldata.schema_url = HLURL;

  if c > 0 then
    dbms_xmlschema.deleteschema(HLURL, dbms_xmlschema.delete_cascade);
  end if;
  exception when others then null;
end;
/

--bug 13647232, remove duplicate rows (remove all but default toksuf ( flags== 0))
begin
 execute immediate 
 'delete from xdb.xdb$ttset where FLAGS != 0 AND TOKSUF in (select TOKSUF from xdb.xdb$ttset where FLAGS = 0)';
    exception
       when others then
         NULL;
end;
/

--bug 13647232,  add unique constraint
begin
   execute immediate 
        'alter table xdb.xdb$ttset
         add constraint xdb$ttset_uniq unique (toksuf)';
    exception
       when others then
         NULL;
end;
/

/*************** Create XDB.XDB$IMPORT_TT_INFO table *****************/
begin
   execute immediate
      'create table xdb.xdb$import_tt_info( 
          guid     raw(16), 
          nmspcid      raw(8),
          localname    varchar2(2000),
          flags        raw(4),
          id           raw(8))';
  exception
       when others then
         -- raise no error if table already exists
         NULL;
end;
/

grant select,insert,update,delete on xdb.xdb$import_tt_info to public;

Rem ================================================================
Rem END XDB User Data upgrade from 11.2.0
Rem ================================================================

Rem ================================================================
Rem BEGIN XDB User Data upgrade from next release
Rem ================================================================

-- uncomment for next release
--@@xdbu120.sql

Rem ================================================================
Rem END XDB User Data upgrade from next release
Rem ================================================================

