/*
 * $Header: precomp/public/sqlcpr.h /osds/1 2011/08/01 02:32:26 pnayak Exp $
 */

/* Copyright (c) 1988, 2011, Oracle and/or its affiliates. 
All rights reserved. */
 
/* NAME
     sqlcpr.h
   FUNCTION
     Contains 'customer' prototypes for the sql* routines generated by the
     precompiler.  
     sqlald, sqlglm, sqlnul and sqlprc are included because, although we don't
     generate calls to them, users may include calls to them.

     'customer' prototypes for dynamic method 4 (i.e., sqlda) reside
     in the sqlda.h public header file.

   NOTES
     There should be no 'modified' notes in this file when it goes to the
     customer.  Remove them as they are put in.  */

#ifndef SQLCA
#  include <sqlca.h>
#endif
#ifndef ORACA
#  include <oraca.h>
#endif

#ifndef SQLPRO
#  define SQLPRO

/* -------------------- */
/* defines for sqlcpr.h */
/* -------------------- */

#define SQL_SUCCESS (sword)0
#define SQL_ERROR (sword)-1


#define SQL_ATTR_COL_PROPERTIES                     0x0000000000000000
#define SQL_ATTR_COL_PROPERTY_IS_IDENTITY           0x0000000000000001
#define SQL_ATTR_COL_PROPERTY_IS_GEN_ALWAYS         0x0000000000000002
#define SQL_ATTR_COL_PROPERTY_IS_GEN_BY_DEF_ON_NULL 0x0000000000000004

#ifndef SQL_SINGLE_RCTX
#define SQL_SINGLE_RCTX (void *)0
#endif /* SQL_SINGLE_RCTX */

#define SQLErrorGetText(arg1, arg2, arg3, arg4) sqlglmt(arg1, arg2, arg3, arg4)

#define SQLStmtGetText(arg1, arg2, arg3, arg4) sqlglst(arg1, arg2, arg3, arg4)

#define SQLColumnNullCheck(arg1, arg2, arg3, arg4) \
        sqlnult(arg1, arg2, arg3, arg4)

#define SQLNumberPrecV6(arg1, arg2, arg3, arg4) sqlprct(arg1, arg2, arg3, arg4)

#define SQLNumberPrecv7(arg1, arg2, arg3, arg4) sqlpr2t(arg1, arg2, arg3, arg4)

#define SQLVarcharGetLength(arg1, arg2, arg3) sqlvcpt(arg1, arg2, arg3) 

#define SQLGetStride(arg1, arg2, arg3, arg4) sqlstrdt(arg1, arg2, arg3, arg4)

#define SQLGetColProp(arg1, arg2, arg3, arg4) sqlcolprop(arg1, arg2, arg3, arg4)


#ifndef SQLPRO_ORACLE

#if defined (__STDC__) || defined (__cplusplus)

#ifdef  __cplusplus
extern "C" {
#endif

/* user-callable functions - non-threaded */
/* -------------------------------------- */

extern void sqlglm( unsigned char*, size_t*, size_t* );
extern void sqlgls( char*, size_t*, size_t* );
extern void sqliem( unsigned char*, signed int* );
extern void sqlnul( unsigned short*, unsigned short*, int* );
extern void sqlprc( unsigned int*, int*, int* );
extern void sqlpr2( unsigned int*, int*, int*);
extern void sqlvcp( unsigned int*, unsigned int* );

/* user-callable functions -- thread safe */
/* -------------------------------------- */

extern void sqlglmt( void*, unsigned char*, size_t*, size_t* ); 

extern void sqlglst( void*, char*, size_t*, size_t* );

extern void sqliemt( void*, unsigned char*, signed int*);

extern void sqlnult( void*, unsigned short*, unsigned short*, int*);

extern void sqlpr2t( void*, unsigned int*, int*, int*);

extern void sqlprct( void*, unsigned int*, int*, int*);

extern void sqlvcpt( void*, unsigned int*, unsigned int*);

extern void SQLExtProcError( void*, char*, size_t );

extern void sqlcolprop( void*, char*, unsigned short*, unsigned long long*);


/* Removed generated Pro* 1.3 entry points */
/* --------------------------------------- */

/* Forms 3.0 compatibility functions */
/* --------------------------------- */

extern int iapprs( unsigned char* );      
extern int iappfo( unsigned char*, unsigned char*, size_t );
extern int exiterr( unsigned char* );

/* user-callable functions - non-threaded */
/* -------------------------------------- */

extern struct SQLDA *sqlald( int, size_t, size_t );
extern void sqlclu( struct SQLDA*);

/* user-callable functions -- thread safe */
/* -------------------------------------- */

extern struct SQLDA *sqlaldt( void*, int, size_t, size_t );

extern void sqlclut( void*, struct SQLDA*);

#ifdef  __cplusplus
}
#endif

#else /* k&r C - not ANSI standard */


/* user-callable functions - non-threaded */
/* -------------------------------------- */

extern void sqlglm( /*_ char*, size_t*, size_t* _*/ );
extern void sqlgls( /*_ char*, size_t*, size_t* _*/);
extern void sqliem( /*_ char*, int* _*/ );
extern void sqlnul( /*_ unsigned short*, unsigned short*, int* _*/ );
extern void sqlprc( /*_ unsigned int*, int*, int* _*/ );
extern void sqlpr2( /*_ unsigned int*, int*, int* _*/);
extern void sqlvcp( /*_ unsigned int *, unsigned int * _*/);
extern void sqlstrd(/*_ ub1 *, ub1 *, size_t _*/);  

/* user-callable functions -- thread safe */
/* -------------------------------------- */

extern void sqlglmt(/*_ void*, char*, size_t*, size_t* _*/ ); 

extern void sqlglst(/*_ void*, char*, size_t*, size_t* _*/);

extern void sqliemt(/*_ void*, char*, int* _*/ );

extern void sqlnult(/*_ void*, unsigned short*, unsigned short*, int* _*/ );

extern void sqlprct(/*_ void*, unsigned int*, int*, int* _*/ );

extern void sqlpr2t(/*_ void*, unsigned int*, int*, int* _*/);

extern void sqlvcpt(/*_ void*, unsigned int *, unsigned int * _*/);

extern void sqlstrdt(/*_ void *, ub1 *, ub1 *, size_t _*/);

extern void SQLExtProcError(/*_ void*, char*, size_t _*/);

extern void SQLRowidGet(/*_ void*, OCIRowid **urid _*/);

extern void sqlcolprop(/*_void*, char*, unsigned short*, unsigned long long*_*/);

/* Removed generated Pro* 1.3 entry points */
/* --------------------------------------- */


/* Forms 3.0 compatibility functions */
/* --------------------------------- */

extern int iapprs( /*_ char* _*/ );      
extern int iappfo( /*_ char*, char*, unsigned int _*/ );
extern int exiterr( /*_ char* _*/ );

/* user-callable functions - non-threaded */
/* -------------------------------------- */

extern struct SQLDA *sqlald( /*_ int, size_t, size_t _*/ );
extern void sqlclu( /*_ struct SQLDA* _*/);

/* user-callable functions -- thread safe */
/* -------------------------------------- */

extern struct SQLDA *sqlaldt(/*_ void*, int, size_t, size_t _*/ );
extern void sqlclut(/*_ void*, struct SQLDA* _*/);

#endif /* k&r C - not ANSI standard */
#endif /* SQLPRO_ORACLE */

#endif /* SQLPRO */
