/*
 * $Header: dsid.h,v 2.28 97/05/16 09:55:47 clcooper: Stab $ 
 */

/* Copyright (c) 1991 by Oracle Corporation */
/*
   NAME
     dsid.h - identifiers

   DESCRIPTION
     This file has all the class & attribute enumerations in it

   NOTES

   NOTE: The new column and table values are NOT reflected in 
   toads8.dmp's data dictionary.

   MODIFIED   (MM/DD/YY)
    clcooper   05/16/97 -  add macro for checking if attr is password 
    hmadan     03/10/97 -  Add description and domainid to DS_CertAuthority 
    hmadan     01/30/97 -  Add attribute ids for extensions 
    hmadan     09/11/96 -  Add DSZPSBLD 
    usriniva   07/10/96 -  Add a DSTLG flag to denote user is already 
                           authenticated and so Ignore Null Password
    hmadan     06/01/96 -  Add #define for type of operation 
    mcheng     05/17/96 -  Add admin class for fetching om_att_types 
    mcheng     03/04/96 -  Add Public Folder privs 
    mcheng     10/19/95 -  add attachmap attributes (OM_ATT_MAP)
    dmatic     05/26/95 -  add DSGEN0 
    dmatic     05/22/95 -  add public/shared folders support 
    mcheng     05/17/95 -  fix typo 
    mcheng     05/17/95 -  Add dirsync apptype 
    dmatic     05/04/95 -  add ps folder support 
    mcheng     03/07/95 -  Add Sync PL/SQL ENUMS 
    yliu       02/17/95 -  add DS_20Process class 
    jluke      02/03/95 -  Need to remove DSALLVER and DSALHVER. 
    mcheng     01/09/95 -  Add new enums for DS_RepSyncLog 
    mcheng     10/24/94 -  Add DS_SyncTypes enums 
    yliu       08/01/94 -  add guardianid for ds_process 
    pfriedma   07/25/94 -  Merging in DM fixes. 
    mcheng     06/29/94 -  Add Timestamp support to ds_replog 
    jluke      06/21/94 -  Need to add DEFINEs for new name resolution stored 
    tkukulsk   06/14/94 -  add DSGEN9, DSRESULT 
    pfriedma   06/01/94 -  Adding array datatype. 
    jluke      05/18/94 -  Need to add FORMS login flag DSTLGFLN. 
    mcheng     05/13/94 -  Add new objsystemattr table constants 
    hmulling   03/17/94 -  Add flag DSTLGSL for DM. 
    jluke      03/07/94 -  Need to add flags to login struct to accomodate di 
    pfriedma   12/29/93 -  Putting back dm flags. 
    pfriedma   12/06/93 -  Adding sched flag. 
    pfriedma   10/05/93 -  Adding debug flag to name res. 
    pfriedma   09/09/93 -  Fixing class size macros. 
    gmehra     08/11/93 -  update version numbers for 2.0.11.0 
    gmehra     07/19/93 -  update version number 
    gmehra     06/23/93 -  fix DSALLVER 
    gmehra     05/21/93 -  change versioning 
    gmehra     05/20/93 -  change DSALBVER to be 0 
    gmehra     05/19/93 -  add versioning to login 
    pfriedma   03/12/93 -  Adding ignore type. 
    gmehra     02/10/93 -  change DSSACOWN and DSSACADM 
    pfriedma   02/02/93 -  Adding dump op. 
    gmehra     01/25/93 -  add desc to attr table 
    pfriedma   01/15/93 -  Adding Martin's flag. 
    pfriedma   12/28/92 -  att_type attribute count. 
    mcheng     12/17/92 -  Correct DSPC_SIZ again 
    pfriedma   12/13/92 -  Fixing sizes. 
    pfriedma   11/23/92 -  Adding negative numbers 
    pfriedma   11/18/92 -  fixing dsnfix flag. 
    mcheng     11/16/92 -  Correct DSPC_SIZ 
    rellinge   11/13/92 -  change # of attrs for DS_ProcessTokens 
    rellinge   10/30/92 -  make patch25 
    pfriedma   10/26/92 -  Adding name resolution fixup mode. 
    gmehra     10/20/92 -  change the dswmail anc dswcal API 
    pfriedma   09/16/92 -  Adding package options. 
    pfriedma   09/08/92 -  Adding move SCN DCN ops. 
    yliu       08/26/92 -  add DSNDBTING and DSNDBTED 
    gmehra     08/23/92 -  add DSALSPAD 
    gmehra     08/23/92 -  patch 23 contd 
    gmehra     08/23/92 -  patch 23 - new attributes 
    gmehra     07/19/92 -  pch17 
    pfriedma   07/15/92 -  Adding delete domain operation. 
    gplesur    07/14/92 -  new select-for-update operation 
    gmehra     07/14/92 -  add new columns and tables 
    pfriedma   07/13/92 -  Adding delete node cleanup operation. 
    gmehra     07/05/92 -  constants for dslgngt added 
    gmehra     07/01/92 -  new ids for patch14 
    pfriedma   06/23/92 -  Changing comment 
    pfriedma   06/19/92 -  Adding rewriting flag. 
    pfriedma   06/18/92 -  Adding unsubscribe replicator operation. 
    gmehra     06/01/92 -  adding rewrite table 
    gplesur    05/22/92 -  use dsfopid 
    gmehra     05/18/92 -  new const for values of kind field 
    gplesur    05/12/92 -  create DSFOPID, DSFOPDF 
    gmehra     04/21/92 -  add community, om_template 
    gplesur    04/12/92 -  remove dsfopx 
    gplesur    04/07/92 -  change ds_srow fields 
    pfriedma   04/05/92 -  Adding dump operation. 
    gmehra     03/31/92 -  add the two new tables for admin 
    gmehra     03/12/92 -  add in the new node states 
    gmehra     03/11/92 -  fix multiply defined 
    gmehra     03/11/92 -  toads11.1 upgrade 
    gmehra     03/06/92 -  v12 - create DS12PBDL 
    gmehra     02/26/92 -  add some more generics 
    pfriedma   02/25/92 -  Changing birth op. 
    pfriedma   02/25/92 -  Adding birth operation. 
    byazdani   02/18/92 -  Fixed DSV12. 
    pfriedma   02/18/92 -  Adding dsn flag. 
    mwick      02/13/92 -  Add define for # of DS_Account overlaps 
    pfriedma   02/12/92 -  Adding DSN type. 
    gmehra     02/11/92 -  toads11 upgrade 
    mwick      02/11/92 -  Adding DS_IDMap type to dsfop 
    gmehra     02/10/92 -  get uids for tool and app.Fix _SIZ 
    pfriedma   02/09/92 -  Adding domain column to ds_commstate; 
    pfriedma   02/07/92 -  Adding DSUSVAL 
    gmehra     02/04/92 -  change DS_ALL to be 247 instead of 237 
    gmehra     01/31/92 -  make DSACOP = 0 instead of 1 
    pfriedma   01/31/92 -  Adding security layer to dsntsp. 
    gmehra     01/30/92 -  add in constants for account status etc. 
    gmehra     01/28/92 -  viewer security 
    gmehra     01/27/92 -  put in schema changes 
    pfriedma   01/24/92 -  Adding application types. 
    msaffari   01/23/92 -  DSV12 
    pfriedma   01/23/92 -  Adding set server account. 
    gmehra     01/15/92 -  doing security 
    gmehra     01/14/92 -  do security 
    pfriedma   01/13/92 -  Changing dserr 
    pfriedma   01/13/92 -  Adding DSNLPF 
    pfriedma   01/13/92 -  Olint 
    pfriedma   01/11/92 -  removing DSNPUB 
    gmehra     12/21/91 -  put in a type for DS_1NAME 
    mwick      12/20/91 -  Add a default value ID back in 
    gmehra     12/20/91 -  merge for toads10 
    pfriedma   12/18/91 -  Adding new dsn constants. 
    mwick      12/08/91 -  Adding max-value to dsfop 
    msaffari   11/26/91 -  add DSALL 
    pfriedma   11/18/91 -  Changing replog operation constants 
    gmehra     11/14/91 -  update all enums 
    pfriedma   11/04/91 -  Adding dsn error code. 
    gmehra     10/30/91 -  add in procs for dsz 
    gmehra     10/22/91 -  temp file for mark 
    mwick      10/10/91 -  Add #defines for new stored procs 
    gmehra     10/10/91 -  fix for mark`s "problem" 
    mwick      10/09/91 -  Add transport defines 
    sxgupta    10/09/91 -  change dskname to 1024 
    gmehra     10/08/91 -  adding the routing table constants 
    gmehra     10/07/91 -  adding DSx_SIZ 
    gmehra     10/07/91 -  DSATTRS and DSCLASS 
    msaffari   10/07/91 -  fix types to categries. 
    gmehra     10/05/91 -  merging 
    mwick      10/02/91 -  Adding new IDs for Stored Procs 
    sxgupta    09/26/91 -  add ds_cldm 
    sxgupta    09/17/91 -  add preference 
    pfriedma   09/04/91 -  Adding constant for steve 
    pfriedma   08/22/91 -  Changing DSN constants 
    pfriedma   08/18/91 -  Changing dsn stuff. 
    pfriedma   07/26/91 -  Adding new column ids. 
    pfriedma   07/25/91 -  Changing DS_CLASS to DS_CLAS 
    sxgupta    07/25/91 -  change ds_class to dsclass 
    pfriedma   07/25/91 -  Moving name resolution symbols from dsn.h to dsid. 
    sxgupta    07/19/91 -  add location 
    sxgupta    07/12/91 -  add generic const. 
    sxgupta    07/12/91 -  cal spids 
    pfriedma   06/30/91 -  Adding global id size. 
    sxgupta    06/19/91 -  add ds_name types 
    pfriedma   06/19/91 -  Including dsspid.h 
    sxgupta    06/03/91 -  calendar spids 
    sxgupta    05/30/91 -  fix ds_clra 
    pfriedma   05/28/91 -  Fixing attribute enums. 
    sxgupta    05/22/91 -  new sp 
    sxgupta    05/20/91 -  add dspnaper 
    sxgupta    05/16/91 -         add sp for org and role 
    byazdani   05/03/91 - Added New spid DSPNOPER
    byazdani   04/29/91 - Added SPIDs from dsc.h 
    sxgupta    04/22/91 -         add cl classes 
    sxgupta    04/19/91 -         add fuzzy sp 
    pfriedma   04/16/91 -         Adding demo sps 
    pfriedma   04/08/91 -         Moving defines to dsid. 
    pfriedma   04/02/91 -         Marking initial release 
    sxgupta    04/01/91 -         fix 
    sxgupta    03/29/91 -         Creation 
*/


#ifndef DSID
#define DSID

#ifndef DSSPID
#include <dsspid.h>
#endif

/* PUBLIC TYPES AND CONSTANTS ------------------------------------------ */

/* TOADS type identifiers (dsttypid) ----------------------------------- */
/*
** These are the datatypes which is supported by TOADS, and should be used
** when retrieving directory data.
*/
#define DSTYPES         100
#define DSTTID		101
#define DSTCID		102
#define DSTOID		103
#define DSTAID		104
#define DSTSPID		105
#define DSTBOOL		106
#define DSTNUM		107
#define DSTUNUM		108
#define DSTPTR		109
#define DSTSTR		110
#define DSTCSTR		111
#define DSTDATE		112
#define DSTCDES		113	/* Currently only used by ofcins */
#define DSTADES		114	/* Currently only used by ofcins */
#define DSTUSER		115	/* Currently only used by ofcins */
#define DSTERR		116	/* Currently only used by ofcins */
#define DSTGID		117
#define DSTLRAW		6	/* Currently only used by ofcins */
#define DSTLCHAR	5	/* Currently only used by ofcins */
#define DSTSNUM		118
#define DSTASTR		119	/* Currently valid only for PL/SQL */
#define DSTANUM		120	/* Currently valid only for PL/SQL */
#define DSTAGID		121	/* Currently valid only for PL/SQL */
#define DSTAOID		122	/* Currently valid only for PL/SQL */
#define DSTRAW          123     /* Raw Data Type */
#define DSTLORAW         124     /* Long Raw Data Type */

/* TOADS Bind Operation identifiers (dstoper) ------------------------ */
/*
** These are bind operations which can be done when using stored
** procedures. 
*/

#define DSBOPER         (dstoper)2000
#define DSEQUAL         (dstoper)2001
#define DSGREAT         (dstoper)2002
#define DSGEQL          (dstoper)2003
#define DSLESS          (dstoper)2004
#define DSLEQL          (dstoper)2005
#define DSNEQL          (dstoper)2006
#define DSLIKE          (dstoper)2007
#define DSIGNOR         (dstoper)2008



/* Class and attribute enumbers ======================================= */

/* Next available class = 266, DS_ALL = 255 */
/* Next available attr  = 1109, DSGEN1 = 970 */


/* Enums for DS_Class with prefix DSZ */
#define DS_CLAS  	201	/* DS_Class */
#define DSZ_SIZ 	15	/* number of attributes */
#define DSZCID    	501	/* ClassId */
#define DSZNAME    	502	/* Name */
#define DSZENUM    	503	/* Enumber */
#define DSZISPID    	504	/* InsertSpid */
#define DSZUSPID    	505	/* UpdateSpid */
#define DSZDSPID    	506	/* DeleteSpid */
#define DSZSSPID    	507	/* SelectSpid */
#define DSZOPER		856	/* Operation */
#define DSZUINAM       1008	/* UIName */
#define DSZNKEYS       1009	/* NumKeys */
#define DSZDENUM       1010	/* DomainEnum */
#define DSZOENUM       1011	/* OidEnum */
#define DSZNENUM       1012	/* NameEnum */
#define DSZFLAGS       1013	/* Flags */
#define DSZLSPID       1014	/* LockSpid */


/* Enums for DS_Attribute with prefix DSX */
#define DS_ATTR  	202	/* DS_Attribute */
#define DSX_SIZ 	14	/* number of attributes */
#define DSXAID    	508	/* AttributeId */
#define DSXENUM    	509	/* Enumber */
#define DSXNAME    	510	/* Name */
#define DSXCID    	511	/* ClassId */
#define DSXKIND    	512	/* Kind */
#define DSXLENG    	513	/* Length */
#define DSXMAND    	514	/* Mandatory */
#define DSXRELA    	515	/* Relation */
#define DSXUINAM       1015	/* UIName */
#define DSXFLAGS       1016	/* Flags */
#define DSXMAXV        1017	/* Maxval */
#define DSXMINV        1018	/* Minval */
#define DSXDVALU	857	/* DefaultValue */
#define DSXDESCR       1066	/* Description */




/* Enums for DS_IDMap with prefix DSQ */
#define DS_IDMAP  	203	/* DS_IDMap */
#define DSQ_SIZ 	2	/* number of attributes */
#define DSQOID    	516	/* ObjectID */
#define DSQGID    	517	/* GlobalID */



/* Enums for DS_RepLog with prefix DSJ */
#define DS_REPLG  	204	/* DS_RepLog */
#define DSJ_SIZ 	9	/* number of attributes */
#define DSJOID    	518	/* ObjectID */
#define DSJDOMA    	519	/* Domain */
#define DSJOPER    	520	/* Operation */
#define DSJITEM    	521	/* Item */
#define DSJSTATE    	522	/* State */
#define DSJCLASS    	523	/* Class */
#define DSJPACK    	524	/* Package */
#define DSJGID    	525	/* GlobalID */
#define DSJGROOP       1019	/* Groop */


/* Enums for DS_CommState with prefix DSS */
#define DS_COMM  	205	/* DS_CommState */
#define DSS_SIZ 	6	/* number of attributes */
#define DSSNODE    	526	/* Node */
#define DSSPACK    	527	/* Package */
#define DSSDIRE    	528	/* Direction */
#define DSSSTATE    	529	/* State */
#define DSSDOMA		882	/* Domain */
#define DSSSTAMP       1047     /* Stamp */


/* Enums for DS_Replicator with prefix DSU */
#define DS_REP  	206	/* DS_Replicator */
#define DSU_SIZ 	5	/* number of attributes */
#define DSUENTRY    	530	/* Entry */
#define DSUSEQ    	531	/* Seq */
#define DSUTAG    	532	/* Tag */
#define DSUVALUE    	533	/* Value */
#define DSUSVAL		881	/* StrVal */


/* Enums for DS_ConfigInfo with prefix DSK */
#define DS_CONF  	207	/* DS_ConfigInfo */
#define DSK_SIZ 	15	/* number of attributes */
#define DSKNODE    	534	/* Node */
#define DSKSTATE    	535	/* State */
#define DSKTVERS    	536	/* TableVersion */
#define DSKEXPA    	537	/* Expansion */
#define DSKDQUOT    	538	/* DefaultQuota */
#define DSKDHOST    	539	/* DefaultHost */
#define DSKTZONE	863	/* Time Zone */
#define DSKPLEVE	864	/* Patch Level */
#define DSKDEBUG    	883	/* Debug */
#define DSKRINDE    	884	/* RunIndex */
#define DSKMVERS    	885	/* MailVersion */
#define DSKCVERS    	886	/* CalVersion */
#define DSKBROA    	887	/* Broadcast */
#define DSKTIME    	888	/* Timestamp */
#define DSKPASS        1046     /* Password */



/* Enums for DS_Name with prefix DSV */
#define DS_NAME  	208	/* DS_Name */
#define DSV_SIZ 	11	/* number of attributes */
#define DSVOID    	540	/* ObjectId */
#define DSVNAME    	541	/* Name */
#define DSVCATE    	542	/* Category */
#define DSVITEM    	543	/* Item */
#define DSVOWNER    	544	/* Owner */
#define DSVUINAM    	545	/* UIName */
#define DSVINAME    	546	/* ItemName */
#define DSVINAM2    	547	/* ItemName2 */
#define DSVINAM3    	548	/* ItemName3 */
#define DSVINAM4    	549	/* ItemName4 */
#define DSVDESC    	550	/* Description */



/* Enums for DS_Access with prefix DSF */
#define DS_AXESS  	209	/* DS_Access */
#define DSF_SIZ 	10	/* number of attributes */
#define DSFOID    	551	/* ObjectID */
#define DSFDID	        854	/* DomainID */
#define DSFUID    	552	/* UserID */
#define DSFITEM    	553	/* Item */
#define DSFOPER    	554	/* Operation */
#define DSFFNAME    	555	/* ForeignName */
#define DSFFNAM2    	556	/* ForeignName2 */
#define DSFFNAM3    	557	/* ForeignName3 */
#define DSFFNAM4    	558	/* ForeignName4 */
#define DSFTAG    	559	/* Tag */



/* Enums for DS_StaticElement with prefix DSW */
#define DS_STATM  	210	/* DS_StaticElement */
#define DSW_SIZ 	7	/* number of attributes */
#define DSWOID    	560	/* ObjectID */
#define DSWITEM    	561	/* Item */
#define DSWINAME    	562	/* ItemName */
#define DSWINAM2    	563	/* ItemName2 */
#define DSWINAM3    	564	/* ItemName3 */
#define DSWINAM4    	565	/* ItemName4 */
#define DSWSROWI    	566	/* StaticRowID */



/* Enums for DS_Person with prefix DSP */
#define DS_PER  	211	/* DS_Person */
#define DSP_SIZ 	50	/* number of attributes */
#define DSPOID    	567	/* ObjectID */
#define DSPDID    	568	/* DomainID */
#define DSPUNAME    	569	/* UserName */
#define DSPLNAME    	570	/* LastName */
#define DSPFNAME    	571	/* FirstName */
#define DSPMNAME    	572	/* MiddleName */
#define DSPNICK    	573	/* Nickname */
#define DSPPHOTO    	574	/* Photo */
#define DSPPASS    	575	/* Password */
#define DSPPACCO    	576	/* PrimaryAccount */
#define DSPEID    	577	/* EmployeeID */
#define DSPPNUMB    	578	/* PhoneNumber */
#define DSPOFFI    	579	/* Office */
#define DSPHADDR    	580	/* HomeAddress */
#define DSPHCITY    	581	/* HomeCity */
#define DSPHSTAT    	582	/* HomeState */
#define DSPHZIP    	583	/* HomeZIP */
#define DSPHCOUN    	584	/* HomeCountry */
#define DSPHPHON    	585	/* HomePhone */
#define DSPHFAX    	586	/* HomeFax */
#define DSPBIRT    	587	/* Birthday */
#define DSPLANG    	588	/* Language */
#define DSPMSTOP    	589	/* MailStop */
#define DSPMANA    	590	/* Manager */
#define DSPPROLE    	591	/* PrimaryRole */
#define DSPPORG    	592	/* PrimaryOrg */
#define DSPOSNAM    	593	/* OSName */
#define DSPFROLE    	873	/* ForeignRole */
#define DSPFORG    	874	/* ForeignOrg */
#define DSPFMGR    	875	/* ForeignMgr */
#define DSPAUANO    	892    	/* AcctUANode */
#define DSPASTAT    	893	/* AcctStatus */
#define DSPAKIND    	894	/* AcctKind */
#define DSPAQUOT    	895	/* AcctQuota */
#define DSPAHOST    	896	/* AcctHost */
#define DSPAFORE    	897	/* AcctForeignString */
#define DSPAFOR2    	898	/* AcctForeignString2 */
#define DSPAFOR3    	899	/* AcctForeignString3 */
#define DSPAFOR4    	900	/* AcctForeignString4 */
#define DSPWFNRQ    	1143	/* WF Notif Request */
#define DSPWFNLN    	1144	/* WF Notif Language */
#define DSPWFNTR    	1145	/* WF Notif Territory */
#define DSPWFNSC    	1146	/* WF Notif In Schedule */
#define DSPWFPST    	1147	/* WF Participation Status */
#define DSPCFSAD    	1148	/* CF Workstation Address */
#define DSPCFSNM    	1149	/* CF Workstation Name */
#define DSPCFPSV    	1150	/* CF Preferred Server */
#define DSPCFDST    	1151	/* CF Desktop Setup */
#define DSPCFCST    	1152	/* CF Current Status */
#define DSPUCERT    	1153	/* User Certificate */

/* Enums for DS_Attribute_Std */
#define DS_ATTRS         269
#define DSAS_SIZ          13

/* Enums for DS_Certificate */
#define DS_CERT         267   /* DS_Certificate */ 
#define DSCT_SIZ          3   /* number of attributes */
#define DSCTOID         1154  /* Object ID */
#define DSCTCERT        1155  /* Certificate */
#define DSCTHASH        1156  /* Hash of Certificate */

/* Enums for DS_CertAuthority */
#define DS_CA           268   /* DS_CertAuthority */
#define DSCA_SIZ         6    /* number of attributes */
#define DSCAOID         1157  /* Object Id */
#define DSCANAME        1158  /* Name */ 
#define DSCADID         1174  /* Domain Id */
#define DSCACRL         1159  /* Certificate RL */
#define DSCAARL         1160  /* Auth RL */
#define DSCACERT        1161  /* CA Certificate */
#define DSCAPAIR        1162  /* Cross Certificate Pair */
#define DSCADESC        1173  /* CA Description */

/* Enums for DS_RevocList */
#define DS_RL           269   /* DS_RevocList */
#define DSRL_SIZ         2    
#define DSRLOID         1163  /* Obj ID */
#define DSRLLIST        1164  /* Revoc List */

/* Enums for DS_CertPair */
#define DS_CPAIR          270   /* DS_CertPair */
#define DSCP_SIZ           3
#define DSCPOID          1170   /* Object ID */
#define DSCPFWD          1171   /* Fwd Certificate */
#define DSCPRVRS         1172   /* Reverse Certificate */

/* Enums for DS_Application with prefix DSAP */
#define DS_APPL  	212	/* DS_Application */
#define DSAP_SIZ 	4	/* number of attributes */
#define DSAPOID    	594	/* ObjectID */
#define DSAPDID    	595	/* DomainID */
#define DSAPNAME    	596	/* Name */
#define DSAPPASS    	597	/* Password */

/* Enums for DS_Role with prefix DSL */
#define DS_ROLE  	213	/* DS_Role */
#define DSL_SIZ 	4	/* number of attributes */
#define DSLOID    	598	/* ObjectID */
#define DSLDID    	599	/* DomainID */
#define DSLNAME    	600	/* Name */
#define DSLDESC    	601	/* Description */



/* Enums for DS_Organization with prefix DSO */
#define DS_ORG  	214	/* DS_Organization */
#define DSO_SIZ 	18	/* number of attributes */
#define DSOOID    	602	/* ObjectID */
#define DSODID    	603	/* DomainID */
#define DSONAME    	604	/* Name */
#define DSOMANA    	605	/* Manager */
#define DSOADMI    	606	/* Administrator */
#define DSOCCENT    	607	/* CostCenter */
#define DSOMSTOP    	608	/* MailStop */
#define DSOADDR    	609	/* Address */
#define DSOCITY    	610	/* City */
#define DSOSTATE    	611	/* State */
#define DSOZIP    	612	/* ZIP */
#define DSOCOUN    	613	/* Country */
#define DSOPHONE    	614	/* Phone */
#define DSOFNUMB    	615	/* FaxNumber */
#define DSOPARE    	616	/* Parent */
#define DSODESC    	617	/* Description */
#define DSOFMGR    	876	/* ForeignMgr */
#define DSOFADM    	877	/* ForeignAdm */



/* Enums for DS_Account with prefix DSA */
#define DS_ACCT  	215	/* DS_Account */
#define DSA_SIZ 	12	/* number of attributes */
#define DSAOID    	618	/* ObjectID */
#define DSADID    	619	/* DomainID */
#define DSANAME    	620	/* Name */
#define DSAUANOD    	621	/* UANode */
#define DSASTAT    	622	/* Status */
#define DSAKIND    	623	/* Kind */
#define DSAQUOTA    	624	/* Quota */
#define DSAHOST    	625	/* Host */
#define DSAFSTRI    	626	/* ForeignString */
#define DSAFSTR2    	627	/* ForeignString2 */
#define DSAFSTR3    	628	/* ForeignString3 */
#define DSAFSTR4    	629	/* ForeignString4 */


/* This # is the number of overlaps between DS_Account and other tables
   that it is related to.
*/

#define DS_ACCT_OVLP	3



/* Enums for DS_Node with prefix DSN */
#define DS_NODE  	216	/* DS_Node */
#define DSN_SIZ 	11	/* number of attributes */
#define DSNOID    	630	/* ObjectID */
#define DSNDID    	631	/* DomainID */
#define DSNNAME    	632	/* Name */
#define DSNCOMM    	633	/* Community */
#define DSNDOMA    	634	/* Domain */
#define DSNCOST    	635	/* Cost */
#define DSNRNAME    	636	/* ReplName */
#define DSNSNAM    	638	/* SchedName */
#define DSNSTAT    	640	/* Status */
#define DSNDESC    	641	/* Description */
#define DSNSCN    	901	/* SCN */



/* Enums for DS_Domain with prefix DSD */
#define DS_DOM  	217	/* DS_Domain */
#define DSD_SIZ 	8	/* number of attributes */
#define DSDOID    	642	/* ObjectID */
#define DSDNAME    	643	/* Name */
#define DSDQNAME    	644	/* QualifiedName */
#define DSDPID    	645	/* PackageID */
#define DSDPARE    	646	/* Parent */
#define DSDCNODE    	647	/* ConfigNode */
#define DSDDESC    	648	/* Description */
#define DSDBOOT        1044     /* Bootstrap */




/* Enums for DS_Gateway with prefix DSG */
#define DS_GATE  	218	/* DS_Gateway */
#define DSG_SIZ 	9	/* number of attributes */
#define DSGOID    	649	/* ObjectID */
#define DSGDID    	650	/* DomainID */
#define DSGNAME    	651	/* Name */
#define DSGNODE    	652	/* Node */
#define DSGKIND    	653	/* Kind */
#define DSGVINFO    	654	/* VisibleInfo */
#define DSGHINFO    	655	/* HiddenInfo */
#define DSGNINF1    	656	/* NumberInfo1 */
#define DSGDESC    	660	/* Description */



/* Enums for DS_GateType with prefix DSGY */
#define DS_GTTYP  	251	/* DS_GateType */
#define DSGY_SIZ 	2	/* number of attributes */
#define DSGYKIND       1006	/* Kind */
#define DSGYNAME       1007	/* Name */



/* Enums for DS_Route with prefix DSRT */
#define DS_ROUT  	219	/* DS_Route */
#define DSRT_SIZ 	6	/* number of attributes */
#define DSRTOID    	661	/* ObjectID */
#define DSRTSOUR    	662	/* Source */
#define DSRTTARG    	663	/* Target */
#define DSRTPATH    	664	/* Paths */
#define DSRTCOST    	665	/* Cost */
#define DSRTRFLA    	666	/* RewriteFlag */



/* Enums for DS_Path with prefix DSH */
#define DS_PATH  	220	/* DS_Path */
#define DSH_SIZ 	11	/* number of attributes */
#define DSHOID    	667	/* ObjectID */
#define DSHNNODE    	668	/* NextNode */
#define DSHONAME    	669	/* OracleName */
#define DSHOCONN    	670	/* OracleConnectInfo */
#define DSHOPASS    	671	/* OraclePassword */
#define DSHSTAT    	672	/* Status */
#define DSHMSIZE    	673	/* MaxSize */
#define DSHPSIZE    	674	/* PackageSize */
#define DSHNINF1    	675	/* NumbInfo1 */
#define DSHSINF1    	676	/* StringInfo1 */
#define DSHCOMM    	993	/* Community */



/* Enums for DS_Community with prefix DSC */
#define DS_CMNTY  	221	/* DS_Community */
#define DSC_SIZ 	4	/* number of attributes */
#define DSCOID    	677	/* ObjectID */
#define DSCNAME    	679	/* Name */
#define DSCPROT    	680	/* Protocol */
#define DSCDESC    	681	/* Description */



/* Enums for DS_CommRoute with prefix DSCR */
#define DS_CRTE  	222	/* DS_CommRoute */
#define DSCR_SIZ 	5	/* number of attributes */
#define DSCROID    	682	/* ObjectID */
#define DSCRSCOM    	683	/* SourceCommunity */
#define DSCRTCOM    	684	/* TargetCommunity */
#define DSCRCCOM    	685	/* ConnectCommunity */
#define DSCRCOST    	686	/* Cost */



/* Enums for DS_Printer with prefix DSPT */
#define DS_TOOL  	223	/* DS_Printer */
#define DSPT_SIZ 	10	/* number of attributes */
#define DSPTOID    	687	/* ObjectID */
#define DSPTDID    	688	/* DomainID */
#define DSPTNAME    	689	/* Name */
#define DSPTNODE    	690	/* Node */
#define DSPTDESC    	691	/* Description */
#define DSPTNUM1	858	/* Numb1 */
#define DSPTNUM2	859	/* Numb2 */
#define DSPTSTR1	860	/* String1 */
#define DSPTSTR2	861	/* String2 */
#define DSPTSTR3	862	/* String3 */



/* Enums for DS_Location with prefix DSM */
#define DS_LOC  	224	/* DS_Location */
#define DSM_SIZ 	7	/* number of attributes */
#define DSMOID    	692	/* ObjectID */
#define DSMDID    	693	/* DomainID */
#define DSMNAME    	694	/* Name */
#define DSMPARE    	695	/* Parent */
#define DSMADMI    	696	/* Administrator */
#define DSMDESC    	697	/* Description */
#define DSMFADM    	878	/* ForeignAdm */



/* Enums for DS_Room with prefix DSR */
#define DS_ROOM  	225	/* DS_Room */
#define DSR_SIZ 	19	/* number of attributes */
#define DSROID    	698	/* ObjectID */
#define DSRDID    	699	/* DomainID */
#define DSRNAME    	700	/* Name */
#define DSRLOCA    	701	/* Location */
#define DSRADMI    	702	/* Administrator */
#define DSRKIND    	703	/* Kind */
#define DSRAID    	704	/* AccountID */
#define DSRCAPA    	705	/* Capacity */
#define DSRDESC    	706	/* Description */
#define DSRFADM    	879	/* ForeignAdm */
#define DSRAUANO    	905	/* AcctUANode */
#define DSRASTAT    	906	/* AcctStatus */
#define DSRAKIND    	907	/* AcctKind */
#define DSRAQUOT    	908	/* AcctQuota */
#define DSRAHOST    	909	/* AcctHost */
#define DSRAFORE    	910	/* AcctForeignString */
#define DSRAFOR2    	911	/* AcctForeignString2 */
#define DSRAFOR3    	912	/* AcctForeignString3 */
#define DSRAFOR4    	913	/* AcctForeignString4 */



/* Enums for DS_Equipment with prefix DSE */
#define DS_EQUIP  	226	/* DS_Equipment */
#define DSE_SIZ 	20	/* number of attributes */
#define DSEOID    	707	/* ObjectID */
#define DSEDID    	708	/* DomainID */
#define DSENAME    	709	/* Name */
#define DSELOCA    	710	/* Location */
#define DSEADMI    	711	/* Administrator */
#define DSEKIND    	712	/* Kind */
#define DSEAID    	713	/* AccountID */
#define DSEMOVA    	714	/* Movable */
#define DSEDESC    	715	/* Description */
#define DSEMNO		855	/* ModelNo */
#define DSEFADM    	880	/* ForeignAdm */
#define DSEAUANO    	917	/* AcctUANode */
#define DSEASTAT    	918	/* AcctStatus */
#define DSEAKIND    	919	/* AcctKind */
#define DSEAQUOT    	920	/* AcctQuota */
#define DSEAHOST    	921	/* AcctHost */
#define DSEAFORE    	922	/* AcctForeignString */
#define DSEAFOR2    	923	/* AcctForeignString2 */
#define DSEAFOR3    	924	/* AcctForeignString3 */
#define DSEAFOR4    	925	/* AcctForeignString4 */



/* Enums for DS_PubStaticList with prefix DSBD */
#define DS_PUBDL  	228	/* DS_PubStaticList */
#define DSBD_SIZ 	11	/* number of attributes */
#define DSBDOID    	718	/* ObjectID */
#define DSBDNAME    	719	/* Name */
#define DSBDUINA    	720	/* UIName */
#define DSBDCATE    	721	/* Category */
#define DSBDITEM    	722	/* Item */
#define DSBDOWNE    	723	/* Owner */
#define DSBDINAM    	724	/* ItemName */
#define DSBDINA2    	725	/* ItemName2 */
#define DSBDINA3    	726	/* ItemName3 */
#define DSBDINA4    	727	/* ItemName4 */
#define DSBDDESC    	728	/* Description */



/* Enums for DS_PubAlias with prefix DSBA */
#define DS_PBAL  	229	/* DS_PubAlias */
#define DSBA_SIZ 	11	/* number of attributes */
#define DSBAOID    	729	/* ObjectID */
#define DSBANAME    	730	/* Name */
#define DSBAUINA    	731	/* UIName */
#define DSBACATE    	732	/* Category */
#define DSBAITEM    	733	/* Item */
#define DSBAOWNE    	734	/* Owner */
#define DSBAINAM    	735	/* ItemName */
#define DSBAINA2    	736	/* ItemName2 */
#define DSBAINA3    	737	/* ItemName3 */
#define DSBAINA4    	738	/* ItemName4 */
#define DSBADESC    	739	/* Description */



/* Enums for DS_PvtStaticList with prefix DSRD */
#define DS_PRDL  	230	/* DS_PvtStaticList */
#define DSRD_SIZ 	11	/* number of attributes */
#define DSRDOID    	740	/* ObjectID */
#define DSRDNAME    	741	/* Name */
#define DSRDUINA    	742	/* UIName */
#define DSRDCATE    	743	/* Category */
#define DSRDITEM    	744	/* Item */
#define DSRDOWNE    	745	/* Owner */
#define DSRDINAM    	746	/* ItemName */
#define DSRDINA2    	747	/* ItemName2 */
#define DSRDINA3    	748	/* ItemName3 */
#define DSRDINA4    	749	/* ItemName4 */
#define DSRDDESC    	750	/* Description */



/* Enums for DS_PvtAlias with prefix DSRA */
#define DS_PRAL  	231	/* DS_PvtAlias */
#define DSRA_SIZ 	11	/* number of attributes */
#define DSRAOID    	751	/* ObjectID */
#define DSRANAME    	752	/* Name */
#define DSRAUINA    	753	/* UIName */
#define DSRACATE    	754	/* Category */
#define DSRAITEM    	755	/* Item */
#define DSRAOWNE    	756	/* Owner */
#define DSRAINAM    	757	/* ItemName */
#define DSRAINA2    	758	/* ItemName2 */
#define DSRAINA3    	759	/* ItemName3 */
#define DSRAINA4    	760	/* ItemName4 */
#define DSRADESC    	761	/* Description */



/* Enums for DS_StaticRow with prefix DSSR */
#define DS_SROW  	232	/* DS_StaticRow */
#define DSSR_SIZ 	7	/* number of attributes */
#define DSSRSROW    	762	/* StaticRowID */
#define DSSRITEM    	763	/* Item */
#define DSSRINAM    	764	/* ItemName */
#define DSSRINA2    	765	/* ItemName2 */
#define DSSRINA3    	766	/* ItemName3 */
#define DSSRINA4    	767	/* ItemName4 */
#define DSSROID    	768	/* ObjectID */



/* Enums for OM_Instance with prefix OMIN */
#define OM_INST  	233	/* OM_Instance */
#define OMIN_SIZ 	8	/* number of attributes */
#define OMINMID    	769	/* msg_Id */
#define OMINFID    	770	/* folder_Id */
#define OMINPRIO    	771	/* priority */
#define OMINFLAG    	772	/* flags */
#define OMINRDAT    	773	/* retention_Date */
#define OMINRECE    	774	/* received_date */
#define OMINSTAT    	775	/* status */
#define OMINQUEU    	776	/* queue */



/* Enums for OM_Header with prefix OMHE */
#define OM_HEAD  	234	/* OM_Header */
#define OMHE_SIZ 	20	/* number of attributes */
#define OMHEMID    	777	/* Msg_ID */
#define OMHEMTYP    	778	/* msg_Type */
#define OMHEHFLA    	779	/* hdr_Flags */
#define OMHESID    	780	/* sender_ID */
#define OMHEPRIO    	781	/* priority */
#define OMHEMSIZ    	782	/* msg_Size */
#define OMHESDAT    	783	/* sent_Date */
#define OMHERDAT    	784	/* Received_Date */
#define OMHERETE    	785	/* retention_date */
#define OMHEAFLA    	786	/* att_Flag */
#define OMHERTO    	787	/* reply_To */
#define OMHETSTR    	788	/* to_Str */
#define OMHECSTR    	789	/* cc_Str */
#define OMHEBSTR    	790	/* bcc_Str */
#define OMHESUBJ    	791	/* subject */
#define OMHEFSTR    	792	/* from_Str */
#define OMHESNAM    	793	/* sender_Name */
#define OMHEIID    	794	/* inclusion_ID */
#define OMHEGID    	795	/* global_ID */
#define OMHENODE	865	/* node_id */



/* Enums for OM_Ext_Header with prefix OMEH */
#define OM_EXTH  	235	/* OM_Ext_Header */
#define OMEH_SIZ 	8	/* number of attributes */
#define OMEHMID    	796	/* msg_ID */
#define OMEHONO    	797	/* order_No */
#define OMEHPROM    	798	/* prompt */
#define OMEHVALU    	799	/* value */
#define OMEHETYP    	800	/* eh_Type */
#define OMEHINF1    	801	/* info1 */
#define OMEHINF2    	802	/* info2 */
#define OMEHINF3    	803	/* info3 */



/* Enums for OM_Body with prefix OMBD */
#define OM_BODY  	236	/* OM_Body */
#define OMBD_SIZ 	13	/* number of attributes */
#define OMBDMID    	804	/* msg_ID */
#define OMBDPART    	805	/* part */
#define OMBDONO    	806	/* order_No */
#define OMBDMLIN    	808	/* msg_Line */
#define OMBDLIN2    	809	/* line2 */
#define OMBDLIN3    	810	/* line3 */
#define OMBDLIN4    	811	/* line4 */
#define OMBDLIN5    	812	/* line5 */
#define OMBDLIN6    	813	/* line6 */
#define OMBDLIN7    	814	/* line7 */
#define OMBDLIN8    	815	/* line8 */
#define OMBDLIN9    	816	/* line9 */
#define OMBDLIN0    	817	/* line10 */



/* Enums for DS_Registration with prefix DSOR */
#define DS_REG  	237	/* DS_Registration */
#define DSOR_SIZ 	11	/* number of attributes */
#define DSORKEY1    	818	/* key1 */
#define DSORKEY2    	819	/* key2 */
#define DSORAID    	820	/* application_ID */
#define DSORNNAM    	821	/* notify_Name */
#define DSORDB_S    	822	/* DB_Session_ID */
#define DSOROS_P    	823	/* OS_Process_ID */
#define DSORHNAM    	824	/* Host_Name */
#define DSORNTYP    	825	/* Notify_Type */
#define DSORUSAG    	826	/* Usage */
#define DSORINF1    	827	/* info1 */
#define DSORINF2    	828	/* info2 */



/* Enums for DS_Process_Tokens with prefix DSPK */
#define DS_PTOK  	238	/* DS_Process_Tokens */
#define DSPK_SIZ        7	/* number of attributes */
#define DSPKCID    	829	/* ClassID */
#define DSPKPID    	830	/* ParameterID */
#define DSPKPTYP    	831	/* ParameterType */
#define DSPKNAME    	832	/* Name */
#define DSPKDESC    	833	/* Description */
#define DSPKMIVL    	1049	/* MinVal */
#define DSPKMAVL    	1050	/* MaxVal */



/* Enums for DS_Process with prefix DSPC */
#define DS_PROC  	239	/* DS_Process */
#define DSPC_SIZ 	8	/* number of attributes */
#define DSPCCID    	834	/* ClassID */
#define DSPCIID    	835	/* InstanceID */
#define DSPCNAME    	926	/* Name */
#define DSPCFLAG    	836	/* Flags */
#define DSPCLWAK    	837	/* LastWakeTime */
#define DSPCLSLE    	838	/* LastSleepTime */
#define DSPCPSTA    	927	/* ProcessState */
#define DSPCPSET       1045     /* ProcSet */
#define DSPCGID        1075     /* GuardinID */



/* Enums for DS_Proc_Params with prefix DSPM */
#define DS_PPARM  	240	/* DS_Proc_Params */
#define DSPM_SIZ 	6	/* number of attributes */
#define DSPMCID    	839	/* ClassID */
#define DSPMIID    	840	/* InstanceID */
#define DSPMPARA    	841	/* Parameter */
#define DSPMVNUM    	842	/* ValueNum */
#define DSPMVCHA    	843	/* ValueChar */
#define DSPMVDAT    	844	/* ValueDate */



/* Enums for DS_Proc_Time with prefix DSTM */
#define DS_PTIME  	241	/* DS_Proc_Time */
#define DSTM_SIZ 	7	/* number of attributes */
#define DSTMCID    	845	/* ClassID */
#define DSTMIID    	846	/* InstanceID */
#define DSTMSTIM    	847	/* StartTime */
#define DSTMDURA    	848	/* Duration */
#define DSTMFLAG    	849	/* Flags */
#define DSTMSLEE    	850	/* Sleeptime */
#define DSTMSTAT    	851	/* State */




/* Enums for DS_OClass with prefix DSOC */
#define DS_OCLAS  	242	/* DS_OClass */
#define DSOC_SIZ 	8	/* number of attributes */
#define DSOCCID    	852	/* ClassID */
#define DSOCNAME      	853     /* Name - obsolete */
#define DSOCSSYS    	928	/* SubSystem */
#define DSOCLNAM       1000	/* LoginName */
#define DSOCDNAM       1001	/* DisplayName */
#define DSOCDID        1002	/* DomainID */
#define DSOCPASS       1003	/* Password */
#define DSOCAID        1004	/* ApplicationID */
#define DSOCENAM       1005	/* ExecName */



/* Enums for DS_GateApp with prefix DSGP */
#define DS_GAPP  	252	/* DS_GateApp */
#define DSGP_SIZ 	8	/* number of attributes */
#define DSGPCID    	1020	/* ClassID */
#define DSGPLNAM    	1021	/* LoginName */
#define DSGPDNAM    	1022	/* DisplayName */
#define DSGPDID    	1023	/* DomainID */
#define DSGPPASS    	1024	/* Password */
#define DSGPAID    	1025	/* ApplicationID */
#define DSGPENAM    	1026	/* ExecName */
#define DSGPSSYS    	1027	/* SubSystem */



/* Enums for DS_UserApp with prefix DSUP */
#define DS_UAPP  	253	/* DS_UserApp */
#define DSUP_SIZ 	8	/* number of attributes */
#define DSUPCID    	1028	/* ClassID */
#define DSUPLNAM    	1029	/* LoginName */
#define DSUPDNAM    	1030	/* DisplayName */
#define DSUPDID    	1031	/* DomainID */
#define DSUPPASS    	1032	/* Password */
#define DSUPAID    	1033	/* ApplicationID */
#define DSUPENAM    	1034	/* ExecName */
#define DSUPSSYS    	1035	/* SubSystem */



/* Enums for DS_InternalApp with prefix DSIP */
#define DS_IAPP  	254	/* DS_InternalApp */
#define DSIP_SIZ 	8	/* number of attributes */
#define DSIPCID    	1036	/* ClassID */
#define DSIPLNAM    	1037	/* LoginName */
#define DSIPDNAM    	1038	/* DisplayName */
#define DSIPDID    	1039	/* DomainID */
#define DSIPPASS    	1040	/* Password */
#define DSIPAID    	1041	/* ApplicationID */
#define DSIPENAM    	1042	/* ExecName */
#define DSIPSSYS    	1043	/* SubSystem */



/* Enums for OM_Att_Types with prefix OMAT */
#define OM_ATT  	243	/* OM_Att_Types */
#define OMAT_SIZ        9	/* number of attributes */
#define OMATOID    	929	/* ObjectID */
#define OMATATYP    	866	/* att_type */
#define OMATANAM    	867	/* att_name */
#define OMATPLAT    	868	/* platform */
#define OMATBINA    	869	/* binary */
#define OMATDESC    	870	/* description */
#define OMATCOMM    	871	/* command */
#define OMATOS_I    	872	/* os_info */
#define OMATDID        1048     /* DomainID */

/* Enums for Admin pseudo class DA_Att_Types with prefix DATCH */ 
/*	 Note this class is only used by Admin for fetching attachtypes */
#define DA_ATT  	265	/* DA_Att_Types */
#define DATCH_SIZ        9	/* number of attributes */
#define DATCHOID    	1119	/* ObjectID */
#define DATCHATYP    	1120	/* att_type */
#define DATCHANAM    	1121	/* att_name */
#define DATCHPLAT    	1122	/* platform */
#define DATCHBINA    	1123	/* binary */
#define DATCHDESC    	1124	/* description */
#define DATCHCOMM    	1125	/* command */
#define DATCHOS_I    	1126	/* os_info */
#define DATCHDID        1127    /* DomainID */

/* Enums for OA_Pref with prefix OAPR */
#define OA_PREF  	244	/* OA_Pref */
#define OAPR_SIZ 	10	/* number of attributes */
#define OAPROID1    	930	/* Obj_ID1 */
#define OAPROID2    	931	/* Obj_ID2 */
#define OAPROID3    	932	/* Obj_ID3 */
#define OAPRRTYP    	933	/* Rec_Type */
#define OAPRPNO    	934	/* Prod_No */
#define OAPRPFNO    	935	/* Pref_No */
#define OAPRVTYP    	936	/* Val_Type */
#define OAPRNUMV    	937	/* Numval */
#define OAPRDATE    	938	/* Dateval */
#define OAPRSTRV    	939	/* Strval */



/* Enums for DS_Pref with prefix DSPF */
#define DS_PREF  	245	/* DS_Pref */
#define DSPF_SIZ 	4	/* number of attributes */
#define DSPFPNO    	940	/* Prod_No */
#define DSPFPFNO    	941	/* Pref_No */
#define DSPFNAM    	942	/* Name */
#define DSPFDESC    	943	/* Description */



/* Enums for DS_Product with prefix DSPD */
#define DS_PROD  	246	/* DS_Product */
#define DSPD_SIZ 	3	/* number of attributes */
#define DSPDPID    	944	/* ProductID */
#define DSPDNAME    	945	/* Name */
#define DSPDVERS    	946	/* Version */



/* Enums for OM_Mon_Test with prefix OMMN */
#define OM_MTES  	247	/* OM_Mon_Test */
#define OMMN_SIZ 	5	/* number of attributes */
#define OMMNTACT    	947	/* Test_Active */
#define OMMNONO    	948	/* Order_No */
#define OMMNTNAM    	949	/* Test_Name */
#define OMMNPID    	950	/* ProdID */
#define OMMNOEMS    	951	/* OEMsgID */



/* Enums for OMK_Tasks with prefix OMKT */
#define OM_KTSK  	248	/* OMK_Tasks */
#define OMKT_SIZ 	9	/* number of attributes */
#define OMKTTNAM    	952	/* Task_Name */
#define OMKTTID    	953	/* TaskID */
#define OMKTONO    	954	/* Order_No */
#define OMKTACTI    	955	/* Active */
#define OMKTLCOL    	956	/* Last_Coll */
#define OMKTEFRE    	957	/* Exp_Freq */
#define OMKTOERR    	958	/* On_Err_Comm */
#define OMKTERR    	959	/* Err */
#define OMKTSNO    	960	/* Stmt_No */


/* Enums for OM_Template with prefix OMTM */
#define OM_TMP  	249	/* OM_Template */
#define OMTM_SIZ 	12	/* number of attributes */
#define OMTMMID    	961	/* Msg_Id */
#define OMTMTOWN    	962	/* Templ_Owner */
#define OMTMTNAM    	963	/* Templ_Name */
#define OMTMDNAM    	964	/* Disp_Name */
#define OMTMTTYP    	965	/* Templ_Type */
#define OMTMTFLA    	966	/* Templ_Flags */
#define OMTMDESC    	967	/* Description */
#define OMTMFSTR    	968	/* Fcc_Str */
#define OMTMCDAT    	969	/* Create_Date */
#define OMTMMDAT    	990	/* Modify_Date */
#define OMTMEDAY    	991	/* Expire_Days */
#define OMTMDDAY    	992	/* Defer_Days */


/* Enums for OM_Prv_Temp with prefix OMPT */
#define OM_PTMP  	257	/* OM_Prv_Temp */
#define OMPT_SIZ 	12	/* number of attributes */
#define OMPTMID    	1054	/* Msg_Id */
#define OMPTTOWN    	1055	/* Templ_Owner */
#define OMPTTNAM    	1056	/* Templ_Name */
#define OMPTDNAM    	1057	/* Disp_Name */
#define OMPTTTYP    	1058	/* Templ_Type */
#define OMPTTFLA    	1059	/* Templ_Flags */
#define OMPTDESC    	1060    /* Description */
#define OMPTFSTR    	1061	/* Fcc_Str */
#define OMPTCDAT    	1062	/* Create_Date */
#define OMPTMDAT    	1063	/* Modify_Date */
#define OMPTEDAY    	1064	/* Expire_Days */
#define OMPTDDAY    	1065	/* Defer_Days */


/* Enums for DS_Rewrite with prefix DSRW */
#define DS_REWR  	250	/* DS_Rewrite */
#define DSRW_SIZ 	6	/* number of attributes */
#define DSRWOID    	994	/* ObjectID */
#define DSRWDID    	995	/* DomainID */
#define DSRWRNO    	996	/* Precedence */
#define DSRWPATT    	997	/* Pattern */
#define DSRWRESU    	998	/* Result */
#define DSRWDESC    	999	/* Description */

/* Enums for DS_Lookup with prefix DSLP */
#define DS_LKUP  	256	/* DS_Lookup */
#define DSLP_SIZ 	3	/* number of attributes */
#define DSLPAID    	1051	/* AttributeId */
#define DSLPNVAL    	1052	/* NumVal */
#define DSLPSVAL    	1053	/* StrVal */


/* Enums for DS_ObjSysAttrs with prefix DSSA */
#define DS_OSYSA	258	/* DS_ObjSysAttr */
#define DSSA_SIZ	6	/* number of attributes */
#define DSSAOID		1067	/* ObjectID */
#define DSSAGID		1068	/* GlobalID */
#define DSSATSTP	1069	/* TimeStamp */
#define DSSASTYP	1070	/* SystemType */
#define DSSARSV1	1071	/* Reserved 1 - num */
#define DSSARSV2	1072	/* Reserved 2 - str */

/* Enums fro DS_SyncType with prefix DSST */
#define DS_STYPE      260     /* DS_SyncType */
#define DSST_SIZ      6       /* number of attributes */
#define DSSTOID       1118    /* Last Package ID */
#define DSSTSYST      1085    /* SystemType */
#define DSSTNAME      1086    /* SystemName */
#define DSSTCODE      1087    /* SystemCode */
#define DSSTDESC      1088    /* Description */
#define DSSTPKID      1096    /* Last Package ID */

/* Enums for DS_RepSyncLog with prefix DSSJ */
#define DS_RSLOG      259
#define DSSJ_SIZ      11       /* number of attributes */
#define DSSJOID       1073     /* ObjectID */
#define DSSJDOM       1074     /* Domain */
#define DSSJOPR       1076     /* Operation */
#define DSSJITM       1077     /* Item */
#define DSSJNME	      1078     /* Name */	
#define DSSJSTA       1079     /* State */
#define DSSJCLS       1080     /* Class */
#define DSSJPCK       1081     /* Package */
#define DSSJGID       1082     /* GlobalID */
#define DSSJGROOP     1083     /* Groop */
#define DSSJTIM       1084     /* Timestamp */

/* Enums for DS_20Process with prefix DS2P */
#define DS_20PROC  	261	/* DS_20Process */
#define DS2P_SIZ 	7	/* number of attributes */
#define DS2PCID    	1089	/* ClassID */
#define DS2PIID    	1090	/* InstanceID */
#define DS2PFLAG    	1091	/* Flags */
#define DS2PLWAK    	1092	/* LastWakeTime */
#define DS2PLSLE    	1093	/* LastSleepTime */
#define DS2PPSTA    	1094	/* ProcessState */
#define DS2PPSET        1095    /* ProcSet */

/* Enum  for OM_PSF_TREE (Public/Shared Folder hierarchy */
#define OM_PSF_TREE	264     /* Public/Shared Folder hierarchy PseudoClass */

/* Enums for OM_PSF (Public/Shared Folders) with prefix OM_PSF */
#define OM_PSF          262     /* Public/Shared Folder Class */
#define OM_PSF_NUMATT   12      /* number of attributes */
#define OM_PSF_FID      1097    /* FolderID Attribute */
#define OM_PSF_NAME     1098    /* Name Attribute */
#define OM_PSF_TYPE     1099    /* Type Attribute */
#define OM_PSF_DL       1100    /* Distribution List Attribute */
#define OM_PSF_ADM      1101    /* Administrator Attribute */
#define OM_PSF_DKPT     1102    /* Days Kept Attribute */
#define OM_PSF_DESC     1103    /* Description Attribute */
#define OM_PSF_CD       1104    /* Create Date Attribute */
#define OM_PSF_MD       1105    /* Modified Date Attribute */
#define OM_PSF_OD       1106    /* Opened Date Attribute */
#define OM_PSF_SIZE     1107    /* Size Attribute */
#define OM_PSF_NUMM     1108    /* Number Of Messages Attribute */

/* Enums for OM_ATT_MAP (Gateway Attachment Maps) with prefix OMATM */
#define OM_ATT_MAP	263	/* OM_ATT_MAP - gateway attachment mappings */
#define OMATM_SIZ	9	/* number of attributes */
#define OMATMOID	1109    /* ObjectID */
#define OMATMDID	1110    /* DomainID */
#define OMATMTYP	1111    /* Office attachment type */
#define OMATMGWY	1112    /* Office gateway type */
#define OMATMFRG	1113    /* Foreign attachment type */
#define OMATMBIN	1114    /* Binary -- Not Used */
#define OMATMDESC	1115    /* Description */
#define OMATMCMD	1116    /* Command -- Not Used */
#define OMATMOSI	1117    /* OS Info -- Not Used */


/* Enums for name resolution function args with prefix DSNR */
#define DSNRNMEL	1073	/* number of stack elements */
#define DSNRETYP	1074	/* array of element types */
#define DSNREITM	1075	/* array of element item ids */
#define DSNREINM	1076	/* array of element item names */
#define DSNREONM	1077	/* array of element orig names */
#define DSNREPUB	1078	/* array of element publicized */
#define DSNRELDO	1079	/* array of element local domains */
#define DSNRTYPE	1080	/* element type */
#define DSNRITEM	1081	/* element item id */
#define DSNRINAM	1082	/* element item name */
#define DSNRORIG	1083	/* element item original string */
#define DSNRPUBL	1084	/* element publicized? */
#define DSNRLDOM	1085	/* element local domain id */
#define DSNRDIDS	1086	/* array of duplicate object ids */
#define DSNRECLS	1087	/* array of element classes */
#define DSNRFLAG	1088	/* context flag(s) */

/* Enums for Sync Export PL/SQL calls with prefix DSXP */
#define DSXPCLS		1089	/* Class to export */
#define DSXPDOM		1090	/* Domain to export */
#define DSXPSVR		1091	/* Server name filter */
#define DSXPTIM		1092	/* Timestamp filter */
#define DSXPSYS		1093	/* System type object filter */
#define DSXPNOB		1094	/* Number of objects exported/retrieved */
#define DSXPBSZ		1095	/* Output Buffer size */
#define DSXPITM		1096	/* Objectid of exported item */
#define DSXPOPR		1097	/* Operation assocated with object export */
#define DSXPLMK		1098	/* Index of last objectid retrieved */
#define DSXPDON		1099	/* end of object list indicator */

/* Check if attribute is a password */
#define DS_ISPASS(a) \
((a) == DSKPASS || (a) == DSPPASS || (a) == DSAPPASS || (a) == DSHOPASS || \
 (a) == DSOCPASS || (a) == DSGPPASS || (a) == DSUPPASS || (a) == DSIPPASS)

/* Miscellaneous attribute identifiers */
#define DSCOUNT	    970
#define DSSUM	    971
#define DSAVG	    972
#define DSSEQNXT    973
#define DSVIN234    974
#define DSWIN234    975
#define DSAFS234    976
#define DSFFN234    977

/* generic ones follow */
#define DSGEN1 978 /* generic 1 */
#define DSGEN2 979 /* generic 2 */
#define DSGEN3 980 /* generic 3 */
#define DSGEN4 981 /* generic 4 */
#define DSGEN5 982 /* generic 5 */
#define DSGEN6 983 /* generic 6 */
#define DSGEN7 984 /* generic 7 */
#define DSGEN8 985 /* generic 8 */
#define DSGEN9 986 /* generic 9 */
#define DSGEN0 988 /* generic 0 */

#define DSRESULT 987 /* generic result code */ 

/* convenience layer classes */
#define DS_CLRA DS_PRAL  /* pRivate Alias */
#define DS_CLBA DS_PBAL  /* puBlic Alias */
#define DS_CLRD DS_PRDL  /* pRivate Dl */
#define DS_CLBD DS_PUBDL /* puBlic Dl */
#define DS_CLDM DS_STATM /* DL elements */ 
#define DS_ALIAS 22
#define DS_STLST 23
#define DS_GROUP        255     /* gmehra - remove */
#define DS_ALL          256    



#ifdef DSV12

/* this is a class for the rhs of private DLs.  Make sure that this enumber
   is different from that for any other class.  This is used in v12 only
   since v20 creates no distinction between members of public and private
   DLs -  see dsxl.c */
#define DSV1PBDL  199

#define DSV1ALS	  (ub4)2
#define DSV1DLS   (ub4)3

#endif /* DSV12 */


/* name table category defines */
#define DSNMPRAL 10 /* private alias */
#define DSNMPRDL 20 /* private dl */
#define DSNMPBAL 40 /* public alias */
#define DSNMPBDL 50 /* public dl */
#define DSNMSRNM 70 /* search name */

/* dsntokn mode flags */

#define DSNCOMNT	(ub4)(1<<0)	/* include comments */

/* dsnres and dsntsp mode flags... */

#define DSNDOFLS	(ub4)(1<<0)	/* do a flush when done */
#define DSNNOFLS	(ub4)(~DSNDOFLS) /* don't do a flush when done */

#define DSNUNIQ		(ub4)(1<<1)	/* call function to choose duplicates*/
#define DSNDUP		(ub4)(~DSNUNIQ)	/* pass through duplicates... */

#define DSNLEAF		(ub4)(1<<2)	/* only leaves are results */
#define DSNALL		(ub4)(~DSNLEAF)	/* all nodes are results */
                                        /* only for dsnres (not dsntsp) */

#define DSNPUBL		(ub4)(1<<3)	/* Callback on least public forms */
#define DSNNPUB		(ub4)(~DSNPUBL)	/* Don't tell public forms */

#define DSNTYPE		(ub4)(1<<4)	/* Get type information for results */
#define DSNNTYP		(ub4)(~DSNTYPE)	/* Type information not needed */

#define DSNNODE		(ub4)(1<<5)	/* Get destination node for results */
#define DSNNNOD		(ub4)(~DSNNODE)	/* Destination node not needed */

#define DSNDOM		(ub4)(1<<6)	/* Restrict search to given domain */
#define DSNNDOM		(ub4)(~DSNDOM)	/* Search all domains on this node */

#define DSNRWR		(ub4)(1<<7)	/* Use rewrite rules */
#define DSNNRWR		(ub4)(~DSNRWR)	/* Don't rewrite the string */

/* reserved             (ub4)(1<<8)     */

#define DSNFIX		(ub4)(1<<9)	/* Fixup aliases/dl problems as found*/
#define DSNNFIX         (ub4)(~DSNFIX)  /* No fixum up */

#define DSN1DOM		(ub4)(1<<10)	/* Restrict qualified names to domain*/
#define DSNN1DOM	(ub4)(~DSN1DOM)	/* Normal */

#define DSNDEBUG	(ub4)(1<<11)	/* Turn on name resolution debugging */
#define DSNNDEBUG	(ub4)(~DSNDEBUG) /* Normal */

#define DSNSCHED	(ub4)(1<<12)	/* Run in "sched-mode" */
#define DSNNSCHD	(ub4)(~DSNSCHED) /* Normal */

/* control flags for the result functions */

#define DSNFLUSH	(ub4)(1<<0)	/* There are no more results... */
#define DSNABORT	(ub4)(1<<1)	/* an error occurred, clean up */
/*#define DSNLEAF	(ub4)(1<<2)*/	/* this is a leaf node (defined above)*/
/*#define DSNPUBL	(ub4)(1<<3)*/	/* a least public form of an object
					   object = alias, dl, or object
					   string = name of object (qualified)
					   original = original name token
					   where = (not used) */

/* result name types */

#define DSNFORGN	(eword)0	/* a foreign name */
                                        /* object = gateway
                                           string = foreign string
					   qualstr = (not used)
                                           where = gateway node */

#define DSNQUAL		(eword)1	/* a qualfied name */
                                        /* object = domain
					   string = name to be resolved in the
					            domain 
					   qualstr = (not used)
                                           where = config node of the domain */

#define DSNLOCAL	(eword)3	/* a local name */
                                        /* object = toads object
                                           string = the searchname
					   qualstr = fully qualified string
                                           where = (not used)*/

#define DSNDL		(eword)4	/* a dl */
                                        /* object = staticelement id 
                                           string = dl name
					   qualstr = fully qualified string
                                           where = (not used)*/
                                        /* (not valid in dsntsp) */

#define DSNEVAL		(eword)5	/* a unevaluated local */
                                        /* NOT PASSED TO CALLBACK */
                                        /* object = 1
                                           string = local name
					   qualstr = (not used)
                                           where = (not used)*/
                                        /* (not valid in dsntsp) */

#define DSNDUPE		(eword)6	/* resolves to duplicate objects
					   (only for dsnvfy) */

#define DSNALIS		(eword)7	/* an unevaluated alias */
                                        /* object = alias id
                                           string = alias name
					   qualstr = (not used)
                                           where = (not used)*/
                                        /* (not valid in dsntsp) */

#define DSNCMNT		(eword)8	/* a comment */
                                        /* only for dsntokn */

/* dsntsp return codes (what SGans wants) */

#define DSNLOUSR	(eword)10	/* a local user
					   object   = objectid of account
					   string   = mailid of account
					   original = original name token
					   where    = nodeid of here */

#define DSNLOGWY	(eword)11	/* a local gateway
					   object = objectid of gateway
					   string = foreign string
					   original = original name token
					   where    = nodeid of here */

#define DSNKNUSR	(eword)12	/* a known user
					   object = (not used)
					   string = %globalid of account
					   original = original name token
					   where = uanode of the account */

#define DSNKNGWY	(eword)13	/* a known gateway
					   object = (not used)
					   string = %globalid:foo
					   original = original name token
					   where = uanode of the gateway */

/*#define DSNQUAL	(eword)1 (defined above)*//* a local gateway
                                                     object = (not used)
						     string = foo@%globalid or
						         unix@%globalid:foo
						     original = original name
						     where = currently the 
						         config node of the 
						         destination domain */

#define DSNPARSE	(eword)14	/* a constant defined for SGans */
                                        /* do not change the value without
					   consulting SGans */

#define DSNLPF		(eword)15	/* a constant defined for SGans */
                                        /* do not change the value without
					   consulting SGans */

#define DSNSPECL	(eword)16      /* a special address form
					  object = (not used)
					  string = '%form'
					  original = original name token
					  where = uanode to go to next */
					  
/* Invalid name type result codes */

#define DSNBADNM	(eword)100

#define DSNSYNT		(eword)101	/* bad syntax */
#define DSNNONM		(eword)102	/* no such name */
#define DSNMULT		(eword)103	/* multiple names (only for dsnvfy) */
#define DSNGATE		(eword)104	/* bad gateway */
#define DSNDOMN		(eword)105	/* bad domain */
#define DSNBCHR		(eword)106	/* bad character */
#define DSNBNAM		(eword)107	/* bad name (alias or dl rhs) */
#define DSNOVRFL	(eword)108	/* too many objects match the name
					   (i.e. more than DSNMAXDP) */
#define DSNBADOB	(eword)109	/* object doesn't have an account */
#define DSNBADGI	(eword)110	/* bad global id */
#define DSNAMBG 	(eword)111	/* Ambiguous name (dupe function return
					                   no object) */
#define DSNACCES	(eword)112	/* Access violation... denied */

/* maximum result code */

#define DSNMXRCP	(eword)200


/* Transport Defines ----------------------------------------------- */

/* Package modes */
#define DSFPMVR		1	/* Verbose Read */
#define DSFPMVW		2	/* Verbose Write */
#define DSFPMTR		3	/* Terse Read */
#define DSFPMTW		4	/* Terse Write */

/* Package Options */

#define DSFPTSV		(ub2)1	/* Set savepoints */

/* Operations appearing in packages */
#define DSFOPN		0	/* No Op */
#define DSFOPI		1	/* Insert */
#define DSFOPU		2	/* Update */
#define DSFOPD		3 	/* Delete */
#define DSFOPS		4	/* Select */
#define DSFOPID         5       /* Insert ID_Mapping */
#define DSFOPSU		6	/* Select for Update */
#define DSFOPDP		7	/* Dump Insert/Update */

/* This next define should always be the highest-valued define from
   the list above.
*/
#define DSFOPMAX	DSFOPDP

/* Special operations only appearing in the log */
#define DSFOPBIRU	20	/* Unapproved birth of a node */
#define DSFOPBIRA	21	/* Approved birth of a node */
#define DSFOPDUMP	22	/* Dump a domain/class to a node */
#define DSFOPFKDL       23      /* Fake delete - provides complimentary
				   insert/deletes for replog squishing */
#define DSFOPUNSB	24	/* Unsubscribe domain clean up replicator info
				   toward this node */
#define DSFOPDELN     	25	/* Delete this node's info */
#define DSFOPDELD     	26	/* Delete this domain's info */
#define DSFOPMDCN	27	/* Move DCN op */
#define DSFOPMSCN	28	/* Move SCN op */

/* This next define should always be the highest-valued define from
   the list above.
*/
#define DSFOPSMX	DSFOPMSCN

/* TOADS common returns identifiers  ------------------------ */
/*
** The idea behind this is that API call will be coded in the following 
** format: 
**       if (API_Call) error_handler;  
** 
*/

#define DS_OK (dsterrid)0    /* Everything's ok */
#define DS_ERR (dsterrid)1   /* Random fatal error */

/* in name table 1 => null and 0 => invalid */
#define DSNULL 1 
#define DSINVLD 0

/* user preferences for cascading aliases/dl's */
#define DSWCBNML 0 /* dependencies get normal directory updates */
#define DSWCBNUL 1 /* nullify the existing dependencies */
#define DSWCBUCH 2 /* leave it unchanged */


/* MACROS -------------------------------------------------------------- */
/* trace defines */

#define DSTRFCON 1 /* trace facility on */
#define DSTRFCOF 0 /* trace facility off */

/* some adminstrative defines */
#define DSDSVER 1
#define DSDBVER 2

/* Constants ----------------------------------------------------------- */

#define DSTGSIZE	30	/* the size (in bytes) of a global id */

/* Constants For Stored Procedures */

#define DS_1NAME 2  	/* length for char(1) */

#ifdef DSV12
#define DS_SNAME 31 	/* short name length */
#define DS_LNAME 31	/* long name length */
#define DS_VNAME 241 	/* very long name length */
#define DS_KNAME 241	/* huge name length */
#else 
#ifdef DSV20
#define DS_SNAME 31 	/* short name length */
#define DS_LNAME 81 	/* long name length */
#define DS_VNAME 256 	/* very long name length */
#define DS_KNAME 1024 	/* kilo name length */
#define DS_HNAME 65536 	/* huge name length */
#endif /* DSV20 */
#endif /* DSV12 */

#define DSNUMBER 4 	/* number length */
#define DS_OID 4 	/* objectid length */
#define DS_LSEQ 4 	/* length of a sequence number */
#define DS_GID 31 	/* global id length */


#define DSNONE 0 	/* flag for none */




/* Constants for Account Status ================================= */

#define DSACOP	(ub4)0	   /* Open */
#define DSACNL  (ub4)1     /* Never logged in */
#define DSACDS  (ub4)2     /* Disconnected */


/* Constants for Node Status ==================================== */

#define DSNDOP	(ub4)0	   /* Open/Running */
#define DSNDSH	(ub4)1	   /* Shut/Down */
#define DSNDSTU (ub4)2     /* Starting Up */
#define DSNDNL  (ub4)3	   /* No Logins/Servers Only */
#define DSNDSHD (ub4)4	   /* Shutting Down */
#define DSNDRS  (ub4)5	   /* Guardian Refresh */


/* Constants for Account Kind ================================= */

#define DSAORAAC (ub4)0	   /* Oracle Account */
#define DSAFGNAC (ub4)1    /* Foreign/Offshore Account */


/* Constants for node state ================================= */

#define DSNDBTED (ub4)0    /* Booted */
#define DSNDBTIG (ub4)1	   /* Booting */


/* Login constants ------------------------------------------------ */

/* Types of servers that can have accounts */

#define DSSSREPL 10	/* Replicator */
#define DSSSSCED 20	/* Scheduler */
#define DSSSPOST 30	/* Postman */
#define DSSSDSYN 40	/* DirSync */

/* Other servers that need to be recognized */

#define DSSSGARD 40     /* Guardian */


/* logon control flags */
#define DSTLGTKT (ub4)0x1    /* Use Toolkit */
#define DSTLGENC (ub4)0x2    /* Encrypted Password */
#define DSTLGADM (ub4)0x4    /* Admin login */
#define DSTLGMO  (ub4)0x8    /* Do not display 'Keymap', and 'Login As' */
#define DSTLGDCL (ub4)0x10   /* Disconnected Client Login */
#define DSTLGLL  (ub4)0x20   /* Lite Login */
#define DSTLGSL  (ub4)0x40   /* disable unwanted options for DM */
#define DSTLGNAL (ub4)0x80   /* disable already logged in dialog */
#define DSTLGFLN (ub4)0x100  /* FORMS login */
#define DSTLGCPY (ub4)0x200  /* Copy login info back into user's struct */
#define DSTLGINP (ub4)0x400  /* Ignore Null Password */

/* Types for recognizing what type of login this is */
#define DSALSRVR  (eword)1	/* server logon */
#define DSALCLNT  (eword)2	/* client logon */
#define DSALGTWY  (eword)3	/* gateway logon */

/* Types for recognizing what operation we are performing 
 *   This is a temporary fix for delete alias performance 
 *   problem, and should be taken off after M3
*/
#define DSXOPDLAL (ub1)1  /* Delete alias operation */
#define DSZPSBLD  (ub1)2  /* dszpsbld operation being performed */

/* Constant ObjectId for Implicit admin user */
#define DSALSPAD  276		/* 256 * 1 + 20 */




/* STORED PROCEDURES -- Public------------------------------------------*/
/*
** These are the  external stored procedures which are supported by TOADS.
*/

#define DSP0PER         1003 
#define DSP0ORG         1009

#define DSPCPOMB 20 /* Given   a person  DSPID   return  the  primary   
		       mailbox (DSPPMAIL) associated with it */
#define DSPCAOVW 50 /* given any objectid  DSPID return all the associated 
		       overlays  DSUID */
#define DSPCMOND 80 /* given a mailbox  DSMID objectid return 
		       the node DSMUANOD */
 

/* Security Defines ======================================================= */


/* Default for security - this special ID corresponds to 'all' */
#define DSSALL 		2      


/* Privileges */

#define DSSLIST	     	(ub4)0x00000001	/* User can list the object */
#define DSSCONN		(ub4)0x00000002	/* User can connect to the object */
#define DSSSEND		(ub4)0x00000004	/* User can send to the object */
#define DSSADMIN     	(ub4)0x00000008 /* User has admin privileges */
#define DSSPRINT	(ub4)0x00000010 /* User has print/write to file privs */

#define DSSDIR3		(ub4)0x00000020 /* Reserved for directory */
#define DSSDIR4		(ub4)0x00000040 /* Reserved for directory */
#define DSSDIR5	        (ub4)0x00000080 /* Reserved for directory */


/* reserved for calendar - they need only 13 */
#define DSSCAL1		(ub4)0x00000100 /* Reserved for Scheduler */
#define DSSCAL2		(ub4)0x00000200 /* Reserved for Scheduler */
#define DSSCAL3		(ub4)0x00000400 /* Reserved for Scheduler */
#define DSSCAL4		(ub4)0x00000800 /* Reserved for Scheduler */
#define DSSCAL5		(ub4)0x00001000 /* Reserved for Scheduler */
#define DSSCAL6		(ub4)0x00002000 /* Reserved for Scheduler */
#define DSSCAL7		(ub4)0x00004000 /* Reserved for Scheduler */
#define DSSCAL8		(ub4)0x00008000 /* Reserved for Scheduler */
#define DSSCAL9		(ub4)0x00010000 /* Reserved for Scheduler */
#define DSSCAL10	(ub4)0x00020000 /* Reserved for Scheduler */
#define DSSCAL11	(ub4)0x00040000 /* Reserved for Scheduler */
#define DSSCAL12	(ub4)0x00080000 /* Reserved for Scheduler */
#define DSSCAL13	(ub4)0x00100000 /* Reserved for Scheduler */


/* reserved for mail - they get 8 */
#define DSSMAIL1	(ub4)0x00200000 /* Public Folder Discover hierarchy */
#define DSSMAIL2	(ub4)0x00400000 /* Public Folder list Content */
#define DSSMAIL3	(ub4)0x00800000 /* Public Folder Moderate Folder */
#define DSSMAIL4	(ub4)0x01000000 /* Public Folder create Child folder */
#define DSSMAIL5	(ub4)0x02000000 /* Reserved for Mail */
#define DSSMAIL6	(ub4)0x04000000 /* Reserved for Mail */
#define DSSMAIL7	(ub4)0x08000000 /* Reserved for Mail */
#define DSSMAIL8	(ub4)0x10000000 /* Reserved for Mail */

/* unused as yet */
#define DSSUNU1		(ub4)0x20000000 /* Unused */
#define DSSUNU2		(ub4)0x40000000 /* Unused */


/* reserved for future expansion */
#define DSSFUTR		(ub4)0x80000000 /* Reserved for future exp */

#define DSSACOWN	(ub4)0x1fff00  /* Privs. allowed to acct owner */
#define DSSACADM	(ub4)0x1fff01  /* Privs. adm has on acct */



#define DSSHSLST	(ub4)1		/* Has list privs. */
#define DSSNOLST	(ub4)0		/* Has no list privs. */



/* Constants for dswmail and dswcal ====================================== */

#define DSW_TOSTR	(eword)0
#define DSW_CCSTR	(eword)1
#define DSW_BCCSTR	(eword)2


#define DSW_ATTNDE	(eword)0
#define DSW_OPTATT	(eword)1
#define DSW_RESRC	(eword)2

/* Constants for dswdm ====================================== */
#define DSW_SSEL         (eword)0   /* Doc Management single selector */
#define DSW_MSEL         (eword)1   /* Doc Management multi selector */

/* temporary - to be removed */

#define DSPPOPER DSZOPER


#endif /* DSID */
