/*
 * $Header: dsspid.h,v 2.21 97/07/17 18:59:58 hmadan: Stab $
 */

/* Copyright (c) 1991 by Oracle Corporation */
/*
   NAME
     dsspid.h - stored procedure id's
   DESCRIPTION
     1. this has four type of stored procedures
     external -- range 0000 - 0990  specified in dsapi.h
     test     -- range 1000 - 1999  these are hard coded in the test files
     internal -- range 2000 - 7990  specified in this file
     complex  -- range 8000 - 12000 specified in this file

     2. each stored procedure, if possible, starts at the multiple of 
     10 boundary
   NOTES
     all stored procedures must have a one line description
   MODIFIED   (MM/DD/YY)
    hmadan     07/17/97 -  Add #define for a new SQL 
    clcooper   05/08/97 -  make dssp backward compatible for DSPDDLAS and DSP 
    hmadan     04/08/97 -  Change constant DSDDSUVER 
    hmadan     03/28/97 -  Add #define for DSPZRSTP 
    hmadan     03/16/97 -  Add #defines for sqls for CertAuthority 
    hmadan     11/14/96 -  Add more spid IDs for DS 
    mcheng     05/17/96 -  Add admin spid for attachtype select 
    mcheng     10/19/95 -  add OM_ATT_MAP DSF sql
    jfix       05/12/95 -  add DSPZRWRK and DSPZTWRK
    pruel      05/08/95 -  For multiple dump fix. 
    mcheng     04/10/95 -  Add DS_Synctype sql 
    yliu       02/23/95 -  add sp for DS_20Process 
    mcheng     01/09/95 -  Add new sql for DS_RepSyncLog 
    pruel      11/14/94 -  Changes for reconciliator. 
    tkukulsk   10/11/94 -  add id for mail init 
    jluke      06/21/94 -  Need to add name resolution SPIDs.
    tkukulsk   05/25/94 -  grab space for login's stored procedures 
    mcheng     05/15/94 -  Add DS_ObjSysAttr sql 
    jluke      02/23/94 -  Adding DSPASROL procedure to retrieve rolestring. 
    tkukulsk   01/06/94 -  Putting back DSPDMMUD 
    pfriedma   11/17/93 -  Adding spid for reset replicator
    pfriedma   10/06/93 -  Adding create accounts for people to dump. 
    pfriedma   08/26/93 -  Moving spids. 
    pfriedma   08/12/93 -  Removing unneeded SQL. 
    gmehra     08/04/93 -  fix numbers so they don't conflict 
    gmehra     08/04/93 -  add display fn for admin: 
    pfriedma   07/21/93 -  Moving spid. 
    gmehra     06/10/93 -  update line no. for DSPAAUAD 
    gmehra     05/24/93 -  shift dspaauad to make more room 
    pfriedma   05/22/93 -  Dumping system tables. 
    gmehra     03/17/93 -  fix dl element fixup problem 
    gmehra     03/14/93 -  fix room bug for security 
    gmehra     02/12/93 -  mark all scheduler's SPs 
    pfriedma   02/02/93 -  Redoing dumping. 
    gmehra     01/27/93 -  fix dscn2ci and dsan2ai 
    pfriedma   01/26/93 -  Fixing manual bootstrap. 
    pfriedma   01/25/93 -  Adding v1->v2 proc. 
    gmehra     01/15/93 -  on invoking edit alias, must pull RHS from databas 
    gmehra     01/07/93 -  update - remove some sps 
    pfriedma   12/14/92 -  Fixing Dumping attachment types. 
    pfriedma   12/11/92 -  Line too long. 
    yliu       12/09/92 -  add dsx8134 
    gmehra     12/04/92 -  add a new SP for Sched 
    gmehra     11/24/92 -  add an SP for getting domains given objectids 
    gmehra     11/24/92 -  add an SP for Bijan 
    pfriedma   11/19/92 -  Adding new node's route record 
    pfriedma   11/10/92 -  Adding verify names proc. 
    rellinge   11/02/92 -  update for patch25 
    pfriedma   10/26/92 -  Lazy binding procs. 
    pfriedma   10/16/92 -  Adding unhandled ack proc. 
    pfriedma   10/08/92 -  Package stuffing. 
    pfriedma   10/05/92 -  Adding cost based routing procs. 
    pfriedma   09/24/92 -  gdve dsz 
    yliu       09/21/92 -  add dsx8131 & dsx8132 
    pfriedma   09/16/92 -  Adding savepoint/rollback procs. 
    pfriedma   09/08/92 -  Adding more dump procs. 
    pfriedma   08/27/92 -  Optimizing large replog. 
    pfriedma   08/24/92 -  Scaleable2. 
    gmehra     08/24/92 -  add DM stored procedures 
    pfriedma   08/23/92 -  Adding lock procs. 
    yliu       08/14/92 -  add DSPDDM07 
    pfriedma   07/21/92 -  Olint 
    gmehra     07/21/92 -  add DSPAGGAT 
    yliu       07/19/92 -  remove DSPDCU05 and DSPDCU06 
    gmehra     07/19/92 -  pch17 
    gmehra     07/18/92 -  rm DSPXUGIC - application sp 
    gmehra     07/14/92 -  move the attribute SPID around 
    gmehra     07/13/92 -  add select for update of procedures 
    pfriedma   07/11/92 -  Adding unsubscribe operations. 
    yliu       07/06/92 -  add dsx8130 
    gmehra     07/02/92 -  fix up gateway logins and do already logged in 
    pfriedma   06/29/92 -  Adding multiple community. 
    yliu       06/23/92 -  add sp for delete operation 
    yliu       06/18/92 -  add complex sp 8123 
    pfriedma   06/14/92 -  Moving rewrite procs. 
    gmehra     06/13/92 -  finish all 
    gmehra     06/11/92 -  finish up fuzzy 
    pfriedma   06/03/92 -  Adding rewriting procs. 
    gmehra     06/02/92 -  add SP for rewrite seq 
    gmehra     06/01/92 -  add rewrite table 
    gplesur    05/28/92 -  delete idmapping of private info, if it exists 
    gmehra     05/25/92 -  add SP for print security 
    gplesur    05/22/92 -  add om_header conv 
    gmehra     05/18/92 -  add new SP DSPAAUAD for admin auth 
    gplesur    05/12/92 -  add two functions for invalidating references to a 
    gplesur    05/11/92 -  add DSPCXDRF 
    gplesur    04/29/92 -  add dspxugnm 
    gmehra     04/21/92 -  om_template 
    pfriedma   04/20/92 -  More replicator procs. 
    pfriedma   04/20/92 -  Adding more replicator procs. 
    gmehra     04/20/92 -  replace the too long #defines with shorter one 
    gmehra     04/13/92 -  olinting 
    pfriedma   04/10/92 -  Adding delete node remote proc. 
    pfriedma   04/07/92 -  Getting route table. 
    pfriedma   04/06/92 -  Generating route table. 
    pfriedma   03/31/92 -  Getting SCN node 
    pfriedma   03/31/92 -  Getting node's path. 
    gmehra     03/31/92 -  om_mon_test and omk_tasks added to data dict 
    pfriedma   03/26/92 -  Getting confignode from domain. 
    gmehra     03/24/92 -  new SPs for new security calls 
    pfriedma   03/22/92 -  Getting node name 
    gmehra     03/18/92 -  get id for ds_access 
    yliu       03/18/92 -  add DSPCXIND 
    pfriedma   03/12/92 -  Adding dsagui proc. 
    gmehra     03/11/92 -  fix for release 11.1 
    gmehra     03/06/92 -  v12 - fix public DL member fetch 
    gplesur    03/06/92 -  add 
    mwick      03/03/92 -  Add an existence SP for DS_Account 
    gmehra     03/03/92 -  add in DSV1GTPW and DSV1 STPW 
    pfriedma   03/02/92 -  Adding birth procs. 
    gplesur    03/01/92 -  add new csp 
    gplesur    03/01/92 -  add 
    gmehra     02/28/92 -  add dsv1dcpi 
    gmehra     02/26/92 -  merge v12 
    pfriedma   02/25/92 -  Adding replog procs. 
    gplesur    02/20/92 -  dspxicde 
    pfriedma   02/14/92 -  Adding proc for Jian. 
    mwick      02/13/92 -  Add new SPs 
    gplesur    02/13/92 -  new dsx ssp 
    pfriedma   02/12/92 -  Adding application addressing format. 
    gmehra     02/12/92 -  change the value for dspfiperson 
    gmehra     02/11/92 -  toads11 upgrade 
    gmehra     02/10/92 -  get uids for tool and app.Fix _SIZ 
    byazdani   02/05/92 -  Added Version 1.2 . 
    gmehra     02/04/92 -  add in calendar's SP for taking a username to a pe 
    gmehra     02/04/92 -  new procedure for default value 
    gplesur    02/04/92 -  new dsx ssps 
    pfriedma   02/03/92 -  Adding to-string procs. 
    gmehra     01/30/92 -  fixing login 
    pfriedma   01/30/92 -  Adding security layer to dsntsp. 
    gmehra     01/29/92 -  fix for viewer security 
    gmehra     01/28/92 -  do viewer security 
    pfriedma   01/28/92 -  Doing replicator procedures 
    gmehra     01/25/92 -  fix table schema 
    gmehra     01/17/92 -  security contd. 
    gmehra     01/15/92 -  doing security 
    gmehra     01/14/92 -  do security 
    pfriedma   01/13/92 -  Olint 
    gmehra     01/13/92 -  add calendar's procedure 
    pfriedma   01/07/92 -  Fixing alias->alias bug again. 
    pfriedma   01/07/92 -  Doing public form procs. 
    gmehra     12/20/91 -  define the domain procedures 
    pfriedma   12/20/91 -  Removing 2 name resolution spids. 
    gmehra     12/18/91 -  fix for toads10 
    pfriedma   12/18/91 -  Adding get name row by objectid. 
    pfriedma   12/15/91 -  Redoing qualified names. 
    msaffari   12/11/91 -  ALL 
    pfriedma   12/10/91 -  Adding dsc spid. 
    gmehra     12/07/91 -  add security stored procs 
    sxgupta    12/04/91 -  add gun 
    pfriedma   12/04/91 -  Ordering events. 
    sxgupta    12/03/91 -  add public stuff 
    pfriedma   12/02/91 -  Ordering events. 
    pfriedma   11/27/91 -  Fixing comment 
    pfriedma   11/27/91 -  Adding get config domain. 
    pfriedma   11/15/91 -  Finding destinations. 
    byazdani   11/15/91 -  Added Mail Req. 
    mwick      11/13/91 -  Fix ID numbers 
    pfriedma   11/10/91 -  Adding receive procedures. 
    gmehra     11/05/91 -  add log squishing procedures 
    pfriedma   11/04/91 -  Moving replicator procedures 
    pfriedma   11/04/91 -  Adding name proc. 
    gmehra     10/30/91 -  add DSPZNXTP 
    gmehra     10/30/91 -  add in procs for dsz 
    mwick      10/24/91 -  Add more SPIDs 
    pfriedma   10/21/91 -  Adding replicator procedures 
    gmehra     10/18/91 -  add dspagnod 
    gmehra     10/18/91 -  fix for dsauth 
    pfriedma   10/17/91 -  Adding replicator procedures 
    gmehra     10/15/91 -  add in DSPALOGN 
    sxgupta    10/08/91 -  get id's 
    msaffari   10/04/91 -  add DL CHECK 
    sxgupta    09/26/91 -  add dl members 
    pfriedma   09/24/91 -  Adding replicator event procedures.. 
    mwick      09/20/91 -  Cleaned up ordering 
    mwick      09/19/91 -  Add new data dictionary procs 
    pfriedma   08/20/91 -  merging dsn changes 
    sxgupta    08/16/91 -  alias &^ dl 
    sxgupta    07/19/91 -  add seq id's 
    sxgupta    07/09/91 -  fix fuzzy 
    sxgupta    07/03/91 -  add dspxidsd 
    sxgupta    07/02/91 -  delete dl 
    pfriedma   07/01/91 -  Adding id conversion procedure. 
    sxgupta    06/30/91 -  add new sp 
    pfriedma   06/26/91 -  adding DSPXISHD for suchin. 
    pfriedma   06/24/91 -  Qualified domain stored procedure. 
    pfriedma   06/20/91 -  including in right order... 
    sxgupta    06/19/91 -  add xi calls 
    pfriedma   06/18/91 -  Name resolution procedures. 
    sxgupta    06/17/91 -  add other symbols 
    sxgupta    06/07/91 -  inserts, updates and deletes 
    sxgupta    05/29/91 -  new classes 
    sxgupta    05/21/91 -  Creation 
*/
 
#ifndef DSSPID
#define DSSPID


/* Some of our SPs are being used by Scheduler and Document management.
   Please make sure that if any of these SPs are changed, then the
   appropriate groups are informed 

   Scheduler

         DSPAGUSF
	 DSPCALEN
	 DSPNMBOX
	 DSPNPERS
	 DSPNROOM
	 DSPOTGID
	 DSPUTOID
	 DSPXLIRM

   Document Management
   
         DSPDMSCN
	 DSPXLIPR (will be replaced with DSPDMMPR)
	 DSPDMMOR
	 DSPDMMRL
	 DSPDMMPR
	 DSPDMMND
	 DSPDMMBD
	 DSPDMMDM
	 DSPDMMDC
	 DSPDMMIO
	 DSPDMMIL
	 DSPDMMIP
	 DSPDMMIN
	 DSPDMMIB
*/

#define DSDDSUVER  (ub4)4100000 /* Expected minimum version of the IO schema
				   for Std/Usr Extensibily changes to take effect -
				   This const actually should be kept in dsdd.h, 
				   however that will mean including dsdd.h in a 
				   lot of places. dsspid.h is included in a 
				   lot of other .h files. */

/* procedures for security on viewer */
#define DSPXLSOR (dstspid)2000 /* Viewer SP for org with security */
#define DSPXLSRL (dstspid)2010 /* Viewer SP for role with security */
#define DSPXLSDM (dstspid)2020 /* Viewer SP for dom with security */
#define DSPXLSEQ (dstspid)2030 /* Viewer SP for equip with security */
#define DSPXLSGT (dstspid)2040 /* Viewer SP for gtway with security */
#define DSPXLSLC (dstspid)2050 /* Viewer SP for loc with security */
#define DSPXLSRM (dstspid)2060 /* Viewer SP for room with security */
#define DSPXLSBA (dstspid)2070 /* Viewer SP for pub. alias with security */
#define DSPXLSPT (dstspid)2080 /* Viewer SP for printer with security */
#define DSPXLSND (dstspid)2090 /* Viewer SP for node with security */
#define DSPXLSBD (dstspid)2100 /* Viewer SP for pub. DLs with security */
#define DSPXLSAP (dstspid)2110 /* Viewer SP for all people with security */
#define DSPXLSPR (dstspid)2120 /* Viewer SP for people with security */
#define DSPXUGTL (dstspid)2130 /* Get uid for ds_tools */
#define DSPXUGMT (dstspid)2150 /* Get uid for om_att_types */
#define DSPXUGCR (dstspid)2160 /* Get uid for ds_commroute */
#define DSPXUGSC (dstspid)2170 /* Get uid for ds_access */
#define DSPSIGRN (dstspid)2180 /* Get oid of grants for given item */
#define DSPSUGRN (dstspid)2190 /* Get oid of grants for given userid */
#define DSPXUGSY (dstspid)2195 /* Get oid for ds_synctype */
#define DSPXUGMM (dstspid)2200 /* Get msgid for mail info. */
#define DSPAAUAD (dstspid)2206 /* Authorize admin logon */

/* Attribute level searches */
#define DSPXLLNP (dstspid)2220 /* Person name search - no security */
#define DSPXLLOR (dstspid)2230 /* Org    attr level - no security */
#define DSPXLLRL (dstspid)2240 /* Role   attr level - no security */
#define DSPXLLEQ (dstspid)2250 /* Equip  attr level - no security */
#define DSPXLLRM (dstspid)2260 /* Room   attr level - no security */
#define DSPXLLRA (dstspid)2270 /* PvtAlias attr level - no security */
#define DSPXLLBA (dstspid)2280 /* PubAlias attr level - no security */
#define DSPXLLRD (dstspid)2290 /* PvtDL  attr level - no security */
#define DSPXLLBD (dstspid)2300 /* PubDL  attr level - no security */
#define DSPXLLND (dstspid)2310 /* Node   attr level - no security */
#define DSPXLLDM (dstspid)2320 /* Domain attr level - no security */
#define DSPXLLLC (dstspid)2330 /* Loc    attr level - no security */
#define DSPXLLGT (dstspid)2340 /* Gtway  attr level - no security */
#define DSPXLLPT (dstspid)2350 /* Tools  attr level - no security */

#define DSPXLMNP (dstspid)2360 /* Person name search - security */
#define DSPXLMOR (dstspid)2370 /* Org    attr level - security */
#define DSPXLMRL (dstspid)2380 /* Role   attr level - security */
#define DSPXLMEQ (dstspid)2390 /* Equip  attr level - security */
#define DSPXLMRM (dstspid)2400 /* Room   attr level - security */
#define DSPXLMBA (dstspid)2410 /* PubAlias attr level - security */
#define DSPXLMBD (dstspid)2420 /* PubDL  attr level - security */
#define DSPXLMND (dstspid)2430 /* Node   attr level - security */
#define DSPXLMDM (dstspid)2440 /* Domain attr level - security */
#define DSPXLMLC (dstspid)2450 /* Loc    attr level - security */
#define DSPXLMGT (dstspid)2460 /* Gtway  attr level - security */
#define DSPXLMPT (dstspid)2470 /* Tools  attr level - security */

/* misc - need to be reorged */
#define DSPXUGRW (dstspid)2480 /* Get ID for DS_Rewrite */
#define DSPXLFPT (dstspid)2490 /* convenience list fuzzy tools */
#define DSPXLLPR (dstspid)2500 /* Person attr level - no security */
#define DSPXLMPR (dstspid)2520 /* Person attr level - security */
#define DSPXLFPR (dstspid)2540 /* convenience list fuzzy person */
#define DSPXLLLL (dstspid)2560 /* all attr level - no security */
#define DSPALGIN (dstspid)2570 /* already logged in */
#define DSPALGGT (dstspid)2580 /* gateway authorization */
#define DSPAGGAT (dstspid)2590 /* gateway info */
#define DSPWHRHS (dstspid)2600 /* get RHS of an alias */
#define DSPXDCPY (dstspid)2610 /* get owner, item, category for a dl */
#define DSPSPOW  (dstspid)2620 /* get domainid given person oid */
#define DSPSROW  (dstspid)2625 /* get domainid given room oid */
#define DSPSEOW  (dstspid)2630 /* get domainid given equip oid */

/* Stored procedure for doc mgmt - Prefix with DSPDMM - 3500 to 3999 */
/* also any SPs for external use */
#define DSPDMMOR (dstspid)3500 /* get org id given name and domainid */
#define DSPDMMRL (dstspid)3510 /* get role id given name and domainid */
#define DSPDMMPR (dstspid)3520 /* get person id given name and domainid */
#define DSPDMMND (dstspid)3530 /* get node id given name and domainid */
#define DSPDMMBD (dstspid)3540 /* get pub. dl id given name and domainid */
#define DSPDMMDM (dstspid)3550 /* get domain id given qualified name */
#define DSPDMMDC (dstspid)3560 /* get name, DCN id given domain id */
#define DSPDMMIO (dstspid)3570 /* get org name given id */
#define DSPDMMIL (dstspid)3580 /* get role name given id */
#define DSPDMMIP (dstspid)3590 /* get person info given id */
#define DSPDMMIN (dstspid)3600 /* get node name given id */
#define DSPDMMIB (dstspid)3610 /* get pub. or private dl name given id */
#define DSPV1V2L (dstspid)3620 /* check whether a dl exists */
#define DSPOTGID (dstspid)3630 /* Get a domainid given the objectid */
#define DSPPQUAL (dstspid)3640 /* Qualified username from person objectid */
#define DSPDDCN2 (dstspid)3650 /* Get enum given uiname for class */
#define DSPDDAN2 (dstspid)3660 /* Get attr enum given uiname and class enum */
#define DSPDMMUD (dstspid)3670 /* Get dm person info by person */
                               /* objectid */
#define DSPSFDUS (dstspid)3680 /* Get privs. for one user */
#define DSPSFDNO (dstspid)3690 /* Get privs. for all users */


/* procedures without security */
#define DSPXLNPR (dstspid)4000 /* convenience list normal person */
#define DSPXLNRA (dstspid)4010 /* convenience list normal private alias */
#define DSPXLNBA (dstspid)4020 /* convenience list normal public alias */
#define DSPXLNRD (dstspid)4030 /* convenience list normal private DL */
#define DSPXLNBD (dstspid)4040 /* convenience list normal public DL */
#define DSPXLNOR (dstspid)4050 /* convenience list normal organisation */
#define DSPXLNRL (dstspid)4060 /* convenience list normal role*/
#define DSPXLFRA (dstspid)4080 /* convenience list fuzzy private alias */
#define DSPXLFBA (dstspid)4090 /* convenience list fuzzy public alias */
#define DSPXLFRD (dstspid)4100 /* convenience list fuzzy private DL */
#define DSPXLFBD (dstspid)4110 /* convenience list fuzzy public DL */
#define DSPXLFOR (dstspid)4120 /* convenience list fuzzy organisation */
#define DSPXLFRL (dstspid)4130 /* convenience list fuzzy role */
#define DSPXLAPR (dstspid)4140 /* convenience list all persons i.e. % */
#define DSPXLNME (dstspid)4150 /* normal dl members */
#define DSPXLNLL (dstspid)4160 /* normal DS_ALL --- msaffari */
#define DSPXLFND (dstspid)4170 /* convenience list fuzzy node */
#define DSPXLFDM (dstspid)4180 /* convenience list fuzzy domain */
#define DSPXLFRM (dstspid)4190 /* convenience list fuzzy room */
#define DSPXLFEQ (dstspid)4200 /* convenience list fuzzy equipment */

/* convenience fuzzy */
#define DSPXLFNP (dstspid)4210 /* names of persons for given prefix */
#define DSPXLFLL (dstspid)4220 /* names of 'all' for given prefix */
#define DSPXLFGT (dstspid)4260 /* convenience list fuzzy gateway */
#define DSPXLFLC (dstspid)4270 /* convenience list fuzzy location */

/* api */
#define DSPACONV (dstspid)4290 /* convert an id from local <--> global */

/* data dictionary */
#define DSPDDLCL (dstspid)4300 /* data dictionary list of classes */
#define DSPDDLAT (dstspid)4310 /* data dictionary list of attributes */
#define DDLAT41  (dstspid)4315 /* data dictionary list of attributes for 4.1 */
#define DSPDDNCL (dstspid)4320 /* data dictionary number of classes */
#define DSPDDNCS (dstspid)4325 /* data dic number of classes for ext schema*/
#define DSPDDNAT (dstspid)4330 /* data dictionary number of attributes */
#define DSPDDMSC (dstspid)4332 /* data dic map of class id's to enums 
				  for ext schema*/
#define DSPDDMCL (dstspid)4340 /* data dictionary map of class id's to enums */
#define DSPDDMAT (dstspid)4350 /* data dictionary map of attr id's to enums */

/* data base access (transport) */
#define DSPDBXAC (dstspid)4355 /* DB access check if an objid is in DS_acct */
#define DSPDBCNV (dstspid)4360 /* DB access conv local to global usg replog */

/* login authorization */
#define DSPAAUSR (dstspid)4370 /* authorizes a server */
#define DSPAAUOW (dstspid)4380 /* authorizes user with no login as */
#define DSPAAULG (dstspid)4390 /* authorizes user with login as */


/* convenience list (range reserved 4000 - 4200, 4400 - 4500 */
#define DSPXLNDM (dstspid)4400 /* convenience list normal domain */
#define DSPXLNEQ (dstspid)4410 /* convenience list normal equipment */
#define DSPXLNFC (dstspid)4420 /* convenience list normal facility */
#define DSPXLNGT (dstspid)4430 /* convenience list normal gateway */
#define DSPXLNLC (dstspid)4440 /* convenience list normal location */
#define DSPXLNRM (dstspid)4450 /* convenience list normal rooms */
#define DSPXILRA (dstspid)4470 /* loop private alias */
#define DSPXILRD (dstspid)4480 /* loop private dl */


/* range 4500 - 4799 reserved for item (alias & dl's) calls */
/* item calls (alias & dl's) */
#define DSPXIUAL (dstspid)4500 /* update alias */
#define DSPXIUDL (dstspid)4510 /* update dl */
#define DSPXIU2DL (dstspid)4515 /* update dl */
#define DSPXISER (dstspid)4550 /* static element row, itemname and item */

#define DSPXICDL (dstspid)4600 /* item add alias check duplicate */
#define DSPXIFPI (dstspid)4610 /* item add alias find present item */
#define DSPXIINM (dstspid)4630 /* item insert row in ds_name table */
#define DSPXIDAL (dstspid)4660 /* delete alias */
#define DSPXICAE (dstspid)4670 /* check alias exists */
#define DSPXIISE (dstspid)4690 /* insert static element */
#define DSPXIDSE (dstspid)4700 /* duplicate static element */
#define DSPXUGSE (dstspid)4710 /* get objectid for  static element */
#define DSPXISHD (dstspid)4720 /* shadow exists */
#define DSPXIDDL (dstspid)4730 /* duplicate dl exits */
#define DSPXUGAL (dstspid)4740 /* get objectid for alias */
#define DSPXUGDL (dstspid)4750 /* get objectid for dl */
#define DSPXIRDL (dstspid)4760 /* remove all dl rhs */
#define DSPXIHMR (dstspid)4770 /* how many rhs */
#define DSPXIDNM (dstspid)4780 /* delete dl from nm table */
#define DSPXIDSD (dstspid)4790 /* delete single dl */

/* name resolution */

#define DSPNGNAM (dstspid)4800 /* get name table by name */
#define DSPNTSEC (dstspid)4810 /* Check security on group object */
#define DSPNDLEX (dstspid)4820 /* get the elements of a dl */
#define DSPNGGAT (dstspid)4830 /* get a gateway object by name */
#define DSPNNODG (dstspid)4840 /* the node of a gateway */
#define DSPNPBDL (dstspid)4850 /* staticelement -> category */
#define DSPNQUAL (dstspid)4860 /* the qualified name of a domain */
#define DSPNDOMG (dstspid)4870 /* walk the domains up */
#define DSPNDOMH (dstspid)4880 /* does this node have this domain */
#define DSPNGDOM (dstspid)4890 /* get a user's domain */
#define DSPNGNOB (dstspid)4900 /* get name row by objectid */
#define DSPNPBPN (dstspid)4910 /* Get person's fully qualified name */
#define DSPNPBAL (dstspid)4920 /* Get alias's fully qualified name */
#define DSPNPBOB (dstspid)4930 /* Get dl or object's fully qualified name */
#define DSPNPBFO (dstspid)4940 /* Get foreign string's fully qualified name */
#define DSPNROLE (dstspid)4950 /* Get people who have a role */
#define DSPNORGG (dstspid)4960 /* Get people who have an org */
#define DSPNSPEC (dstspid)4970 /* Get application's accounts */

/* 4980 - 5100 reserved for alias & dl continued  layer */
#define DSPXIDLC (dstspid)4980 /* Check for existence of DL */
#define DSPXIFUA (dstspid)4990 /* full update alias */
#define DSPXILUA (dstspid)5000 /* limited update alias */
#define DSPXILUD (dstspid)5010 /* limited update DL */
#define DSPXARSD (dstspid)5020 /* kill all private static elements owned by
				  the person tagged with the given account */
#define DSPXARND (dstspid)5030 /* kill all private names owned by the 
				  person tagged with the given account */
#define DSPXICDE (dstspid)5040 /* check dl exists */
#define DSPXDSID (dstspid)5050 /* delete public dl element id mapping */
#define DSPXIALR (dstspid)5060 /* invalidate all aliases refering to the
				  given objectid */
#define DSPXIDLR (dstspid)5070 /* invalidate all staticelements refering to
				  the given objectid */
#define DSPXARID (dstspid)5080 /* if idmapping exists for private info, 
				  delete it. */
#define DSPXARIN (dstspid)5090 /* if idmapping exists for private info, 
				  delete it. */

/* User Maintainance (5110-5190) */
#define DSXFACUA (dstspid)5110  /* get the uanode for a user */

/* 5200 - 5400 + some others reserved for get table id's */
#define DSPXUGNM (dstspid)4620 /* item add alias find objectid */
#define DSPXUGCL (dstspid)5210 /* ds_class */
#define DSPXUGAT (dstspid)5220 /* ds_attribute */
#define DSPXUGRP (dstspid)5230 /* ds_replog */
#define DSPXUGCY (dstspid)5240 /* ds_community */
#define DSPXUGPR (dstspid)5250 /* ds_person */
#define DSPXUGRL (dstspid)5260 /* ds_role */
#define DSPXUGOR (dstspid)5270 /* ds_organization */
#define DSPXUGPA (dstspid)5280 /* ds_PvtAlias */
#define DSPXUGPL (dstspid)5290 /* ds_PvtStaticList */
#define DSPXUGSR (dstspid)5300 /* ds_StaticRow */
#define DSPXUGMB (dstspid)5310 /* ds_mailbox */
#define DSPXUGND (dstspid)5320 /* ds_node */
#define DSPXUGDM (dstspid)5330 /* ds_domain */
#define DSPXUGGT (dstspid)5340 /* ds_gateway */
#define DSPXUGRT (dstspid)5350 /* ds_routing */
#define DSPXUGPT (dstspid)5360 /* ds_ path*/
#define DSPXUGCA (dstspid)5370 /* ds_calendar */
#define DSPXUGLC (dstspid)5380 /* ds_location */
#define DSPXUGRM (dstspid)5390 /* ds_room */
#define DSPXUGEQ (dstspid)5400 /* ds_equipment */
#define DSPXUGCE (dstspid)5405 /* ds_certAuthority */

/* 5410 - 5550 reserved for info box */
#define DSPXLIPR (dstspid)5410 /* ds_person */
#define DSPXLIOR (dstspid)5420 /* ds_organization */
#define DSPXLIBA (dstspid)5430 /* convenience list info public alias */
#define DSPXLIBD (dstspid)5440 /* convenience list info public DL */
#define DSPXLIRL (dstspid)5450 /* convenience list info role*/
#define DSPXLIDM (dstspid)5460 /* convenience list info domain */
#define DSPXLIEQ (dstspid)5470 /* convenience list info equipment */
#define DSPXLIFC (dstspid)5480 /* convenience list info facility */
#define DSPXLIGT (dstspid)5490 /* convenience list info gateway */
#define DSPXLILC (dstspid)5500 /* convenience list info location */
#define DSPXLIRM (dstspid)5510 /* convenience list info rooms */

/* Misc get user info */

#define DSPAGUIN (dstspid)5600 /* get username and pername */
#define DSPDMSCN (dstspid)5610 /* get objectid of SCN */

/* Package execution (dsf) */
#define DSPFGHID (dstspid)5700 /* Get om_header id, globalid */
#define DSPFCUPW (dstspid)5710 /* clear a user's password */

/* Savepoint procs */

#define DSPUSSAV (dstspid)5750 /* Set savepoint */
#define DSPURSAV (dstspid)5760 /* Rollback to savepoint */

/* 5800 -> 5999 for reconciliator */

#define DSPRCNVT (dstspid)5800 /* for printing enumber as a string */
#define DSPRDLNK (dstspid)5802 /* drop link to remote database */
#define DSPRCLNK (dstspid)5803 /* create link to remote database */
#define DSPRROID (dstspid)5804 /* generic selector for an object ID */
#define DSPRRNUM (dstspid)5805 /* generic selector for a number */
#define DSPRRSTR (dstspid)5806 /* generic selector for a string */
#define DSPRHNT1 (dstspid)5807 /* here_not_there replacement for DSPZDC04 */
#define DSPRHNT2 (dstspid)5809 /* here_not_there replacement for DSPZDC19 */
#define DSPRHNT3 (dstspid)5813 /* here_not_there replacement for DSPZDC33 */
#define DSPRHNT4 (dstspid)5816 /* here_not_there replacement for DSPZDC20 */
#define DSPRHNT5 (dstspid)5819 /* here_not_there replacement for DSPZDC31 */
#define DSPRHNT6 (dstspid)5822 /* here_not_there replacement for DSPZDC15 */
#define DSPRHNT7 (dstspid)5826 /* here_not_there replacement for DSPZDC16 */
#define DSPRHNT8 (dstspid)5829 /* here_not_there replacement for DSPZDC17 */

#define DSPRGCLS (dstspid)5870 /* get class name from enumber */
#define	DSPRCB01 (dstspid)5971 /* callback data retriever: DS_PER */
#define	DSPRCB02 (dstspid)5972 /* callback data retriever: DS_ROLE */
#define	DSPRCB03 (dstspid)5973 /* callback data retriever: DS_ORG */
#define	DSPRCB04 (dstspid)5974 /* callback data retriever: DS_GATE */
#define	DSPRCB05 (dstspid)5975 /* callback data retriever: DS_LOC */
#define	DSPRCB06 (dstspid)5976 /* callback data retriever: DS_ROOM */
#define	DSPRCB07 (dstspid)5977 /* callback data retriever: DS_EQUIP */
#define	DSPRCB08 (dstspid)5978 /* callback data retriever: DS_CMNTY */
#define	DSPRCB09 (dstspid)5979 /* callback data retriever: DS_DOM */
#define	DSPRCB10 (dstspid)5980 /* callback data retriever: OM_ATT */
#define	DSPRCB11 (dstspid)5981 /* callback data retriever: OM_TMP */
#define	DSPRCB12 (dstspid)5982 /* callback data retriever: DS_REWR */
#define	DSPRCB13 (dstspid)5983 /* callback data retriever: DS_PBAL */
#define	DSPRCB14 (dstspid)5984 /* callback data retriever: DS_PUBDL */
#define	DSPRCB15 (dstspid)5985 /* callback data retriever: DS_AXESS */
#define	DSPRCB16 (dstspid)5987 /* callback data retriever: DS_NODE */
#define	DSPRCB17 (dstspid)5988 /* callback data retriever: DS_PATH */
#define	DSPRCB18 (dstspid)5989 /* callback data retriever: DS_CRTE */

/* 6000 -> 6040 to-string processing */

#define DSPNFACL (dstspid)6000 /* get accts of peple who work in facility */
#define DSPNMBOX (dstspid)6010 /* get this account's information */
#define DSPNPERS (dstspid)6020 /* get this person's primary account info */
#define DSPNROOM (dstspid)6030 /* get this room's account info */
#define DSPNEQIP (dstspid)6040 /* get this equipment's account info */

/* gmehra - I'm using this number.  Feel free to move it */
#define DSPALOGN (dstspid)6050 /* get the oracle office connect in oraoffice */
#define DSPASROL (dstspid)6055 /* get the oracle office role in oraoffice */
#define DSPAGNOD (dstspid)6060 /* get the node id from the configinfo table */
#define DSPAGUSF (dstspid)6070 /* get the user and account info */
#define DSPASTPW (dstspid)6080 /* Set Password */
#define DSPAGTPW (dstspid)6090 /* Get Password */
#define DSPAGMIN (dstspid)6100 /* Get mailnfo stuff */

/* public stuff 6110-6190 */

#define DSPXBGAL (dstspid)6110 /* get all aliases */
#define DSPXBGDL (dstspid)6120 /* get all dl's */
#define DSPXBGUN (dstspid)6130 /* get all dl's & aliases*/
#define DSPXBGRA (dstspid)6140 /* get all private */
#define DSPSCHCK (dstspid)6150 /* check privileges */
#define DSPXLIPT (dstspid)6160 /* convenience list info printer */
#define DSPXLNPT (dstspid)6170 /* SP for Printer viewing */
#define DSPXLIRA (dstspid)6180 /* convenience list info private alias */
#define DSPXLIRD (dstspid)6190 /* convenience list info private DL */
#define DSPXLIND (dstspid)6200 /* convenience list info node */
#define DSPXLNND (dstspid)6210 /* viewer for node */
#define DSPCALEN (dstspid)6220 /* fetch connect string for calendar folks */

/* dss stored procedures */

#define DSPSRXST (dstspid)6230 /* checks for existence of userid,item pair */
#define DSPSRINS (dstspid)6240 /* insert into ds_access */
#define DSPSRUPD (dstspid)6250 /* update ds_access */
#define DSPSNXID (dstspid)6260 /* gets next objectid from ds_access_id */
#define DSPSEBRL (dstspid)6270 /* early bind grants for roles */
#define DSPSEBOR (dstspid)6280 /* early bind grants for orgs */
#define DSPSRDEL (dstspid)6290 /* delete from ds_access */
#define DSPSFTCH (dstspid)6300 /* fetch privs from ds_Access */
#define DSPSVUI  (dstspid)6310 /* checks existence of a user, role or org id */
#define DSPSACOW (dstspid)6320 /* Fetch account owner */
#define DSPSOOW  (dstspid)6330 /* Fetch owner of name table obj. (cat = 70) */
#define DSPSALOW (dstspid)6340 /* Fetch owner of alias or DL */
#define DSPSGALL (dstspid)6380 /* Fetch all objectid for a given grant */
#define DSPSDGRP (dstspid)6390 /* Fetch all entries for a userid, gid combo */
#define DSPSDITM (dstspid)6400 /* Fetch all users for a given object */
#define DSPSINFI (dstspid)6410 /* Fetch all grants for a given item */
#define DSPSAGRP (dstspid)6420 /* Fetch info for all grants for a given grp */
#define DSPSDUID (dstspid)6430 /* Fetch all grants for a userid or qualname */
#define DSPSDUGP (dstspid)6440 /* Fetch all grants for a given group */
#define DSPSVNOD (dstspid)6450 /* Check if user's uanode = currnode */
#define DSPSGUPV (dstspid)6460 /* Gets the (class,priv) that the user has */
#define DSPSGPRN (dstspid)6470 /* Gets the print priv that the user has */
#define DSPDDDVL (dstspid)6480 /* Fetch default value from att table */
#define DSPUTOID (dstspid)6490 /* Fetch person's Id given the username */

/* 6500 -> 7500 replicator procedures */

#define DSPZGNID (dstspid)6500 /* get next replicator event/task id */
#define DSPZEENQ (dstspid)6510 /* insert a row into ds_replicator */
#define DSPZEDEQ (dstspid)6520 /* fetch the first event from the queue */
#define DSPZEDDQ (dstspid)6530 /* delete an event from the queue */
#define DSPZTUPD (dstspid)6540 /* update a component of a task */
#define DSPZOTIM (dstspid)6550 /* get current db time */
#define DSPZOGEN (dstspid)6560 /* get any timeouts that have passed */
#define DSPZRCNT (dstspid)6570 /* get the ct. of unpckged entries in replog */
#define DSPZGTLG (dstspid)6580 /* Pulls in the squished down log */
#define DSPZSTTR (dstspid)6590 /* set transaction read only */
#define DSPZRWRK (dstspid)6595 /* check for work in the replog */
#define DSPZMKPK (dstspid)6600 /* updates the package entry for a new packet */
#define DSPZNXTP (dstspid)6610 /* get next package id */
#define DSPZNODA (dstspid)6620 /* get the replicator account name of a node */
#define DSPZCMSU (dstspid)6630 /* update the state of a commstate row */
#define DSPZPIGG (dstspid)6640 /* get packages which should be piggybacked */
#define DSPZP1SQ (dstspid)6650 /* first log SQuishing procedure */
#define DSPZP2SQ (dstspid)6660 /* second log SQuishing procedure */

#define DSPZUPG1 (dstspid)6670 /* Get the objectids for the upgrade */

#define DSPZRCMX (dstspid)6680 /* received max package number */
#define DSPZCMIN (dstspid)6690 /* insert a row into ds_commstate */
#define DSPZNFIN (dstspid)6700 /* find the destination nodes for a package */
#define DSPZRSPE (dstspid)6710 /* Get any special replog entries */
#define DSPZGDCN (dstspid)6720 /* Get the confignode of a domain */
#define DSPZEORD (dstspid)6730 /* Order the events */
#define DSPZEGRD (dstspid)6740 /* Get next event in order */
#define DSPZUPCK (dstspid)6750 /* Bump the package counter for a domain */
#define DSPZRSTP (dstspid)6755 /* Restore the package id for a domain */
#define DSPZRUSP (dstspid)6760 /* Mark all special log entries as handled */
#define DSPZBGIN (dstspid)6770 /* Get information for birth task */
#define DSPZGNNM (dstspid)6780 /* Get the name of this node */
#define DSPZIRPL (dstspid)6790 /* Insert row into ds_replog */
#define DSPZBIRI (dstspid)6800 /* Get all birthing information */
/* reserved               6810 DSPZBIRI is over 10 messages long */
#define DSPZNPAT (dstspid)6820 /* Get a node's path */
#define DSPZGMAN (dstspid)6825 /* Get the status flag for a node */
#define DSPZGSCN (dstspid)6830 /* Get the scn's id */
#define DSPZMBOT (dstspid)6835 /* Update node status for manual bootstrap */
#define DSPZRSCN (dstspid)6840 /* Scan replog for SCN event */
#define DSPZGSCR (dstspid)6850 /* Get replog rows for SCN */
#define DSPZPRSC (dstspid)6860 /* Create fake idmap entries for SCN replog */
#define DSPZMKSC (dstspid)6870 /* Mark the SCN package */
#define DSPZPRSN (dstspid)6880 /* Nuke fake idmap entries for SCN replog */
#define DSPZNROU (dstspid)6890 /* Nuke the routing table */
#define DSPZNROI (dstspid)6900 /* Nuke the routing idmap entries */
#define DSPZROU1 (dstspid)6910 /* Generate route records for multiple comms */
#define DSPZROU2 (dstspid)6920 /* Unique-ify route records */
#define DSPZROUG (dstspid)6930 /* Generate globalids for route records */
#define DSPZSFIN (dstspid)6940 /* find the destinations for an SCN package */
#define DSPZSMRL (dstspid)6950 /* Initial mark replog for SCN log entries */
#define DSPZSMR2 (dstspid)6960 /* Final mark replog for SCN log entries */
#define DSPZSGRL (dstspid)6970 /* Get the SCN replog entries */
#define DSPZGROU (dstspid)6980 /* Get the objectids from the route table */
#define DSPZDELN (dstspid)6990 /* Delete a node (remotely) */
#define DSPZGCRE (dstspid)7000 /* Clean up replog */
#define DSPZGCCM (dstspid)7010 /* Clean up the commstate table */

/* Class Dumping procedures */
#define DSPZDC02 (dstspid)7020 /* Dump a classes objectids for a domain */
#define DSPZDC03 (dstspid)7025 /* Dump a classes objectids for a domain */
#define DSPZDC04 (dstspid)7030 /* Dump a classes objectids for a domain */
#define DSPZDC05 (dstspid)7035 /* Dump a classes objectids for a domain */
#define DSPZDC06 (dstspid)7040 /* Dump a classes objectids for a domain */
#define DSPZDC07 (dstspid)7045 /* Dump a classes objectids for a domain */
/*               (dstspid)7050 deleted */
#define DSPZDC09 (dstspid)7055 /* Dump a classes objectids for a domain */
#define DSPZDC10 (dstspid)7060 /* Dump a classes objectids for a domain */
/*               (dstspid)7065 deleted */
#define DSPZDC12 (dstspid)7070 /* Dump a classes objectids for a domain */
#define DSPZDC13 (dstspid)7075 /* Dump a classes objectids for a domain */
#define DSPZDC14 (dstspid)7080 /* Dump a classes objectids for a domain */
#define DSPZDC15 (dstspid)7085 /* Dump a classes objectids for a domain */
#define DSPZDC16 (dstspid)7090 /* Dump a classes objectids for a domain */
#define DSPZDC17 (dstspid)7095 /* Dump a classes objectids for a domain */
#define DSPZDC18 (dstspid)7100 /* Dump a classes objectids for a domain */
#define DSPZDC19 (dstspid)7105 /* Dump a classes objectids for a domain */
#define DSPZDC20 (dstspid)7110 /* Dump a classes objectids for a domain */
#define DSPZDC21 (dstspid)7115 /* Dump a classes objectids for a domain */
#define DSPZDC22 (dstspid)7120 /* Dump a classes objectids for a domain */
#define DSPZDC23 (dstspid)7125 /* Dump a classes objectids for a domain */
#define DSPZDC24 (dstspid)7130 /* Dump a classes objectids for a domain */
#define DSPZDC25 (dstspid)7135 /* Dump a classes objectids for a domain */
#define DSPZDC26 (dstspid)7140 /* Dump a classes objectids for a domain */
#define DSPZDC27 (dstspid)7145 /* Dump a classes objectids for a domain */
#define DSPZDC28 (dstspid)7150 /* Dump a classes objectids for a domain */
#define DSPZDC29 (dstspid)7155 /* Dump a classes objectids for a domain */
#define DSPZDC30 (dstspid)7160 /* Dump a classes objectids for a domain */
#define DSPZDC31 (dstspid)7165 /* Dump a classes objectids for a domain */
#define DSPZDC32 (dstspid)7170 /* Dump a classes objectids for a domain */
#define DSPZDC33 (dstspid)7175 /* Dump a classes objectids for a domain */

#define DSPZRREP (dstspid)7290 /* Reset replicator spid */
#define DSPZPBRO (dstspid)7300 /* Add the new node's route record */
#define DSPZ0ACK (dstspid)7310 /* Mark unhandled ack message */
#define DSPZ1GNP (dstspid)7320 /* Get next/previous replicate task */
#define DSPZROIG (dstspid)7330 /* Get min objectids from replog table */
#define DSPZROU4 (dstspid)7340 /* Fixup route table */
#define DSPZQ1   (dstspid)7350 /* Replicator queue management */
#define DSPZGCFL (dstspid)7360 /* Clean up outgoing files */
#define DSPZRFLS (dstspid)7370 /* Flush out the replog for a domain */
#define DSPZMSCN (dstspid)7380 /* Clean up after moving the SCN */
#define DSPZMDCN (dstspid)7390 /* Clean up after moving the DCN */
#define DSPZMCHK (dstspid)7400 /* Check for running package in same domain */
#define DSPZRLOK (dstspid)7410 /* Lock the replog by locking the daemon event*/
#define DSPZMLOK (dstspid)7420 /* Lock the mail inbox */
#define DSPZLACK (dstspid)7430 /* Find a task that wants an ack message */
#define DSPZTLOK (dstspid)7440 /* Lock a task */
#define DSPZLRUN (dstspid)7450 /* Find all runnable tasks */
#define DSPZTCHK (dstspid)7460 /* Check if a task type exists */
#define DSPZTWRK (dstspid)7465 /* Check if there is any work in task queue */
#define DSPZELOK (dstspid)7470 /* Lock an event */
#define DSPZUNSB (dstspid)7480 /* Unsubscribe a node from a domain */
#define DSPZROU3 (dstspid)7490 /* Generate single community route table */
#define DSPZOLOK (dstspid)7494 /* Lock all tasks "O"ther than a given one */
#define DSPZCODP (dstspid)7496 /* Check other dump tasks' state */

/* End replicator Procedures */

/* Address rewriting procs 7500 -> 7510 */
#define DSPNRCNT (dstspid)7500 /* Get number of rewriting rules */
#define DSPNRGET (dstspid)7510 /* Get rewriting rules */

/* Lazy binding fixup 7520->7540 */

#define DSPNFIAL (dstspid)7520 /* Fix up an alias */
#define DSPNFIDL (dstspid)7530 /* Fix up a dl element */
#define DSPNVFGA (dstspid)7540 /* Get all aliases to be fixed */
#define DSPNVFGD (dstspid)7545 /* Get all dl elements to be fixed */

/* domain clean up sp 7550 -> 7690 */
#define DSPDCU01 (dstspid)7550 /* Invalidate alias/dl */
#define DSPDCU02 (dstspid)7555 /* Invalidate staticelement */
#define DSPDCU03 (dstspid)7560 /* Delete DS_person from ID_Map */
#define DSPDCU04 (dstspid)7565 /* Delete objects from DS_person */
#define DSPDCU31 (dstspid)7570 /* Delete objects from DS_OClass */
#define DSPDCU07 (dstspid)7580 /* Delete DS_role from ID_Map */
#define DSPDCU08 (dstspid)7585 /* Delete objects from DS_role */
#define DSPDCU09 (dstspid)7590 /* Delete DS_organization from ID_Map */
#define DSPDCU10 (dstspid)7595 /* Delete objects from DS_organization */
#define DSPDCU11 (dstspid)7600 /* Delete DS_account from ID_Map */
#define DSPDCU12 (dstspid)7605 /* Delete objects from DS_account */
#define DSPDCU13 (dstspid)7610 /* Delete DS_gateway from ID_Map */
#define DSPDCU14 (dstspid)7615 /* Delete objects from DS_gateway */
#define DSPDCU15 (dstspid)7620 /* Delete DS_tools from ID_Map */
#define DSPDCU16 (dstspid)7625 /* Delete objects from DS_tools */
#define DSPDCU17 (dstspid)7630 /* Delete DS_location from ID_Map */
#define DSPDCU18 (dstspid)7635 /* Delete objects from DS_location */
#define DSPDCU19 (dstspid)7640 /* Delete DS_room from ID_Map */
#define DSPDCU20 (dstspid)7645 /* Delete objects from DS_room */
#define DSPDCU21 (dstspid)7650 /* Delete DS_equipment from ID_Map */
#define DSPDCU22 (dstspid)7655 /* Delete objects from DS_equipment */
#define DSPDCU23 (dstspid)7660 /* Delete DS_access from ID_Map */
#define DSPDCU24 (dstspid)7665 /* Delete objects from DS_access */
#define DSPDCU25 (dstspid)7670 /* Delete DS_name from ID_Map */
#define DSPDCU26 (dstspid)7675 /* Delete objects from DS_name */
#define DSPDCU27 (dstspid)7678 /* Delete classid from DS_ProcParams */
#define DSPDCU28 (dstspid)7681 /* Delete classid from DS_ProcessTokens */
#define DSPDCU29 (dstspid)7684 /* Delete classid from DS_ProcTime */
#define DSPDCU30 (dstspid)7687 /* Delete classid from DS_Process */

/* update attributes which refer to a deleted person */
#define DSPDPE01 (dstspid)7690 /* update manager attribute of ds_person */
#define DSPDPE02 (dstspid)7695 /* update manager attribute of ds_organization*/
#define DSPDPE03 (dstspid)7700 /* update admin attribute of ds_equipment */
#define DSPDPE04 (dstspid)7705 /* update admin attribute of ds_organization */
#define DSPDPE05 (dstspid)7710 /* update admin attribute of ds_location */
#define DSPDPE06 (dstspid)7715 /* update admin attribute of ds_room */

/* update attributes which refer to a deleted role */
#define DSPDRO01 (dstspid)7720 /* update role attribute of ds_person */

/* update attributes which refer to a deleted organization */
#define DSPDOG01 (dstspid)7725 /* update org attribute of ds_person */
#define DSPDOG02 (dstspid)7730 /* update parent attribute of ds_person */

/* delete node */
#define DSPDND01 (dstspid)7735 /* delete account */
#define DSPDND02 (dstspid)7740 /* delete idmap */
#define DSPDND03 (dstspid)7745 /* delete name */
#define DSPDND04 (dstspid)7750 /* delete gateway */
#define DSPDND05 (dstspid)7755 /* delete idmap */
#define DSPDND06 (dstspid)7760 /* delete path */
#define DSPDND07 (dstspid)7765 /* delete idmap */
#define DSPDND08 (dstspid)7770 /* delete name */
#define DSPDND09 (dstspid)7775 /* delete tools */

/* update attributes which refer to a deleted location */
#define DSPDLO01 (dstspid)7780 /* update office attribute of ds_person */
#define DSPDLO02 (dstspid)7785 /* update parent attribute of ds_location */
#define DSPDLO03 (dstspid)7790 /* update location attribute of ds_room */
#define DSPDLO04 (dstspid)7795 /* update location attribute of ds_equipment */

#define DSPDPVGD (dstspid)7800 /* cleanup globalid for private alias & dl */

/* Standard extensions related SPIDs */
#define DSPDDLAE (dstspid)7805 /* Data Dictionary List of standard attr extensions */
#define DSPDDNSU (dstspid)7810 /* Get counts of standard/user config attributes */
#define DSPDDLAS (dstspid)7815 /* Data Dictionary List of base and
				   standard attr/user config extensions */
#define DSPDDMCS (dstspid)7825  /* data dictionary map of class id's to enums .
				   Accomodate the changes for DS_ATTRIBUTE_STD */
#define DDLAS41  (dstspid)7840 /* Data Dictionary List of base and
				   standard attr/user config extensions */
#define DSPFFPRS  (dstspid)22000 /* Fetch extended person attributes */
#define DSPFUPRS  (dstspid)22070 /* Update extended person attributes */
#define DSPFIPRS  (dstspid)22120 /* Insert extended person attributes */
#define DSPFDPRS  (dstspid)22150 /* Delete extended person attributes */

/* SPIDs related to CertAuthority */
#define DSPFCA   (dstspid)22200    /* Select CA */
#define DSPICA   (dstspid)22210    /* Insert CA */
#define DSPDCA   (dstspid)22220    /* Delete CA */
#define DSPUCA   (dstspid)22230    /* Update CA */

/* delete community */
#define DSPDCM01 (dstspid)3000 /* delete idmap */
#define DSPDCM02 (dstspid)3010 /* delete name */
#define DSPDCM03 (dstspid)3020 /* delete node */
#define DSPDCM04 (dstspid)3030 /* delete idmap */
#define DSPDCM05 (dstspid)3040 /* delete commroute */
#define DSPDCM06 (dstspid)3050 /* delete idmap */
#define DSPDCM07 (dstspid)3060 /* delete path */

/* delete domain */
#define DSPDDM01 (dstspid)3070 /* delete idmap */
#define DSPDDM02 (dstspid)3080 /* delete name */
#define DSPDDM03 (dstspid)3090 /* delete domain */
#define DSPDDM04 (dstspid)3100 /* delete idmap */
#define DSPDDM05 (dstspid)3110 /* delete name */
#define DSPDDM06 (dstspid)3120 /* delete node */
#define DSPDDM07 (dstspid)3130 /* delete node */

/* complex stored procedures */

/* range 8000 - 8099 are reserved for test procedures */

/* 8100 on for external complex procedures */
#define DSPCXAAL (dstspid)8100 /* add alias */
#define DSPCXDAL (dstspid)8101 /* delete alias */
#define DSPCXUAL (dstspid)8102 /* update alias */
#define DSPCXADL (dstspid)8103 /* add dl */
#define DSPCXDDL (dstspid)8104 /* delete dl */
#define DSPCXUDL (dstspid)8105 /* update dl */
#define DSPCXDSR (dstspid)8106 /* delete single rhs for a dl */
#define DSPCXCDL (dstspid)8107 /* copy dl */
#define DSPCXUSR (dstspid)8108 /* update single rhs for a dl */
#define DSPCXCAC (dstspid)8109 /* create a mail and calendar acct */
#define DSPCXDAC (dstspid)8110 /* delete a mail and calendar acct */

#define DSPCXIPR (dstspid)8111
#define DSPCXDPR (dstspid)8112
#define DSPCXUPR (dstspid)8113
#define DSPCXIRM (dstspid)8114
#define DSPCXDRM (dstspid)8115
#define DSPCXURM (dstspid)8116
#define DSPCXIEQ (dstspid)8117
#define DSPCXDEQ (dstspid)8118
#define DSPCXUEQ (dstspid)8119

#define DSPCXDID (dstspid)8120
#define DSPCXIND (dstspid)8121

#define DSPCXDRF (dstspid)8122 /* invalidate references to an object */
#define DSPCXDDM (dstspid)8123 /* domain clean up */
#define DSPCXDRO (dstspid)8124 /* delete role */
#define DSPCXDOG (dstspid)8125 /* delete organization */
#define DSPCXDLO (dstspid)8126 /* delete location */
#define DSPCXDND (dstspid)8127 /* delete node */
#define DSPCXDCM (dstspid)8128 /* delete community */
#define DSPCXDDD (dstspid)8129 /* delete domain */
#define DSPCXDRH (dstspid)8130 /* delete dl's right hand side */ 
#define DSPCXDTM (dstspid)8131 /* delete template */ 
#define DSPCXUTM (dstspid)8132 /* update template */ 

#define DSPVFYNM (dstspid)8133 /* Validate/fixup the aliases/dls on a node */
#define DSPCXDGD (dstspid)8134 /* clean up globalid for private alias & dl */

/* complex fetches */


/* Defines for the generic stored procs */
/* Yes, I know the names are too long - I will change them */


#define DSPFFCLA	(dstspid)11010	/* Select for DS_Class */
#define DSPFICLA	(dstspid)11040	/* Insert for DS_Class */
#define DSPFDCLA	(dstspid)11070	/* Delete for DS_Class */
#define DSPFUCLA	(dstspid)11100	/* Update for DS_Class */
#define DSPFFATT	(dstspid)11130	/* Select for DS_Attribute */
#define DSPFIATT	(dstspid)11160	/* Insert for DS_Attribute */
#define DSPFDATT	(dstspid)11190	/* Delete for DS_Attribute */
#define DSPFUATT	(dstspid)11220	/* Update for DS_Attribute */
#define DSPFFIDM	(dstspid)11250	/* Select for DS_IDMap */
#define DSPFIIDM	(dstspid)11280	/* Insert for DS_IDMap */
#define DSPFDIDM	(dstspid)11310	/* Delete for DS_IDMap */
#define DSPFUIDM	(dstspid)11340	/* Update for DS_IDMap */
#define DSPFFGRE	(dstspid)11370	/* Select for DS_RepLog */
#define DSPFIGRE	(dstspid)11400	/* Insert for DS_RepLog */
#define DSPFDGRE	(dstspid)11430	/* Delete for DS_RepLog */
#define DSPFUGRE	(dstspid)11460	/* Update for DS_RepLog */
#define DSPFFCOM	(dstspid)11490	/* Select for DS_CommState */
#define DSPFICOM	(dstspid)11520	/* Insert for DS_CommState */
#define DSPFDCOM	(dstspid)11550	/* Delete for DS_CommState */
#define DSPFUCOM	(dstspid)11580	/* Update for DS_CommState */
#define DSPFFREP	(dstspid)11610	/* Select for DS_Replicator */
#define DSPFIREP	(dstspid)11640	/* Insert for DS_Replicator */
#define DSPFDREP	(dstspid)11670	/* Delete for DS_Replicator */
#define DSPFUREP	(dstspid)11700	/* Update for DS_Replicator */
#define DSPFFCON	(dstspid)11730	/* Select for DS_ConfigInfo */
#define DSPFICON	(dstspid)11760	/* Insert for DS_ConfigInfo */
#define DSPFDCON	(dstspid)11790	/* Delete for DS_ConfigInfo */
#define DSPFUCON	(dstspid)11820	/* Update for DS_ConfigInfo */
#define DSPFFNAM	(dstspid)11850	/* Select for DS_Name */
#define DSPFINAM	(dstspid)11880	/* Insert for DS_Name */
#define DSPFDNAM	(dstspid)11910	/* Delete for DS_Name */
#define DSPFUNAM	(dstspid)11940	/* Update for DS_Name */
#define DSPFFAXE	(dstspid)11970	/* Select for DS_Access */
#define DSPFIAXE	(dstspid)12000	/* Insert for DS_Access */
#define DSPFDAXE	(dstspid)12030	/* Delete for DS_Access */
#define DSPFUAXE	(dstspid)12060	/* Update for DS_Access */
#define DSPFFSTA	(dstspid)12090	/* Select for DS_StaticElement */
#define DSPFISTA	(dstspid)12120	/* Insert for DS_StaticElement */
#define DSPFDSTA	(dstspid)12150	/* Delete for DS_StaticElement */
#define DSPFUSTA	(dstspid)12180	/* Update for DS_StaticElement */
#define DSPFFPER	(dstspid)12210	/* Select for DS_Person */
#define DSPFIPER	(dstspid)16170	/* Insert for DS_Person */
#define DSPFDPER	(dstspid)12270	/* Delete for DS_Person */
#define DSPFUPER	(dstspid)12300	/* Update for DS_Person */
#define DSPFFAPP	(dstspid)12330	/* Select for DS_Application */
#define DSPFIAPP	(dstspid)12360	/* Insert for DS_Application */
#define DSPFDAPP	(dstspid)12390	/* Delete for DS_Application */
#define DSPFUAPP	(dstspid)12420	/* Update for DS_Application */
#define DSPFFROL	(dstspid)12450	/* Select for DS_Role */
#define DSPFIROL	(dstspid)12480	/* Insert for DS_Role */
#define DSPFDROL	(dstspid)12510	/* Delete for DS_Role */
#define DSPFUROL	(dstspid)12540	/* Update for DS_Role */
#define DSPFFORG	(dstspid)12570	/* Select for DS_Organization */
#define DSPFIORG	(dstspid)12600	/* Insert for DS_Organization */
#define DSPFDORG	(dstspid)12630	/* Delete for DS_Organization */
#define DSPFUORG	(dstspid)12660	/* Update for DS_Organization */
#define DSPFFACC	(dstspid)12690	/* Select for DS_Account */
#define DSPFIACC	(dstspid)12720	/* Insert for DS_Account */
#define DSPFDACC	(dstspid)12750	/* Delete for DS_Account */
#define DSPFUACC	(dstspid)12780	/* Update for DS_Account */
#define DSPFFNOD	(dstspid)12810	/* Select for DS_Node */
#define DSPFINOD	(dstspid)12840	/* Insert for DS_Node */
#define DSPFDNOD	(dstspid)12870	/* Delete for DS_Node */
#define DSPFUNOD	(dstspid)12900	/* Update for DS_Node */
#define DSPFFDOM	(dstspid)12930	/* Select for DS_Domain */
#define DSPFIDOM	(dstspid)12960	/* Insert for DS_Domain */
#define DSPFDDOM	(dstspid)12990	/* Delete for DS_Domain */
#define DSPFUDOM	(dstspid)13020	/* Update for DS_Domain */
#define DSPFFGAT	(dstspid)13050	/* Select for DS_Gateway */
#define DSPFIGAT	(dstspid)13080	/* Insert for DS_Gateway */
#define DSPFDGAT	(dstspid)13110	/* Delete for DS_Gateway */
#define DSPFUGAT	(dstspid)13140	/* Update for DS_Gateway */
#define DSPFFROU	(dstspid)13170	/* Select for DS_Route */
#define DSPFIROU	(dstspid)13200	/* Insert for DS_Route */
#define DSPFDROU	(dstspid)13230	/* Delete for DS_Route */
#define DSPFUROU	(dstspid)13260	/* Update for DS_Route */
#define DSPFFPAT	(dstspid)13290	/* Select for DS_Path */
#define DSPFIPAT	(dstspid)13320	/* Insert for DS_Path */
#define DSPFDPAT	(dstspid)13350	/* Delete for DS_Path */
#define DSPFUPAT	(dstspid)13380	/* Update for DS_Path */
#define DSPFFCMN	(dstspid)13410	/* Select for DS_Community */
#define DSPFICMN	(dstspid)13440	/* Insert for DS_Community */
#define DSPFDCMN	(dstspid)13470	/* Delete for DS_Community */
#define DSPFUCMN	(dstspid)13500	/* Update for DS_Community */
#define DSPFFCRT	(dstspid)13530	/* Select for DS_CommRoute */
#define DSPFICRT	(dstspid)13560	/* Insert for DS_CommRoute */
#define DSPFDCRT	(dstspid)13590	/* Delete for DS_CommRoute */
#define DSPFUCRT	(dstspid)13620	/* Update for DS_CommRoute */
/*       DSPFFTOO	(dstspid)13650	deleted */
/*	 DSPFITOO	(dstspid)13680	deleted */
/*	 DSPFDTOO	(dstspid)13710	deleted */
/*	 DSPFUTOO	(dstspid)13740	deleted */
#define DSPFFLOC	(dstspid)13770	/* Select for DS_Location */
#define DSPFILOC	(dstspid)13800	/* Insert for DS_Location */
#define DSPFDLOC	(dstspid)13830	/* Delete for DS_Location */
#define DSPFULOC	(dstspid)13860	/* Update for DS_Location */
#define DSPFFROO	(dstspid)13890	/* Select for DS_Room */
#define DSPFIROO	(dstspid)13920	/* Insert for DS_Room */
#define DSPFDROO	(dstspid)13950	/* Delete for DS_Room */
#define DSPFUROO	(dstspid)13980	/* Update for DS_Room */
#define DSPFFEQU	(dstspid)14010	/* Select for DS_Equipment */
#define DSPFIEQU	(dstspid)14040	/* Insert for DS_Equipment */
#define DSPFDEQU	(dstspid)14070	/* Delete for DS_Equipment */
#define DSPFUEQU	(dstspid)14100	/* Update for DS_Equipment */
#define DSPFFPUB	(dstspid)14250	/* Select for DS_PubStaticList */
#define DSPFIPUB	(dstspid)14280	/* Insert for DS_PubStaticList */
#define DSPFDPUB	(dstspid)14310	/* Delete for DS_PubStaticList */
#define DSPFUPUB	(dstspid)14340	/* Update for DS_PubStaticList */
#define DSPFFPBA	(dstspid)14370	/* Select for DS_PubAlias */
#define DSPFIPBA	(dstspid)14400	/* Insert for DS_PubAlias */
#define DSPFDPBA	(dstspid)14430	/* Delete for DS_PubAlias */
#define DSPFUPBA	(dstspid)14460	/* Update for DS_PubAlias */
#define DSPFFPRD	(dstspid)14490	/* Select for DS_PvtStaticList */
#define DSPFIPRD	(dstspid)14520	/* Insert for DS_PvtStaticList */
#define DSPFDPRD	(dstspid)14550	/* Delete for DS_PvtStaticList */
#define DSPFUPRD	(dstspid)14580	/* Update for DS_PvtStaticList */
#define DSPFFPRA	(dstspid)14610	/* Select for DS_PvtAlias */
#define DSPFIPRA	(dstspid)14640	/* Insert for DS_PvtAlias */
#define DSPFDPRA	(dstspid)14670	/* Delete for DS_PvtAlias */
#define DSPFUPRA	(dstspid)14700	/* Update for DS_PvtAlias */
#define DSPFFSRO	(dstspid)14730	/* Select for DS_StaticRow */
#define DSPFISRO	(dstspid)14760	/* Insert for DS_StaticRow */
#define DSPFDSRO	(dstspid)14790	/* Delete for DS_StaticRow */
#define DSPFUSRO	(dstspid)14820	/* Update for DS_StaticRow */
#define DSPFFINS	(dstspid)14850	/* Select for OM_Instance */
#define DSPFIINS	(dstspid)14880	/* Insert for OM_Instance */
#define DSPFDINS	(dstspid)14910	/* Delete for OM_Instance */
#define DSPFUINS	(dstspid)14940	/* Update for OM_Instance */
#define DSPFFHEA	(dstspid)14970	/* Select for OM_Header */
#define DSPFIHEA	(dstspid)15000	/* Insert for OM_Header */
#define DSPFDHEA	(dstspid)15030	/* Delete for OM_Header */
#define DSPFUHEA	(dstspid)15060	/* Update for OM_Header */
#define DSPFFEXT	(dstspid)15090	/* Select for OM_Ext_Header */
#define DSPFIEXT	(dstspid)15120	/* Insert for OM_Ext_Header */
#define DSPFDEXT	(dstspid)15150	/* Delete for OM_Ext_Header */
#define DSPFUEXT	(dstspid)15180	/* Update for OM_Ext_Header */
#define DSPFFBOD	(dstspid)15210	/* Select for OM_Body */
#define DSPFIBOD	(dstspid)15240	/* Insert for OM_Body */
#define DSPFDBOD	(dstspid)15270	/* Delete for OM_Body */
#define DSPFUBOD	(dstspid)15300	/* Update for OM_Body */
#define DSPFFREG	(dstspid)15330	/* Select for DS_Registration */
#define DSPFIREG	(dstspid)15360	/* Insert for DS_Registration */
#define DSPFDREG	(dstspid)15390	/* Delete for DS_Registration */
#define DSPFUREG	(dstspid)15420	/* Update for DS_Registration */
#define DSPFFPTO	(dstspid)15450	/* Select for DS_Process_Tokens */
#define DSPFIPTO	(dstspid)15480	/* Insert for DS_Process_Tokens */
#define DSPFDPTO	(dstspid)15510	/* Delete for DS_Process_Tokens */
#define DSPFUPTO	(dstspid)15540	/* Update for DS_Process_Tokens */
#define DSPFFPRO	(dstspid)15570	/* Select for DS_Process */
#define DSPFIPRO	(dstspid)15600	/* Insert for DS_Process */
#define DSPFDPRO	(dstspid)15630	/* Delete for DS_Process */
#define DSPFUPRO	(dstspid)15660	/* Update for DS_Process */
#define DSPFFPPA	(dstspid)15690	/* Select for DS_Proc_Params */
#define DSPFIPPA	(dstspid)15720	/* Insert for DS_Proc_Params */
#define DSPFDPPA	(dstspid)15750	/* Delete for DS_Proc_Params */
#define DSPFUPPA	(dstspid)15780	/* Update for DS_Proc_Params */
#define DSPFFPTI	(dstspid)15810	/* Select for DS_Proc_Time */
#define DSPFIPTI	(dstspid)15840	/* Insert for DS_Proc_Time */
#define DSPFDPTI	(dstspid)15870	/* Delete for DS_Proc_Time */
#define DSPFUPTI	(dstspid)15900	/* Update for DS_Proc_Time */
#define DSPFFOCL	(dstspid)15930	/* Select for DS_OClass */
#define DSPFIOCL	(dstspid)15960	/* Insert for DS_OClass */
#define DSPFDOCL	(dstspid)15990	/* Delete for DS_OClass */
#define DSPFUOCL	(dstspid)16020	/* Update for DS_OClass */
#define DSPFFOMA	(dstspid)16050	/* Select for OM_Att_Types */
#define DSPFIOMA	(dstspid)16080	/* Insert for OM_Att_Types */
#define DSPFDOMA	(dstspid)16110	/* Delete for OM_Att_Types */
#define DSPFUOMA	(dstspid)16140	/* Update for OM_Att_Types */
#define DAPFFOMA	(dstspid)16150	/* Fetch OM_Att_Types for admin only */
/* DSPFFIPERSON 16170  - see above */
#define DSPFFOAP	(dstspid)16190	/* Select for OA_Pref */
#define DSPFIOAP	(dstspid)16200	/* Insert for OA_Pref */
#define DSPFDOAP	(dstspid)16210	/* Delete for OA_Pref */
#define DSPFUOAP	(dstspid)16220	/* Update for OA_Pref */
#define DSPFFPRE	(dstspid)16232	/* Select for DS_Pref */
#define DSPFIPRE	(dstspid)16240	/* Insert for DS_Pref */
#define DSPFDPRE	(dstspid)16250	/* Delete for DS_Pref */
#define DSPFUPRE	(dstspid)16260	/* Update for DS_Pref */
#define DSPFFDPR	(dstspid)16270	/* Select for DS_Product */
#define DSPFIDPR	(dstspid)16280	/* Insert for DS_Product */
#define DSPFDDPR	(dstspid)16290	/* Delete for DS_Product */
#define DSPFUDPR	(dstspid)16300	/* Update for DS_Product */
#define DSPFFMTE	(dstspid)16310	/* Select for OM_Mon_Test */
#define DSPFIMTE	(dstspid)16320	/* Insert for OM_Mon_Test */
#define DSPFDMTE	(dstspid)16330	/* Delete for OM_Mon_Test */
#define DSPFUMTE	(dstspid)16340	/* Update for OM_Mon_Test */
#define DSPFFKTS	(dstspid)16350	/* Select for OMK_Tasks */
#define DSPFIKTS	(dstspid)16360	/* Insert for OMK_Tasks */
#define DSPFDKTS	(dstspid)16370	/* Delete for OMK_Tasks */
#define DSPFUKTS	(dstspid)16380	/* Update for OMK_Tasks */
#define DSPFFTMP	(dstspid)16390	/* Select for OM_Template */
#define DSPFITMP	(dstspid)16410	/* Insert for OM_Template */
#define DSPFDTMP	(dstspid)16420	/* Delete for OM_Template */
#define DSPFUTMP	(dstspid)16430	/* Update for OM_Template */
#define DSPFFRWR	(dstspid)16450  /* Select for DS_Rewrite */
#define DSPFIRWR	(dstspid)16460  /* Insert for DS_Rewrite */
#define DSPFDRWR	(dstspid)16470  /* Delete for DS_Rewrite */
#define DSPFURWR	(dstspid)16480  /* Update for DS_Rewrite */


/* select for update of procedures */
#define DSPFLCLA     (dstspid)16490
#define DSPFLIDM     (dstspid)16510
#define DSPFLGRE     (dstspid)16520
#define DSPFLCOM     (dstspid)16530
#define DSPFLREP     (dstspid)16540
#define DSPFLCON     (dstspid)16550
#define DSPFLNAM     (dstspid)16570
#define DSPFLAXE     (dstspid)16590
#define DSPFLSTA     (dstspid)16600
#define DSPFLPER     (dstspid)16610
#define DSPFLAPP     (dstspid)16650
#define DSPFLROL     (dstspid)16660
#define DSPFLORG     (dstspid)16670
#define DSPFLACC     (dstspid)16690
#define DSPFLNOD     (dstspid)16710
#define DSPFLDOM     (dstspid)16730
#define DSPFLGAT     (dstspid)16740
#define DSPFLROU     (dstspid)16750
#define DSPFLPAT     (dstspid)16760
#define DSPFLCMN     (dstspid)16780
#define DSPFLCRT     (dstspid)16790
#define DSPFLTOO     (dstspid)16800
#define DSPFLLOC     (dstspid)16820
#define DSPFLROO     (dstspid)16830
#define DSPFLEQU     (dstspid)16860
#define DSPFLPUB     (dstspid)16890
#define DSPFLPBA     (dstspid)16910
#define DSPFLPRD     (dstspid)16930
#define DSPFLPRA     (dstspid)16950
#define DSPFLSRO     (dstspid)16970
#define DSPFLINS     (dstspid)16980
#define DSPFLHEA     (dstspid)16990
#define DSPFLEXT     (dstspid)17010
#define DSPFLBOD     (dstspid)17020
#define DSPFLREG     (dstspid)17040
#define DSPFLPTO     (dstspid)17060
#define DSPFLPRO     (dstspid)17070
#define DSPFLPPA     (dstspid)17080
#define DSPFLPTI     (dstspid)17090
#define DSPFLOCL     (dstspid)17100
#define DSPFLOMA     (dstspid)17110
#define DSPFLOAP     (dstspid)17120
#define DSPFLPRE     (dstspid)17130
#define DSPFLDPR     (dstspid)17140
#define DSPFLMTE     (dstspid)17150
#define DSPFLKTS     (dstspid)17160
#define DSPFLTMP     (dstspid)17170
#define DSPFLRWR     (dstspid)17190

/* Newer classes, added on later and out of sequence */
#define DSPFFGTY	(dstspid)17200  /* Select for DS_GateType */
#define DSPFIGTY	(dstspid)17210  /* Insert for DS_GateType */
#define DSPFDGTY	(dstspid)17220  /* Delete for DS_GateType */
#define DSPFUGTY	(dstspid)17230  /* Update for DS_GateType */
#define DSPFLGTY	(dstspid)17240  /* Lock for DS_GateType */
#define DSPFLATT        (dstspid)17250  /* Lock for DS_Attribute */
#define DSPFFGAP	(dstspid)17270  /* Select for DS_GateApp */
#define DSPFIGAP	(dstspid)17280  /* Insert for DS_GateApp */
#define DSPFDGAP	(dstspid)17290  /* Delete for DS_GateApp */
#define DSPFUGAP	(dstspid)17300  /* Update for DS_GateApp */
#define DSPFFUAP	(dstspid)17310  /* Select for DS_UserApp */
#define DSPFIUAP	(dstspid)17320  /* Insert for DS_UserApp */
#define DSPFDUAP	(dstspid)17330  /* Delete for DS_UserApp */
#define DSPFUUAP	(dstspid)17340  /* Update for DS_UserApp */
#define DSPFLGAP	(dstspid)17350  /* Lock for DS_GateApp */
#define DSPFLUAP	(dstspid)17360  /* Lock for DS_UserApp */
#define DSPFFIAP	(dstspid)17370  /* Select for DS_InternalApp */
#define DSPFIIAP	(dstspid)17380  /* Insert for DS_InternalApp */
#define DSPFDIAP	(dstspid)17390  /* Delete for DS_InternalApp */
#define DSPFUIAP	(dstspid)17400  /* Update for DS_InternalApp */
#define DSPFLIAP	(dstspid)17410  /* Lock for DS_InternalApp */

/* OM_Prv_Temp Stored Procedures  */

#define DSPFFPRV_TEMP	(dstspid)17427	/* Select for OM_Prv_Temp */
#define DSPFIPRV_TEMP	(dstspid)17447	/* Insert for OM_Prv_Temp */
#define DSPFDPRV_TEMP	(dstspid)17462	/* Delete for OM_Prv_Temp */
#define DSPFUPRV_TEMP	(dstspid)17478	/* Update for OM_Prv_Temp */
#define DSPFLPRV_TEMP	(dstspid)17498	/* Lock for OM_Prv_Temp */

/* DS_Lookup Stored Procedures  */

#define DSPFFLOOKUP	(dstspid)17519	/* Select for DS_Lookup */
#define DSPFILOOKUP	(dstspid)17533	/* Insert for DS_Lookup */
#define DSPFDLOOKUP	(dstspid)17545	/* Delete for DS_Lookup */
#define DSPFULOOKUP	(dstspid)17557	/* Update for DS_Lookup */
#define DSPFLLOOKUP	(dstspid)17571	/* Lock for DS_Lookup */

/* DS_ObjSysAttrs Stored Procedures  */
#define DSPFFOSA	(dstspid)17600  /* Select for DS_ObjSysAttrs */
#define DSPFIOSA	(dstspid)17610  /* Insert for DS_ObjSysAttrs */
#define DSPFDOSA	(dstspid)17620  /* Delete for DS_ObjSysAttrs */
#define DSPFUOSA	(dstspid)17630  /* Update for DS_ObjSysAttrs */
#define DSPFLOSA	(dstspid)17640  /* Lock for DS_ObjSysAttrs */

/* DS_RepSyncLog Stored Procedures  */
#define DSPFFRSL	(dstspid)17650  /* Select for DS_ObjSysAttrs */
#define DSPFIRSL	(dstspid)17660  /* Insert for DS_ObjSysAttrs */
#define DSPFDRSL	(dstspid)17670  /* Delete for DS_ObjSysAttrs */
#define DSPFURSL	(dstspid)17680  /* Update for DS_ObjSysAttrs */
#define DSPFLRSL	(dstspid)17690  /* Lock for DS_ObjSysAttrs */

/* DS PL/SQL stored procedures and anonymous blocks */
#define DSPL_ILI         (dstspid)17700 /* is user <uid> logged in? */
#define DSPL_MON         (dstspid)17710 /* monolithic login */
/*      DSPL_MON, continued       17720    monolithic login */
/*      DSPL_MON, continued       17730    monolithic login */
#define DSPL_ROL         (dstspid)17740 /* set role */
#define DSPL_NARE	 (dstspid)17750 /* name resolution */
#define DSPL_NRCO	 (dstspid)17760 /* name resolution continue */
#define DSPL_NRRR	 (dstspid)17770 /* name resolution return results */
#define DSPL_MAIL        (dstspid)17780 /* mail init */

/* DS_20Process pseudo class sql -- 2.0.14 back compatibility */    
#define DS2FFPRO	(dstspid)17800	/* Select for DS_20Process */
#define DS2FIPRO	(dstspid)17810	/* Insert for DS_20Process */
#define DS2FDPRO	(dstspid)17820	/* Delete for DS_20Process */
#define DS2FUPRO	(dstspid)17830	/* Update for DS_20Process */
#define DS2FLPRO	(dstspid)17840	/* Lock for DS_20Process */

/* DS_SyncType synchronization type registry SQL */
#define DSPFFSST	(dstspid)17850	/* Select for DS_Synctype */
#define DSPFISST	(dstspid)17860	/* Insert for DS_Synctype */
#define DSPFDSST	(dstspid)17870	/* Delete for DS_Synctype */
#define DSPFUSST	(dstspid)17880	/* Update for DS_Synctype */
#define DSPFLSST	(dstspid)17890	/* Lock for DS_Synctype */

/* OM_ATT_MAP SQL */
#define DSPFFOMAT	(dstspid)17900	/* Select for OM_Att_Map */
#define DSPFIOMAT	(dstspid)17910	/* Insert for OM_Att_Map */
#define DSPFDOMAT	(dstspid)17920	/* Delete for OM_Att_Map */
#define DSPFUOMAT	(dstspid)17930	/* Update for OM_Att_Map */
#define DSPFLOMAT	(dstspid)17110  /* Lock for OM_Att_Map */

/* range 18000 - 20000 is owned by oa_admin */


/* Using the following for Version 1.2 */

/* DLs	*/
#define DSV1DPRS	(dstspid)30010	/* Select Private DL */
#define DSV1DPRU	(dstspid)30020	/* Update Private DL */
#define DSV1DPRI	(dstspid)30030	/* Insert Private DL */
#define DSV1DPRD	(dstspid)30040	/* Delete Private DL */
#define DSV1DPUS	(dstspid)30050	/* Select Public  DL */
#define DSV1DALS	(dstspid)30090  /* Select All     DL */
#define DSV1DMMS	(dstspid)30100  /* Select Dls members */
#define DSV1DRHD	(dstspid)30110  /* Delete a single RHS */
#define DSV1DARH	(dstspid)30120  /* Delete the entire RHS */
#define DSV1DLOP	(dstspid)30130  /* Check if nlhs creats loop on U DL */
#define DSV1DRHI	(dstspid)30140  /* Insert a single RHS */
#define DSV1DCPI	(dstspid)30150  /* CP rhs of a DL */
#define DSV1DBMS	(dstspid)30160  /* Fetch Public DL members */


/* Aliases */
#define DSV1APRS	(dstspid)30200	/* Select Private Alias */
#define DSV1APRU	(dstspid)30210	/* Update Private Alias */
#define DSV1APRI	(dstspid)30220	/* Insert Private Alias */
#define DSV1APRD	(dstspid)30230	/* Delete Private Alias */
#define DSV1APUS	(dstspid)30240	/* Select Public  Alias */
#define DSV1AALS	(dstspid)30280	/* Select All	  Alias */

/* Names */
#define DSV1PNMS	(dstspid)30300	/* Select All Names */

/* Domain */
#define DSV1PDOS	(dstspid)30310	/* Select Domain Names */

/* Gateway */
#define DSV1PGTS	(dstspid)30320	/* Select Gateway Names */

/* Misc */
#define DSV1CDUP	(dstspid)30330	/* Get itemid, node for alias or dl */

/* Get and Set Password */
#define DSV1GTPW	(dstspid)30340	/* Get password */
#define DSV1STPW	(dstspid)30350	/* Set password */


#endif /* DSSPID */
