#!/bin/sh

JDK_ROOT=%JDK_ROOT%
ORACLE_HOME=%ORACLE_HOME%

LD_LIBRARY_PATH=$ORACLE_HOME/lib:$JDK_ROOT/lib
export LD_LIBRARY_PATH

JLIBDIR=$ORACLE_HOME/jlib
LIBDIR=$ORACLE_HOME/lib
JDBCDIR=$ORACLE_HOME/jdbc/lib
OJLIBDIR=$ORACLE_HOME/olap/jlib
UCPLIBDIR=$ORACLE_HOME/ucp/lib
RUNTIME12DIR=$ORACLE_HOME/sqlj/lib

EWT=$JLIBDIR/share.jar:$JLIBDIR/ewt3.jar
JEWT4=$JLIBDIR/jewt4.jar:$JLIBDIR/jle3.jar:$JLIBDIR/dbui4.jar
KODIAK=$OJLIBDIR/kodiak.jar
JDBC2=$JDBCDIR/ojdbc6.jar
OHJ4=$JLIBDIR/ohj.jar
HELPSHARE=$JLIBDIR/help-share.jar
ICE=$JLIBDIR/oracle_ice.jar
WDEP=$OJLIBDIR/workdep.zip

API1=$OJLIBDIR/collections.jar
API2=$ORACLE_HOME/olap/api/lib/olap_api.jar:$ORACLE_HOME/olap/api/lib/olap_api_spl.jar
API3=$ORACLE_HOME/olap/api/lib/awxml.jar
GDK4=$JLIBDIR/orai18n.jar:$JLIBDIR/orai18n-utility.jar:$JLIBDIR/orai18n-mapping.jar:$JLIBDIR/orai18n-translation.jar:$JLIBDIR/orai18n-collation.jar

WKS=$OJLIBDIR/xsjwork.jar
UCP=$UCPLIBDIR/ucp.jar
RUNTIME12=$RUNTIME12DIR/runtime12.jar

AWM=$OJLIBDIR/awm.jar:$OJLIBDIR/awmdep.zip:$OJLIBDIR/awmhelp.jar:$LIBDIR/xmlparserv2.jar:$LIBDIR/xmlcomp.jar


START=oracle.olap.awm.app.AwmApp
CLASSPATH=$WDEP:$EWT:$JEWT4:$KODIAK:$JDBC2:$AWM:$OHJ4:$HELPSHARE:$ICE:$API1:$API2:$API3:$GDK4:$WKS:$UCP:$RUNTIME12
JAVA_RT=$JDK_ROOT/bin/java

cd $ORACLE_HOME/olap/awm
$JAVA_RT -DORACLE_HOME=%ORACLE_HOME% -mx1024m -XX:MaxPermSize=128m -cp $CLASSPATH $START $1 $2 $3 $4 $5 $6 $7 $8 $9 > awmrun.log
