Rem
Rem $Header: duma/admin/after_drop_repository.sql /main/2 2010/06/01 19:29:03 nli Exp $
Rem
Rem after_drop_repository.sql
Rem
Rem Copyright (c) 2008, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      after_drop_repository.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This script drops DUMA auxiliary tables and packages
Rem
Rem    NOTES
Rem      Run as SYS user.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    qicheng     12/30/09 - Created
Rem
SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


-- uninstall ctas package
drop package sys.dum$ctas
/

drop type sys.TableObjectNumber
/

drop type sys.NestTableName
/

-- uninstall scanning package
drop table system.dum$chunks_info
/

DROP PROCEDURE DUM_CALCULATE_TABLE
/

DROP PROCEDURE DUM_LOCAL_SPLIT
/

DROP PROCEDURE DUM_DICT_SPLIT
/

DROP PROCEDURE DUM_PARTITION_SPLIT
/

DROP PROCEDURE DUM_SPLIT_CHUNKS_PROC
/

DROP PROCEDURE DUM_SPLIT_CHUNKS
/

-- uninstall cleansing package
drop function sys.DUMA_GET_VARCHAR2
/

drop function sys.DUMA_PUT_VARCHAR2
/

drop type sys.DUMA_ADT_VARCHAR2
/

drop function sys.dum$c2b
/

drop procedure sys.dum$anydataset_sql
/

drop procedure dum$updatelongarr
/

drop type dum$LongUpdateArr
/

drop type dum$LongUpdateElem
/

DROP FUNCTION SYS.DUM$XML2B
/

--DROP PROCEDURE %s.DUM_%s_UPDATE_XMLTYPE, sys, public
DROP PROCEDURE sys.DUM_PUBLIC_UPDATE_XMLTYPE
/

-- DROP TYPE %s.%s_CHANGE_LIST, sys, public
DROP TYPE SYSTEM.DUM$PUBLIC_CHANGE_LIST
/

-- DROP TYPE %s.%s_CHANGE_OBJECT, sys, public
DROP TYPE SYSTEM.DUM$PUBLIC_CHANGE_OBJECT
/


--DROP CLOB UPDATE TYPES 
drop type sys.dum$ClobUpdateElem;
drop type sys.dum$ClobUpdateArr;
drop procedure sys.dum$updateclobarr;


 -- drop anydataset temporaries
 declare 
   cursor updateobj is select name from obj$ where name like 'DUM$CLS$%UPD' and type# = 7; 
   cursor queryobj is select name from obj$ where name like 'DUM$CLS$%QUE' and type# = 8; 
   cursor arrayobj is select name from obj$ where name like 'DUM$CLS$%ARR' and type# = 13;
   objname varchar2(40); 
 begin 
   open updateobj; 
   loop 
     fetch updateobj into objname;   
     exit when updateobj%NOTFOUND; 
     dbms_output.put_line('drop procedure ' || objname); 
     execute immediate 'drop procedure ' || objname;    
   end loop;   
   close updateobj;  
   open queryobj; 
   loop 
     fetch queryobj into objname;   
     exit when queryobj%NOTFOUND; 
     dbms_output.put_line('drop function ' || objname); 
     execute immediate 'drop function ' || objname;    
   end loop; 
   close queryobj; 
   open arrayobj; 
   loop 
     fetch arrayobj into objname;  
     exit when arrayobj%NOTFOUND; 
     dbms_output.put_line('drop type ' || objname);      
     execute immediate 'drop type ' || objname;        
   end loop; 
   close arrayobj; 
 end; 
/

-- 
drop package sys.dbms_duma_sys
/


