
  CREATE OR REPLACE PACKAGE "ODMRSYS"."ODMR_CONSTANT" 
AUTHID CURRENT_USER AS

  /* Global settings */
  -- algorithm settings as defined in DBMS_DM
  /* Depreciated
  ABNS_MAX_BUILD_MINUTES        CONSTANT VARCHAR2(30) := 'ABNS_MAX_BUILD_MINUTES';
  ABNS_MAX_NB_PREDICTORS        CONSTANT VARCHAR2(30) := 'ABNS_MAX_NB_PREDICTORS';
  ABNS_MAX_PREDICTORS           CONSTANT VARCHAR2(30) := 'ABNS_MAX_PREDICTORS';
  ABNS_MODEL_TYPE               CONSTANT VARCHAR2(30) := 'ABNS_MODEL_TYPE';
  */

  /* Association Rules settings */
  -- Maximum rule length for Association Rules. 2<= numeric_expr <=20
  ASSO_MAX_RULE_LENGTH          CONSTANT VARCHAR2(30) := 'ASSO_MAX_RULE_LENGTH';
  -- Minimum confidence for Association Rules, 0<= numeric_expr <=1
  ASSO_MIN_CONFIDENCE           CONSTANT VARCHAR2(30) := 'ASSO_MIN_CONFIDENCE';
  -- Minimum support for Association Rules, 0<= numeric_expr <=1
  ASSO_MIN_SUPPORT              CONSTANT VARCHAR2(30) := 'ASSO_MIN_SUPPORT';
  -- Item ID
  ODMS_ITEM_ID_COLUMN_NAME      CONSTANT VARCHAR2(30) := 'ODMS_ITEM_ID_COLUMN_NAME';
  -- Item Value (optional)
  ODMS_ITEM_VALUE_COLUMN_NAME   CONSTANT VARCHAR2(30) := 'ODMS_ITEM_VALUE_COLUMN_NAME';

  /* Clustering settings */
  -- Number of clusters generated by a clustering algorithm, numeric_expr >=1
  CLUS_NUM_CLUSTERS             CONSTANT VARCHAR2(30) := 'CLUS_NUM_CLUSTERS';

  /* KMean settings */
  -- Growth factor for memory allocated to hold cluster data.
  -- Default is 2. 1< numeric_expr <=5
  KMNS_BLOCK_GROWTH             CONSTANT VARCHAR2(30) := 'KMNS_BLOCK_GROWTH';
  -- Convergence tolerance for k-Means algorithm
  -- Default is 0.01. 0< numeric_expr <=0.5
  KMNS_CONV_TOLERANCE           CONSTANT VARCHAR2(30) := 'KMNS_CONV_TOLERANCE';
  -- Distance Function for k-Means Clustering. The default is euclidean.
  KMNS_DISTANCE                 CONSTANT VARCHAR2(30) := 'KMNS_DISTANCE';
    KMNS_COSINE                   CONSTANT VARCHAR2(30) := 'KMNS_COSINE';
    KMNS_EUCLIDEAN                CONSTANT VARCHAR2(30) := 'KMNS_EUCLIDEAN';
    KMNS_FAST_COSINE              CONSTANT VARCHAR2(30) := 'KMNS_FAST_COSINE';
  -- Number of iterations for k-Means algorithm
  -- Default is 3. 0< numeric_expr <=20
  KMNS_ITERATIONS               CONSTANT VARCHAR2(30) := 'KMNS_ITERATIONS';
  -- The fraction of attribute values that must be non-null in order for the attribute to be included in the rule description for the cluster.
  -- Setting the parameter value too high in data with missing values can result in very short or even empty rules.
  -- Default is 0.1. 0<= numeric_expr <=1
  KMNS_MIN_PCT_ATTR_SUPPORT     CONSTANT VARCHAR2(30) := 'KMNS_MIN_PCT_ATTR_SUPPORT';
  -- Number of histogram bins. Specifies the number of bins in the attribute histogram produced by k-Means. The bin boundaries for each attribute are computed globally on the entire training data set. The binning method is equi-width. All attributes have the same number of bins with the exception of attributes with a single value that have only one bin.
  -- Default is 10. numeric_expr >0
  KMNS_NUM_BINS                 CONSTANT VARCHAR2(30) := 'KMNS_NUM_BINS';
  -- Split criterion for k-Means Clustering. The default criterion is the variance.
  KMNS_SPLIT_CRITERION          CONSTANT VARCHAR2(30) := 'KMNS_SPLIT_CRITERION';
    KMNS_SIZE                     CONSTANT VARCHAR2(30) := 'KMNS_SIZE';
    KMNS_VARIANCE                 CONSTANT VARCHAR2(30) := 'KMNS_VARIANCE';

  /* OCluster settings */
  -- Buffer size for O-Cluster.
  -- Default is 50,000. numeric_expr >0
  OCLT_MAX_BUFFER               CONSTANT VARCHAR2(30) := 'OCLT_MAX_BUFFER';
  -- A fraction that specifies the peak density required for separating a new cluster. The fraction is related to the global uniform density.
  -- Default is 0.5. 0 <=numeric_expr <=1
  OCLT_SENSITIVITY              CONSTANT VARCHAR2(30) := 'OCLT_SENSITIVITY';

  /* GLM settings */
  -- The confidence level for coefficient confidence intervals.
  -- The default confidence level is 0.95. 0< numeric_expr <1
  GLMS_CONF_LEVEL               CONSTANT VARCHAR2(30) := 'GLMS_CONF_LEVEL';
  -- The name of a table to contain row-level diagnostic information for a GLM model. The table is created during model build.
  -- If you want to create a diagnostics table, you must specify a case ID when you build the model. (See the CREATE_MODEL Procedure.) If you specify a diagnostics table but do not provide a case ID, an exception is raised.
  GLMS_DIAGNOSTICS_TABLE_NAME   CONSTANT VARCHAR2(30) := 'GLMS_DIAGNOSTICS_TABLE_NAME';
  -- The target value to be used as a reference in a binary logistic regression model. Probabilities will be produced for the other (non-reference) class.
  -- By default, the algorithm choses the value with the highest prevalence (the most cases) for the reference class.
  GLMS_REFERENCE_CLASS_NAME     CONSTANT VARCHAR2(30) := 'GLMS_REFERENCE_CLASS_NAME';
  -- Whether or not ridge regression will be enabled. By default, the algorithm determines whether or not to use ridge. You can explicitly enable ridge by setting GLMS_RIDGE_REGRESSION to GLMS_RIDGE_REG_ENABLE.
  -- Ridge applies to both regression and classification mining functions.
  -- When ridge is enabled, VIF is not produced  unless you set GLMS_VIF_FOR_RIDGE to GLMS_VIF_RIDGE_ENABLE and adequate system resources are available. GLMS_VIF_FOR_RIDGE applies to linear regression only. GLMS_VIF_FOR_RIDGE can only be specified when you explicitly enable ridge.
  -- When ridge is enabled, no prediction bounds are produced by the PREDICTION_BOUNDS SQL operator.
  GLMS_RIDGE_REGRESSION         CONSTANT VARCHAR2(30) := 'GLMS_RIDGE_REGRESSION';
    GLMS_RIDGE_REG_ENABLE         CONSTANT VARCHAR2(30) := 'GLMS_RIDGE_REG_ENABLE';
    GLMS_RIDGE_REG_DISABLE        CONSTANT VARCHAR2(30) := 'GLMS_RIDGE_REG_DISABLE';
  -- The value for the ridge parameter used by the algorithm. This setting is only used when you explicitly enable ridge regression by setting GLMS_RIDGE_REGRESSION to GLMS_RIDGE_REG_ENABLE.
  -- If ridge regression is enabled internally by the algorithm, the ridge parameter is determined by the algorithm.
  -- 0< numeric_expr
  GLMS_RIDGE_VALUE              CONSTANT VARCHAR2(30) := 'GLMS_RIDGE_VALUE';
  -- Whether or not to produce Variance Inflation Factor (VIF) statistics when ridge is being used for linear regression. When you explicitly enable ridge regression by setting GLMS_RIDGE_REGRESSION to GLMS_RIDGE_REG_ENABLE, you can request VIF statistics by setting GLMS_VIF_FOR_RIDGE to GLMS_VIF_RIDGE_ENABLE; the algorithm will produce VIF if enough system resources are available.
  GLMS_VIF_FOR_RIDGE            CONSTANT VARCHAR2(30) := 'GLMS_VIF_FOR_RIDGE';
    GLMS_VIF_RIDGE_ENABLE         CONSTANT VARCHAR2(30) := 'GLMS_VIF_RIDGE_ENABLE';
    GLMS_VIF_RIDGE_DISABLE        CONSTANT VARCHAR2(30) := 'GLMS_VIF_RIDGE_DISABLE';

  /* NB settings */
  -- Value of pairwise threshold for NB algorithm
  -- Default is 0.01. 0<= numeric_expr <=1
  NABS_PAIRWISE_THRESHOLD       CONSTANT VARCHAR2(30) := 'NABS_PAIRWISE_THRESHOLD';
  -- Value of singleton threshold for NB algorithm
  -- Default value is 0.01. 0<= numeric_expr <=1
  NABS_SINGLETON_THRESHOLD      CONSTANT VARCHAR2(30) := 'NABS_SINGLETON_THRESHOLD';

  /* NMF settings */
  -- Number of features to be extracted by a feature extraction model.
  -- The default is estimated from the data by the algorithm.  1 <= numeric_expr
  FEAT_NUM_FEATURES             CONSTANT VARCHAR2(30) := 'FEAT_NUM_FEATURES';
  -- Convergence toerance for NMF algorithm
  -- Default is 0.05. 0< numeric_expr <=0.5
  NMFS_CONV_TOLERANCE           CONSTANT VARCHAR2(30) := 'NMFS_CONV_TOLERANCE';
  -- Number of iterations for NMF algorithm
  -- Default is 50. 1 <= numeric_expr <=500
  NMFS_NUM_ITERATIONS           CONSTANT VARCHAR2(30) := 'NMFS_NUM_ITERATIONS';
  -- Random seed for NMF algorithm.
  -- Default is -1.
  NMFS_RANDOM_SEED              CONSTANT VARCHAR2(30) := 'NMFS_RANDOM_SEED';

  /* SVM settings */
  -- Whether active learning is enabled or disabled. By default, active learning is enabled.
  -- When active learning is enabled, the SVM algorithm uses active learning to build a reduced size model. When active learning is disabled, the SVM algorithm builds a standard model.
  SVMS_ACTIVE_LEARNING          CONSTANT VARCHAR2(30) := 'SVMS_ACTIVE_LEARNING';
    SVMS_AL_DISABLE               CONSTANT VARCHAR2(30) := 'SVMS_AL_DISABLE';
    SVMS_AL_ENABLE                CONSTANT VARCHAR2(30) := 'SVMS_AL_ENABLE';
  -- Value of complexity factor for SVM algorithm (both classification and regression)
  -- efault value estimated from the data by the algorithm. numeric_expr >0
  SVMS_COMPLEXITY_FACTOR        CONSTANT VARCHAR2(30) := 'SVMS_COMPLEXITY_FACTOR';
  --Convergence tolerance for SVM algorithm
  -- Default is 0.001. numeric_expr >0
  SVMS_CONV_TOLERANCE           CONSTANT VARCHAR2(30) := 'SVMS_CONV_TOLERANCE';
  -- Value of epsilon factor for SVM regression
  -- Default value estimated from the data by the algorithm. numeric_expr >0
  SVMS_EPSILON                  CONSTANT VARCHAR2(30) := 'SVMS_EPSILON';
  -- Value of kernel cache size for SVM algorithm. Applies to Gaussian kernel only.
  -- Default is 50000000 bytes. numeric_expr >0
  SVMS_KERNEL_CACHE_SIZE        CONSTANT VARCHAR2(30) := 'SVMS_KERNEL_CACHE_SIZE';
  -- Kernel for Support Vector Machine. The default kernel is linear.
  SVMS_KERNEL_FUNCTION          CONSTANT VARCHAR2(30) := 'SVMS_KERNEL_FUNCTION';
    SVMS_GAUSSIAN                 CONSTANT VARCHAR2(30) := 'SVMS_GAUSSIAN';
    SVMS_LINEAR                   CONSTANT VARCHAR2(30) := 'SVMS_LINEAR';
  -- The desired rate of outliers in the training data. Valid for One-Class SVM models only (anomaly detection).
  -- Default is 0.1. 0< numeric_expr <1
  SVMS_OUTLIER_RATE             CONSTANT VARCHAR2(30) := 'SVMS_OUTLIER_RATE';
  -- Value of standard deviation for SVM algorithm
  -- This is applicable only for Gaussian kernel
  -- Default value estimated from the data by the algorithm. numeric_expr >0
  SVMS_STD_DEV                  CONSTANT VARCHAR2(30) := 'SVMS_STD_DEV';

  /* Decision Tree Settings */
  -- Tree impurity metric for Decision Tree.
  -- Tree algorithms seek the best test question for splitting data at each node. The best splitter and split value are those that result in the largest increase in target value homogeneity (purity) for the entities in the node. Purity is measured in accordance with a metric. Decision trees can use either gini (TREE_IMPURITY_GINI) or entropy (TREE_IMPURITY_ENTROPY) as the purity metric. By default, the algorithm uses gini.
  TREE_IMPURITY_METRIC          CONSTANT VARCHAR2(30) := 'TREE_IMPURITY_METRIC';
  -- Criteria for splits: maximum tree depth (the maximum number of nodes between the root and any leaf node, including the leaf node).
  -- Default is 7. 2<= numeric_expr <=20
  TREE_TERM_MAX_DEPTH           CONSTANT VARCHAR2(30) := 'TREE_TERM_MAX_DEPTH';
  -- No child shall have fewer records than this number, which is expressed as a percentage of the training rows.
  -- Default is 0.05, indicating 0.05%. 0<= numeric_expr <=10
  TREE_TERM_MINPCT_NODE         CONSTANT VARCHAR2(30) := 'TREE_TERM_MINPCT_NODE';
  -- Criteria for splits: minimum number of records in a parent node expressed as a percent of the total number of records used to train the model. No split is attempted if number of records is below this value.
  -- Default is 0.1, indicating 0.1%. 0 <= numeric_expr <=20
  TREE_TERM_MINPCT_SPLIT        CONSTANT VARCHAR2(30) := 'TREE_TERM_MINPCT_SPLIT';
  -- No child shall have fewer records than this number.
  -- Default is 10. numeric_expr >=0
  TREE_TERM_MINREC_NODE         CONSTANT VARCHAR2(30) := 'TREE_TERM_MINREC_NODE';
  -- Criteria for splits: minimum number of records in a parent node expressed as a value. No split is attempted if number of records is below this value.
  -- Default is 20. numeric_expr >=0
  TREE_TERM_MINREC_SPLIT        CONSTANT VARCHAR2(30) := 'TREE_TERM_MINREC_SPLIT';

  /* Global settings (only applicable for GLM now) */
  -- (GLM only) How to treat missing values in the training data. This setting does not affect the scoring data.
  ODMS_MISSING_VALUE_TREATMENT  CONSTANT VARCHAR2(30) := 'ODMS_MISSING_VALUE_TREATMENT';
  -- Missing values treatment Options
  -- Oracle Data Mining replaces missing values with the mean (numeric attributes) or the mode (categorical attributes) both at build time and apply time.
  ODMS_MISSING_VALUE_MEAN_MODE  CONSTANT VARCHAR2(30) := 'ODMS_MISSING_VALUE_MEAN_MODE';
  -- You can set ODMS_MISSING_VALUE_TREATMENT to ODMS_MISSING_VALUE_DELETE_ROW to override this behavior in the training data.
  -- When ODMS_MISSING_VALUE_TREATMENT is set to ODMS_MISSING_VALUE_DELETE_ROW, the rows in the training data that contain missing values are deleted. However, if you want to replicate this missing value treatment in the scoring data, you must perform the transformation manually.
  -- The value ODMS_MISSING_VALUE_DELETE_ROW is only valid for tables without nested columns. If this value is used with nested data, an exception is raised.
  ODMS_MISSING_VALUE_DELETE_ROW CONSTANT VARCHAR2(30) := 'ODMS_MISSING_VALUE_DELETE_ROW';
  -- (GLM only) Name of a column in the training data that contains a weighting factor for the rows.
  -- Row weights can be used as a compact representation of repeated rows, as in the design of experiments where a specific configuration is repeated several times. Row weights can also be used to emphasize certain rows during model construction. For example, to bias the model towards rows that are more recent and away from potentially obsolete data.
  ODMS_ROW_WEIGHT_COLUMN_NAME   CONSTANT VARCHAR2(30) := 'ODMS_ROW_WEIGHT_COLUMN_NAME';
  PREP_AUTO                     CONSTANT VARCHAR2(30) := 'PREP_AUTO';

  -- activity level settings
  WORKFLOW_SETTING_TEST_MAPPING CONSTANT VARCHAR2(30) := 'WORKFLOW_SETTING_TEST_MAPPING'; -- Use activity level test data mapping:1 If not, use the test split data
  WORKFLOW_SETTING_SPLIT_PERC   CONSTANT VARCHAR2(30) := 'WORKFLOW_SETTING_SPLIT_PERC';   -- Build split percent, test percent = (1 - build split percent)

  -- build settings for classification models (performance balance option)
  BUILD_SETTING_PERFORM_OPTION  CONSTANT VARCHAR2(30) := 'BUILD_SETTING_PERFORM_OPTION';
    BUILD_SETTING_PERFORM_OP_AVG  CONSTANT VARCHAR2(30) := 'BUILD_SETTING_PERFORM_OP_AVG';
    BUILD_SETTING_PERFORM_OP_OVRL CONSTANT VARCHAR2(30) := 'BUILD_SETTING_PERFORM_OP_OVRL';
    BUILD_SETTING_PERFORM_OP_CUST CONSTANT VARCHAR2(30) := 'BUILD_SETTING_PERFORM_OP_CUST';
  -- internal use (cost benefit cost matrix source indicator)
  BUILD_SETTING_CSTBENFIT_OPTION  CONSTANT VARCHAR2(30) := 'BUILD_SETTING_CSTBENFIT_OPTION';
    BUILD_SETTING_CSTBNF_OP_NONE    CONSTANT VARCHAR2(30) := 'BUILD_SETTING_CSTBNF_OP_NONE';    -- no cost to use
    BUILD_SETTING_CSTBNF_OP_TRUE    CONSTANT VARCHAR2(30) := 'BUILD_SETTING_CSTBNF_OP_TRUE';    -- use true cost (user specified)
    BUILD_SETTING_CSTBNF_OP_TUNED   CONSTANT VARCHAR2(30) := 'BUILD_SETTING_CSTBNF_OP_TUNED';   -- use tuned cost (from ROC)
  BUILD_SETTING_NB_USE_PRIOR        CONSTANT VARCHAR2(30) := 'BUILD_SETTING_NB_USE_PRIOR';      -- Use Prior or not for NB build

  -- test settings
  TEST_SETTING_LIFT_QUANTILES   CONSTANT VARCHAR2(30) := 'TEST_SETTING_LIFT_QUANTILES';
  TEST_SETTING_USE_MAPPING      CONSTANT VARCHAR2(30) := 'TEST_SETTING_USE_MAPPING';  -- Use custom data mapping:2 If not, use the activity level test data mapping
  TEST_SETTING_USE_ARCHIVE      CONSTANT VARCHAR2(30) := 'TEST_SETTING_USE_ARCHIVE';  -- Archive test results:3
  -- test result tables (classification)
  PERFORM_METRICS_TABLE_NAME    CONSTANT VARCHAR2(30) := 'PERFORM_METRICS_TABLE_NAME';
  LIFT_RESULT_TABLE_NAME        CONSTANT VARCHAR2(30) := 'LIFT_RESULT_TABLE_NAME';
  ROC_RESULT_TABLE_NAME         CONSTANT VARCHAR2(30) := 'ROC_RESULT_TABLE_NAME';
  CONFUSION_MATRIX_TABLE_NAME   CONSTANT VARCHAR2(30) := 'CONFUSION_MATRIX_TABLE_NAME';
  ROC_RESULT_AREA_UNDER_CURVE   CONSTANT VARCHAR2(30) := 'ROC_RESULT_AREA_UNDER_CURVE';

  -- test result tables (regression)
  RESIDUAL_PLOT_TABLE_NAME      CONSTANT VARCHAR2(30) := 'RESIDUAL_PLOT_TABLE_NAME';

  -- apply settings
  APPLY_SETTING_USE_MAPPING       CONSTANT VARCHAR2(30) := 'APPLY_SETTING_USE_MAPPING';   -- Use custom data mapping:4 If not, use the activity level apply data mapping
  APPLY_SETTING_USE_ARCHIVE       CONSTANT VARCHAR2(30) := 'APPLY_SETTING_USE_ARCHIVE';   -- Archive apply results:5
  APPLY_SETTING_OPTION            CONSTANT VARCHAR2(30) := 'APPLY_SETTING_OPTION';        -- Apply option - top N, specific target values, etc
    APPLY_SETTING_OPTION_TOPN     CONSTANT VARCHAR2(30) := 'APPLY_SETTING_OPTION_TOPN';   -- Top N
    APPLY_SETTING_OPTION_TARGETS  CONSTANT VARCHAR2(30) := 'APPLY_SETTING_OPTION_TARGETS';-- Specific target values
  APPLY_SETTING_PROB_COL          CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PROB_COL';      -- Probability column name
  APPLY_SETTING_PRED_COL          CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PRED_COL';      -- Prediction column name
  APPLY_SETTING_RANK_COL          CONSTANT VARCHAR2(30) := 'APPLY_SETTING_RANK_COL';      -- Rank column name
  APPLY_SETTING_COST_COL          CONSTANT VARCHAR2(30) := 'APPLY_SETTING_COST_COL';      -- Cost column name
  APPLY_SETTING_NODE_COL          CONSTANT VARCHAR2(30) := 'APPLY_SETTING_NODE_COL';      -- Node column name
  APPLY_SETTING_CLUSTER_ID_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_CLUSTER_ID_COL';-- Cluster id column name
  APPLY_SETTING_FEATURE_ID_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_FEATURE_ID_COL';-- Feature id column name
  APPLY_SETTING_FEATURE_VAL_COL   CONSTANT VARCHAR2(30) := 'APPLY_SETTING_FEATURE_VAL_COL';-- Feature value column name
  APPLY_SETTING_PROB_LOWER_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PROB_LOWER_COL';-- Probability Lower Bound column name
  APPLY_SETTING_PROB_UPPER_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PROB_UPPER_COL';-- Probability Upper Bound column name
  APPLY_SETTING_PRED_LOWER_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PRED_LOWER_COL';-- Prediction Lower Bound column name
  APPLY_SETTING_PRED_UPPER_COL    CONSTANT VARCHAR2(30) := 'APPLY_SETTING_PRED_UPPER_COL';-- Prediction Upper Bound column name

  APPLY_SETTING_USE_SUPPL       CONSTANT VARCHAR2(30) := 'APPLY_SETTING_USE_SUPPL';     -- Use nodel level specific supplemental attributes:6 If not, use the activity level specific supplemental attributes
  -- apply result table
  APPLY_RESULT_TABLE_NAME       CONSTANT VARCHAR2(30) := 'APPLY_RESULT_TABLE_NAME';

  -- activity state
  WORKFLOW_STATUS_ACTIVE        CONSTANT VARCHAR2(30) := 'ACTIVE';      -- Workflow is being executed or scheduled to run
  WORKFLOW_STATUS_INACTIVE      CONSTANT VARCHAR2(30) := 'INACTIVE';    -- Workflow is idle
  WORKFLOW_STATUS_STOPPING      CONSTANT VARCHAR2(30) := 'STOPPING';    -- Workflow is being stopped
  WORKFLOW_STATUS_STOPPED       CONSTANT VARCHAR2(30) := 'STOPPED';     -- Workflow is stopped
  WORKFLOW_STATUS_QUEUED        CONSTANT VARCHAR2(30) := 'QUEUED';      -- Workflow is queued (waiting to be run)

  WORKFLOW_NODE_STATUS_INVAL    CONSTANT VARCHAR2(30) := 'Invalid';   -- not ready for execution
  WORKFLOW_NODE_STATUS_STALE    CONSTANT VARCHAR2(30) := 'Stale';     -- setting has been changed, data/result becomes stale
  WORKFLOW_NODE_STATUS_WARN     CONSTANT VARCHAR2(30) := 'Warning';   -- execution is complete but with warning
  WORKFLOW_NODE_STATUS_READY    CONSTANT VARCHAR2(30) := 'Ready';     -- ready for execution
  WORKFLOW_NODE_STATUS_FAIL     CONSTANT VARCHAR2(30) := 'Failure';   -- execution failed
  WORKFLOW_NODE_STATUS_DONE     CONSTANT VARCHAR2(30) := 'Complete';  -- execution succeed

  WORKFLOW_MODEL_STATUS_READY   CONSTANT VARCHAR2(30) := 'Ready';     -- model ready for build/rebuild
  WORKFLOW_MODEL_STATUS_FAIL    CONSTANT VARCHAR2(30) := 'Failure';   -- model build failed
  WORKFLOW_MODEL_STATUS_DONE    CONSTANT VARCHAR2(30) := 'Complete';  -- model build succeed
  WORKFLOW_MODEL_STATUS_WARN    CONSTANT VARCHAR2(30) := 'Warning';   -- execution is complete but with warning

  WORKFLOW_MODEL_R_STATUS_INVAL    CONSTANT VARCHAR2(30) := 'Invalid';   -- model ref invalid
  WORKFLOW_MODEL_R_STATUS_VALID    CONSTANT VARCHAR2(30) := 'Valid';   -- model ref valid

  WORKFLOW_ATTR_STATUS_VALID    CONSTANT VARCHAR2(30) := 'Valid';     -- valid attribute
  WORKFLOW_ATTR_STATUS_INVAL    CONSTANT VARCHAR2(30) := 'Invalid';   -- invalid attribute (e.g. datatype change)
  --WORKFLOW_ATTR_STATUS_MISSING  CONSTANT VARCHAR2(30) := 'Missing';   -- missing attribute

  -- activity chain job status level
  /*
  WORKFLOW_JOB_STATUS_WARN      CONSTANT VARCHAR2(5) := 'WARN';
  WORKFLOW_JOB_STATUS_ERR       CONSTANT VARCHAR2(5) := 'ERR';
  WORKFLOW_JOB_STATUS_INFO      CONSTANT VARCHAR2(5) := 'INFO';
  */
  -- constants in meta model
  WORKFLOW_DATA_TYPE_STR        CONSTANT VARCHAR2(30) := 'STRING';
  WORKFLOW_DATA_TYPE_NUM        CONSTANT VARCHAR2(30) := 'NUMBER';

  WORKFLOW_MINING_TYPE_CAT     CONSTANT VARCHAR2(30) := 'Categorical';
  WORKFLOW_MINING_TYPE_NUM     CONSTANT VARCHAR2(30) := 'Numerical';

  -- workflow nodel type
  WF_NODE_TYPE_DATASOURCE     CONSTANT VARCHAR2(30) := 'DataSource';
  WF_NODE_TYPE_CREATETABLE    CONSTANT VARCHAR2(30) := 'CreateTable';
  WF_NODE_TYPE_UPDATETABLE    CONSTANT VARCHAR2(30) := 'UpdateTable';
  WF_NODE_TYPE_DATAPROFILE    CONSTANT VARCHAR2(30) := 'DataProfile';
  WF_NODE_TYPE_TRANSFORMATION CONSTANT VARCHAR2(30) := 'Transformation';
  WF_NODE_TYPE_AGGREGATION    CONSTANT VARCHAR2(30) := 'Aggregation';
  WF_NODE_TYPE_JOIN           CONSTANT VARCHAR2(30) := 'Join';
  WF_NODE_TYPE_TEXT           CONSTANT VARCHAR2(30) := 'BuildTextRef';
  WF_NODE_TYPE_BUILDTEXT      CONSTANT VARCHAR2(30) := 'BuildText';
  WF_NODE_TYPE_APPLYTEXT      CONSTANT VARCHAR2(30) := 'ApplyText';
  WF_NODE_TYPE_SPLIT          CONSTANT VARCHAR2(30) := 'Split';
  WF_NODE_TYPE_SAMPLE         CONSTANT VARCHAR2(30) := 'Sample';
  WF_NODE_TYPE_COLUMNFILTER   CONSTANT VARCHAR2(30) := 'ColumnFilter';
  WF_NODE_TYPE_ROWFILTER      CONSTANT VARCHAR2(30) := 'RowFilter';
  WF_NODE_TYPE_CLASS_BUILD    CONSTANT VARCHAR2(30) := 'ClassificationBuild';
  WF_NODE_TYPE_REGRESS_BUILD  CONSTANT VARCHAR2(30) := 'RegressionBuild';
  WF_NODE_TYPE_CLUST_BUILD    CONSTANT VARCHAR2(30) := 'ClusteringBuild';
  WF_NODE_TYPE_ASSOC_BUILD    CONSTANT VARCHAR2(30) := 'AssociationBuild';
  WF_NODE_TYPE_FEATURE_BUILD  CONSTANT VARCHAR2(30) := 'FeatureExtractionBuild';
  WF_NODE_TYPE_ANOMALY_BUILD  CONSTANT VARCHAR2(30) := 'AnomalyDetectionBuild';
  WF_NODE_TYPE_MODEL          CONSTANT VARCHAR2(30) := 'Model';
  WF_NODE_TYPE_APPLY          CONSTANT VARCHAR2(30) := 'Apply';
  WF_NODE_TYPE_TEST           CONSTANT VARCHAR2(30) := 'Test';
  WF_NODE_TYPE_MODELDETAILS   CONSTANT VARCHAR2(30) := 'ModelDetails';
  WF_NODE_TYPE_TESTDETAILS    CONSTANT VARCHAR2(30) := 'TestDetails';
  WF_NODE_TYPE_FILTERDETAILS  CONSTANT VARCHAR2(30) := 'FilterDetails';
  -- system defined types
  WF_NODE_TYPE_STARTUP        CONSTANT VARCHAR2(30) := 'WF_START';
  WF_NODE_TYPE_CLEANUP        CONSTANT VARCHAR2(30) := 'WF_END';
  WF_NODE_TYPE_SUBFLOW_ENTER  CONSTANT VARCHAR2(30) := 'E';
  WF_NODE_TYPE_SUBFLOW_EXIT   CONSTANT VARCHAR2(30) := 'X';

  -- build node models
  WF_NODE_BUILD_NB            CONSTANT VARCHAR2(30) := 'NaiveBayesModel';
  WF_NODE_BUILD_DT            CONSTANT VARCHAR2(30) := 'DecisionTreeModel';
  WF_NODE_BUILD_SVMC          CONSTANT VARCHAR2(30) := 'CSupportVectorMachineModel';
  WF_NODE_BUILD_GLMC          CONSTANT VARCHAR2(30) := 'CGeneralizedLinearModel';
  WF_NODE_BUILD_SVMR          CONSTANT VARCHAR2(30) := 'RSupportVectorMachineModel';
  WF_NODE_BUILD_GLMR          CONSTANT VARCHAR2(30) := 'RGeneralizedLinearModel';
  WF_NODE_BUILD_OC            CONSTANT VARCHAR2(30) := 'OClusterModel';
  WF_NODE_BUILD_KM            CONSTANT VARCHAR2(30) := 'KMeansModel';
  WF_NODE_BUILD_AR            CONSTANT VARCHAR2(30) := 'AprioriModel';
  WF_NODE_BUILD_NMF           CONSTANT VARCHAR2(30) := 'NonNegativeMatrixFactorModel';
  WF_NODE_BUILD_AI            CONSTANT VARCHAR2(30) := 'MinimumDescriptionLengthModel';
  WF_NODE_BUILD_SVMO          CONSTANT VARCHAR2(30) := 'AnomalyDetectionModel';

  CACHE_SAMPLE_SIZE             CONSTANT VARCHAR2(30) := 'CACHE_SAMPLE_SIZE';     -- Cache data sample size

  --SAMPLE_ROW_COUNT         CONSTANT VARCHAR2(30) := 'SAMPLE_ROW_COUNT';
  MAX_TARGET_DISTINCT_COUNT  CONSTANT VARCHAR2(30) := 'MAX_TARGET_DISTINCT_COUNT';
  UNIQUE_PERCENTAGE          CONSTANT VARCHAR2(30) := 'UNIQUE_PERCENTAGE';
  MAX_DISTINCT_CAT_CUTOFF    CONSTANT VARCHAR2(30) := 'MAX_DISTINCT_CAT_CUTOFF';
  PERCENT_UNI_THRESHOLD_CAT  CONSTANT VARCHAR2(30) := 'PERCENT_UNI_THRESHOLD_CAT';
  CUTOFF_FOR_NUMBER_FOR_CAT  CONSTANT VARCHAR2(30) := 'CUTOFF_FOR_NUMBER_FOR_CAT';
  SPARSITY_CUTOFF            CONSTANT VARCHAR2(30) := 'SPARSITY_CUTOFF';
  --MAX_NUMERICAL_BIN        CONSTANT VARCHAR2(30) := 'MAX_NUMERICAL_BIN';
  --MAX_CATEGORICAL_BIN      CONSTANT VARCHAR2(30) := 'MAX_CATEGORICAL_BIN';
  MAX_DISTINCT_STRAT_SAMPLE  CONSTANT VARCHAR2(30) := 'MAX_DISTINCT_STRAT_SAMPLE';
  MAX_WORKFLOW_LOG_COUNT     CONSTANT VARCHAR2(30) := 'MAX_WORKFLOW_LOG_COUNT';  -- keep most recent 100000 workflow run log
  
  MAX_NUM_THREADS            CONSTANT VARCHAR2(30) := 'MAX_NUM_THREADS';
  WORKFLOW_JOB_CLASS         CONSTANT VARCHAR2(30) := 'WORKFLOW_JOB_CLASS';
END;
/
 
