
  CREATE OR REPLACE PACKAGE "ODMRSYS"."ODMR_MSG" 
AUTHID CURRENT_USER AS

  -- message level
  MSG_LEVEL_WARN      CONSTANT VARCHAR2(10) := 'WARN';
  MSG_LEVEL_ERR       CONSTANT VARCHAR2(10) := 'ERR';
  MSG_LEVEL_INFO      CONSTANT VARCHAR2(10) := 'INFO';

  MSG_LOG_TYPE_WARN          CONSTANT VARCHAR2(10) := 'WARN';
  MSG_LOG_TYPE_ERR           CONSTANT VARCHAR2(10) := 'ERR';
  MSG_LOG_TYPE_INFO          CONSTANT VARCHAR2(10) := 'INFO';

  MSG_LOG_SUBTYPE_START      CONSTANT VARCHAR2(10) := 'START';
  MSG_LOG_SUBTYPE_END        CONSTANT VARCHAR2(10) := 'END';

  MSG_LOG_TASK_WORKFLOW      CONSTANT VARCHAR2(30) := 'WORKFLOW';
  MSG_LOG_TASK_NODE          CONSTANT VARCHAR2(30) := 'NODE';
  MSG_LOG_TASK_SUBNODE       CONSTANT VARCHAR2(30) := 'SUBNODE';
  MSG_LOG_TASK_VALIDATE      CONSTANT VARCHAR2(30) := 'VALIDATE';
  MSG_LOG_TASK_SAMPLE        CONSTANT VARCHAR2(30) := 'SAMPLE';
  MSG_LOG_TASK_CACHE         CONSTANT VARCHAR2(30) := 'CACHE';
  MSG_LOG_TASK_STATISTICS    CONSTANT VARCHAR2(30) := 'STATISTICS';
  MSG_LOG_TASK_FEATURES      CONSTANT VARCHAR2(30) := 'FEATURES';
  MSG_LOG_TASK_DATAPREP      CONSTANT VARCHAR2(30) := 'DATAPREP';
  MSG_LOG_TASK_BUILD         CONSTANT VARCHAR2(30) := 'BUILD';
  MSG_LOG_TASK_TEST          CONSTANT VARCHAR2(30) := 'TEST';
  MSG_LOG_TASK_APPLY         CONSTANT VARCHAR2(30) := 'APPLY';
  MSG_LOG_TASK_TRANSFORM     CONSTANT VARCHAR2(30) := 'TRANSFORM';
  MSG_LOG_TASK_TEXT          CONSTANT VARCHAR2(30) := 'TEXT';
  MSG_LOG_TASK_BUILDTEXT     CONSTANT VARCHAR2(30) := 'BUILDTEXT';
  MSG_LOG_TASK_APPLYTEXT     CONSTANT VARCHAR2(30) := 'APPLYTEXT';
  MSG_LOG_TASK_OUTPUT        CONSTANT VARCHAR2(30) := 'OUTPUT';
  MSG_LOG_TASK_CLEANUP       CONSTANT VARCHAR2(30) := 'CLEANUP';

  -- Valid range of application error message codes are -20999 to -20000
  -- MSG_GEN prefix for Generic messages that can be used across many modules
  -- Range -20000 to -20100
  MSG_ERROR_CODE_START            CONSTANT NUMBER := -20000;
  MSG_GEN_OBJECT_NOT_EXISTS       CONSTANT NUMBER := -20001;
  MSG_GEN_OBJECT_EXISTS           CONSTANT NUMBER := -20002;
  MSG_GEN_OPERATION_FAIL          CONSTANT NUMBER := -20003;
  MSG_GEN_INVALID_INPUT           CONSTANT NUMBER := -20004;
--  MSG_GEN_INVALID_INPUT2          CONSTANT NUMBER := -20005;
  MSG_GEN_INPUT_DATA_EMPTY        CONSTANT NUMBER := -20005;
  MSG_GEN_OUTPUT_DATA_EMPTY       CONSTANT NUMBER := -20006;

  MSG_INVALID_COST_BENEFIT        CONSTANT NUMBER := -20007;
  MSG_TARGET_ONE_DISTINCT_VALUE   CONSTANT NUMBER := -20008;
  MSG_TARGET_EXCEED_DISTINCT_VAL  CONSTANT NUMBER := -20009;
  MSG_TARGET_ALL_DISTINCT_VALUE   CONSTANT NUMBER := -20010;
  MSG_TARGET_HAS_NULL_VALUE       CONSTANT NUMBER := -20011;
  MSG_TARGET_HAS_SPACE_VALUE      CONSTANT NUMBER := -20012;
  MSG_TARGET_HAS_ALL_NULL_VALUE   CONSTANT NUMBER := -20013;
  MSG_TARGET_INCOMP_WITH_BUILD    CONSTANT NUMBER := -20014;
  MSG_TARGET_VAL_INCOMP_W_MODEL   CONSTANT NUMBER := -20015;
  MSG_TARGET_INCOMP_DATATYPE      CONSTANT NUMBER := -20016;
  MSG_CASEID_NOT_UNIQUE           CONSTANT NUMBER := -20017;
  MSG_OBJECT_IS_MISSING           CONSTANT NUMBER := -20018;
  MSG_ITEM_VALUE_TOO_MANY_VALUES  CONSTANT NUMBER := -20019;
  MSG_TARGET_INCOMP_WITH_GLMC     CONSTANT NUMBER := -20020;
  MSG_GEN_INVALID_APPLY_ATTR      CONSTANT NUMBER := -20021;
  MSG_WORKFLOW_CANCEL             CONSTANT NUMBER := -20022;
  MSG_WORKFLOW_NOT_RUNNING        CONSTANT NUMBER := -20023;
  MSG_THEMES_NOT_GENERATED        CONSTANT NUMBER := -20024;
  MSG_NO_PREDICTOR_FOUND          CONSTANT NUMBER := -20025;
  MSG_COLUMN_INCOMP_DATATYPE      CONSTANT NUMBER := -20026;
  MSG_COLUMN_INCOMP_DATATYPE_EX   CONSTANT NUMBER := -20027;
  MSG_TEXT_TRANSFORM_OBJ_MISSING  CONSTANT NUMBER := -20028;
  MSG_PROJECT_DELETE_FAIL         CONSTANT NUMBER := -20029;
  MSG_TABLE_NOT_GRANTED_DIRECTLY  CONSTANT NUMBER := -20030;
  MSG_WORKFLOW_EXCEPTION          CONSTANT NUMBER := -20031;
  MSG_TARGET_INCOMP_DATATYPE_EX   CONSTANT NUMBER := -20032;
  MSG_TGT_INCOMP_NUM_DATATYPE     CONSTANT NUMBER := -20033;
  MSG_TGT_INCOMP_NUM_DATATYPE_EX  CONSTANT NUMBER := -20034;
  MSG_IMPORT_VERSION_INCOMP_ERR   CONSTANT NUMBER := -20035;

  MSG_DEBUG_MESSAGE               CONSTANT NUMBER := -20999;

  -- ID's of error message parameters
  PARAM_DATA_SOURCE               CONSTANT VARCHAR2(10) := 'ODMR_1000';
  PARAM_WORKFLOW                  CONSTANT VARCHAR2(10) := 'ODMR_1001';
  PARAM_QTILE_BINNING             CONSTANT VARCHAR2(10) := 'ODMR_1002';
  PARAM_NOT_ENOUGH_DATA           CONSTANT VARCHAR2(10) := 'ODMR_1003';
  PARAM_BINNING_VALIDATION        CONSTANT VARCHAR2(10) := 'ODMR_1004';
  PARAM_NOT_ENOUGH_DISTINCTS      CONSTANT VARCHAR2(10) := 'ODMR_1005';
  PARAM_DB_TABLE                  CONSTANT VARCHAR2(10) := 'ODMR_1006';
  PARAM_VALIDATION                CONSTANT VARCHAR2(10) := 'ODMR_1007';
  PARAM_MISSING_TABLE             CONSTANT VARCHAR2(10) := 'ODMR_1008';
  PARAM_ATTRIBUTE                 CONSTANT VARCHAR2(10) := 'ODMR_1009';
  PARAM_MISSING_ATTRIBUTES        CONSTANT VARCHAR2(10) := 'ODMR_1010';
  PARAM_AGGREGATION               CONSTANT VARCHAR2(10) := 'ODMR_1011';
  PARAM_UPDATE_TABLE              CONSTANT VARCHAR2(10) := 'ODMR_1012';
  PARAM_INCORRECT_INPUT           CONSTANT VARCHAR2(10) := 'ODMR_1013';
  PARAM_DB_VIEW                   CONSTANT VARCHAR2(10) := 'ODMR_1014';
  PARAM_CREATE_TABLE_OR_VIEW      CONSTANT VARCHAR2(10) := 'ODMR_1015';
  PARAM_EXPLORE_DATA              CONSTANT VARCHAR2(10) := 'ODMR_1016';
  PARAM_BUILD                     CONSTANT VARCHAR2(10) := 'ODMR_1017';
  PARAM_TEST                      CONSTANT VARCHAR2(10) := 'ODMR_1018';
  PARAM_INPUT_DATA_EMPTY          CONSTANT VARCHAR2(10) := 'ODMR_1019';
  PARAM_TARGET                    CONSTANT VARCHAR2(10) := 'ODMR_1020';
  PARAM_ATTRIBUTE_2               CONSTANT VARCHAR2(10) := 'ODMR_1021';
  PARAM_INCOMPATIBLE_ATTRIBUTE    CONSTANT VARCHAR2(10) := 'ODMR_1022';
  PARAM_MODEL                     CONSTANT VARCHAR2(10) := 'ODMR_1023';
  PARAM_MISSING_MODEL             CONSTANT VARCHAR2(10) := 'ODMR_1024';
  PARAM_GLM_TARGET_ERROR          CONSTANT VARCHAR2(10) := 'ODMR_1025';
  PARAM_INVALID_ITEM_VALUE_ATTR   CONSTANT VARCHAR2(10) := 'ODMR_1026';
  PARAM_MISSING_MODELS            CONSTANT VARCHAR2(10) := 'ODMR_1027';
  PARAM_APPLY                     CONSTANT VARCHAR2(10) := 'ODMR_1028';
  PARAM_NO_VALIDATION_PERFORMED   CONSTANT VARCHAR2(10) := 'ODMR_1029';
  PARAM_MODEL_DETAILS             CONSTANT VARCHAR2(10) := 'ODMR_1030';
  PARAM_TEST_DETAILS              CONSTANT VARCHAR2(10) := 'ODMR_1031';
  PARAM_FILTER_DETAILS            CONSTANT VARCHAR2(10) := 'ODMR_1032';
  PARAM_FEATURES_TABLE            CONSTANT VARCHAR2(10) := 'ODMR_1033';
  PARAM_FEATURES_POLICY           CONSTANT VARCHAR2(10) := 'ODMR_1034';
  PARAM_LEXER                     CONSTANT VARCHAR2(10) := 'ODMR_1035';
  PARAM_STOPLIST                  CONSTANT VARCHAR2(10) := 'ODMR_1036';
  PARAM_INCOMPATIBLE_CASEID_ATTR  CONSTANT VARCHAR2(10) := 'ODMR_1037';
  PARAM_TABLE_COLUMN              CONSTANT VARCHAR2(10) := 'ODMR_1038';
  PARAM_INCOMPATIBLE_COLUMN_ATTR  CONSTANT VARCHAR2(10) := 'ODMR_1039';
  PARAM_JOIN                      CONSTANT VARCHAR2(10) := 'ODMR_1040';
  PARAM_TEXT                      CONSTANT VARCHAR2(10) := 'ODMR_1041';
  PARAM_SPLIT                     CONSTANT VARCHAR2(10) := 'ODMR_1042';
  PARAM_COLUMN                    CONSTANT VARCHAR2(10) := 'ODMR_1043';
  PARAM_SAMPLE                    CONSTANT VARCHAR2(10) := 'ODMR_1044';
  PARAM_COLUMN_FILTER             CONSTANT VARCHAR2(10) := 'ODMR_1045';
  PARAM_ROW_FILTER                CONSTANT VARCHAR2(10) := 'ODMR_1046';
  PARAM_TRANSFORMATION            CONSTANT VARCHAR2(10) := 'ODMR_1047';
  PARAM_WORKFLOW_SAVE             CONSTANT VARCHAR2(10) := 'ODMR_1048';
  PARAM_WORKFLOW_NOT_LOCKED       CONSTANT VARCHAR2(10) := 'ODMR_1049';
  PARAM_WORKFLOW_RUN              CONSTANT VARCHAR2(10) := 'ODMR_1050';
  PARAM_WORKFLOW_RUNNING          CONSTANT VARCHAR2(10) := 'ODMR_1051';
  PARAM_WORKFLOW_IN_USE           CONSTANT VARCHAR2(10) := 'ODMR_1052';
  PARAM_WORKFLOW_DELETE           CONSTANT VARCHAR2(10) := 'ODMR_1053';
  PARAM_WFNODE_REGRESS_BUILD      CONSTANT VARCHAR2(10) := 'ODMR_1054';  
  PARAM_WFNODE_CLASS_BUILD        CONSTANT VARCHAR2(10) := 'ODMR_1055';  
  PARAM_BUILD_TEXT                CONSTANT VARCHAR2(10) := 'ODMR_1056';   
  PARAM_APPLY_TEXT                CONSTANT VARCHAR2(10) := 'ODMR_1057';   
  PARAM_BUILD_TEXT_REF            CONSTANT VARCHAR2(10) := 'ODMR_1058';   
  PARAM_ITEM_VALUE                CONSTANT VARCHAR2(10) := 'ODMR_1059';   
  PARAM_PROJECT                   CONSTANT VARCHAR2(10) := 'ODMR_1060';   
  PARAM_WORKFLOW_RENAME           CONSTANT VARCHAR2(10) := 'ODMR_1061';
  PARAM_WORKFLOW_DEF_INVALID      CONSTANT VARCHAR2(10) := 'ODMR_1062';

  PARAM_SUBTYPE_START             CONSTANT VARCHAR2(10) := 'ODMR_1063';
  PARAM_SUBTYPE_END               CONSTANT VARCHAR2(10) := 'ODMR_1064';
  PARAM_LOG_TASK_WORKFLOW         CONSTANT VARCHAR2(10) := 'ODMR_1065';
  PARAM_LOG_TASK_NODE             CONSTANT VARCHAR2(10) := 'ODMR_1066';
  PARAM_LOG_TASK_SUBNODE          CONSTANT VARCHAR2(10) := 'ODMR_1067';
  PARAM_LOG_TASK_VALIDATE         CONSTANT VARCHAR2(10) := 'ODMR_1068';
  PARAM_LOG_TASK_SAMPLE           CONSTANT VARCHAR2(10) := 'ODMR_1069';
  PARAM_LOG_TASK_CACHE            CONSTANT VARCHAR2(10) := 'ODMR_1070';
  PARAM_LOG_TASK_STATISTICS       CONSTANT VARCHAR2(10) := 'ODMR_1071';
  PARAM_LOG_TASK_FEATURES         CONSTANT VARCHAR2(10) := 'ODMR_1072';
  PARAM_LOG_TASK_DATAPREP         CONSTANT VARCHAR2(10) := 'ODMR_1073';
  PARAM_LOG_TASK_BUILD            CONSTANT VARCHAR2(10) := 'ODMR_1074';
  PARAM_LOG_TASK_TEST             CONSTANT VARCHAR2(10) := 'ODMR_1075';
  PARAM_LOG_TASK_APPLY            CONSTANT VARCHAR2(10) := 'ODMR_1076';
  PARAM_LOG_TASK_TRANSFORM        CONSTANT VARCHAR2(10) := 'ODMR_1077';
  PARAM_LOG_TASK_TEXT             CONSTANT VARCHAR2(10) := 'ODMR_1078';
  PARAM_LOG_TASK_BUILDTEXT        CONSTANT VARCHAR2(10) := 'ODMR_1079';
  PARAM_LOG_TASK_APPLYTEXT        CONSTANT VARCHAR2(10) := 'ODMR_1080';
  PARAM_LOG_TASK_OUTPUT           CONSTANT VARCHAR2(10) := 'ODMR_1081';
  PARAM_LOG_TASK_CLEANUP          CONSTANT VARCHAR2(10) := 'ODMR_1082';
  
  
/* --------------------------------------------------------------------------- */
  -- Temporarily we will use the following structure to define the
  -- messages associated with the constants. Later we may have to
  -- define an error message table that will have these messages
  TYPE MSG_ASSOCIATIVE_ARRAY IS TABLE OF VARCHAR2(4000) index by binary_integer;

--  ERR_MSG MSG_ASSOCIATIVE_ARRAY;

  -- Keeps currents db session locale
  DEF_LANG_ID                     CONSTANT VARCHAR2(20) := 'am';

  LANGUAGE_ID                     VARCHAR2(400);

  FUNCTION MAP_LANGUAGE(p_language VARCHAR2 ) RETURN VARCHAR2;
  FUNCTION TRANSLATION_MESSAGE_LOOKUP ( p_message_id NUMBER ) RETURN NVARCHAR2;
  FUNCTION TRANSLATION_PARAM_LOOKUP ( p_param_id VARCHAR2 ) RETURN NVARCHAR2;

END ODMR_MSG;
/
