/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.db.DBUtil;

public class RollbackSkippedChangeVisitor
implements ChangeSetVisitor,
SkippedChangeSetVisitor {
    private final LinkedHashMap<ChangeSet, ChangeSetStatus> changeSetStatuses = new LinkedHashMap();
    private final List<RanChangeSet> ranChangeSets;

    public RollbackSkippedChangeVisitor(Database database) throws DatabaseException {
        this.ranChangeSets = new ArrayList<RanChangeSet>(ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getRanChangeSets());
    }

    protected ChangeSetStatus addStatus(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) throws LiquibaseException {
        ChangeSetStatus status = new ChangeSetStatus(changeSet);
        RanChangeSet ranChangeSetToRemove = null;
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.isSameAs(changeSet)) continue;
            status.setPreviouslyRan(true);
            status.setDateLastExecuted(ranChangeSet.getDateExecuted());
            status.setStoredCheckSum(ranChangeSet.getLastCheckSum());
            status.setRanChangeSet(ranChangeSet);
            ranChangeSetToRemove = ranChangeSet;
            break;
        }
        if (ranChangeSetToRemove != null) {
            this.ranChangeSets.remove(ranChangeSetToRemove);
        }
        this.changeSetStatuses.put(changeSet, status);
        return status;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.REVERSE;
    }

    public void skipped(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        if (RollbackSkippedChangeVisitor.setSkip(changeSet.getId(), database)) {
            changeSet.setIgnore(true);
            ChangeSetStatus status = this.addStatus(changeSet, databaseChangeLog, database);
            status.setWillRun(false);
            status.setFilterResults(filterResults);
            try {
                ((JdbcConnection)database.getConnection()).getUnderlyingConnection().commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
    }

    public static boolean setSkip(String id, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("ID", id);
        int rows = dbUtil.executeUpdate("delete databasechangelog_actions WHERE ID = :ID and to_char(sql) = '--skipped'", binds);
        if (rows == 1) {
            return true;
        }
        try {
            ((JdbcConnection)database.getConnection()).getUnderlyingConnection().rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }
}

