/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.io.BufferedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exception.PropertyNotFoundException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SqlclConfig {
    private BufferedOutputStream outputBuffer = null;
    private ArrayList<String> errorList = new ArrayList();
    private boolean createActionTable = true;
    private final List<String> parameters = Arrays.asList("help", "command", "changelog", "filter", "object", "type", "name", "filename", "emit_schema", "label", "context", "count", "url", "user", "password", "dir", "silent", "split", "report", "debug", "enable", "privs", "synonyms", "grants", "log", "fail", "replace", "runonchange", "runalways", "sql", "action", "date", "tag", "dbChangeLogTable", "isSqlCl");
    private ScriptRunnerContext SQLCL_CONTEXT = new ScriptRunnerContext();
    private final String LB_PARMS = "LB_PARMS";
    private final String APEX_PARMS = "APEX_PARMS";
    public String CONTROLLER_NAME = "controller";
    public String SCREEN_NAME = "screenoutput.log";
    public String LOG_NAME = "logoutput.log";
    public String DIFF_XML = "diffResult.txt";
    public String DIFF_TXT = "diffReport.txt";

    public SqlclConfig() {
        this.resetAllParms();
    }

    public void addApexParameter(String value) {
        if (this.SQLCL_CONTEXT == null) {
            return;
        }
        ((ArrayList)this.SQLCL_CONTEXT.getProperty("APEX_PARMS")).add(value);
    }

    public void addError(String value) {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
        }
        this.errorList.add(value);
    }

    public ArrayList<String> getAllErrors() {
        return this.errorList;
    }

    public ArrayList<String> getApexParms() {
        if (this.SQLCL_CONTEXT == null) {
            return null;
        }
        return (ArrayList)this.SQLCL_CONTEXT.getProperty("APEX_PARMS");
    }

    public ScriptRunnerContext getContext() {
        return this.SQLCL_CONTEXT;
    }

    public String getControllerFileName() {
        return this.CONTROLLER_NAME;
    }

    public boolean getCreateActionTable() {
        return this.createActionTable;
    }

    public String getDiffFileName(boolean xml) {
        if (xml) {
            return this.DIFF_XML;
        }
        return this.DIFF_TXT;
    }

    public String getLbParameter(String name) {
        return (String)((HashMap)this.SQLCL_CONTEXT.getProperty("LB_PARMS")).get(name);
    }

    public HashMap<String, String> getLbParms() {
        if (this.SQLCL_CONTEXT == null) {
            return null;
        }
        return (HashMap)this.SQLCL_CONTEXT.getProperty("LB_PARMS");
    }

    public String getLogFileName() {
        return this.LOG_NAME;
    }

    public BufferedOutputStream getOutputBuffer() {
        return this.outputBuffer;
    }

    public String getScreenFileName() {
        return this.SCREEN_NAME;
    }

    public void resetAllParms() {
        this.resetApexParms();
        this.resetLbParms();
    }

    public void resetApexParms() {
        ArrayList<String> _parms = new ArrayList<String>();
        _parms.clear();
        try {
            this.setApexParms(_parms);
        }
        catch (ProcessFailedException e) {
            this.setContext(new ScriptRunnerContext());
            try {
                this.setApexParms(_parms);
            }
            catch (ProcessFailedException processFailedException) {
                // empty catch block
            }
        }
    }

    public void resetErrorList() {
        this.errorList = new ArrayList();
    }

    public void resetLbParms() {
        HashMap<String, String> _parms = new HashMap<String, String>();
        _parms.clear();
        _parms.put("emit_schema", "false");
        _parms.put("silent", "false");
        _parms.put("report", "true");
        _parms.put("debug", "false");
        _parms.put("enable", "true");
        _parms.put("privs", "true");
        _parms.put("synonyms", "false");
        _parms.put("grants", "false");
        _parms.put("log", "false");
        _parms.put("fail", "false");
        _parms.put("replace", "false");
        _parms.put("runonchange", "false");
        _parms.put("runalways", "false");
        _parms.put("help", "");
        _parms.put("changelog", "");
        _parms.put("dir", "");
        _parms.put("type", "");
        _parms.put("name", "");
        _parms.put("label", "");
        _parms.put("context", "");
        _parms.put("count", "");
        _parms.put("url", "");
        _parms.put("user", "");
        _parms.put("password", "");
        _parms.put("name", "");
        _parms.put("isSqlCl", "true");
        _parms.put("help", "false");
        _parms.put("command", "");
        _parms.put("sql", "false");
        _parms.put("date", "");
        _parms.put("tag", "");
        try {
            this.setLbParms(_parms);
        }
        catch (ProcessFailedException e) {
            this.setContext(new ScriptRunnerContext());
            try {
                this.setLbParms(_parms);
            }
            catch (ProcessFailedException processFailedException) {
                // empty catch block
            }
        }
    }

    public void setApexParms(ArrayList<String> parms) throws ProcessFailedException {
        if (this.SQLCL_CONTEXT == null) {
            throw new ProcessFailedException(null, "No context saved in configuration");
        }
        this.SQLCL_CONTEXT.putProperty("APEX_PARMS", parms);
    }

    public SqlclConfig setContext(ScriptRunnerContext ctx) {
        this.SQLCL_CONTEXT = ctx;
        return this;
    }

    public void setControllerFileName(String value) {
        this.CONTROLLER_NAME = value;
    }

    public void setCreateActionTable(boolean createActionTable) {
        this.createActionTable = createActionTable;
    }

    public void setDiffFileName(String value, boolean xml) {
        if (xml) {
            this.DIFF_XML = value;
        } else {
            this.DIFF_TXT = value;
        }
    }

    public void setLbParameter(String name, String value) throws PropertyNotFoundException, ProcessFailedException {
        if (this.SQLCL_CONTEXT == null) {
            throw new ProcessFailedException(null, "No context saved in configuration");
        }
        if (!this.parameters.contains(name)) {
            throw new PropertyNotFoundException("Unknown Liquibase parameter " + name + " supplied can not store it.");
        }
        ((HashMap)this.SQLCL_CONTEXT.getProperty("LB_PARMS")).put(name, value);
    }

    public void setLbParms(HashMap<String, String> parms) throws ProcessFailedException {
        if (this.SQLCL_CONTEXT == null) {
            throw new ProcessFailedException(null, "No context saved in configuration");
        }
        this.SQLCL_CONTEXT.putProperty("LB_PARMS", parms);
    }

    public void setLogFileName(String value) {
        this.LOG_NAME = value;
    }

    public void setOutputBuffer(BufferedOutputStream buffer) {
        this.outputBuffer = buffer;
    }

    public void setScreenFileName(String value) {
        this.SCREEN_NAME = value;
    }
}

