/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.ext.ora.statement.DropCommentStatement;
import liquibase.ext.ora.statement.RollbackOraclePlSqlStatement;
import liquibase.ext.ora.statement.RollbackOracleSxmlStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exception.PropertyNotFoundException;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;

public class SqlClExecutor
extends JdbcExecutor {
    public void execute(SqlStatement stmt, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (stmt instanceof AbstractOracleStatement) {
            LiquibaseActions.log("Executing with the 'SqlCl-jdbc' executor", ((Object)((Object)this)).getClass());
            Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(stmt, this.database);
            if (sqls == null) {
                LiquibaseActions.report("No SQL to execute object not changed.", ((Object)((Object)this)).getClass());
                return;
            }
            for (Sql sql : sqls) {
                if (sql == null) {
                    LiquibaseActions.report("No SQL to execute object not changed.", ((Object)((Object)this)).getClass());
                    continue;
                }
                LiquibaseActions.log(sql.toSql(), ((Object)((Object)this)).getClass());
                ActionLogTableManager tm = new ActionLogTableManager(this.database);
                try {
                    String testString = null;
                    try {
                        testString = sql.toString().substring(0, tm.addLogRecordComment.length());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tm.addLogRecordComment.equals(testString) || tm.delLogRecordComment.equals(testString)) {
                        QueryUtils.runSqlReturnResult(sql.toSql(), ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), false);
                        LiquibaseActions.report(tm.LogActionSuccessMessage, ((Object)((Object)this)).getClass());
                        continue;
                    }
                    if (stmt instanceof DropCommentStatement) {
                        String result = QueryUtils.runSqlReturnResult(sql.toSql(), ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), false);
                        LiquibaseActions.report(result.replaceAll("created", "dropped"), ((Object)((Object)this)).getClass());
                        continue;
                    }
                    LiquibaseActions.report(QueryUtils.runSqlReturnResult(sql.toSql(), ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), false), ((Object)((Object)this)).getClass());
                }
                catch (Exception e) {
                    LiquibaseActions.report(e, ((Object)((Object)this)).getClass(), ((AbstractOracleStatement)stmt).getFile());
                    errors.add(e);
                }
            }
            if (errors.size() > 0 && !"rollback".equals(LiquibaseActions.getLbParameter("action"))) {
                if (stmt instanceof RunOracleScriptStatement) {
                    LiquibaseActions.report("Unable to rollback Scripts automatically, taking no action.", ((Object)((Object)this)).getClass());
                    throw new DatabaseException("");
                }
                ((JdbcConnection)this.database.getConnection()).commit();
                LiquibaseActions.report("Rolling back changeset.", ((Object)((Object)this)).getClass());
                LiquibaseActions.log("ChangeSet failed rolling back.", ((Object)((Object)this)).getClass());
                ActionLogTableManager tm = new ActionLogTableManager(this.database);
                try {
                    AbstractOracleStatement rec = (AbstractOracleStatement)stmt;
                    String origObject = tm.getActionFromActionLog(rec.getId(), rec.getAuthor(), rec.getFile());
                    rec.setSource(origObject);
                    String origAction = LiquibaseActions.getLbParameter("action");
                    LiquibaseActions.setLbParameter("action", "rollback");
                    if (stmt instanceof AbstractCommonPlSqlStatement) {
                        this.execute((SqlStatement)new RollbackOraclePlSqlStatement(rec), null);
                    } else {
                        this.execute((SqlStatement)new RollbackOracleSxmlStatement(rec), null);
                    }
                    LiquibaseActions.setLbParameter("action", origAction);
                    ((JdbcConnection)this.database.getConnection()).commit();
                }
                catch (ProcessFailedException e) {
                    LiquibaseActions.report(e, ((Object)((Object)this)).getClass(), ((AbstractOracleStatement)stmt).getFile());
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
                throw new DatabaseException("");
            }
        } else {
            super.execute(stmt, sqlVisitors);
        }
    }

    public String getName() {
        return "jdbc";
    }

    public int getPriority() {
        return 999;
    }
}

