/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.generator.MetadataSqlGenerator;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public abstract class AbstractCommonPlSqlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonPlSqlStatement> {
    public abstract ACTIONS createOrDrop();

    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        String actionLogging;
        if (!(database instanceof OracleDatabase)) {
            return null;
        }
        Sql[] sqls = null;
        sqls = ACTIONS.CREATE.equals((Object)this.createOrDrop()) ? MetadataSqlGenerator.getCreateSqlPlSql(statement, database) : MetadataSqlGenerator.getDropSqlPlSql(statement, database);
        if (sqls == null) {
            return null;
        }
        try {
            ActionLogTableManager tm = new ActionLogTableManager(database);
            actionLogging = tm.getActionLogSql((SqlStatement)statement, sqls[0].toSql());
        }
        catch (DatabaseException e) {
            return null;
        }
        if (actionLogging != null && !actionLogging.trim().isEmpty()) {
            sqls = Arrays.copyOf(sqls, sqls.length + 1);
            sqls[sqls.length - 1] = new UnparsedSql(actionLogging, new DatabaseObject[0]);
        }
        return sqls;
    }

    public abstract boolean supports(AbstractCommonPlSqlStatement var1, Database var2);

    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        if (statement instanceof AbstractCommonPlSqlStatement && ((Object)((Object)statement)).getClass().getSimpleName().startsWith("Create")) {
            validationErrors.checkRequiredField("source", (Object)statement.getSource());
        }
        if (statement instanceof RunOracleScriptStatement) {
            if (statement.getSourceType() != null && "STRING".equals(statement.getSourceType().toUpperCase())) {
                validationErrors.checkRequiredField("source", (Object)statement.getSource());
            } else if (statement.getSourceType() != null && "FILE".equals(statement.getSourceType().toUpperCase())) {
                Path cwd = null;
                Path path = null;
                try {
                    cwd = Paths.get(FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext()), new String[0]).toAbsolutePath();
                    path = cwd.resolve(statement.getSource());
                    new String(Files.readAllBytes(path));
                }
                catch (Exception e) {
                    if (LiquibaseActions.getBoolenParameter("debug")) {
                        LiquibaseActions.getContext().write("cwd      - " + cwd.toString() + "\n");
                        LiquibaseActions.getContext().write("relative - " + path.toString() + "\n");
                        e.printStackTrace();
                    }
                    validationErrors.addError("generateSql unable to find and load file, check paths");
                }
            } else if (statement.getSourceType() != null && "URL".equals(statement.getSourceType().toUpperCase())) {
                URL url = null;
                URI uri = null;
                URL fileURL = null;
                try {
                    url = new URL(statement.getSource());
                    uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    fileURL = uri.toURL();
                    BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                    in.close();
                }
                catch (Exception e) {
                    validationErrors.addError("generateSql unable to find and load file, check urls");
                }
            } else {
                validationErrors.addError("Invalid source type :" + statement.getSourceType());
            }
        }
        return validationErrors;
    }

    protected static enum ACTIONS {
        CREATE,
        DROP;

    }
}

