/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.ext.ora.generator.AbstractCommonPlSqlGenerator;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class RunOracleScriptGenerator
extends AbstractCommonPlSqlGenerator<AbstractCommonPlSqlStatement> {
    @Override
    public AbstractCommonPlSqlGenerator.ACTIONS createOrDrop() {
        return null;
    }

    @Override
    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder();
        if ("STRING".equals(statement.getSourceType().toUpperCase())) {
            sql.append(statement.getSource());
        } else if ("FILE".equals(statement.getSourceType().toUpperCase())) {
            String content = "";
            Path cwd = null;
            Path path = null;
            try {
                cwd = Paths.get(FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext()), new String[0]).toAbsolutePath();
                path = cwd.resolve(statement.getSource());
                content = new String(Files.readAllBytes(path));
            }
            catch (Exception e) {
                LiquibaseActions.log(e, LiquibaseActions.class);
                return null;
            }
            sql.append(content);
        } else if ("URL".equals(statement.getSourceType().toUpperCase())) {
            URL url = null;
            URI uri = null;
            URL fileURL = null;
            try {
                String inputLine;
                url = new URL(statement.getSource());
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                fileURL = uri.toURL();
                BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    sql.append(inputLine);
                }
                in.close();
            }
            catch (Exception e) {
                LiquibaseActions.log(e, LiquibaseActions.class);
                return null;
            }
        }
        String outSql = null;
        outSql = !LiquibaseActions.getBoolenParameter("emit_schema") ? sql.toString().replaceAll("\"" + statement.getOwnerName() + "\"[.]", "") : sql.toString();
        if (outSql.endsWith("/\n") || outSql.endsWith("/")) {
            outSql = outSql.replaceAll("/\n$", "");
            outSql = outSql.replaceAll("/$", "");
        }
        return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
    }

    @Override
    public boolean supports(AbstractCommonPlSqlStatement statement, Database database) {
        return database instanceof OracleDatabase && statement instanceof RunOracleScriptStatement;
    }
}

