/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.actionlogging;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.ora.change.CreateOracleSxmlChange;
import liquibase.ext.ora.change.CreateTriggerChange;
import liquibase.ext.ora.change.RunOracleScriptChange;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.core.Messages;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ActionLogTableManager {
    public String delLogRecordComment = "delete from %DATABASECHANGELOG%_ACTIONS where id =";
    public String addLogRecordComment = "-- Logging Oracle Liquibase extension actions to";
    public String LogActionSuccessMessage = "Action logged sucessfully.";
    private String LogTriggerSource = "--create log table trigger\nCREATE OR REPLACE TRIGGER %DATABASECHANGELOG%_ACTIONS_TRG BEFORE\r\n    INSERT ON %DATABASECHANGELOG%_ACTIONS\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        %DATABASECHANGELOG%_ACTIONS\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n";
    private String LogViewsource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n   <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>%DATABASECHANGELOG%_DETAILS</NAME>\r\n   <COL_LIST>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DEPLOYMENT_ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>ID</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>AUTHOR</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>FILENAME</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SQL</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>SXML</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DATEEXECUTED</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>EXECTYPE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>MD5SUM</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>DESCRIPTION</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>COMMENTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LIQUIBASE</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>CONTEXTS</NAME>\r\n      </COL_LIST_ITEM>\r\n      <COL_LIST_ITEM>\r\n         <NAME>LABELS</NAME>\r\n      </COL_LIST_ITEM>\r\n   </COL_LIST>\r\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \r\nFROM %DATABASECHANGELOG% d  LEFT JOIN %DATABASECHANGELOG%_ACTIONS da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\r\n</VIEW>";
    private String MergeSql = "MERGE INTO %DATABASECHANGELOG%_ACTIONS tt\r\nUSING %DATABASECHANGELOG% st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,\r\n    tt.filename = st.filename;";
    private String LogTableSource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>%DATABASECHANGELOG%_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n   </RELATIONAL_TABLE>\r\n</TABLE>";
    private String PkSql = "ALTER TABLE %DATABASECHANGELOG%_ACTIONS ADD PRIMARY KEY (id,author,filename,sequence);";
    private final CreateOracleSxmlChange CreateorUpdateLogTableChange = new CreateOracleSxmlChange();
    private final CreateTriggerChange CreateorUpdateLogTableTriggerChange = new CreateTriggerChange();
    private final RunOracleScriptChange UpdateLogDataChange = new RunOracleScriptChange();
    private final RunOracleScriptChange CreatePkChange = new RunOracleScriptChange();
    private final CreateOracleSxmlChange CreateorUpdateLogViewChange = new CreateOracleSxmlChange();
    private Database database = null;

    public ActionLogTableManager(Database database) {
        this.database = database;
        this.delLogRecordComment = this.delLogRecordComment.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.addLogRecordComment = this.addLogRecordComment.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogTriggerSource = this.LogTriggerSource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogViewsource = this.LogViewsource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.MergeSql = this.MergeSql.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogTableSource = this.LogTableSource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.PkSql = this.PkSql.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.CreateorUpdateLogTableChange.setSource(this.LogTableSource);
        this.CreateorUpdateLogTableChange.setObjectName("%DATABASECHANGELOG%_ACTIONS".replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName()));
        this.CreateorUpdateLogTableChange.setObjectType("TABLE");
        this.CreateorUpdateLogTableTriggerChange.setSource(this.LogTriggerSource);
        this.CreateorUpdateLogTableTriggerChange.setObjectType("TRIGGER");
        this.CreateorUpdateLogTableTriggerChange.setObjectName("%DATABASECHANGELOG%_ACTIONS_TRG".replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName()));
        this.CreateorUpdateLogViewChange.setSource(this.LogViewsource);
        this.CreateorUpdateLogViewChange.setObjectName("%DATABASECHANGELOG%_DETAILS".replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName()));
        this.CreateorUpdateLogViewChange.setObjectType("VIEW");
        this.UpdateLogDataChange.setSource(this.MergeSql);
        this.UpdateLogDataChange.setSourceType("STRING");
        this.CreatePkChange.setSource(this.PkSql);
        this.CreatePkChange.setSourceType("STRING");
    }

    public void createLogView(Connection con, ScriptRunnerContext ctx) {
        Sql[] sql = null;
        String sqlToRun = null;
        try {
            sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogViewChange, this.database);
            sqlToRun = sql[0].toSql();
            QueryUtils.runSqlReturnResult(sqlToRun, con);
        }
        catch (Exception e) {
            LiquibaseActions.log(e, ActionLogTableManager.class);
            Scope.getCurrentScope().getUI().sendMessage(MessageFormat.format(Messages.getString("BAD_VIEW_PERMISSION"), e.getMessage()));
        }
    }

    public void createUpdateLogTable() throws DatabaseException, ProcessFailedException {
        block16: {
            Connection con = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
            Sql[] sql = null;
            boolean create = false;
            String sqlToRun = null;
            try {
                if (!LiquibaseActions.getConfig().getCreateActionTable()) break block16;
                DBUtil dbUtil = DBUtil.getInstance((Connection)con);
                String cols = dbUtil.executeReturnOneCol("select count(*) from user_tab_columns where table_name='%DATABASECHANGELOG%_ACTIONS' ".replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName()));
                if (cols != null && Integer.parseInt(cols) == 7) {
                    LiquibaseActions.getConfig().setCreateActionTable(false);
                    return;
                }
                create = Integer.parseInt(cols) == 0;
                Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
                if (exec instanceof LoggingExecutor) {
                    exec.execute((Change)this.CreateorUpdateLogTableChange);
                    if (!create) {
                        exec.execute((Change)this.UpdateLogDataChange);
                    }
                    exec.execute((Change)this.CreatePkChange);
                    exec.execute((Change)this.CreateorUpdateLogTableTriggerChange);
                    exec.execute((Change)this.CreateorUpdateLogViewChange);
                } else {
                    sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogTableChange, this.database);
                    if (sql.length == 0) {
                        throw new DatabaseException(Messages.getString("BAD_PERMISSION"));
                    }
                    sqlToRun = sql[0].toSql();
                    QueryUtils.runSqlReturnResult(sqlToRun, con);
                    if (!create) {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.UpdateLogDataChange, this.database);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    try {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreatePkChange, this.database);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    catch (Exception e) {
                        try {
                            QueryUtils.runSqlReturnResult("drop table %DATABASECHANGELOG%_ACTIONS".replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName()), con);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw e;
                    }
                    try {
                        sql = SqlGeneratorFactory.getInstance().generateSql((Change)this.CreateorUpdateLogTableTriggerChange, this.database);
                        sqlToRun = sql[0].toSql();
                        QueryUtils.runSqlReturnResult(sqlToRun, con);
                    }
                    catch (Exception e) {
                        try {
                            QueryUtils.runSqlReturnResult("drop table %DATABASECHANGELOG%_ACTIONS".replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName()), con);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
                    }
                }
                LiquibaseActions.getConfig().setCreateActionTable(false);
            }
            catch (DatabaseException e) {
                LiquibaseActions.log((Exception)((Object)e), ActionLogTableManager.class);
                throw e;
            }
        }
    }

    public String getActionFromActionLog(String changeId, String author, String filename) throws ProcessFailedException {
        Connection conn = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            this.createUpdateLogTable();
            stmt = conn.prepareStatement(actionLogSxmlQuery);
            stmt.setString(1, changeId);
            stmt.setString(2, author);
            stmt.setString(3, filename);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Clob sxml = rs.getClob(1);
                if (sxml == null) {
                    String string = null;
                    return string;
                }
                sb.append(LiquibaseStringUtils.clobToString(sxml));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, ActionLogTableManager.class);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
            }
        }
    }

    public String getActionLogSql(SqlStatement statement, String sqltorun) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        if (!(statement instanceof AbstractOracleStatement)) {
            return null;
        }
        if ("rollback".equals(LiquibaseActions.getLbParameter("action"))) {
            AbstractOracleStatement st = (AbstractOracleStatement)statement;
            sb.append(this.genRollbackActionLogging(st.getId(), st.getAuthor(), st.getFile()));
        } else if ("update".equals(LiquibaseActions.getLbParameter("action"))) {
            AbstractOracleStatement st = (AbstractOracleStatement)statement;
            sb.append(this.genActionLoggingSql(st.getId(), st.getAuthor(), st.getFile(), sqltorun, DbmsMetaUtils.getObjectFromDb(((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), st.getObjectType(), st.getObjectName())));
        } else {
            throw new DatabaseException("getActionLog unknown workflow path");
        }
        return sb.toString();
    }

    private String genActionLoggingSql(String id, String author, String filename, String actions, String sxml) throws DatabaseException {
        try {
            StringBuilder sb = new StringBuilder();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            String rawAction = "";
            String rawSxml = "";
            if (actions != null) {
                rawAction = new String(Base64.getEncoder().encode(actions.getBytes()));
            }
            if (sxml != null) {
                rawSxml = new String(Base64.getEncoder().encode(sxml.getBytes()));
            }
            sb.append(this.addLogRecordComment);
            sb.append("\n DECLARE ");
            sb.append("\n id varchar2(200) := '" + id + "';");
            sb.append("\n rawAction clob;");
            sb.append("\n rawSxml clob;");
            sb.append("\n myrow varchar2(2000);");
            sb.append("\n action clob := '';");
            sb.append("\n sxml clob := '';");
            sb.append("\n dep varchar2(200) := '" + ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).getDeploymentId() + "';");
            sb.append("\n author varchar2(200) := '" + author + "';");
            sb.append("\n filename varchar2(200) := '" + filename + "';");
            sb.append("\n insertlog varchar2(200) := 'insert into %DATABASECHANGELOG%_ACTIONS (id,author,filename,sql,sxml,deployment_id) values (:id,:author,:filename,:action,:sxml,:dep) returning rowid into :out';");
            sb.append("\n updateaction varchar2(200) := 'update %DATABASECHANGELOG%_ACTIONS set sql = sql ||:action where rowid = :myrow ';");
            sb.append("\n updatesxml varchar2(200) := 'update %DATABASECHANGELOG%_ACTIONS set sxml = sxml ||:sxml where rowid = :myrow ';");
            sb.append("\n begin ");
            if (actions == null) {
                sb.append("\n action := '';");
            } else if (rawAction.length() < 32000 && rawSxml.length() < 32000) {
                if (rawAction.length() > 0) {
                    sb.append("\naction := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawAction + "}')));");
                }
                if (rawSxml.length() > 0) {
                    sb.append("\nsxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawSxml + "}')));");
                }
                sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
            } else {
                List<String> actionchunks = LiquibaseStringUtils.splitString(rawAction, 32000);
                List<String> sxmlchunks = LiquibaseStringUtils.splitString(rawSxml, 32000);
                boolean first = true;
                for (String piece : actionchunks) {
                    sb.append("\n rawAction := '" + piece + "';");
                    sb.append("\n action := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawAction)));");
                    if (first) {
                        sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep returning into myrow;");
                        first = false;
                        continue;
                    }
                    sb.append("\n execute immediate updateaction using action,myrow;");
                }
                for (String piece : sxmlchunks) {
                    sb.append("\n rawSxml := '" + piece + "';");
                    sb.append("\n sxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawSxml)));");
                    sb.append("\n execute immediate updatesxml using sxml,myrow;\n");
                }
            }
            sb.append("\nend;");
            if (exec instanceof LoggingExecutor) {
                sb.append("\n/        --\n");
            }
            return sb.toString().replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName());
        }
        catch (Exception e) {
            LiquibaseActions.log(e, ActionLogTableManager.class);
            throw e;
        }
    }

    private String genRollbackActionLogging(String id, String author, String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from " + this.database.getDatabaseChangeLogTableName() + "_ACTIONS");
        sb.append(" where id = '" + id + "' and filename = '" + filename);
        sb.append("' and author ='" + author + "' and sequence = (select Max(sequence) from ");
        sb.append(this.database.getDatabaseChangeLogTableName() + "_ACTIONS where id = '");
        sb.append(id + "' and filename = '" + filename + "' and author ='" + author + "')");
        return sb.toString();
    }
}

