/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.OracleSkippedChangeVisitor;
import liquibase.changelog.visitor.RollbackSkippedChangeVisitor;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.Data;
import liquibase.util.LiquibaseUtil;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.core.Messages;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exception.PropertyNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LiquibaseFileUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.util.Service;

public class LiquibaseActions {
    public static final String ACTION_NAME = "action";
    public static final String LB_ROLLBACK_ACTION = "rollback";
    public static final String LB_UPDATE_ACTION = "update";
    public static final String LB_NONE_ACTION = "none";

    private static ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog, Database database) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(database, true), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(database), new IgnoreChangeSetFilter()});
    }

    private static void report(String msg) {
        Scope.getCurrentScope().getUI().sendMessage(msg);
    }

    private static void reportIfDebug(String msg) {
        if (LiquibaseActions.getBoolenParameter("debug")) {
            Scope.getCurrentScope().getUI().sendMessage(msg);
        }
    }

    private static void validate_action_table(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String tab_exists = dbUtil.executeReturnOneCol("select count(*) from user_tables where table_name='DATABASECHANGELOG_ACTIONS'");
        if (tab_exists != null && Integer.parseInt(tab_exists) == 0) {
            LiquibaseActions.getConfig().setCreateActionTable(true);
        }
    }

    public static String doRollbackWork(Connection conn, StringWriter writer) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        LiquibaseActions.validate_action_table(conn);
        Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
        Database database = liquibase.getDatabase();
        SimpleDateFormat dtFmt = new SimpleDateFormat("MM/dd/yyyy");
        String mydate = LiquibaseActions.getLbParameter("date");
        int count = 0;
        Date date = null;
        String tag = LiquibaseActions.getLbParameter("tag");
        try {
            count = Integer.parseInt(LiquibaseActions.getLbParameter("count"));
        }
        catch (Exception e) {
            count = 0;
        }
        try {
            date = dtFmt.parse(mydate);
        }
        catch (Exception e) {
            date = null;
        }
        DatabaseChangeLog changeLog = liquibase.getDatabaseChangeLog();
        ChangeLogIterator changeLogIterator = LiquibaseActions.getStandardChangelogIterator(new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), changeLog, database);
        BufferedLogService bufferLog = new BufferedLogService();
        CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferLog});
        Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> changeLogIterator.run((ChangeSetVisitor)new RollbackSkippedChangeVisitor(database), new RuntimeEnvironment(database, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")))));
        if (date == null && count == 0 && "".equals(tag)) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: count or date must be supplied"), Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        int parm = 0;
        if (date != null) {
            ++parm;
        }
        if (count > 0) {
            ++parm;
        }
        if (!"".equals(tag)) {
            ++parm;
        }
        if (parm > 1) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: either count,date or tag must be supplied only one "), Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        if (count > 0) {
            if (writer == null) {
                liquibase.rollback(count, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            } else {
                liquibase.rollback(count, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            }
        } else if (date != null) {
            if (writer == null) {
                liquibase.rollback(date, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            } else {
                liquibase.rollback(date, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            }
        } else if (!"".equals(tag)) {
            if (writer == null) {
                liquibase.rollback(tag, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            } else {
                liquibase.rollback(tag, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            }
        } else {
            throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Don't know how to apply rollback "), Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        if (writer != null) {
            sb.append(writer);
        }
        if (isSqlCl) {
            LiquibaseActions.getContext().write(sb.toString());
            return null;
        }
        return sb.toString();
    }

    public static String doUpdateWork(Connection conn, StringWriter writer) throws Exception {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sb = new StringBuilder();
        LiquibaseActions.validate_action_table(conn);
        Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
        Database database = liquibase.getDatabase();
        DatabaseChangeLog changeLog = liquibase.getDatabaseChangeLog();
        ChangeLogIterator changeLogIterator = LiquibaseActions.getStandardChangelogIterator(new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), changeLog, database);
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).generateDeploymentId();
        String dep_id = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId();
        BufferedLogService bufferLog = new BufferedLogService();
        CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferLog});
        Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> changeLogIterator.run((ChangeSetVisitor)new OracleSkippedChangeVisitor(dep_id, database), new RuntimeEnvironment(database, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")))));
        if (writer == null) {
            if ("".equals(LiquibaseActions.getLbParameter("tag"))) {
                liquibase.update(new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            } else {
                liquibase.update(LiquibaseActions.getLbParameter("tag"), new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            }
        } else {
            if ("".equals(LiquibaseActions.getLbParameter("tag"))) {
                liquibase.update(new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            } else {
                liquibase.update(LiquibaseActions.getLbParameter("tag"), new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            }
            sb.append(writer + "\n");
        }
        if (isSqlCl) {
            LiquibaseActions.getContext().write(sb.toString());
            return null;
        }
        return sb.toString();
    }

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while (e.getCause() != null) {
            e = (Exception)e.getCause();
        }
        pw.print(e.getMessage() + "\r\n");
        if (LiquibaseActions.getBoolenParameter("debug")) {
            e.printStackTrace(pw);
        }
        return sw.toString();
    }

    public static HashMap<String, String> genApexObjectChangelogsWork(Connection conn) throws ProcessFailedException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sb = new StringBuilder();
        try {
            HashMap<String, String> logs = gen.getApexChangeLogs(LiquibaseActions.getAllLbParameters(), sb);
            if (isSqlCl) {
                gen.writeChangeLogMap(logs, LiquibaseActions.getContext());
                return null;
            }
            return logs;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String genControlFileWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        SchemaGenerator gen = new SchemaGenerator(conn);
        String fileName = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getControllerFileName() + ".XML".toLowerCase();
        try {
            String cwd = FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext());
            Path path = Paths.get(cwd + "/" + fileName, new String[0]);
            int i = 1;
            String newFile = null;
            while (Files.exists(path, new LinkOption[0])) {
                newFile = fileName.replace(".", i + ".");
                ++i;
                path = Paths.get(cwd + "/" + newFile, new String[0]);
            }
            gen.getMasterLog();
            if (isSqlCl) {
                gen.writeMasterLog(path);
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), path.getFileName().toString()));
                return null;
            }
            return gen.getMasterLog();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String genDbDocWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Path work_dir = Paths.get(LiquibaseActions.getContext().prependCD(""), new String[0]);
            Object dir = LiquibaseActions.getLbParameter("dir").replaceFirst("^~", System.getProperty("user.home"));
            if (!Paths.get((String)dir, new String[0]).isAbsolute()) {
                dir = LiquibaseActions.getContext().prependCD("") + (String)dir;
            }
            Path out_dir = Paths.get((String)dir, new String[0]);
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), work_dir.toString(), false);
            liquibase.generateDocumentation(out_dir.toString(), new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            StringBuilder sb = new StringBuilder();
            sb.append(MessageFormat.format(Messages.getString("LB_DBDOC_DONE"), LiquibaseActions.getLbParameter("dir").equals(".") || LiquibaseActions.getLbParameter("dir").equals("") ? "current directory" : LiquibaseActions.getLbParameter("dir")));
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String genDbObjectChangelogWork(Connection conn) throws ProcessFailedException {
        String fName;
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        String name = LiquibaseActions.getLbParameter("name").contains("\"") ? Service.handleMixedCase((String)LiquibaseActions.getLbParameter("name"), (boolean)true) : LiquibaseActions.getLbParameter("name").toUpperCase();
        if ("PACKAGE".equals(LiquibaseActions.getLbParameter("type").toUpperCase())) {
            try {
                LiquibaseActions.setLbParameter("type", "PACKAGE_SPEC");
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    throw (ProcessFailedException)e;
                }
                throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
            }
        }
        SchemaGenerator gen = new SchemaGenerator(conn);
        if (!isSqlCl) {
            return gen.getChangeLog(LiquibaseActions.getAllLbParameters());
        }
        String fileName = fName = (name + "_" + LiquibaseActions.getLbParameter("type") + ".xml").toLowerCase();
        int count = 1;
        File file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fName)));
        while (file.exists()) {
            fileName = fName.replace(".xml", count++ + ".xml");
            file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        try {
            LiquibaseActions.setLbParameter("name", name);
            LiquibaseActions.setLbParameter("filename", fileName);
            gen.writeChangeLog(LiquibaseActions.getAllLbParameters());
            LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
            return null;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static HashMap<String, String> genDbSchemaWork(Connection conn) throws ProcessFailedException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        try {
            return gen.doSchemaExport();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static HashMap<String, String> genDiffWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sbLog = new StringBuilder();
        StringBuilder sbDiff = new StringBuilder();
        String difName = null;
        try {
            JdbcConnection c = new JdbcConnection(DriverManager.getConnection("jdbc:oracle:thin:@" + LiquibaseActions.getLbParameter("url"), LiquibaseActions.getLbParameter("user"), LiquibaseActions.getLbParameter("password")));
            Liquibase liquibase = LiquibaseActions.getLiquibase(c, null, null, false);
            Database database = liquibase.getDatabase();
            Database source = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
            Database dest = liquibase.getDatabase();
            DiffResult diff = liquibase.diff(source, dest, CompareControl.STANDARD);
            if (LiquibaseActions.getBoolenParameter("report")) {
                if (isSqlCl) {
                    difName = LiquibaseFileUtils.writeFile(LiquibaseActions.getContext(), ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getDiffFileName(false), LiquibaseStringUtils.diffToString(diff));
                    LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), difName));
                } else {
                    sbDiff.append(LiquibaseStringUtils.diffToString(diff));
                }
            } else if (isSqlCl) {
                difName = LiquibaseFileUtils.writeFile(LiquibaseActions.getContext(), ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getDiffFileName(true), LiquibaseStringUtils.diffToChangeLog(diff));
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), difName));
            } else {
                sbDiff.append(LiquibaseStringUtils.diffToChangeLog(diff));
            }
            if (database instanceof OracleDatabase) {
                List<String> errors = LiquibaseActions.getAllErrors();
                sbLog.append("######## ERROR SUMMARY ##################\n");
                sbLog.append("Errors encountered:" + errors.size() + "\n\n");
                for (String error : errors) {
                    sbLog.append(error + "\n");
                }
                if (LiquibaseActions.getBoolenParameter("log") && errors.size() > 0) {
                    String fileName = LiquibaseActions.getLbParameter("changelog") + "-ERRORS-" + new Date().getTime() + ".log";
                    FileWriter fileWriter = new FileWriter(LiquibaseActions.getContext().prependCD("") + fileName);
                    fileWriter.write("######## ERROR SUMMARY ##################\n");
                    fileWriter.write("Errors encountered:" + errors.size() + "\n\n");
                    for (String error : errors) {
                        fileWriter.write(error + "\n");
                    }
                    ((Writer)fileWriter).close();
                }
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getLogFileName(), sbLog.toString());
            returnMap.put(difName, sbDiff.toString());
            return returnMap;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String genOrdsObjectChangelogWork(Connection conn) throws ProcessFailedException, PropertyNotFoundException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        SchemaGenerator gen = new SchemaGenerator(conn);
        String fileName = null;
        if (!isSqlCl) {
            return gen.getOrdsChangeLog(LiquibaseActions.getAllLbParameters());
        }
        fileName = LiquibaseActions.getLbParameter("name") != null && !"".equals(LiquibaseActions.getLbParameter("name")) ? ("ords-rest_" + LiquibaseActions.getLbParameter("name")).toLowerCase() : "ords-rest_schema".toLowerCase();
        int count = 1;
        File file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)(fileName + ".xml"))));
        while (file.exists()) {
            fileName = (fileName + count++ + ".xml").toLowerCase();
            file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        fileName = file.getName();
        try {
            LiquibaseActions.setLbParameter("filename", fileName);
            gen.writeOrdsChangeLog(LiquibaseActions.getAllLbParameters());
            LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
            return null;
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String genTableDataWork(Connection conn) throws ProcessFailedException {
        StandardObjectChangeFilter.FilterType type = null;
        StandardObjectChangeFilter filter = null;
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            String tableNamesPattern;
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), null, null, false);
            Database database = liquibase.getDatabase();
            CatalogAndSchema catalogAndSchema = new CatalogAndSchema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
            DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, false, null);
            if (LiquibaseActions.getLbParameter("object") != null) {
                type = LiquibaseActions.getLbParameter("filter") != null && "exclude".equalsIgnoreCase(LiquibaseActions.getLbParameter("filter")) ? StandardObjectChangeFilter.FilterType.EXCLUDE : StandardObjectChangeFilter.FilterType.INCLUDE;
                tableNamesPattern = LiquibaseActions.getLbParameter("object").toUpperCase();
                filter = new StandardObjectChangeFilter(type, tableNamesPattern);
            } else if (LiquibaseActions.getLbParameter("filter") == null && LiquibaseActions.getLbParameter("object") == null) {
                type = StandardObjectChangeFilter.FilterType.EXCLUDE;
                tableNamesPattern = "DATABASECHANGELOG_ACTIONS,DATABASECHANGELOGLOCK,DATABASECHANGELOG";
                filter = new StandardObjectChangeFilter(type, "DATABASECHANGELOG_ACTIONS,DATABASECHANGELOGLOCK,DATABASECHANGELOG");
            } else {
                throw new ProcessFailedException(null, "Invalid Parameters");
            }
            diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)filter);
            DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffOutputControl);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
            liquibase.generateChangeLog(catalogAndSchema, diffToChangeLog, printStream, new Class[]{Data.class});
            printStream.close();
            if (isSqlCl) {
                LiquibaseFileUtils.writeFile(LiquibaseActions.getContext(), "data.xml", out.toString("UTF-8"));
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), "data.xml"));
                return null;
            }
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static ArrayList<String> getAllApexParameters() {
        return LiquibaseActions.getConfig().getApexParms();
    }

    public static List<String> getAllErrors() {
        return LiquibaseActions.getConfig().getAllErrors();
    }

    public static HashMap<String, String> getAllLbParameters() {
        return LiquibaseActions.getConfig().getLbParms();
    }

    public static boolean getBoolenParameter(String name) {
        return Boolean.parseBoolean(LiquibaseActions.getLbParameter(name));
    }

    public static SqlclConfig getConfig() {
        return (SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue();
    }

    public static ScriptRunnerContext getContext() {
        return LiquibaseActions.getConfig().getContext();
    }

    public static String getLbParameter(String name) {
        return LiquibaseActions.getConfig().getLbParameter(name);
    }

    public static String getLbVersion() throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nLiquibase version:   " + LiquibaseUtil.getBuildVersion());
        sb.append("\nExtension Version:   " + Messages.getString("SQLclVersion.VERSION"));
        sb.append("\n\n");
        return sb.toString();
    }

    public static Liquibase getLiquibase(JdbcConnection conn) throws Exception {
        return new Liquibase("", (ResourceAccessor)null, DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)conn));
    }

    public static Liquibase getLiquibase(JdbcConnection conn, String changelog, String cwd) throws Exception {
        return LiquibaseActions.getLiquibase(conn, changelog, cwd, true);
    }

    public static Liquibase getLiquibase(JdbcConnection conn, String changelog, String cwd, boolean log) throws Exception {
        ArrayList<File> list = new ArrayList<File>();
        conn.setAutoCommit(false);
        Liquibase liquibase = null;
        Database database = null;
        if (changelog != null) {
            Path filePath;
            if ((changelog = LiquibaseStringUtils.trim(changelog)).startsWith("../")) {
                changelog = changelog.replaceFirst("../", "");
                filePath = Paths.get(Paths.get(LiquibaseActions.getContext().prependCD(changelog), new String[0]).normalize().getParent().getParent() + File.separator + changelog, new String[0]);
            } else {
                filePath = Paths.get(changelog, new String[0]).isAbsolute() ? Paths.get(changelog, new String[0]).normalize() : Paths.get(LiquibaseActions.getContext().prependCD(changelog), new String[0]).normalize();
            }
            if (filePath != null && filePath.getRoot() != null) {
                list.add(filePath.getRoot().toFile());
            }
            if (filePath != null && filePath.getParent() != null) {
                list.add(filePath.getParent().toFile());
            }
            if (list.size() == 0) {
                list.add(Paths.get(".", new String[0]).toFile());
            }
            String fileName = filePath.getFileName().toString();
            File[] mypaths = new File[list.size()];
            list.toArray(mypaths);
            liquibase = new Liquibase(fileName, (ResourceAccessor)new FileSystemResourceAccessor(mypaths), (DatabaseConnection)conn);
            database = liquibase.getDatabase();
            if (LiquibaseActions.getLbParameter("dbChangeLogTable") != null && !"".equals(LiquibaseActions.getLbParameter("dbChangeLogTable"))) {
                database.setDatabaseChangeLogTableName(LiquibaseActions.getLbParameter("dbChangeLogTable"));
                database.setDatabaseChangeLogLockTableName(database.getDatabaseChangeLogTableName() + "LOCK");
            }
        } else {
            liquibase = new Liquibase(null, null, (DatabaseConnection)conn);
            database = liquibase.getDatabase();
        }
        LockService lockService = LockServiceFactory.getInstance().getLockService(database);
        lockService.init();
        LiquibaseActions.resetErrors();
        if (log) {
            ActionLogTableManager tm = new ActionLogTableManager(database);
            tm.createUpdateLogTable();
        }
        if (liquibase.getDatabaseChangeLog() != null && liquibase.getDatabaseChangeLog().getChangeSets() != null) {
            LiquibaseActions.report("-- Loaded " + liquibase.getDatabaseChangeLog().getChangeSets().size() + " changeSets", LiquibaseActions.class);
        }
        return liquibase;
    }

    public static String lbChangeLogSyncWork(Connection conn) throws ProcessFailedException {
        try {
            StringWriter sw = new StringWriter();
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD("").concat(LiquibaseActions.getLbVersion()), false);
            if ("".equals(LiquibaseActions.getLbParameter("tag"))) {
                liquibase.changeLogSync(new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)sw);
            } else {
                liquibase.changeLogSync(LiquibaseActions.getLbParameter("tag"), new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)sw);
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sw.toString());
                LiquibaseActions.getContext().write(Messages.getString("LB_OPERATION_SUCCESS"));
                return null;
            }
            return sw.toString() + "\n -- " + Messages.getString("LB_OPERATION_SUCCESS");
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbClearCheckSumsWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""), false);
            liquibase.clearCheckSums();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_CHECK_SUCCESS"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_CHECK_SUCCESS"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbListLocksWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn));
            DatabaseChangeLogLock[] locks = liquibase.listLocks();
            StringBuilder sb = new StringBuilder();
            if (locks.length > 0) {
                sb.append("\nID\t\tUSER\n");
                for (DatabaseChangeLogLock lock : locks) {
                    sb.append(Messages.getString(lock.getId() + "\t\t" + lock.getLockedBy() + "\n"));
                }
            } else {
                sb.append(Messages.getString("LB_NO_LOCKS"));
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbReleaseLocksWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn));
            liquibase.forceReleaseLocks();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_LOCK_SUCCESS"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_LOCK_SUCCESS"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbStatusWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""), false);
            StringWriter sw = new StringWriter();
            liquibase.reportStatus(true, LiquibaseActions.getLbParameter("context"), (Writer)sw);
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sw.toString());
                return null;
            }
            return sw.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbTagExistsWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn));
            boolean tagExists = liquibase.tagExists(LiquibaseActions.getLbParameter("tag"));
            if (isSqlCl) {
                if (tagExists) {
                    LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_TAGCHECK_SUCCESS"), LiquibaseActions.getLbParameter("tag")));
                } else {
                    LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_TAGCHECK_FAIL"), LiquibaseActions.getLbParameter("tag")));
                }
                return null;
            }
            if (tagExists) {
                return MessageFormat.format(Messages.getString("LB_TAG_SUCCESS"), LiquibaseActions.getLbParameter("tag"));
            }
            return MessageFormat.format(Messages.getString("LB_TAG_FAIL"), LiquibaseActions.getLbParameter("tag"));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbTagWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn));
            liquibase.tag(LiquibaseActions.getLbParameter("tag"));
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_TAG_SUCCESS"), LiquibaseActions.getLbParameter("tag")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_TAG_SUCCESS"), LiquibaseActions.getLbParameter("tag"));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static String lbValidateWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase(new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""), false);
            liquibase.validate();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_VALID"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_FILE_VALID"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static void log(Exception e, Class<?> clazz) {
        LiquibaseActions.log(LiquibaseActions.exceptionToString(e), clazz);
    }

    public static void log(String msg, Class<?> clazz) {
        Scope.getCurrentScope().getLog(clazz).fine(msg);
        LiquibaseActions.reportIfDebug(msg);
    }

    public static void report(Exception e, Class<?> clazz) {
        LiquibaseActions.report(e, clazz, "");
    }

    public static void report(Exception e, Class<?> clazz, String file) {
        Scope.getCurrentScope().getLog(clazz).fine(LiquibaseActions.exceptionToString(e).toString());
        ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).addError(file + "\n---------\n" + LiquibaseActions.exceptionToString(e));
        LiquibaseActions.report(LiquibaseActions.exceptionToString(e).toString());
    }

    public static void report(String msg, Class<?> clazz) {
        Scope.getCurrentScope().getLog(clazz).fine(msg);
        LiquibaseActions.report(msg);
    }

    public static void reportErrors() {
        if (LiquibaseActions.getAllErrors().size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n######## ERROR SUMMARY ##################\n");
            sb.append("Errors encountered:" + LiquibaseActions.getAllErrors().size() + "\n\n");
            for (String error : LiquibaseActions.getAllErrors()) {
                sb.append("----------------------------\n");
                sb.append(error + "\n");
                sb.append("----------------------------\n\n");
            }
            LiquibaseActions.report(sb.toString());
            try {
                LiquibaseFileUtils.writeErrorLog(sb.toString());
            }
            catch (Exception e) {
                LiquibaseActions.log(e, LiquibaseActions.class);
            }
        } else {
            LiquibaseActions.report("No Errors Encountered");
        }
    }

    public static void resetErrors() {
        LiquibaseActions.getConfig().resetErrorList();
    }

    public static void setContext(ScriptRunnerContext ctx) {
        LiquibaseActions.getConfig().setContext(ctx);
    }

    public static void setLbParameter(String name, String value) throws PropertyNotFoundException, ProcessFailedException {
        LiquibaseActions.getConfig().setLbParameter(name, value);
    }
}

