/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import java.io.StringWriter;
import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exception.PropertyNotFoundException;

public class LiquibaseApi {
    public String doRollback(Connection conn, String changelog, int count) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("count", String.valueOf(count));
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, null);
    }

    public String doRollback(Connection conn, String changelog, String date) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("date", date);
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, null);
    }

    public String doRollbackSql(Connection conn, String changelog, int count, StringWriter writer) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("count", String.valueOf(count));
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, writer);
    }

    public String doRollbackSql(Connection conn, String changelog, String date, StringWriter writer) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("date", date);
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, writer);
    }

    public String doUpdate(Connection conn, String changelog) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doUpdateWork(conn, null);
    }

    public String doUpdateSql(Connection conn, String changelog, StringWriter writer) throws Exception {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doUpdateWork(conn, writer);
    }

    public HashMap<String, String> genApexObjectChangelogs(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genApexObjectChangelogsWork(conn);
    }

    public String genControlFile(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genControlFileWork(conn);
    }

    public String genDbDoc(Connection conn, String changelog, String dir) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("dir", dir);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbDocWork(conn);
    }

    public String genDbObjectChangelog(Connection conn, String name, String type) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("name", name);
            if ("PACKAGE".equals(type.toUpperCase())) {
                type = "PACKAGE_SPEC";
            }
            LiquibaseActions.setLbParameter("type", type);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbObjectChangelogWork(conn);
    }

    public HashMap<String, String> genDbSchema(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbSchemaWork(conn);
    }

    public HashMap<String, String> genDiff(Connection conn, String user, String pass, String url, String style) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("user", user);
            LiquibaseActions.setLbParameter("password", pass);
            LiquibaseActions.setLbParameter("url", url);
            LiquibaseActions.setLbParameter("log", "false");
            if ("changelog".equals(style)) {
                LiquibaseActions.setLbParameter("report", "false");
            } else {
                LiquibaseActions.setLbParameter("report", "true");
            }
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDiffWork(conn);
    }

    public String genOrdsObjectChangelog(Connection conn, String name, String type) throws ProcessFailedException, PropertyNotFoundException {
        LiquibaseActions.setLbParameter("name", name);
        LiquibaseActions.setLbParameter("type", type);
        LiquibaseActions.setLbParameter("isSqlCl", "false");
        return LiquibaseActions.genOrdsObjectChangelogWork(conn);
    }

    public String genTableData(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genTableDataWork(conn);
    }

    public String lbChangeLogSync(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbChangeLogSyncWork(conn);
    }

    public String lbClearCheckSums(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbClearCheckSumsWork(conn);
    }

    public String lbListLocks(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbListLocksWork(conn);
    }

    public String lbReleaseLocks(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbReleaseLocksWork(conn);
    }

    public String lbStatus(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbStatusWork(conn);
    }

    public String lbValidate(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LiquibaseActions.log(e, LiquibaseApi.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbValidateWork(conn);
    }
}

