/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.sql.Connection;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseFileUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.util.Service;

public class MetadataSqlGenerator {
    private static String getDrop(AbstractOracleStatement statement, Database database) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP ");
        if (SchemaGenerator.typeNameTransform.containsKey(statement.getObjectType())) {
            sql.append(SchemaGenerator.typeNameTransform.get(statement.getObjectType()) + " ");
        } else {
            sql.append(statement.getObjectType() + " ");
        }
        if (LiquibaseActions.getBoolenParameter("emit_schema")) {
            sql.append("\"" + statement.getOwnerName() + "\".");
        }
        sql.append("\"" + statement.getObjectName() + "\"");
        if ("TABLE".equals(statement.getObjectType())) {
            sql.append(" CASCADE CONSTRAINTS");
        }
        return sql.toString();
    }

    private static String metadata_cleanup(String sql) {
        String fixed = "";
        fixed = sql.replaceAll(",\\s+\\);", ");\n");
        fixed = sql.replaceAll("COMPRESS Y ENABLE", "COMPRESS ENABLE");
        return fixed;
    }

    private static String processSchema(String sql, boolean emit_schema, String schema, String catalog) {
        String newSql;
        if (emit_schema) {
            newSql = sql;
        } else {
            newSql = sql.replaceAll("\"" + schema + "\"[.]", "");
            newSql = newSql.replaceAll("\"" + catalog + "\"[.]", "");
            newSql = newSql.replaceAll(schema + "[.]", "");
        }
        return newSql;
    }

    public static Sql[] getCreateSqlPlSql(AbstractOracleStatement statement, Database database) {
        String outSql = null;
        StringBuilder sql = new StringBuilder();
        if (!("GRANT".equals(statement.getObjectType()) || "JOB".equals(statement.getObjectType()) || "COMMENT".equals(statement.getObjectType()) || statement.getSource().toUpperCase().substring(0, 15).contains("CREATE") || statement.getSource().toUpperCase().substring(0, 15).contains("ALTER"))) {
            sql.append("CREATE ");
            if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
                sql.append("OR REPLACE ");
            }
        }
        sql.append(statement.getSource());
        outSql = sql.toString();
        outSql = outSql.replace("%USER_NAME%", database.getDefaultSchemaName());
        outSql = outSql.replaceAll("END;/", "END;");
        outSql = outSql.replaceAll("\nALTER", "\n/ \nALTER");
        outSql = MetadataSqlGenerator.processSchema(outSql, LiquibaseActions.getBoolenParameter("emit_schema"), statement.getOwnerName(), database.getDefaultCatalogName());
        while (outSql.trim().endsWith(";")) {
            outSql = outSql.substring(0, outSql.length() - 1);
        }
        if (SchemaGenerator.ddlChangeTypes.containsKey(statement.getObjectType())) {
            outSql = outSql.concat(";");
        }
        if (outSql != null && !"".equals(outSql.trim())) {
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
    }

    public static Sql[] getCreateSqlSxml(AbstractOracleStatement stmt, Database database) {
        try {
            Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
            String sql = null;
            String oName = stmt.getObjectName();
            String oType = stmt.getObjectType();
            String destXml = stmt.getSource();
            String schema = stmt.getOwnerName();
            if (schema == null) {
                schema = stmt.getOwnerName();
            }
            if (stmt.getFile() == null) {
                stmt.setObjectOwner(database.getDefaultSchemaName());
                stmt.setSource(stmt.getSource().replaceAll("%USER_NAME%", database.getDefaultSchemaName()));
                destXml = destXml.replaceAll("%USER_NAME%", database.getDefaultSchemaName());
            }
            if (!"VIEW".equalsIgnoreCase(oType) && QueryUtils.doesObjectExist(conn, oName, oType)) {
                String sourceXml = DbmsMetaUtils.getObjectFromDb(conn, stmt.getObjectType(), stmt.getObjectName());
                sql = DbmsMetaUtils.getAlterDdl(conn, sourceXml, destXml, stmt.getObjectType());
            } else {
                sql = DbmsMetaUtils.getDdlFromSxml(conn, destXml, stmt.getObjectType());
                sql = MetadataSqlGenerator.metadata_cleanup(sql);
            }
            if (sql == null || "".equals(sql)) {
                sql = "-- object is the same nothing to do";
            }
            sql = MetadataSqlGenerator.processSchema(sql, LiquibaseActions.getBoolenParameter("emit_schema"), schema, database.getDefaultCatalogName());
            return new Sql[]{new UnparsedSql(LiquibaseStringUtils.trimEndofSql(sql), new DatabaseObject[0])};
        }
        catch (Exception e) {
            LiquibaseActions.log(e, LiquibaseFileUtils.class);
            return null;
        }
    }

    public static Sql[] getDropSqlPlSql(AbstractOracleStatement statement, Database database) {
        String outSql = null;
        String oName = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        String action = null;
        if (statement instanceof RunOracleScriptStatement) {
            return null;
        }
        try {
            if (statement.getObjectName() != null && !"%OBJECT_NAME%".equals(statement.getObjectName())) {
                oName = Service.handleMixedCase((String)statement.getObjectName());
            }
            try {
                action = QueryUtils.getXmlFromActionsLog(conn, statement);
            }
            catch (Exception e) {
                LiquibaseActions.log(e, LiquibaseActions.class);
            }
            if (action == null || "".equals(action)) {
                if ("JOB".equals(statement.getObjectType())) {
                    String subType = QueryUtils.getSchedulerObjectType(oName, database);
                    if (subType != null) {
                        sql.append("BEGIN DBMS_SCHEDULER.drop_" + subType.toLowerCase() + " (" + subType.toLowerCase() + "_name => '" + oName + "' ,FORCE=>TRUE); end;");
                    }
                } else if ("COMMENT".equals(statement.getObjectType())) {
                    sql.append(LiquibaseStringUtils.trimEndofSql(statement.getSource().replaceAll("'.*'", "''")));
                } else if ("REFCONSTRAINT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("ADD", "DROP");
                    int loc = dropsql.indexOf("FOREIGN KEY");
                    sql.append(dropsql.substring(0, loc - 1));
                } else if ("GRANT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("GRANT", "REVOKE");
                    dropsql = dropsql.replaceAll("TO", "FROM");
                    sql.append(dropsql);
                } else {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                }
            } else {
                sql.append(action);
            }
            outSql = MetadataSqlGenerator.processSchema(sql.toString(), LiquibaseActions.getBoolenParameter("emit_schema"), statement.getOwnerName(), database.getDefaultCatalogName());
            if (outSql == null || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql("REM No Changes to be made", new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            LiquibaseActions.log(e, LiquibaseActions.class);
            return null;
        }
    }

    public static Sql[] getDropSqlSxml(AbstractOracleStatement statement, Database database) {
        String sourceXml = null;
        String destXml = null;
        String outSql = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        try {
            String oType = statement.getObjectType();
            if ("MATERIALIZED_VIEW_LOG".equals(oType)) {
                String create = DbmsMetaUtils.getDdlFromSxml(conn, statement.getSource(), statement.getObjectType());
                String drop = create.replace("CREATE", "DROP");
                int loc = LiquibaseStringUtils.nthOccurrence(drop, '\"', 4);
                outSql = drop = drop.substring(0, loc + 1);
            } else {
                destXml = DbmsMetaUtils.getObjectFromDb(((JdbcConnection)database.getConnection()).getUnderlyingConnection(), statement.getObjectType(), statement.getObjectName());
                String logSxml = QueryUtils.getXmlFromActionsLog(conn, statement);
                if (logSxml == null || logSxml.trim().isEmpty()) {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                } else {
                    sourceXml = logSxml;
                    sql.append(DbmsMetaUtils.getAlterDdl(conn, destXml, sourceXml, statement.getObjectType()));
                }
                outSql = MetadataSqlGenerator.processSchema(sql.toString(), LiquibaseActions.getBoolenParameter("emit_schema"), statement.getOwnerName(), database.getDefaultCatalogName());
            }
            if (outSql == null || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql("REM No Changes to be made", new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            LiquibaseActions.log(e, LiquibaseActions.class);
            return null;
        }
    }
}

