/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import liquibase.Scope;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.core.Messages;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGeneratorUtils;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.liquibase.util.StopWatch;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;

public class SchemaGenerator {
    static DBUtil dbUtil;
    public static final HashMap<String, String> ddlChangeTypes;
    public static LinkedHashMap<String, Integer> ordered_types_short;
    public static LinkedHashMap<String, Integer> ordered_types_long;
    public static final HashMap<String, String> typeNameTransform;
    private final Connection conn;
    private final List<String> file_names = new ArrayList<String>();

    public SchemaGenerator(Connection _conn) {
        dbUtil = DBUtil.getInstance((Connection)_conn);
        this.conn = _conn;
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkApexVersion", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException("APEX is not installed in DB or this connection has no access.");
        }
        Version source = new Version(version);
        return source.compareTo(new Version("19.2")) > 0;
    }

    private HashMap<String, String> cleanDdlParam(HashMap<String, String> params) throws ProcessFailedException {
        String type = params.get("type");
        String ddl = params.get("ddl");
        try {
            if (ddl == null || ddl.isEmpty()) {
                ddl = DbmsMetaUtils.getObjectFromDb(this.conn, params.get("type"), params.get("name"));
                if (ddl == null || ddl.length() == 0) {
                    throw new ProcessFailedException(new Exception("Unable to retrieve object metadata are you sure it exists?"), Thread.currentThread().getStackTrace()[1].getMethodName());
                }
            } else if ("JOB".equalsIgnoreCase(type) && ddl.contains("create_program")) {
                ddl = ddl.replaceFirst("BEGIN", Matcher.quoteReplacement(ddl));
            }
            params.put("ddl", ddl);
            return params;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void cleanupCaptureTable(StringBuilder sb) throws ProcessFailedException {
        StopWatch stopWatch = new StopWatch("Method cleanupCaptureTable", sb);
        String queryCaptureTable = QueryUtils.getXMLQueries().getQuery("queryCaptureTableRecursion", this.conn).getSql();
        String getRefConstraints = QueryUtils.getXMLQueries().getQuery("getRefConstraints", this.conn).getSql();
        PreparedStatement pstatement = null;
        DBUtil dbUtil = DBUtil.getInstance((Connection)this.conn);
        ResultSet rs = null;
        try {
            pstatement = this.conn.prepareStatement(queryCaptureTable);
            rs = pstatement.executeQuery();
            int counter = 1;
            while (rs.next()) {
                int seq = rs.getInt(1);
                String name = rs.getString(2);
                String type = rs.getString(3);
                this.modifyDDL(dbUtil, "off");
                String newMeta = DbmsMetaUtils.getObjectFromDb(this.conn, type, name);
                this.modifyDDL(dbUtil, "on");
                HashMap<String, String> binds = new HashMap<String, String>();
                binds.put("ONAME", name);
                String refs = dbUtil.executeReturnOneCol(getRefConstraints, binds);
                this.updateCaptureTableMeta(newMeta, seq, type);
                Clob refClob = this.conn.createClob();
                refClob.setString(1L, refs);
                this.insertCaptureTable(counter++, refClob, (name.toLowerCase() + "_REFS.xml").toLowerCase());
            }
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        stopWatch.end(sb);
    }

    private String getComments(String oName) throws ProcessFailedException {
        String querycomments = QueryUtils.getXMLQueries().getQuery("querycomments", this.conn).getSql();
        String ddlSetup = QueryUtils.getXMLQueries().getQuery("ddlSetup", this.conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Object clob;
            stmt = this.conn.prepareStatement(ddlSetup);
            stmt.executeQuery();
            stmt.close();
            stmt = this.conn.prepareStatement(querycomments);
            stmt.setString(1, oName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                clob = rs.getClob(1);
                String sql = LiquibaseStringUtils.clobToString((Clob)clob);
                if (!LiquibaseActions.getBoolenParameter("emit_schema")) {
                    sql = sql.replaceAll("\"" + this.conn.getSchema() + "\"[.]", "");
                }
                sb.append(sql);
            }
            if (sb.toString().length() <= 0) {
                clob = null;
                return clob;
            }
            clob = sb.toString();
            return clob;
        }
        catch (SQLException e1) {
            if (e1.getErrorCode() == 31608) {
                String string = null;
                return string;
            }
            LiquibaseActions.log(e1, this.getClass());
            throw new ProcessFailedException(e1, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String getControllerFooter() {
        return "</databaseChangeLog> \n";
    }

    private String getControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.9.xsd\">\n";
    }

    private String getControllerInclude(String fileName) {
        String include = "  <include file=\"%FILE%\"/> \n";
        return LiquibaseStringUtils.replaceVal("%FILE%", fileName, "  <include file=\"%FILE%\"/> \n");
    }

    private final String getSha1fromString(String data) throws ProcessFailedException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(data.getBytes(StandardCharsets.UTF_8));
            return String.format("%040x", new BigInteger(1, digest.digest()));
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void insertCaptureTable(int seq, Clob meta, String filename) throws ProcessFailedException {
        String insertCaptureTable = QueryUtils.getXMLQueries().getQuery("insertCaptureTable", this.conn).getSql();
        try (PreparedStatement insert = this.conn.prepareStatement(insertCaptureTable);){
            insert.setInt(1, 100);
            insert.setString(2, "REF_CONSTRAINT");
            insert.setInt(3, seq);
            insert.setClob(4, meta);
            insert.setString(5, filename);
            insert.executeUpdate();
            this.conn.commit();
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void insertCommentCaptureTable(HashMap<String, String> params, Clob source) throws ProcessFailedException {
        String insertCaptureTable = QueryUtils.getXMLQueries().getQuery("insertCommentCaptureTable", this.conn).getSql();
        try (PreparedStatement insert = this.conn.prepareStatement(insertCaptureTable);){
            insert.setInt(1, 65);
            insert.setString(2, "COMMENT");
            insert.setClob(3, source);
            insert.setString(4, params.get("filename"));
            insert.setString(5, params.get("name"));
            insert.executeUpdate();
            this.conn.commit();
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void loadCaptureTable(HashMap<String, String> params, StringBuilder sb) throws ProcessFailedException {
        ScriptRunnerContext ctx = LiquibaseActions.getContext();
        boolean pubSyns = Boolean.parseBoolean(params.get("synonyms"));
        boolean grants = Boolean.parseBoolean(params.get("grants"));
        String filter = params.get("filter");
        StopWatch stopWatch = new StopWatch("Method loadCaptureTable", sb);
        String callLoadCapture = QueryUtils.getXMLQueries().getQuery("callLoadCapture", this.conn).getSql();
        String key = "";
        try (CallableStatement statement = this.conn.prepareCall(callLoadCapture);){
            LinkedHashMap<String, Integer> ordered_types = ((String)ctx.getDDLOptions().get("REF_CONSTRAINTS")).equals("ON") ? ordered_types_short : ordered_types_long;
            for (Map.Entry<String, Integer> entry : ordered_types.entrySet()) {
                key = entry.getKey();
                if ("PUBLIC_SYNONYM".equals(key) && !pubSyns || ("OBJECT_GRANT".equals(key) || "SYSTEM_GRANT".equals(key) || "ROLE_GRANT".equals(key)) && !grants) continue;
                Integer rank = entry.getValue();
                statement.setString("otype", key);
                statement.setInt("rank", (int)rank);
                if (ctx.getDDLOptions() != null && !"ON".equals(ctx.getDDLOptions().get("DEFAULT"))) {
                    statement.setString("inherit", (String)ctx.getDDLOptions().get("INHERIT"));
                    statement.setString("sqlterminator", (String)ctx.getDDLOptions().get("SQLTERMINATOR"));
                    statement.setString("specification", (String)ctx.getDDLOptions().get("SPECIFICATION"));
                    statement.setString("size_byte_keyword", (String)ctx.getDDLOptions().get("SIZE_BYTE_KEYWORD"));
                    statement.setString("pretty", (String)ctx.getDDLOptions().get("PRETTY"));
                    statement.setString("force", (String)ctx.getDDLOptions().get("FORCE"));
                    statement.setString("inserts", (String)ctx.getDDLOptions().get("INSERT"));
                    statement.setString("body", (String)ctx.getDDLOptions().get("BODY"));
                    statement.setString("constraints_as_alter", (String)ctx.getDDLOptions().get("CONSTRAINTS_AS_ALTER"));
                    statement.setString("ref_constraints", (String)ctx.getDDLOptions().get("REF_CONSTRAINTS"));
                    statement.setString("filter", filter);
                }
                statement.execute();
                stopWatch.split("Type - " + key, sb);
            }
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, "type -" + key + " failed\n" + Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            stopWatch.end(sb);
        }
    }

    private void modifyDDL(DBUtil dbUtil, String state) throws ProcessFailedException {
        String optionSQL;
        if ("on".equalsIgnoreCase(state)) {
            optionSQL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,true); end;";
            LiquibaseActions.getContext().setDDLOptions("REF_CONSTRAINTS", "ON");
        } else {
            optionSQL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,false); end;";
            LiquibaseActions.getContext().setDDLOptions("REF_CONSTRAINTS", "OFF");
        }
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OPTION", "REF_CONSTRAINTS");
        try {
            dbUtil.execute(optionSQL, binds);
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private void processCaptureTable(HashMap<String, String> params, StringBuilder sb) throws ProcessFailedException {
        StopWatch stopWatch = new StopWatch("Method processCaptureTable", sb);
        String queryCaptureTable = QueryUtils.getXMLQueries().getQuery("queryCaptureTable", this.conn).getSql();
        PreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = this.conn.prepareStatement(queryCaptureTable);
            rs = pstatement.executeQuery();
            int counter = 0;
            int badFile = 0;
            while (rs.next()) {
                String comments;
                String fileName;
                Object name = null;
                String depList = null;
                String type = rs.getString(1);
                Clob meta = rs.getClob(2);
                int seq = rs.getInt(3);
                String ddl = ddlChangeTypes.containsKey(type) ? LiquibaseStringUtils.trim(LiquibaseStringUtils.clobToString(meta)).replace("REFERENCING FOR EACH ROW", "") : DbmsMetaUtils.getDdlFromSxml(this.conn, meta.getSubString(1L, (int)meta.length()).trim(), type);
                SqlRecognizer recognizer = new SqlRecognizer(ddl);
                List names = recognizer.getObjectNames();
                List deps = recognizer.getReferencedTypes();
                if (names != null && names.size() > 0) {
                    name = ((String)names.get(0)).replaceAll("\"", "");
                }
                if (deps != null && deps.size() > 0) {
                    depList = String.join((CharSequence)",", deps);
                    depList = depList.replaceAll("\"", "").toUpperCase();
                }
                if (name != null) {
                    fileName = (name + "_" + type + ".xml").toLowerCase();
                } else if ("REF_CONSTRAINT".equals(type) || "ROLE_GRANT".equals(type) || "OBJECT_GRANT".equals(type) || "SYSTEM_GRANT".equals(type) || "MATERIALIZED_VIEW_LOG".equals(type)) {
                    name = type.toLowerCase() + counter;
                    fileName = (type + counter++ + ".xml").toLowerCase();
                } else {
                    fileName = (type + "_BAD_" + badFile++ + ".xml").toLowerCase();
                    this.file_names.add(fileName);
                }
                this.createOrReplaceParam(params, "name", (String)name);
                this.createOrReplaceParam(params, "filename", fileName);
                this.createOrReplaceParam(params, "ddl", ddl);
                this.createOrReplaceParam(params, "type", type);
                if (deps != null && deps.size() > 0) {
                    this.updateCaptureTable((String)name, depList, deps.size(), fileName, seq, type);
                } else {
                    this.updateCaptureTable((String)name, null, 0, fileName, seq, type);
                }
                if (name == null || !"TABLE".equalsIgnoreCase(type) && !"VIEW".equalsIgnoreCase(type) || (comments = this.getComments((String)name)) == null) continue;
                fileName = ((String)name + "_comments.xml").toLowerCase();
                this.createOrReplaceParam(params, "name", (String)name + "_comments");
                this.createOrReplaceParam(params, "filename", fileName);
                this.createOrReplaceParam(params, "ddl", comments);
                this.createOrReplaceParam(params, "type", "COMMENT");
                Clob sourceClob = this.conn.createClob();
                sourceClob.setString(1L, comments);
                this.insertCommentCaptureTable(params, sourceClob);
            }
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        stopWatch.end(sb);
    }

    private void sortCaptureTable(StringBuilder sb) throws ProcessFailedException {
        StopWatch stopWatch = new StopWatch("Method sortCaptureTable", sb);
        String query = QueryUtils.getXMLQueries().getQuery("callSortCapture", this.conn).getSql();
        try (CallableStatement statement = this.conn.prepareCall(query);){
            statement.execute();
        }
        catch (Exception e) {
            try {
                this.conn.commit();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        stopWatch.end(sb);
    }

    private void updateCaptureTable(String name, String depList, int depCount, String fileName, int seq, String type) throws ProcessFailedException {
        String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTable", this.conn).getSql();
        Statement update = null;
        try {
            this.conn.setAutoCommit(false);
            update = this.conn.prepareStatement(updateCaptureTable);
            update.setString(1, name);
            update.setString(2, depList);
            update.setInt(3, depCount);
            update.setString(4, fileName);
            update.setInt(5, seq);
            update.setString(6, type);
            update.executeUpdate();
            this.conn.commit();
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (update != null) {
                try {
                    update.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void updateCaptureTableMeta(String meta, int seq, String type) throws ProcessFailedException {
        String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTableMeta", this.conn).getSql();
        try (PreparedStatement update = this.conn.prepareStatement(updateCaptureTable);){
            update.setString(1, meta);
            update.setInt(2, seq);
            update.setString(3, type);
            update.executeUpdate();
            this.conn.commit();
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            try {
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private String[] writeControllerFile(LinkedList<String> files, StringBuilder sb) throws ProcessFailedException {
        String[] ar = new String[2];
        try {
            String fileName = (((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getControllerFileName() + ".xml").toLowerCase();
            if (sb == null) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(LiquibaseActions.getContext().prependCD(fileName.toLowerCase())));
                writer.write(this.getControllerHeader());
                for (String file : files) {
                    writer.write(this.getControllerInclude(file));
                }
                writer.write(this.getControllerFooter());
                writer.close();
            } else {
                ar[0] = fileName;
                ar[1] = this.getControllerHeader();
                for (String file : files) {
                    ar[1] = ar[1] + this.getControllerInclude(file);
                }
                ar[1] = ar[1] + this.getControllerFooter();
            }
            return ar;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected void createOrReplaceParam(HashMap<String, String> params, String key, String value) {
        if (params.containsKey(key)) {
            params.replace(key, value);
        } else {
            params.put(key, value);
        }
    }

    public HashMap<String, String> doSchemaExport() throws ProcessFailedException {
        StringBuilder sb = null;
        HashMap<String, String> params = LiquibaseActions.getAllLbParameters();
        HashMap<String, String> _ret = new HashMap<String, String>();
        boolean isSqlCl = Boolean.parseBoolean(params.get("isSqlCl"));
        boolean report = Boolean.parseBoolean(params.get("report"));
        boolean pubSyns = Boolean.parseBoolean(params.get("synonyms"));
        boolean grants = Boolean.parseBoolean(params.get("grants"));
        if (!isSqlCl || !report) {
            sb = new StringBuilder();
        }
        if (sb == null) {
            LiquibaseActions.getContext().write("\n" + Messages.getString("LB_FLAGS") + "\n");
            LiquibaseActions.getContext().write(Messages.getString("LB_GRANTS") + "\t\t" + grants + "\n");
            LiquibaseActions.getContext().write(Messages.getString("LB_SYNS") + "\t\t" + pubSyns + "\n\n");
        }
        SchemaGeneratorUtils.createCaptureObjects(this.conn);
        boolean split = false;
        if (params.get("split") != null) {
            split = Boolean.parseBoolean(params.get("split"));
        }
        try {
            this.loadCaptureTable(params, sb);
            this.processCaptureTable(params, sb);
            this.sortCaptureTable(sb);
            this.cleanupCaptureTable(sb);
            StopWatch stopWatch = new StopWatch("Method writeChangeLogs", sb);
            if (this.file_names.size() > 0) {
                if (isSqlCl) {
                    LiquibaseActions.getContext().write("\n" + Messages.getString("LB_NO_PARSE") + "\n");
                } else {
                    sb.append("\n").append(Messages.getString("LB_NO_PARSE")).append("\n");
                }
                for (String name : this.file_names) {
                    if (isSqlCl) {
                        LiquibaseActions.getContext().write(name + "\n");
                        continue;
                    }
                    sb.append(name).append("\n");
                }
            }
            LinkedList<String> includes = new LinkedList<String>();
            String writeFiles = QueryUtils.getXMLQueries().getQuery("writeCaptureTable", this.conn).getSql();
            PreparedStatement pstatement = this.conn.prepareStatement(writeFiles);
            ResultSet rs = pstatement.executeQuery();
            while (rs.next()) {
                this.createOrReplaceParam(params, "name", rs.getString(1));
                this.createOrReplaceParam(params, "type", rs.getString(2));
                String filename = rs.getString(3);
                if (split) {
                    this.createOrReplaceParam(params, "filename", rs.getString(2).toLowerCase() + "/" + filename);
                } else {
                    this.createOrReplaceParam(params, "filename", filename);
                }
                this.createOrReplaceParam(params, "ddl", LiquibaseStringUtils.clobToString(rs.getClob(4)));
                if (isSqlCl) {
                    this.writeChangeLog(params);
                } else {
                    _ret.put(filename, this.getChangeLog(params));
                }
                includes.add(params.get("filename"));
            }
            String[] controller = this.writeControllerFile(includes, null);
            _ret.put(controller[0], controller[1]);
            stopWatch.end(sb);
            if (sb != null) {
                sb.append("\n").append(Messages.getString("LB_FLAGS")).append("\n");
                sb.append(Messages.getString("LB_GRANTS")).append("\t\t").append(grants).append("\n");
                sb.append(Messages.getString("LB_SYNS")).append("\t\t").append(pubSyns).append("\n");
                _ret.put(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getScreenFileName(), sb.toString());
            }
            LiquibaseActions.getContext().write("\n");
            HashMap<String, String> hashMap = _ret;
            return hashMap;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            SchemaGeneratorUtils.dropCaptureObjects(this.conn);
        }
    }

    public HashMap<String, String> getApexChangeLogs(HashMap<String, String> params, StringBuilder sb) throws ProcessFailedException {
        HashMap<String, String> ret = new HashMap<String, String>();
        LinkedList<String> names = new LinkedList<String>();
        StringBuilder screen = new StringBuilder();
        Object genApex = null;
        try {
            genApex = SchemaGenerator.newApexVersion(this.conn) ? new APEXExport(true) : new APEXExportV1(true);
        }
        catch (AppNotInstalledException e) {
            throw new ProcessFailedException((Exception)((Object)e), Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        genApex.setConnection(this.conn);
        genApex.setOutStream((OutputStream)LiquibaseActions.getContext().getOutputStream());
        genApex.setCWD(FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext()));
        try {
            genApex.processArgs(LiquibaseActions.getAllApexParameters().toArray(new String[0]));
            genApex.doCapture();
            LinkedHashMap data = genApex.getClobData();
            for (Map.Entry item : data.entrySet()) {
                String fileName = (String)item.getKey();
                fileName = fileName.replace(".sql", ".xml");
                names.add(fileName);
                Clob script = (Clob)item.getValue();
                params.put("name", "SCRIPT");
                params.put("type", "APEX");
                String ddl = LiquibaseStringUtils.clobToString(script);
                if (ddl.endsWith("/\n")) {
                    ddl = ddl.replaceAll("/\n$", "");
                }
                params.put("ddl", ddl);
                params.put("filename", fileName);
                ret.put(fileName, this.getChangeLog(params));
            }
            if (data.size() > 1) {
                String[] controller = this.writeControllerFile(names, sb);
                ret.put(controller[0], controller[1]);
                screen.append(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getControllerFileName().toLowerCase()));
            } else if (data.size() == 1) {
                String filename = (String)data.keySet().toArray()[0];
                screen.append(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), filename.replace(".sql", ".xml")));
            }
            ret.put(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getScreenFileName(), screen.toString());
            return ret;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public String getChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        params = this.cleanDdlParam(params);
        String oType = params.get("type");
        String oName = params.get("name");
        String ddlXml = params.get("ddl");
        String fail = params.get("fail");
        String context = params.get("context");
        String label = params.get("label");
        boolean replace = Boolean.parseBoolean(params.get("replace"));
        boolean runonchange = Boolean.parseBoolean(params.get("runonchange"));
        boolean runalways = Boolean.parseBoolean(params.get("runalways"));
        boolean disableTrans = false;
        String schema = "";
        String rawChangeLogString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.9.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" failOnError=\"%FAILONERROR%\" %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
        String change = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog \n\txmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n\txsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n\thttp://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.9.xsd\">\n\t<changeSet id=\"%ID%\" author=\"%AUTHOR%\" failOnError=\"%FAILONERROR%\" %CONTEXTS% %LABELS% %RUNOPTIONS% >\n\t\t<n0:%CHANGE_TYPE% objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% >\n\t\t\t<n0:source><![CDATA[%SOURCE%]]></n0:source>\n\t\t</n0:%CHANGE_TYPE%>\n\t</changeSet>\n</databaseChangeLog>\n";
        try {
            schema = this.conn.getSchema();
            change = LiquibaseStringUtils.replaceVal("%ID%", this.getSha1fromString(ddlXml), change);
            change = LiquibaseStringUtils.replaceVal("%AUTHOR%", "(" + this.conn.getSchema() + ")-Generated", change);
            if (oName != null) {
                change = LiquibaseStringUtils.replaceVal("%OBJECT_NAME%", oName.replaceAll("\"", ""), change);
            }
            if (oType != null) {
                change = LiquibaseStringUtils.replaceVal("%OBJECT_TYPE%", oType, change);
            }
            if (schema != null) {
                change = LiquibaseStringUtils.replaceVal("%OWNER_NAME%", schema, change);
            }
            change = LiquibaseStringUtils.replaceVal("%SOURCE%", ddlXml.replaceAll("\\]\\]\\>", "]]]]><![CDATA[>"), change);
            if (DbmsMetaUtils.isSxmlType(oType.toUpperCase())) {
                change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createSxmlObject", change);
            } else if ("SCRIPT".equalsIgnoreCase(oType) || "ORDS".equalsIgnoreCase(oType)) {
                change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", change);
                change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
            } else if ("COMMENT".equalsIgnoreCase(oType)) {
                change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createOracleComment", change);
                change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
            } else if ("APEX".equalsIgnoreCase(oType)) {
                change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", change);
                change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", change);
                disableTrans = true;
            } else {
                change = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", ddlChangeTypes.get(oType.toUpperCase()), change);
            }
            change = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "", change);
            if ("TRIGGER".equals(oType)) {
                change = change.replaceAll("\\nALTER TRIGGER", "\n/\nALTER TRIGGER");
            }
            change = LiquibaseStringUtils.replaceVal("%FAILONERROR%", fail, change);
            change = replace ? LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"true\"", change) : LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", null, change);
            change = context != null && !context.isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + context + "\"", change) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, change);
            change = label != null && !label.isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + label + "\"", change) : LiquibaseStringUtils.replaceVal("%LABELS%", null, change);
            Object runOptions = "";
            if (runonchange) {
                runOptions = "runOnChange=\"true\" ";
            }
            if (runalways) {
                runOptions = (String)runOptions + "runAlways=\"true\" ";
            }
            if (disableTrans) {
                runOptions = (String)runOptions + "runInTransaction=\"false\" ";
            }
            change = runOptions != null && !((String)runOptions).isEmpty() ? LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", (String)runOptions, change) : LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", null, change);
            return change;
        }
        catch (Exception e) {
            LiquibaseActions.log(LiquibaseActions.exceptionToString(e), this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public String getMasterLog() throws ProcessFailedException {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-4.3.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n";
    }

    public String getOrdsChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        String module = params.get("name");
        boolean enable = Boolean.parseBoolean(params.get("enable"));
        boolean privs = Boolean.parseBoolean(params.get("privs"));
        Statement stmt = null;
        try {
            if (params.get("name") != null && !params.get("name").isEmpty()) {
                String ordsQuery = "begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setString(2, module);
                stmt.setInt(3, enable ? 0 : 1);
                stmt.setInt(4, privs ? 0 : 1);
            } else {
                String ordsQuery = "begin ? := ords_metadata.ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setInt(2, enable ? 0 : 1);
                stmt.setInt(3, privs ? 0 : 1);
            }
            stmt.execute();
            Clob script = stmt.getClob(1);
            this.createOrReplaceParam(params, "name", "SCRIPT");
            this.createOrReplaceParam(params, "type", "ORDS");
            this.createOrReplaceParam(params, "ddl", LiquibaseStringUtils.clobToString(script));
            String string = this.getChangeLog(params);
            return string;
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void writeChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        block22: {
            BufferedWriter xmlwriter = null;
            BufferedWriter sqlwriter = null;
            try {
                String data = this.getChangeLog(params);
                String cwd = FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext());
                Path path = Paths.get(cwd + "/" + params.get("filename"), new String[0]);
                File file = path.toFile();
                File dir = path.getParent().toFile();
                dir.mkdirs();
                xmlwriter = new BufferedWriter(new FileWriter(file));
                xmlwriter.write(data);
                if (!LiquibaseActions.getBoolenParameter("sql")) break block22;
                Path sqlPath = Paths.get(cwd + "/" + params.get("filename").replace(".xml", ".sql"), new String[0]);
                File sqlFile = sqlPath.toFile();
                sqlwriter = new BufferedWriter(new FileWriter(sqlFile));
                if (ddlChangeTypes.containsKey(params.get("type"))) {
                    if (LiquibaseActions.getBoolenParameter("emit_schema")) {
                        sqlwriter.write(params.get("ddl"));
                    } else {
                        sqlwriter.write(params.get("ddl").replaceAll("\"" + this.conn.getSchema() + "\"[.]", ""));
                    }
                    break block22;
                }
                try {
                    String sql = DbmsMetaUtils.getDdlFromSxml(this.conn, params.get("ddl"), params.get("type"));
                    if (LiquibaseActions.getBoolenParameter("emit_schema")) {
                        sqlwriter.write(sql);
                        break block22;
                    }
                    sqlwriter.write(sql.replaceAll("\"" + this.conn.getSchema() + "\"[.]", ""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                LiquibaseActions.log(LiquibaseActions.exceptionToString(e), this.getClass());
                if (e instanceof ProcessFailedException) {
                    throw (ProcessFailedException)e;
                }
                throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
            }
            finally {
                try {
                    if (xmlwriter != null) {
                        xmlwriter.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (sqlwriter != null) {
                        sqlwriter.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeChangeLogMap(HashMap<String, String> logs, ScriptRunnerContext ctx) throws ProcessFailedException {
        BufferedWriter writer = null;
        try {
            String cwd = FileUtils.getCWD((ScriptRunnerContext)ctx);
            for (Map.Entry<String, String> entry : logs.entrySet()) {
                String filename = entry.getKey();
                if (filename.equals(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getScreenFileName())) continue;
                String log = entry.getValue();
                Path path = Paths.get(cwd + "/" + filename, new String[0]);
                File file = path.toFile();
                File dir = path.getParent().toFile();
                boolean mkdirs = dir.mkdirs();
                if (!mkdirs && !dir.exists()) {
                    throw new ProcessFailedException(null, Thread.currentThread().getStackTrace()[1].getMethodName());
                }
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(log);
                writer.close();
                if (ctx == null || ctx.getOutputStream() == null) continue;
                Scope.getCurrentScope().getUI().sendMessage(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), file.getName()));
            }
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void writeMasterLog(Path path) throws ProcessFailedException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile()));
            writer.write(this.getMasterLog());
            writer.close();
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public void writeOrdsChangeLog(HashMap<String, String> params) throws ProcessFailedException {
        String module = params.get("name");
        boolean enable = Boolean.parseBoolean(params.get("enable"));
        boolean privs = Boolean.parseBoolean(params.get("privs"));
        Statement stmt = null;
        Clob script = null;
        try {
            if (params.get("name") != null && !params.get("name").isEmpty()) {
                String ordsQuery = "begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setString(2, module);
                stmt.setInt(3, enable ? 0 : 1);
                stmt.setInt(4, privs ? 0 : 1);
            } else {
                String ordsQuery = "begin ? := ords_metadata.ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
                stmt = this.conn.prepareCall(ordsQuery);
                stmt.registerOutParameter(1, 2005);
                stmt.setInt(2, enable ? 0 : 1);
                stmt.setInt(3, privs ? 0 : 1);
            }
            stmt.execute();
            script = stmt.getClob(1);
            this.createOrReplaceParam(params, "name", "SCRIPT");
            this.createOrReplaceParam(params, "type", "ORDS");
            this.createOrReplaceParam(params, "ddl", LiquibaseStringUtils.clobToString(script));
            this.writeChangeLog(params);
        }
        catch (Exception e) {
            LiquibaseActions.log(e, this.getClass());
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static {
        ddlChangeTypes = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("CONSTRAINT", "createOracleConstraint");
                this.put("REF_CONSTRAINT", "createOracleRefConstraint");
                this.put("DIMENSION", "createOracleDimension");
                this.put("FUNCTION", "createOracleFunction");
                this.put("PROCEDURE", "createOracleProcedure");
                this.put("PACKAGE_SPEC", "createOraclePackageSpec");
                this.put("PACKAGE_BODY", "createOraclePackageBody");
                this.put("TYPE_SPEC", "createOracleTypeSpec");
                this.put("TYPE_BODY", "createOracleTypeBody");
                this.put("PUBLIC_SYNONYM", "createOraclePublicSynonym");
                this.put("SYNONYM", "createOracleSynonym");
                this.put("OBJECT_GRANT", "createOracleGrant");
                this.put("DB_LINK", "createOracleDbLink");
                this.put("TRIGGER", "createOracleTrigger");
                this.put("JOB", "createOracleJob");
                this.put("DIRECTORY", "createOracleDirectory");
                this.put("COMMENT", "createOracleComment");
            }
        };
        ordered_types_short = new LinkedHashMap<String, Integer>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("TYPE_SPEC", 10);
                this.put("TYPE_BODY", 20);
                this.put("SEQUENCE", 30);
                this.put("DIRECTORY", 40);
                this.put("CLUSTER", 50);
                this.put("TABLE", 60);
                this.put("MATERIALIZED_VIEW_LOG", 70);
                this.put("MATERIALIZED_VIEW", 80);
                this.put("VIEW", 90);
                this.put("DIMENSION", 110);
                this.put("FUNCTION", 120);
                this.put("PROCEDURE", 130);
                this.put("PACKAGE_SPEC", 140);
                this.put("DB_LINK", 150);
                this.put("SYNONYM", 160);
                this.put("INDEX", 170);
                this.put("TRIGGER", 180);
                this.put("PACKAGE_BODY", 190);
                this.put("JOB", 200);
                this.put("PUBLIC_SYNONYM", 210);
                this.put("OBJECT_GRANT", 220);
            }
        };
        ordered_types_long = new LinkedHashMap<String, Integer>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("TYPE_SPEC", 10);
                this.put("TYPE_BODY", 20);
                this.put("SEQUENCE", 30);
                this.put("DIRECTORY", 40);
                this.put("CLUSTER", 50);
                this.put("TABLE", 60);
                this.put("MATERIALIZED_VIEW_LOG", 70);
                this.put("MATERIALIZED_VIEW", 80);
                this.put("VIEW", 90);
                this.put("REF_CONSTRAINT", 100);
                this.put("DIMENSION", 110);
                this.put("FUNCTION", 120);
                this.put("PROCEDURE", 130);
                this.put("PACKAGE_SPEC", 140);
                this.put("DB_LINK", 150);
                this.put("SYNONYM", 160);
                this.put("INDEX", 170);
                this.put("TRIGGER", 180);
                this.put("PACKAGE_BODY", 190);
                this.put("JOB", 200);
                this.put("PUBLIC_SYNONYM", 210);
                this.put("OBJECT_GRANT", 220);
            }
        };
        typeNameTransform = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("PACKAGE_SPEC", "PACKAGE");
                this.put("PACKAGE_BODY", "PACKAGE BODY");
                this.put("TYPE_SPEC", "TYPE");
                this.put("TYPE_BODY", "TYPE BODY");
                this.put("MATERIALIZED_VIEW_LOG", "MATERIALIZED VIEW LOG");
                this.put("MATERIALIZED_VIEW", "MATERIALIZED VIEW");
                this.put("DB_LINK", "DATABASE LINK");
                this.put("PUBLIC_SYNONYM", "PUBLIC SYNONYM");
            }
        };
    }
}

