/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.exception.CustomSqlException;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.util.LiquibaseFileUtils;
import oracle.dbtools.raptor.liquibase.util.NullOutputStream;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SchemaGeneratorUtils {
    public static void createCaptureObjects(Connection conn) throws ProcessFailedException {
        try {
            if (SchemaGeneratorUtils.doesCaptureTableExist(conn)) {
                SchemaGeneratorUtils.dropCaptureTable(conn);
            }
            SchemaGeneratorUtils.createCaptureTable(conn);
            if (!SchemaGeneratorUtils.doesCapturePackageExist(conn)) {
                SchemaGeneratorUtils.createCapturePackage(conn);
            }
        }
        catch (Exception e) {
            LiquibaseActions.log(e, LiquibaseFileUtils.class);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static void createCapturePackage(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String createOrderRowProc = QueryUtils.getXMLQueries().getQuery("createCapturePackage", conn).getSql();
        m_executor.setStmt(createOrderRowProc);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static void createCaptureTable(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String createCaptureTable = QueryUtils.getXMLQueries().getQuery("createCaptureTable", conn).getSql();
        m_executor.setStmt(createCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static boolean doesCapturePackageExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbPackage", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static boolean doesCaptureTableExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbtable", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static void dropCaptureObjects(Connection conn) throws ProcessFailedException {
        try {
            SchemaGeneratorUtils.dropCapturePackage(conn);
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
        try {
            SchemaGeneratorUtils.dropCaptureTable(conn);
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
    }

    public static void dropCapturePackage(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCapturePackage = QueryUtils.getXMLQueries().getQuery("dropCapturePackage", conn).getSql();
        m_executor.setStmt(dropCapturePackage);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static void dropCaptureTable(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCaptureTable = QueryUtils.getXMLQueries().getQuery("dropCaptureTable", conn).getSql();
        m_executor.setStmt(dropCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }
}

