/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import liquibase.Scope;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.util.SecureLogFilter;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class LiquibaseFileUtils {
    static String logFileName = null;
    static String errorFileName = null;
    static FileHandler logHandler = null;

    private static FileHandler configureLogging(Level logLevel, File logFile) throws IOException {
        Handler logHandler = null;
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        logService.setParent(liquibaseLogger);
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = logLevel;
        if (logFile != null) {
            if (logHandler == null) {
                logHandler = new FileHandler(logFile.getAbsolutePath(), true);
                logHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(logHandler);
            }
            logHandler.setLevel(logLevel);
            if (logLevel == Level.OFF) {
                logHandler.setLevel(Level.FINE);
            }
            cliLogLevel = Level.OFF;
        }
        rootLogger.setLevel(logLevel);
        liquibaseLogger.setLevel(logLevel);
        for (Handler handler : rootLogger.getHandlers()) {
            if (handler instanceof ConsoleHandler) {
                handler.setLevel(cliLogLevel);
            }
            handler.setFilter(new SecureLogFilter(logService.getFilter()));
        }
        return logHandler;
    }

    public static void cleanup() {
        if (logHandler != null) {
            logHandler.flush();
            logHandler.close();
        }
    }

    public static void enableLogging() throws IOException {
        String fName = "liquibase";
        if (LiquibaseActions.getLbParameter("changelog") != null || !"".equals(LiquibaseActions.getLbParameter("changelog"))) {
            fName = LiquibaseActions.getLbParameter("changelog");
        }
        logFileName = fName + "-exe-" + new Date().getTime() + ".log";
        errorFileName = fName + "-err-" + new Date().getTime() + ".log";
        File logFile = LiquibaseFileUtils.getFile(LiquibaseActions.getContext(), logFileName, false);
        logHandler = LiquibaseActions.getBoolenParameter("debug") ? LiquibaseFileUtils.configureLogging(Level.FINEST, logFile) : LiquibaseFileUtils.configureLogging(Level.INFO, logFile);
    }

    public static File getFile(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        return LiquibaseFileUtils.getPath(ctx, fileName, create).toFile();
    }

    public static String getFileString(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        return LiquibaseFileUtils.getPath(ctx, fileName, create).toString();
    }

    public static Path getPath(ScriptRunnerContext ctx, String fileName, boolean create) throws IOException {
        Path out = null;
        if (fileName == null) {
            return Paths.get(ctx.prependCD(""), new String[0]);
        }
        String[] parts = fileName.split("\\.");
        String front = parts.length > 1 ? parts[0] : fileName;
        out = fileName.contains(ctx.prependCD("")) ? Paths.get(fileName, new String[0]) : Paths.get(ctx.prependCD(fileName), new String[0]);
        int i = 1;
        Object oldfront = front;
        String newfront = (String)oldfront + i;
        while (Files.exists(out, new LinkOption[0])) {
            out = Paths.get(out.toString().replace((CharSequence)oldfront, newfront), new String[0]);
            oldfront = newfront;
            newfront = front + ++i;
        }
        if (create) {
            out.toFile().createNewFile();
        }
        return out;
    }

    public static void writeErrorLog(String data) throws IOException {
        errorFileName = LiquibaseActions.getLbParameter("changelog") + "-err-" + new Date().getTime() + ".log";
        File file = LiquibaseFileUtils.getFile(LiquibaseActions.getContext(), errorFileName, true);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
    }

    public static String writeFile(ScriptRunnerContext ctx, String fileName, String data) throws IOException {
        File file = LiquibaseFileUtils.getFile(LiquibaseActions.getContext(), fileName, true);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(data);
        writer.close();
        return file.getName();
    }
}

