/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseCommand;

public class QueryUtils {
    static QueryXMLSupport s_xml = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(Connection conn, String oName, String oType) {
        String objectExistsQuery = QueryUtils.getXMLQueries().getQuery("objectExistsQuery", conn).getSql();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int count = 0;
            stmt = conn.prepareStatement(objectExistsQuery);
            stmt.setString(1, oName);
            if (SchemaGenerator.typeNameTransform.containsKey(oType)) {
                stmt.setString(2, SchemaGenerator.typeNameTransform.get(oType));
            } else {
                stmt.setString(2, oType);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getSchedulerObjectType(String name, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_NAME", name);
        return dbUtil.executeReturnOneCol("select object_type from all_objects where object_name = :OBJECT_NAME and rownum = 1", binds);
    }

    public static String getXmlFromActionsLog(Connection conn, AbstractOracleStatement statement) throws ProcessFailedException {
        String string;
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(actionLogSxmlQuery);
            stmt.setString(1, statement.getId());
            stmt.setString(2, statement.getAuthor());
            stmt.setString(3, statement.getFile());
            rs = stmt.executeQuery();
            while (rs.next()) {
                Clob sxml = rs.getClob(1);
                if (sxml == null) {
                    String string2 = null;
                    return string2;
                }
                sb.append(LiquibaseStringUtils.clobToString(sxml));
            }
            string = sb.toString();
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(LiquibaseCommand.class.getClassLoader(), "oracle/dbtools/raptor/scriptrunner/commands/liquibase/cmQueries.xml"));
        }
        return s_xml;
    }

    public static String runSqlReturnResult(String sql, Connection conn) throws ProcessFailedException {
        try {
            return QueryUtils.runSqlReturnResult(sql, conn, false);
        }
        catch (DatabaseException e) {
            LiquibaseActions.log((Exception)((Object)e), QueryUtils.class);
            throw new ProcessFailedException((Exception)((Object)e), e.getStackTrace()[0].getMethodName());
        }
    }

    public static String runSqlReturnResult(String sql, Connection conn, boolean scan) throws DatabaseException {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(sql);
            ScriptExecutor runner = new ScriptExecutor((Reader)rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            ctx.setSubstitutionOn(scan);
            ctx.setScanOn(scan);
            ctx.setSqlError(4);
            ctx.putProperty("sqlplus.error.logging", (Object)true);
            ctx.putProperty("script.runner.exit_int_whenever", (Object)2);
            ctx.putProperty("script.runner.exit_int_whenever.wassqlcode", (Object)true);
            ctx.setBaseConnection(conn);
            ctx.setCurrentConnection(conn);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            if (((Boolean)runner.getScriptRunnerContext().getProperty("sqldev.error")).booleanValue()) {
                if (BaS.toString().length() > 0) {
                    throw new DatabaseException(BaS.toString(encoding).trim());
                }
                throw new DatabaseException((String)runner.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode"));
            }
            String type = (String)ctx.getProperty("sqldev.last.err.type");
            if (type != null) {
                throw new DatabaseException(BaS.toString(encoding).trim());
            }
            return LiquibaseStringUtils.stripCR(BaS.toString(encoding));
        }
        catch (UnsupportedEncodingException e) {
            LiquibaseActions.log(e, QueryUtils.class);
            throw new DatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static int updateTable(String sql, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        return dbUtil.executeUpdate(sql, new HashMap());
    }
}

