/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.ui.ConsoleUIService;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.liquibase.core.LiquibaseActions;
import oracle.dbtools.raptor.liquibase.core.Messages;
import oracle.dbtools.raptor.liquibase.exception.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.tokenizer.ArgumentTokenizer;
import oracle.dbtools.raptor.liquibase.util.LiquibaseFileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExport;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportV1;
import oracle.dbtools.raptor.newscriptrunner.apex.AppNotInstalledException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;

public class LiquibaseCommand
extends CommandListener
implements IHelp,
SQLCLService {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private static String version = "2221";
    private static final List<String> commands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("genobject");
            this.add("genschema");
            this.add("gencontrolfile");
            this.add("update");
            this.add("updatesql");
            this.add("rollback");
            this.add("rollbacksql");
            this.add("diff");
            this.add("dbdoc");
            this.add("status");
            this.add("validate");
            this.add("changelogsync");
            this.add("listlocks");
            this.add("releaselocks");
            this.add("clearchecksums");
            this.add("help");
            this.add("version");
            this.add("data");
            this.add("tag");
            this.add("tagexists");
        }
    };
    final String NAME = "Liquibase Command";

    private static String getBanner() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        Object myVersion = LiquibaseUtil.getBuildVersionInfo();
        String buildTimeString = LiquibaseUtil.getBuildTime();
        StringBuilder banner = new StringBuilder();
        banner.append(String.format(coreBundle.getString("starting.liquibase.at.timestamp"), dateFormat.format(calendar.getTime())));
        if (StringUtil.isNotEmpty((String)myVersion) && StringUtil.isNotEmpty((String)buildTimeString)) {
            myVersion = (String)myVersion + " #" + LiquibaseUtil.getBuildNumber();
            banner.append(String.format(coreBundle.getString("liquibase.version.builddate"), myVersion, buildTimeString));
        }
        return banner.toString().replace("0000", version);
    }

    private static String getLbVersion() throws ProcessFailedException {
        String myVersion = LiquibaseUtil.getBuildVersionInfo() + " #" + LiquibaseUtil.getBuildNumber();
        String buildTimeString = LiquibaseUtil.getBuildTime().replace("0000", version);
        StringBuilder sb = new StringBuilder();
        sb.append("\nLiquibase version:   " + String.format(" %s built at %s", myVersion, buildTimeString));
        sb.append("\nExtension Version:   " + Messages.getString("SQLclVersion.VERSION"));
        sb.append("\n\n");
        return sb.toString();
    }

    private String checkArg(String parm) throws ProcessFailedException {
        if (parm == null || parm.startsWith("-")) {
            throw new ProcessFailedException((Exception)new InvalidParameterException("Bad Arguemnt value " + parm), "checkArg");
        }
        return parm;
    }

    private void printArgs(ScriptRunnerContext ctx) {
        System.out.println(Collections.singletonList(LiquibaseActions.getAllLbParameters()));
    }

    private void processArgs(String cmd, ScriptRunnerContext ctx) throws ProcessFailedException {
        SqlclConfig cfg = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).setContext(ctx);
        cfg.resetAllParms();
        List<String> rawArgs = ArgumentTokenizer.tokenize(cmd, false);
        String[] _args = rawArgs.toArray(new String[0]);
        for (int i = 1; i < _args.length; ++i) {
            try {
                if (!_args[i].startsWith("-")) {
                    if (!commands.contains(_args[i].toLowerCase())) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown command supplied please check your arguments. - " + _args[i]), "processArgs");
                    }
                    if ("help".equalsIgnoreCase(_args[i])) {
                        cfg.setLbParameter("help", "true");
                        if (i == 1) {
                            cfg.setLbParameter("command", "help");
                        }
                        continue;
                    }
                    cfg.setLbParameter("command", _args[i].toLowerCase());
                    continue;
                }
                if ("-id".equalsIgnoreCase(_args[i])) {
                    if (!"tag".equals(cfg.getLbParameter("command")) && !"tagexists".equals(cfg.getLbParameter("command"))) {
                        throw new InvalidParameterException("ERROR: Unknown parameter or bad value supplied " + _args[i]);
                    }
                    cfg.setLbParameter("tag", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-dbChangeLogTable".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("dbChangeLogTable", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-tag".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("tag", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-changelog".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("changelog", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-sql".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("sql", "true");
                    continue;
                }
                if ("-filter".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("filter", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-object".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("object", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-type".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("type", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-name".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("name", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-emit_schema".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("emit_schema", "true");
                    continue;
                }
                if ("-label".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("label", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-context".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("context", this.checkArg(this.checkArg(_args[++i])));
                    continue;
                }
                if ("-count".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("count", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-url".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("url", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-user".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("user", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-password".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("password", this.checkArg(_args[++i]));
                    continue;
                }
                if ("-silent".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("silent", "true");
                    continue;
                }
                if ("-noreport".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("report", "false");
                    continue;
                }
                if ("-debug".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("debug", "true");
                    cfg.addApexParameter("-debug");
                    continue;
                }
                if ("-noenable".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("enable", "false");
                    continue;
                }
                if ("-noprivs".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("privs", "false");
                    continue;
                }
                if ("-synonyms".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("synonyms", "true");
                    continue;
                }
                if ("-grants".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("grants", "true");
                    continue;
                }
                if ("-log".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("log", "true");
                    continue;
                }
                if ("-fail".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("fail", "true");
                    continue;
                }
                if ("-replace".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("replace", "true");
                    continue;
                }
                if ("-runonchange".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("runonchange", "true");
                    continue;
                }
                if ("-runalways".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("runalways", "true");
                    continue;
                }
                if ("-h".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-h");
                    continue;
                }
                if ("-db".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-db");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-user".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-user");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-password".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-password");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-workspaceid".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-workspaceid");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-applicationid".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-applicationid");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-skipExportDate".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-skipExportDate");
                    continue;
                }
                if ("-expPubReports".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expPubReports");
                    continue;
                }
                if ("-expSavedReports".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expSavedReports");
                    continue;
                }
                if ("-expIRNotif".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expIRNotif");
                    continue;
                }
                if ("-expTranslations".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expTranslations");
                    continue;
                }
                if ("-instance".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-instance");
                    continue;
                }
                if ("-expWorkspace".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expWorkspace");
                    continue;
                }
                if ("-expMinimal".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expMinimal");
                    continue;
                }
                if ("-expFiles".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expFiles");
                    continue;
                }
                if ("-expFeedback".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expFeedback");
                    continue;
                }
                if ("-expTeamdevdata".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expTeamdevdata");
                    continue;
                }
                if ("-deploymentSystem".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-deploymentSystem");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-expFeedbackSince".equalsIgnoreCase(_args[i])) {
                    SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                    String mydate = "";
                    try {
                        mydate = this.checkArg(_args[++i]);
                        dtFmt.parse(mydate);
                        cfg.addApexParameter("-expFeedbackSince");
                        cfg.addApexParameter(mydate);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expFeedbackSince " + mydate), "process_args");
                    }
                }
                if ("-expOriginalIds".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expOriginalIds");
                    continue;
                }
                if ("-split".equalsIgnoreCase(_args[i])) {
                    cfg.setLbParameter("split", "true");
                    cfg.addApexParameter("-split");
                    continue;
                }
                if ("-expNoSubscriptions".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expNoSubscriptions");
                    continue;
                }
                if ("-expComments".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expComments");
                    continue;
                }
                if ("-expSupportingObjects".equalsIgnoreCase(_args[i])) {
                    String _expSupportingObjects = this.checkArg(_args[++i]);
                    if (!Arrays.asList("Y", "I", "N").contains(_expSupportingObjects)) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad expSupportingObjects " + this.checkArg(_args[++i])), "process_args");
                    }
                    cfg.addApexParameter("-expSupportingObjects");
                    cfg.addApexParameter(_expSupportingObjects);
                    continue;
                }
                if ("-expACLAssignments".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expACLAssignments");
                    continue;
                }
                if ("-expLocked".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-expLocked");
                    continue;
                }
                if ("-nochecksum".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-nochecksum");
                    continue;
                }
                if ("-dir".equalsIgnoreCase(_args[i])) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -dir "), "process_args");
                    }
                    String dir = _args[++i];
                    cfg.addApexParameter("-dir");
                    cfg.addApexParameter(this.checkArg(dir));
                    cfg.setLbParameter("dir", dir);
                    continue;
                }
                if ("-list".equalsIgnoreCase(_args[i])) {
                    cfg.addApexParameter("-list");
                    continue;
                }
                if ("-changesSince".equalsIgnoreCase(_args[i])) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesSince "), "process_args");
                    }
                    cfg.addApexParameter("-changesSince");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-changesBy".equalsIgnoreCase(_args[i])) {
                    if (i == _args.length - 1) {
                        throw new ProcessFailedException((Exception)new InvalidParameterException("Bad -changesBy "), "process_args");
                    }
                    cfg.addApexParameter("-changesBy");
                    cfg.addApexParameter(this.checkArg(_args[++i]));
                    continue;
                }
                if ("-expComponents".equalsIgnoreCase(_args[i])) {
                    StringBuilder _components = null;
                    while (++i < _args.length) {
                        _components = (_components == null ? new StringBuilder("null") : _components).append("#").append(_args[i]);
                    }
                    cfg.addApexParameter("-expComponents");
                    cfg.addApexParameter(_components == null ? null : _components.toString());
                    continue;
                }
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Unknown parameter or bad value supplied " + _args[i]), "process_args");
            }
            catch (Exception e) {
                LiquibaseActions.log(e, ((Object)((Object)this)).getClass());
                if (e instanceof ProcessFailedException) {
                    throw (ProcessFailedException)e;
                }
                throw new ProcessFailedException(e, "process_args");
            }
        }
        if (LiquibaseActions.getBoolenParameter("debug")) {
            this.printArgs(ctx);
        }
    }

    private void showHelp(Connection conn) {
        ScriptRunnerContext ctx = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getContext();
        String _command = LiquibaseActions.getLbParameter("command");
        String _type = LiquibaseActions.getLbParameter("type");
        if ("genobject".equalsIgnoreCase(_command)) {
            if ("APEX".equalsIgnoreCase(_type)) {
                Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT_APEX"));
            } else if ("ORDS".equalsIgnoreCase(_type)) {
                Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
            } else if (!"".equalsIgnoreCase(_type)) {
                Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT"));
                Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_OBJECT_TYPES"));
            } else {
                this.showObjectHelp(ctx, conn);
            }
        } else if ("genschema".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENSCHEMA"));
        } else if ("gencontrolfile".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENCONTROLFILE"));
        } else if ("update".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_UPDATE"));
        } else if ("updatesql".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_UPDATESQL"));
        } else if ("rollback".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_ROLLBACK"));
        } else if ("rollbacksql".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_ROLLBACKSQL"));
        } else if ("diff".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_DIFF"));
        } else if ("dbdoc".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_DBDOC"));
        } else if ("status".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_STATUS"));
        } else if ("version".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_VERSION"));
        } else if ("validate".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_VALIDATE"));
        } else if ("changelogsync".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_CHANGELOGSYNC"));
        } else if ("listlocks".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_LISTLOCKS"));
        } else if ("releaselocks".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_RELEASELOCKS"));
        } else if ("clearchecksums".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_CLEARCHECKSUMS"));
        } else if ("data".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_DATA"));
        } else if ("tag".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_TAG"));
        } else if ("tagexists".equalsIgnoreCase(_command)) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_TAGEXISTS"));
        } else {
            Scope.getCurrentScope().getUI().sendMessage(this.getHelp());
        }
    }

    private void showObjectHelp(ScriptRunnerContext ctx, Connection conn) {
        Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT"));
        Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_OBJECT_TYPES"));
        Scope.getCurrentScope().getUI().sendMessage("==================================================================\n\n");
        Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT_ORDS"));
        Scope.getCurrentScope().getUI().sendMessage("==================================================================\n\n");
        Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_HELP_GENOBJECT_APEX"));
        try {
            if (conn != null && !SchemaGenerator.newApexVersion(conn)) {
                APEXExportV1.usage((OutputStream)ctx.getOutputStream());
            } else {
                APEXExport.usage((OutputStream)ctx.getOutputStream());
            }
        }
        catch (AppNotInstalledException appNotInstalledException) {
            // empty catch block
        }
    }

    public void beginEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public void endEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public String getCommand() {
        return "LIQUIBASE";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Liquibase change management commands";
    }

    public String getExtensionName() {
        return "Liquibase Command";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        return Messages.getString("LB_HELP_OVERVIEW");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith("lb") && !cmd.getLoweredTrimmedSQL().startsWith("liquibase")) {
            return false;
        }
        ConsoleUIService service = (ConsoleUIService)Scope.getCurrentScope().getUI();
        PrintStream stream = new PrintStream((OutputStream)ctx.getOutputStream(), true);
        service.setOutputStream(stream);
        service.setErrorStream(stream);
        Scope.getCurrentScope().getUI().sendMessage("--" + LiquibaseCommand.getBanner() + System.lineSeparator());
        try {
            this.processArgs(cmd.getSql(), ctx);
            if (LiquibaseActions.getBoolenParameter("log")) {
                LiquibaseFileUtils.enableLogging();
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                if (LiquibaseActions.getBoolenParameter("debug")) {
                    Scope.getCurrentScope().getUI().sendMessage(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR2"), "Location \n" + e.getMessage(), "Message \n" + e1.getMessage()));
                } else {
                    Scope.getCurrentScope().getUI().sendMessage(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
                }
            } else {
                Scope.getCurrentScope().getUI().sendMessage(this.getHelp());
            }
            return true;
        }
        String _command = LiquibaseActions.getLbParameter("command");
        boolean _help = LiquibaseActions.getBoolenParameter("help");
        if (_help) {
            this.showHelp(conn);
            return true;
        }
        try {
            if (conn == null || !conn.isValid(10)) {
                Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_NO_CONNECTION"));
                return true;
            }
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getUI().sendMessage(Messages.getString("LB_NO_CONNECTION"));
            return true;
        }
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "true");
        }
        catch (Exception e1) {
            Scope.getCurrentScope().getUI().sendMessage(MessageFormat.format(Messages.getString("LB_GENERIC_ERROR"), e1.getMessage()));
            return true;
        }
        try {
            if ("genobject".equalsIgnoreCase(_command)) {
                if ("ords".equalsIgnoreCase(LiquibaseActions.getLbParameter("type"))) {
                    LiquibaseActions.genOrdsObjectChangelogWork(conn);
                } else if ("apex".equalsIgnoreCase(LiquibaseActions.getLbParameter("type"))) {
                    LiquibaseActions.genApexObjectChangelogsWork(conn);
                } else {
                    LiquibaseActions.genDbObjectChangelogWork(conn);
                }
            } else if ("genschema".equalsIgnoreCase(_command)) {
                LiquibaseActions.genDbSchemaWork(conn);
            } else if ("gencontrolfile".equalsIgnoreCase(_command)) {
                LiquibaseActions.genControlFileWork(conn);
            } else if ("update".equalsIgnoreCase(_command)) {
                LiquibaseActions.setLbParameter("action", "update");
                LiquibaseActions.doUpdateWork(conn, null);
                LiquibaseActions.setLbParameter("action", "none");
                LiquibaseActions.reportErrors();
            } else if ("updatesql".equalsIgnoreCase(_command)) {
                LiquibaseActions.setLbParameter("action", "update");
                LiquibaseActions.doUpdateWork(conn, new StringWriter());
                LiquibaseActions.setLbParameter("action", "none");
            } else if ("rollback".equalsIgnoreCase(_command)) {
                LiquibaseActions.setLbParameter("action", "rollback");
                LiquibaseActions.doRollbackWork(conn, null);
                LiquibaseActions.setLbParameter("action", "none");
                LiquibaseActions.reportErrors();
            } else if ("rollbacksql".equalsIgnoreCase(_command)) {
                LiquibaseActions.setLbParameter("action", "rollback");
                LiquibaseActions.doRollbackWork(conn, new StringWriter());
                LiquibaseActions.setLbParameter("action", "none");
                LiquibaseActions.reportErrors();
            } else if ("diff".equalsIgnoreCase(_command)) {
                LiquibaseActions.genDiffWork(conn);
            } else if ("dbdoc".equalsIgnoreCase(_command)) {
                LiquibaseActions.genDbDocWork(conn);
            } else if ("status".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbStatusWork(conn);
            } else if ("tag".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbTagWork(conn);
            } else if ("tagexists".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbTagExistsWork(conn);
            } else if ("validate".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbValidateWork(conn);
            } else if ("changelogsync".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbChangeLogSyncWork(conn);
            } else if ("listlocks".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbListLocksWork(conn);
            } else if ("releaselocks".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbReleaseLocksWork(conn);
            } else if ("clearchecksums".equalsIgnoreCase(_command)) {
                LiquibaseActions.lbClearCheckSumsWork(conn);
            } else if ("data".equalsIgnoreCase(_command)) {
                LiquibaseActions.genTableDataWork(conn);
            } else if ("version".equalsIgnoreCase(_command)) {
                Scope.getCurrentScope().getUI().sendMessage(LiquibaseCommand.getLbVersion());
            } else {
                Scope.getCurrentScope().getUI().sendMessage(this.getHelp());
            }
            ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).resetAllParms();
            boolean e1 = true;
            return e1;
        }
        catch (Exception e) {
            LiquibaseActions.report(e, ((Object)((Object)this)).getClass());
            ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).resetAllParms();
            boolean bl = true;
            return bl;
        }
        finally {
            LiquibaseFileUtils.cleanup();
        }
    }

    public boolean isSqlPlus() {
        return false;
    }
}

