/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Hashtable;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;

public class CMPUtils {
    private static Hashtable algoNamemap = null;
    private static Hashtable algoIdmap = null;
    private static Hashtable algoOIDmap = null;
    public static final String DEFAULT_RandomGenerator_ALGO = "SHA1PRNG";
    public static final String DEFAULT_RSA_Signature_Algo = "MD5withRSA";
    public static final String DEFAULT_DSA_Signature_Algo = "SHA-1withDSA";
    public static final String HASH_ALG_MD5 = "MD5";
    public static final String HASH_ALG_MD2 = "MD2";
    public static final String HASH_ALG_SHA_1 = "SHA-1";

    private static void setMapping() {
        algoNamemap = new Hashtable();
        algoIdmap = new Hashtable();
        CMPUtils.setAlgoName("SHA1", CMP.sha_1);
        CMPUtils.setAlgoName(HASH_ALG_MD5, CMP.md5);
        CMPUtils.setAlgoName(DEFAULT_DSA_Signature_Algo, CMP.id_dsa_with_sha_1);
        CMPUtils.setAlgoName("SHAwithDSA", CMP.dsaWithSHA);
        CMPUtils.setAlgoName("MD2withRSA", AlgID.md2WithRSAEncryption);
        CMPUtils.setAlgoName(DEFAULT_RSA_Signature_Algo, AlgID.md5WithRSAEncryption);
        CMPUtils.setAlgoName("SHA1withRSA", AlgID.sha_1WithRSAEncryption);
        CMPUtils.setAlgoName("RSA/ /NoPadding", CMP.rsaEncryption);
        CMPUtils.setAlgoName("RSA", CMP.rsaEncryption);
        CMPUtils.setAlgoName("RSA/ /PKCS1Padding", CMP.rsaEncryption);
        CMPUtils.setAlgoName("DESede/ /PKCS5Padding", CMP.id_alg_CMS3DESwrap);
        CMPUtils.setAlgoName("DESede", CMP.id_alg_CMS3DESwrap);
        CMPUtils.setAlgoName("DES/CBC/PKCS5Padding", AlgID.desCBC);
        CMPUtils.setAlgoName("DES/CBC/NoPadding", AlgID.desCBC);
        CMPUtils.setAlgoName("RC2/ /PKCS5Padding", CMP.id_alg_CMSRC2wrap);
        CMPUtils.setAlgoName("RC2", CMP.id_alg_CMSRC2wrap);
        CMPUtils.setAlgoName("DESede/CBC/PKCS5Padding", CMP.des_ede3_cbc);
        CMPUtils.setAlgoName("DESede/CBC/NoPadding", CMP.des_ede3_cbc);
        CMPUtils.setAlgoName("RC2/CBC/PKCS5Padding", CMP.rc2_cbc);
        CMPUtils.setAlgoName("RC2/CBC/NoPadding", CMP.rc2_cbc);
        CMPUtils.setAlgoName("HmacSHA1", CMP.hmac_SHA_1);
    }

    private static void setOIDMapping() {
        algoOIDmap = new Hashtable();
        algoOIDmap.put(CMP.sha_1.getOID(), HASH_ALG_SHA_1);
        algoOIDmap.put(CMP.md5.getOID(), HASH_ALG_MD5);
        algoOIDmap.put(CMP.id_dsa_with_sha_1.getOID(), DEFAULT_DSA_Signature_Algo);
        algoOIDmap.put(CMP.dsaWithSHA.getOID(), "SHAwithDSA");
        algoOIDmap.put(CMP.rsaEncryption.getOID(), "RSA/ /PKCS1Padding");
        algoOIDmap.put(AlgID.md2WithRSAEncryption.getOID(), "MD2withRSA");
        algoOIDmap.put(AlgID.md5WithRSAEncryption.getOID(), DEFAULT_RSA_Signature_Algo);
        algoOIDmap.put(AlgID.sha_1WithRSAEncryption.getOID(), "SHA1withRSA");
        algoOIDmap.put(CMP.id_alg_CMS3DESwrap.getOID(), "DESede");
        algoOIDmap.put(AlgID.desCBC.getOID(), "DES/CBC/NoPadding");
        algoOIDmap.put(CMP.id_alg_CMSRC2wrap.getOID(), "RC2");
        algoOIDmap.put(CMP.des_ede3_cbc.getOID(), "DESede/CBC/NoPadding");
        algoOIDmap.put(CMP.rc2_cbc.getOID(), "RC2/CBC/NoPadding");
        algoOIDmap.put(CMP.hmac_SHA_1.getOID(), "HmacSHA1");
    }

    private static AlgorithmIdentifier setAlgoName(String name, AlgorithmIdentifier oid) {
        algoNamemap.put(oid, name);
        return algoIdmap.put(name.toUpperCase(), oid);
    }

    public static AlgorithmIdentifier getAlgoID(String name) throws NoSuchAlgorithmException {
        AlgorithmIdentifier oid;
        if (algoIdmap == null) {
            CMPUtils.setMapping();
        }
        if ((oid = (AlgorithmIdentifier)algoIdmap.get(name.toUpperCase())) == null) {
            throw new NoSuchAlgorithmException();
        }
        return oid;
    }

    public static String getAlgoName(AlgorithmIdentifier oid) throws NoSuchAlgorithmException {
        return CMPUtils.getAlgoName(oid, false);
    }

    public static String getAlgoName(AlgorithmIdentifier oid, boolean removeMode) throws NoSuchAlgorithmException {
        String name;
        if (algoNamemap == null) {
            CMPUtils.setMapping();
        }
        if ((name = (String)algoNamemap.get(oid)) == null) {
            if (algoOIDmap == null) {
                CMPUtils.setOIDMapping();
            }
            if ((name = (String)algoOIDmap.get(oid.getOID())) == null) {
                throw new NoSuchAlgorithmException();
            }
            if (removeMode) {
                return CMPUtils.removeMode(name);
            }
            return name;
        }
        if (removeMode) {
            return CMPUtils.removeMode(name);
        }
        return name;
    }

    private static String removeMode(String name) {
        int index = name.indexOf(47);
        String algoName = null;
        if (index != -1) {
            algoName = name.substring(0, index);
            return algoName;
        }
        return name;
    }

    public static X509 convertX509(X509Certificate cert) throws CertificateEncodingException {
        try {
            X509 certificate = new X509(cert.getEncoded());
            return certificate;
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IO EXception occured while encoding the certificate");
        }
    }

    public static X509Certificate toJCECertificate(X509 cert) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static X509ExtensionSet getExtensionSet(X509Certificate cert) throws IOException {
        try {
            X509 X509cert = new X509(cert.getEncoded());
            return X509cert.getExtensionSet();
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    public static PublicKey toPhaosPublicKey(java.security.PublicKey pubkey) throws InvalidKeyException {
        if (pubkey instanceof DSAPublicKey) {
            oracle.security.crypto.core.DSAParams params = ((oracle.security.crypto.core.DSAPublicKey)pubkey).getParams();
            oracle.security.crypto.core.DSAParams oraDSAparams = new oracle.security.crypto.core.DSAParams(params.getP(), params.getQ(), params.getG());
            return new oracle.security.crypto.core.DSAPublicKey(((oracle.security.crypto.core.DSAPublicKey)pubkey).getY(), oraDSAparams);
        }
        if (pubkey instanceof java.security.interfaces.RSAPublicKey) {
            return new RSAPublicKey(((java.security.interfaces.RSAPublicKey)pubkey).getModulus(), ((java.security.interfaces.RSAPublicKey)pubkey).getPublicExponent());
        }
        if (pubkey instanceof DHPublicKey) {
            DHParameterSpec params = ((DHPublicKey)pubkey).getParams();
            DHParams oraDHparams = new DHParams(params.getP(), params.getG(), params.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            return new oracle.security.crypto.core.DHPublicKey(((DHPublicKey)pubkey).getY(), oraDHparams);
        }
        throw new InvalidKeyException("Pubickey Format not supported");
    }

    public static java.security.PublicKey toJCEPublicKey(PublicKey orakey) throws NoSuchAlgorithmException {
        if (orakey instanceof oracle.security.crypto.core.DSAPublicKey) {
            try {
                oracle.security.crypto.core.DSAParams dparams = ((oracle.security.crypto.core.DSAPublicKey)orakey).getParams();
                DSAPublicKeySpec dsaspec = new DSAPublicKeySpec(((oracle.security.crypto.core.DSAPublicKey)orakey).getY(), dparams.getP(), dparams.getQ(), dparams.getG());
                KeyFactory kf = KeyFactory.getInstance("DSA");
                return kf.generatePublic(dsaspec);
            }
            catch (InvalidKeySpecException ex) {
                throw new NoSuchAlgorithmException(ex.toString());
            }
        }
        if (orakey instanceof RSAPublicKey) {
            try {
                RSAPublicKeySpec rsaspec = new RSAPublicKeySpec(((RSAPublicKey)orakey).getModulus(), ((RSAPublicKey)orakey).getExponent());
                KeyFactory kf = KeyFactory.getInstance("RSA");
                return kf.generatePublic(rsaspec);
            }
            catch (InvalidKeySpecException ex) {
                throw new NoSuchAlgorithmException(ex.toString());
            }
        }
        if (orakey instanceof oracle.security.crypto.core.DHPublicKey) {
            try {
                DHParams dhparams = ((oracle.security.crypto.core.DHPublicKey)orakey).getParams();
                DHPublicKeySpec dhspec = new DHPublicKeySpec(((oracle.security.crypto.core.DHPublicKey)orakey).getY(), dhparams.getP(), dhparams.getG());
                KeyFactory kf = KeyFactory.getInstance("DH");
                return kf.generatePublic(dhspec);
            }
            catch (InvalidKeySpecException ex) {
                throw new NoSuchAlgorithmException(ex.toString());
            }
        }
        throw new NoSuchAlgorithmException("PublicKey format not supported");
    }

    public static oracle.security.crypto.core.RSAPrivateKey toPhaosRSAPrivateKey(RSAPrivateKey privKey) {
        if (privKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)privKey;
            oracle.security.crypto.core.RSAPrivateKey phaosKey = new oracle.security.crypto.core.RSAPrivateKey(crtKey.getModulus(), crtKey.getPrivateExponent(), crtKey.getPublicExponent(), crtKey.getPrimeP(), crtKey.getPrimeQ(), crtKey.getPrimeExponentP(), crtKey.getPrimeExponentQ(), crtKey.getCrtCoefficient());
            return phaosKey;
        }
        return new oracle.security.crypto.core.RSAPrivateKey(privKey.getModulus(), privKey.getPrivateExponent());
    }

    public static RSAPrivateKey toJCERSAPrivateKey(oracle.security.crypto.core.RSAPrivateKey oraKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(oraKey.getModulus(), oraKey.getPublicExponent(), oraKey.getExponent(), oraKey.getPrimeP(), oraKey.getPrimeQ(), oraKey.getPrimeExponentP(), oraKey.getPrimeExponentQ(), oraKey.getCrtCoefficient());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)kf.generatePrivate(spec);
    }

    public static PrivateKey toPhaosPrivateKey(java.security.PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)privateKey;
            return new oracle.security.crypto.core.RSAPrivateKey(privKey.getModulus(), privKey.getPrivateExponent(), privKey.getPublicExponent(), privKey.getPrimeP(), privKey.getPrimeQ(), privKey.getPrimeExponentP(), privKey.getPrimeExponentQ(), privKey.getCrtCoefficient());
        }
        if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey privKey = (DSAPrivateKey)privateKey;
            DSAParams dp = privKey.getParams();
            return new oracle.security.crypto.core.DSAPrivateKey(privKey.getX(), new oracle.security.crypto.core.DSAParams(dp.getP(), dp.getQ(), dp.getG()));
        }
        if (privateKey instanceof javax.crypto.interfaces.DHPrivateKey) {
            javax.crypto.interfaces.DHPrivateKey privKey = (javax.crypto.interfaces.DHPrivateKey)privateKey;
            DHParameterSpec p = privKey.getParams();
            DHParams params = new DHParams(p.getP(), p.getG(), p.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            return new DHPrivateKey(privKey.getX(), params);
        }
        throw new InvalidKeyException("PrivateKey format not supported");
    }

    public static oracle.security.crypto.core.KeyPair toPhaosKeyPair(KeyPair kp) throws InvalidKeyException {
        return new oracle.security.crypto.core.KeyPair(CMPUtils.toPhaosPublicKey(kp.getPublic()), CMPUtils.toPhaosPrivateKey(kp.getPrivate()));
    }

    public static String addPadding(String algoName) {
        String algName = null;
        int index = algoName.indexOf(47);
        if (index != -1) {
            int lindex = algoName.lastIndexOf(47);
            if (index != lindex) {
                algName = algoName.substring(0, lindex) + "/PKCS5Padding";
            }
        } else {
            algName = algoName + "/ /PKCS5Padding";
        }
        return algName;
    }
}

