/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class Challenge
implements ASN1Object {
    private AlgorithmIdentifier digestAlg;
    private byte[] witness;
    private BigInteger randomInt;
    private GeneralName sender;
    private byte[] challenge;
    private boolean decrypted;
    private transient ASN1Object contents;

    public Challenge() {
    }

    public Challenge(AlgorithmIdentifier digestAlg, BigInteger randomInt, GeneralName sender, PublicKey pubKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this(MessageDigest.getInstance(CMPUtils.getAlgoName(digestAlg)).digest(randomInt.toByteArray()), randomInt, sender, pubKey);
        this.digestAlg = digestAlg;
    }

    public Challenge(byte[] witness, BigInteger randomInt, GeneralName sender, PublicKey pubKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.witness = witness;
        this.randomInt = randomInt;
        this.sender = sender;
        ASN1Sequence rand = new ASN1Sequence();
        rand.addElement((ASN1Object)new ASN1Integer(randomInt));
        rand.addElement((ASN1Object)sender);
        String algo = pubKey.getAlgorithm();
        if (algo.indexOf("RSA") != -1) {
            algo = "RSA/ /PKCS1Padding";
        }
        Cipher c = Cipher.getInstance(algo);
        c.init(1, pubKey);
        this.challenge = c.doFinal(Utils.toBytes((Streamable)rand));
        this.decrypted = true;
    }

    public Challenge(InputStream is) throws IOException {
        this.input(is);
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlg;
    }

    public byte[] getWitness() {
        return this.witness;
    }

    public BigInteger getRandomInt(PrivateKey privKey) throws NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this.decrypt(privKey);
        return this.randomInt;
    }

    public GeneralName getSender(PrivateKey privKey) throws NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this.decrypt(privKey);
        return this.sender;
    }

    private void decrypt(PrivateKey privKey) throws NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        if (!this.decrypted) {
            try {
                String algo = privKey.getAlgorithm();
                if (algo.indexOf("RSA") != -1) {
                    algo = "RSA/ /PKCS1Padding";
                }
                Cipher c = Cipher.getInstance(algo);
                c.init(2, privKey);
                byte[] dkeybytes = c.doFinal(this.challenge);
                ASN1Sequence rand = new ASN1Sequence((InputStream)new UnsyncByteArrayInputStream(dkeybytes));
                this.randomInt = ((ASN1Integer)rand.elementAt(0)).getValue();
                this.sender = new GeneralName(Utils.toStream((Streamable)rand.elementAt(1)));
                this.decrypted = true;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new NoSuchPaddingException(ex.toString());
            }
            catch (InvalidKeyException ex) {
                throw new NoSuchPaddingException(ex.toString());
            }
            catch (IOException ex) {
                throw new NoSuchPaddingException(ex.toString());
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.digestAlg != null) {
            s.append("digestAlg = " + this.digestAlg);
        }
        s.append("witness = " + Utils.toHexString((byte[])this.witness));
        s.append("challenge = " + Utils.toHexString((byte[])this.challenge));
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.digestAlg = sis.getCurrentTag() == 16 ? new AlgorithmIdentifier((InputStream)sis) : null;
        this.witness = ASN1OctetString.inputValue((InputStream)sis);
        this.challenge = ASN1OctetString.inputValue((InputStream)sis);
        this.randomInt = null;
        this.sender = null;
        this.decrypted = false;
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.digestAlg != null) {
                s.addElement((ASN1Object)this.digestAlg);
            }
            s.addElement((ASN1Object)new ASN1OctetString(this.witness));
            s.addElement((ASN1Object)new ASN1OctetString(this.challenge));
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

