/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.CertifiedKeyPair;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class KeyRecoveryResponse
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.KEY_RECOVERY_RESPONSE;
    private PKIStatusInfo status;
    private X509Certificate newSigCert;
    private X509 X509newSigCert;
    private Vector caCerts;
    private Vector X509caCerts;
    private Vector keyPairHist;
    private transient ASN1Object contents;

    public KeyRecoveryResponse() {
    }

    public KeyRecoveryResponse(PKIStatusInfo status) {
        this.status = status;
    }

    public KeyRecoveryResponse(PKIStatusInfo status, X509Certificate newSigCert) throws CertificateEncodingException {
        this.status = status;
        this.newSigCert = newSigCert;
        this.X509newSigCert = CMPUtils.convertX509(newSigCert);
    }

    public KeyRecoveryResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCACert(X509Certificate cert) {
        if (this.caCerts == null) {
            this.caCerts = new Vector();
            this.X509caCerts = new Vector();
        }
        this.caCerts.addElement(cert);
        try {
            this.X509caCerts.addElement(CMPUtils.convertX509(cert));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        this.update();
    }

    public void addCertifiedKeyPair(CertifiedKeyPair keyPair) {
        if (this.keyPairHist == null) {
            this.keyPairHist = new Vector();
        }
        this.keyPairHist.addElement(keyPair);
        this.update();
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public X509Certificate getNewSigCert() {
        return this.newSigCert;
    }

    public Vector getCACerts() {
        return this.caCerts;
    }

    public Vector getKeyPairHistory() {
        return this.keyPairHist;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        int i;
        int n;
        StringBuffer s = new StringBuffer();
        s.append(TYPE + " { ");
        s.append("status = { " + this.status.toString() + " } ");
        if (this.newSigCert != null) {
            s.append("newSigCert = { " + this.newSigCert.toString() + " } ");
        }
        if (this.caCerts != null) {
            s.append("caCerts = { ");
            n = this.caCerts.size();
            for (i = 0; i < n; ++i) {
                s.append(this.caCerts.elementAt(i).toString());
                if (i >= n - 1) continue;
                s.append(", ");
            }
            s.append(" } ");
        }
        if (this.keyPairHist != null) {
            s.append("keyPairHist = { ");
            n = this.keyPairHist.size();
            for (i = 0; i < n; ++i) {
                s.append(this.keyPairHist.elementAt(i).toString());
                if (i >= n - 1) continue;
                s.append(", ");
            }
        }
        s.append(" } }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream eis;
        ASN1ConstructedInputStream cis;
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.status = new PKIStatusInfo((InputStream)sis);
        if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
            try {
                this.X509newSigCert = new X509((InputStream)cis);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.newSigCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.X509newSigCert.getEncoded()));
            }
            catch (CertificateException ex) {
                throw new IOException(ex);
            }
            cis.terminate();
        } else {
            this.newSigCert = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 1);
            eis = new ASN1SequenceInputStream((InputStream)cis);
            if (this.caCerts == null) {
                this.caCerts = new Vector();
                this.X509caCerts = new Vector();
            } else {
                this.caCerts.removeAllElements();
                this.X509caCerts.removeAllElements();
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (eis.hasMoreData()) {
                    X509 cert = new X509((InputStream)eis);
                    this.X509caCerts.addElement(cert);
                    this.caCerts.addElement(CMPUtils.toJCECertificate(cert));
                }
            }
            catch (CertificateException ex) {
                throw new IOException(ex.toString());
            }
            eis.terminate();
            cis.terminate();
        } else {
            this.caCerts = null;
            this.X509caCerts = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 2) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 2);
            eis = new ASN1SequenceInputStream((InputStream)cis);
            if (this.keyPairHist == null) {
                this.keyPairHist = new Vector();
            } else {
                this.keyPairHist.removeAllElements();
            }
            while (eis.hasMoreData()) {
                this.keyPairHist.addElement(new CertifiedKeyPair((InputStream)eis));
            }
            eis.terminate();
            cis.terminate();
        } else {
            this.keyPairHist = null;
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.status);
            if (this.newSigCert != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.X509newSigCert, 0));
            }
            if (this.caCerts != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Sequence(this.X509caCerts), 1));
            }
            if (this.keyPairHist != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Sequence(this.keyPairHist), 2));
            }
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

