/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cmp.PKIMessageBody;

public class PKCS10CertReq
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.PKCS10_CERT_REQUEST;
    private CertificateRequest certReq;
    private transient ASN1Object contents;

    public PKCS10CertReq() {
    }

    public PKCS10CertReq(CertificateRequest certReq) {
        this.certReq = certReq;
    }

    public PKCS10CertReq(InputStream is) throws IOException {
        this.input(is);
    }

    public CertificateRequest getCertRequest() {
        return this.certReq;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return "{ type = " + TYPE + ", certReq = " + this.certReq + " }";
    }

    public void input(InputStream is) throws IOException {
        this.certReq = new CertificateRequest(is);
        this.update();
        this.contents = this.certReq;
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.certReq;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

