/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cmp.CertReqMessages;
import oracle.security.crypto.cmp.CertReqMsg;
import oracle.security.crypto.cmp.PKIMessageBody;

public abstract class PKICertReqMessages
extends PKIMessageBody {
    private CertReqMessages crms = new CertReqMessages();
    private transient ASN1Object contents;

    protected PKICertReqMessages() {
    }

    protected PKICertReqMessages(CertReqMsg crm) {
        this.crms.addCertReqMsg(crm);
    }

    protected PKICertReqMessages(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCertReqMsg(CertReqMsg crm) {
        this.crms.addCertReqMsg(crm);
        this.update();
    }

    public CertReqMessages getCertReqMessages() {
        return this.crms;
    }

    public String toString() {
        return this.getType() + " { crms = " + this.crms + " }";
    }

    public void input(InputStream is) throws IOException {
        this.crms = new CertReqMessages(is);
        this.update();
        this.contents = this.crms.toASN1();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.crms.toASN1();
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

