/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPException;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIMessageHeader;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.InvalidMACException;
import oracle.security.crypto.core.PasswordBasedMAC;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class PKIMessage
implements ASN1Object {
    private PKIMessageHeader header;
    private PKIMessageBody body;
    private byte[] protection = null;
    private Vector extraCerts = null;
    private transient ASN1Object contents;

    public PKIMessage() {
    }

    public PKIMessage(GeneralName sender, GeneralName recipient, PKIMessageBody body) throws CMPException {
        this(sender, recipient, body, Version.CMP2000);
    }

    public PKIMessage(GeneralName sender, GeneralName recipient, PKIMessageBody body, Version version) throws CMPException {
        this(new PKIMessageHeader(sender, recipient, version), body);
    }

    public PKIMessage(PKIMessageHeader header, PKIMessageBody body) {
        this.header = header;
        this.body = body;
    }

    public PKIMessage(InputStream is) throws IOException {
        this.input(is);
    }

    public PKIMessageHeader getHeader() {
        return this.header;
    }

    public PKIMessageBody getBody() {
        return this.body;
    }

    public Version getVersion() {
        return this.header.getVersion();
    }

    public void addCertificate(X509Certificate cert) {
        if (this.extraCerts == null) {
            this.extraCerts = new Vector();
        }
        this.extraCerts.addElement(cert);
        this.update();
    }

    public Vector getExtraCerts() {
        return this.extraCerts;
    }

    public AlgorithmIdentifier getProtectionAlgID() {
        return this.header.getProtectionAlgID();
    }

    public void computeProtection() throws SignatureException {
        this.protection = this.header.computeProtectionBytes(this.getProtectedPart());
        this.update();
    }

    public byte[] getProtectionBytes() throws SignatureException {
        if (this.protection == null && this.header.getProtectionAlgID() != null) {
            this.computeProtection();
        }
        return this.protection;
    }

    public byte[] getProtectedPart() {
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)this.header);
        s.addElement((ASN1Object)this.body);
        return Utils.toBytes((Streamable)s);
    }

    public boolean verifyProtection(byte[] password) throws InvalidMACException {
        AlgorithmIdentifier algID = this.header.getProtectionAlgID();
        if (algID == null || this.protection == null) {
            throw new InvalidMACException("Message not protected");
        }
        if (!algID.getOID().equals((Object)AlgID.PasswordBasedMac.getOID())) {
            throw new InvalidMACException("Message not protected using PasswordBasedMac");
        }
        try {
            PasswordBasedMAC pbMac = new PasswordBasedMAC(algID, password);
            byte[] macBytes = pbMac.computeDigest(this.getProtectedPart());
            return Utils.areEqual((byte[])this.protection, (byte[])macBytes);
        }
        catch (AlgorithmIdentifierException ex) {
            throw new InvalidMACException(ex.toString());
        }
    }

    public boolean verifyProtection(PublicKey pubKey) throws SignatureException {
        AlgorithmIdentifier algID = this.header.getProtectionAlgID();
        if (algID == null || this.protection == null) {
            throw new SignatureException("Message not protected");
        }
        try {
            Signature sig = Signature.getInstance(CMPUtils.getAlgoName(algID));
            sig.initVerify(pubKey);
            sig.update(this.getProtectedPart());
            return sig.verify(this.protection);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ header = " + this.header);
        s.append(", body = " + this.body);
        if (this.protection != null) {
            s.append(", protection = " + Utils.toHexString((byte[])this.protection));
        }
        if (this.extraCerts != null) {
            s.append(", extraCerts = {");
            int n = this.extraCerts.size();
            for (int i = 0; i < n; ++i) {
                X509 c = (X509)this.extraCerts.elementAt(i);
                s.append(" (subject=" + c.getSubject());
                s.append(", issuer=" + c.getIssuer() + ")");
                if (i == n - 1) continue;
                s.append(',');
            }
            s.append(" }");
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1ConstructedInputStream cis;
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.header = new PKIMessageHeader((InputStream)sis);
        this.body = PKIMessageBody.inputInstance((InputStream)sis);
        if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
            this.protection = ASN1BitString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.protection = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
            if (this.extraCerts == null) {
                this.extraCerts = new Vector();
            } else {
                this.extraCerts.removeAllElements();
            }
            cis = new ASN1ConstructedInputStream((InputStream)sis, 1);
            ASN1SequenceInputStream xis = new ASN1SequenceInputStream((InputStream)cis);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (xis.hasMoreData()) {
                    this.extraCerts.addElement(cf.generateCertificate((InputStream)xis));
                }
            }
            catch (CertificateException ex) {
                throw new IOException(ex.toString());
            }
            xis.terminate();
            cis.terminate();
        } else {
            this.extraCerts = null;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.header);
            s.addElement((ASN1Object)this.body);
            if (this.protection != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1BitString(this.protection), 0));
            }
            if (this.extraCerts != null && this.extraCerts.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Sequence(this.extraCerts), 1));
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }

    public static class Version {
        public static final Version CMP1999 = new Version(1);
        public static final Version CMP2000 = new Version(2);
        private int value;

        static Version getVersion(int v) {
            switch (v) {
                case 1: {
                    return CMP1999;
                }
                case 2: {
                    return CMP2000;
                }
            }
            return null;
        }

        private Version(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 1: {
                    return "CMP1999";
                }
                case 2: {
                    return "CMP2000";
                }
            }
            return "CMP v" + this.value;
        }
    }
}

