/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1Null;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cmp.ProofOfPossession;

public class RAVerifiedPOP
extends ProofOfPossession {
    private static final ProofOfPossession.Type TYPE = ProofOfPossession.Type.RA_VERIFIED;
    private transient ASN1Object contents;

    public RAVerifiedPOP() {
    }

    public RAVerifiedPOP(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public ProofOfPossession.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { null }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Null(is);
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Null();
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

