/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cmp.PKICertID;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class RevAnnouncement
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.REVOCATION_ANNOUNCEMENT;
    private PKIStatusInfo status;
    private PKICertID certID;
    private Date willBeRevokedAt;
    private Date badSinceDate;
    private X509ExtensionSet crlDetails;
    private transient ASN1Object contents;

    public RevAnnouncement() {
    }

    public RevAnnouncement(PKIStatusInfo status, PKICertID certID, Date willBeRevokedAt, Date badSinceDate) {
        this.status = status;
        this.certID = certID;
        this.willBeRevokedAt = willBeRevokedAt;
        this.badSinceDate = badSinceDate;
    }

    public RevAnnouncement(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCRLDetail(X509Extension detail) {
        if (this.crlDetails == null) {
            this.crlDetails = new X509ExtensionSet();
        }
        this.crlDetails.addExtension(detail);
        this.update();
    }

    public X509ExtensionSet getCRLDetails() {
        return this.crlDetails;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public PKICertID getCertID() {
        return this.certID;
    }

    public Date getWillBeRevokedAt() {
        return this.willBeRevokedAt;
    }

    public Date getBadSinceDate() {
        return this.badSinceDate;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(TYPE);
        s.append(" { ");
        s.append("status = ");
        s.append(this.status.toString());
        s.append(", certID = ");
        s.append(this.certID.toString());
        s.append(", willBeRevokedAt = ");
        s.append(this.willBeRevokedAt.toString());
        s.append(", badSinceDate = ");
        s.append(this.badSinceDate.toString());
        if (this.crlDetails != null) {
            s.append(", crlDetails = ");
            s.append(this.crlDetails);
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.status = new PKIStatusInfo((InputStream)sis);
        this.certID = new PKICertID((InputStream)sis);
        this.willBeRevokedAt = ASN1Date.inputValue((InputStream)sis);
        this.badSinceDate = ASN1Date.inputValue((InputStream)sis);
        this.crlDetails = sis.hasMoreData() ? new X509ExtensionSet((InputStream)sis) : null;
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.status);
            s.addElement((ASN1Object)this.certID);
            s.addElement((ASN1Object)new ASN1Date(this.willBeRevokedAt));
            s.addElement((ASN1Object)new ASN1Date(this.badSinceDate));
            if (this.crlDetails != null) {
                s.addElement((ASN1Object)this.crlDetails);
            }
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

