/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cmp.CertTemplate;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class RevDetails
implements ASN1Object {
    private CertTemplate certDetails;
    private X509ExtensionSet crlEntryDetails;
    private transient ASN1Object contents;

    public RevDetails() {
    }

    public RevDetails(CertTemplate certTemp) {
        this(certTemp, null);
    }

    public RevDetails(CertTemplate certTemp, X509ExtensionSet extensions) {
        this.certDetails = certTemp;
        this.crlEntryDetails = extensions;
    }

    public RevDetails(InputStream is) throws IOException {
        this.input(is);
    }

    public CertTemplate getCertTemplate() {
        return this.certDetails;
    }

    public X509ExtensionSet getExtensions() {
        return this.crlEntryDetails;
    }

    public X509Extension getExtension(ASN1ObjectID id) {
        return this.crlEntryDetails != null ? this.crlEntryDetails.getExtension(id) : null;
    }

    public void addExtension(X509Extension ext) {
        if (this.crlEntryDetails == null) {
            this.crlEntryDetails = new X509ExtensionSet();
        }
        this.crlEntryDetails.addExtension(ext);
        this.update();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("certDetails = " + this.certDetails.toString());
        if (this.crlEntryDetails != null) {
            s.append("crlEntryDetails = " + this.crlEntryDetails.toString());
        }
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.certDetails = new CertTemplate((InputStream)sis);
        if (sis.hasMoreData()) {
            this.crlEntryDetails = new X509ExtensionSet((InputStream)sis);
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.certDetails);
            if (this.crlEntryDetails != null) {
                s.addElement((ASN1Object)this.crlEntryDetails);
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

