/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class EncKeyPairTypesInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_EncKeyPairTypes;
    Vector algIDs;

    public EncKeyPairTypesInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public EncKeyPairTypesInfo(AlgorithmIdentifier algID) {
        this();
        this.addAlgID(algID);
    }

    public EncKeyPairTypesInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public void addAlgID(AlgorithmIdentifier algID) {
        if (this.algIDs == null) {
            this.algIDs = new Vector();
        }
        this.algIDs.addElement(algID);
        this.encoded = false;
    }

    public Vector getAlgIDs() {
        this.decodeValue();
        return this.algIDs;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("EncKeyPairTypes { ");
        int n = this.algIDs.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.algIDs.elementAt(i).toString());
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append(" }");
        return s.toString();
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            if (this.algIDs != null && this.algIDs.size() > 0) {
                this.setValue((ASN1Object)new ASN1Sequence(this.algIDs));
            } else {
                this.setValue(null);
            }
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            if (this.getValue() != null) {
                try {
                    ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.getValue()));
                    if (this.algIDs == null) {
                        this.algIDs = new Vector();
                    } else {
                        this.algIDs.removeAllElements();
                    }
                    while (sis.hasMoreData()) {
                        this.algIDs.addElement(new AlgorithmIdentifier((InputStream)sis));
                    }
                    sis.terminate();
                }
                catch (IOException ex) {
                    throw new StreamableInputException(ex.toString());
                }
            } else {
                this.algIDs = null;
            }
            this.decoded = true;
        }
    }
}

