/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerAdapter;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewMouseMotionListener;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewController;
import oracle.dss.gridView.GridViewSelectionManager;
import oracle.dss.gridView.GridViewSizingManager;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.gridView.managers.GridViewSelectionService;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.util.DataComponentInfo;

public abstract class GridViewControllerAdapter
extends ControllerAdapter
implements GridViewController,
TableResizeListener,
VetoableChangeListener,
Cloneable {
    private static final boolean DEBUG = false;
    protected int AUTOFIT_CLICKS = 2;
    protected GridViewSelectionManager gridViewSelectionManager = null;
    protected GridViewSizingManager gridViewSizingManager = null;
    private GridView gridView = null;
    protected transient ComponentHandle sizingComponent = null;
    protected boolean resizing = false;
    protected boolean inResize = false;
    private DataComponentInfo wasCell = null;
    protected boolean inSetSelectedObject = false;
    protected transient ComponentHandle selectedObject = null;
    protected boolean clickDragSelection = false;
    protected boolean selectingCells = false;
    protected int viewKeyListenerCount = 0;
    protected int viewMouseMotionListenerCount = 0;
    protected boolean m_bDrill = false;

    public GridViewControllerAdapter(GridView v) {
        super((Dataview)v);
        this.gridView = v;
        GridViewTable gvt = this.gridView.getGridViewTable();
        this.gridView.getDatabody().addVetoableChangeListener(this);
        this.gridView.getRowHeader().addVetoableChangeListener(this);
        this.gridView.getColumnHeader().addVetoableChangeListener(this);
        gvt.addResizeListener(this);
        gvt.addMouseMotionListener((MouseMotionListener)((Object)this));
        gvt.addMouseListener((MouseListener)((Object)this));
        gvt.addKeyListener((KeyListener)((Object)this));
        this.gridView.getPagingControl().addMouseListener((MouseListener)((Object)this));
        this.gridView.getPagingControl().addMouseMotionListener((MouseMotionListener)((Object)this));
        this.gridView.getPagingControl().addFocusListener((FocusListener)((Object)this));
        this.gridView.getPagingControl().addKeyListener((KeyListener)((Object)this));
        this.gridView.getPagingControl().getPagingComponent().addVetoableChangeListener((VetoableChangeListener)this);
        this.setGridViewSelectionManager(new GridViewSelectionService());
        this.setRolloverTextManager((RolloverTextManager)ManagerAdapter.getInstance());
    }

    public void setWaitCursorForced(boolean yesNo) {
        super.setWaitCursorForced(yesNo);
        if (yesNo) {
            this.setCursor(WindowUtils.getWindow((Component)((Object)this.gridView)), this.getCursorType(2));
        } else {
            this.setCursor(WindowUtils.getWindow((Component)((Object)this.gridView)), this.getCursorType(0));
        }
    }

    public void focusCellChanging(TableEvent e) {
    }

    public abstract void focusCellChanged(TableEvent var1);

    @Override
    public abstract void vetoableChange(PropertyChangeEvent var1) throws PropertyVetoException;

    public void columnResizing(TableEvent e) {
        this.resizing = true;
        this.gridView.setHeaderResizing(true);
        ColumnComponentHandle c = new ColumnComponentHandle(14, this.gridView.getNameFromID(14), e.getSource(), e.getColumn());
        if (this.fireSizingEvent((ComponentHandle)c)) {
            return;
        }
        ((Cancelable)e).cancel();
        this.resizing = false;
        this.gridView.setHeaderResizing(false);
    }

    public void columnResized(TableEvent e) {
        this.resizing = false;
        this.gridView.setHeaderResizing(false);
        this.fireSizedEvent();
    }

    public void rowResizing(TableEvent e) {
        this.resizing = true;
        this.gridView.setHeaderResizing(true);
        RowComponentHandle c = new RowComponentHandle(15, this.gridView.getNameFromID(15), e.getSource(), e.getRow());
        if (this.fireSizingEvent((ComponentHandle)c)) {
            return;
        }
        ((Cancelable)e).cancel();
        this.resizing = false;
        this.gridView.setHeaderResizing(false);
    }

    public void rowResized(TableEvent e) {
        this.resizing = false;
        this.gridView.setHeaderResizing(false);
        this.fireSizedEvent();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseEvent = e;
        if (this.viewMouseMotionListenerCount == 0) {
            return;
        }
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        this.processViewMouseMotionEvent(e, c);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseEvent = e;
        if (this.viewMouseMotionListenerCount == 0) {
            return;
        }
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        this.processViewMouseMotionEvent(e, c);
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        this.processViewMouseEvent(e, c);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        this.processViewMouseEvent(e, c);
    }

    public void keyTyped(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), false);
        this.processViewKeyEvent(e, c);
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.selectedObject;
    }

    @Override
    public void setGridViewSelectionManager(GridViewSelectionManager m) {
        this.setSelectionManager(m);
        this.gridViewSelectionManager = m;
    }

    @Override
    public GridViewSelectionManager getGridViewSelectionManager() {
        return this.gridViewSelectionManager;
    }

    @Override
    public GridViewSizingManager getGridViewSizingManager() {
        return this.gridViewSizingManager;
    }

    protected void setGridViewSizingManager(GridViewSizingManager sm) {
        this.gridViewSizingManager = sm;
    }

    @Override
    public void fireComponentSized(Object source, ComponentHandle id) {
        super.fireComponentSized(source, id);
    }

    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        final ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        this.processViewMouseEvent(e, c);
        if (!this.gridView.isEnabled()) {
            return;
        }
        this.clickDragSelection = false;
        if (c instanceof NonDataComponentHandle) {
            switch (c.getID()) {
                case 3: 
                case 9: 
                case 10: 
                case 11: {
                    ComponentHandle currSel = this.getSelectedObject();
                    if (currSel != null && currSel instanceof NonDataComponentHandle) {
                        if (currSel.getID() == 6) {
                            ((BaseTitle)this.gridView.getDataviewTitle()).setSelected(true);
                        } else if (currSel.getID() == 7) {
                            ((BaseTitle)this.gridView.getDataviewSubtitle()).setSelected(true);
                        } else if (currSel.getID() == 8) {
                            ((BaseTitle)this.gridView.getDataviewFootnote()).setSelected(true);
                        }
                    }
                    return;
                }
            }
        }
        if (!this.isSpecialSelectedObject(c) && this.fireComponentSelecting(this.gridView, c)) {
            Component comp = (Component)e.getSource();
            if (!comp.isFocusTraversable()) {
                Component rootComponent = SwingUtilities.getRoot(comp);
                rootComponent.requestFocus();
                if (!this.isSpecialSelectedObject(c)) {
                    this.gridView.getDatabody().setCellFocus(null);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GridViewControllerAdapter.this.setSelectedObject(c, false);
                }
            });
            e.consume();
        }
        if (c.getID() == 12 || c.getID() == 16 || c.getID() == 14 || c.getID() == 19 || c.getID() == 15 || c.getID() == 20) {
            this.clickDragSelection = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.inResize = this.resizing;
        this.resizing = false;
        this.gridView.setHeaderResizing(false);
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        if (!this.gridView.isEnabled()) {
            this.processViewMouseEvent(e, c);
            return;
        }
        if (c.getID() == 13) {
            c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), true);
            this.setSelectedObject(c, false);
        }
        if (this.clickDragSelection && !this.m_bDrill && (c.getID() == 12 || c.getID() == 16 || c.getID() == 14 || c.getID() == 19 || c.getID() == 15 || c.getID() == 20)) {
            c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), true);
            this.setSelectedObject(c, true);
        }
        this.clickDragSelection = false;
        this.m_bDrill = false;
        this.processViewMouseEvent(e, c);
    }

    public void keyPressed(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), false);
        this.processViewKeyEvent(e, c);
    }

    public void keyReleased(KeyEvent e) {
        if (this.viewKeyListenerCount == 0) {
            return;
        }
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), false);
        this.processViewKeyEvent(e, c);
    }

    @Override
    public void setSelectingCells(boolean selecting) {
        this.selectingCells = selecting;
    }

    private static final void selectPageItem(Dataview view, long pi) {
        if (view.getPagingControl() != null && view.getPagingControl().getPagingComponent() != null && pi >= 0L) {
            view.getPagingControl().getPagingComponent().setSelectedItem(view.getPagingControl().getPagingComponent().getItem((int)pi));
        }
    }

    @Override
    public boolean setSelectedObject(ComponentHandle c, boolean special) {
        this.inSetSelectedObject = true;
        this.selectedObject = c;
        if (c instanceof PageItemComponentHandle) {
            this.unselectGridView();
            PageItemComponentHandle pic = (PageItemComponentHandle)c;
            GridViewControllerAdapter.selectPageItem(this.gridView, pic.getPageItem());
        } else {
            if (!(c instanceof NonDataComponentHandle)) {
                this.gridView.getPagingControl().getPagingComponent().setSelectedItem(null);
            }
            if (c == null) {
                this.unselectGridView();
            }
        }
        this.changeTitleSelectedState(false);
        if (this.selectedObject != null && this.selectedObject.getComponent() instanceof BaseTitle) {
            this.unselectGridView();
            ((BaseTitle)this.selectedObject.getComponent()).setSelected(true);
        }
        this.fireComponentSelected(this.gridView, c);
        this.inSetSelectedObject = false;
        return true;
    }

    public void addViewMouseMotionListener(ViewMouseMotionListener l) {
        super.addViewMouseMotionListener(l);
        this.viewMouseMotionListenerCount = this.listenerList.getListenerCount(ViewMouseMotionListener.class);
    }

    public void removeViewMouseMotionListener(ViewMouseMotionListener l) {
        super.removeViewMouseMotionListener(l);
        this.viewMouseMotionListenerCount = this.listenerList.getListenerCount(ViewMouseMotionListener.class);
    }

    public void addViewKeyListener(ViewKeyListener l) {
        super.addViewKeyListener(l);
        this.viewKeyListenerCount = this.listenerList.getListenerCount(ViewKeyListener.class);
    }

    public void removeViewKeyListener(ViewKeyListener l) {
        super.removeViewKeyListener(l);
        this.viewKeyListenerCount = this.listenerList.getListenerCount(ViewKeyListener.class);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        GridViewTable gvt = this.gridView.getGridViewTable();
        this.gridView.getDatabody().removeVetoableChangeListener(this);
        this.gridView.getRowHeader().removeVetoableChangeListener(this);
        this.gridView.getColumnHeader().removeVetoableChangeListener(this);
        gvt.removeResizeListener(this);
        gvt.removeMouseMotionListener((MouseMotionListener)((Object)this));
        gvt.removeMouseListener((MouseListener)((Object)this));
        gvt.removeKeyListener((KeyListener)((Object)this));
    }

    public void focusGained(FocusEvent e) {
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), false);
        if (!this.gridView.isEnabled()) {
            this.processViewFocusEvent(e, c);
            return;
        }
        if (!e.isTemporary()) {
            if (!this.isSpecialSelectedObject(c)) {
                this.gridView.getDatabody().setCellFocus(null);
            }
            this.changeTitleSelectedState(false);
            ComponentHandle currSel = this.getSelectedObject();
            if (currSel != null && currSel instanceof NonDataComponentHandle) {
                if (currSel.getID() == 6) {
                    ((BaseTitle)this.gridView.getDataviewTitle()).setSelected(true);
                } else if (currSel.getID() == 7) {
                    ((BaseTitle)this.gridView.getDataviewSubtitle()).setSelected(true);
                } else if (currSel.getID() == 8) {
                    ((BaseTitle)this.gridView.getDataviewFootnote()).setSelected(true);
                }
            }
            if (c.getID() == 12 || c.getID() == 16 || c.getID() == 10 || c.getID() == 17 || c.getID() == 11 || c.getID() == 18 || c.getID() == 14 || c.getID() == 19 || c.getID() == 15 || c.getID() == 20) {
                c = this.getComponentFromGrid(e.getSource(), true);
            }
        }
        this.processViewFocusEvent(e, c);
    }

    public void focusLost(FocusEvent e) {
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), false);
        if (!this.gridView.isEnabled()) {
            this.processViewFocusEvent(e, c);
            return;
        }
        this.processViewFocusEvent(e, c);
    }

    protected void fireSelectedEvent() {
        if (this.gridViewSelectionManager.canSelectComponents(this.gridView) && this.gridViewSelectionManager.canSelectComponent(this.gridView, this.selectedObject)) {
            this.fireComponentSelected(this.gridView, this.selectedObject);
        }
    }

    protected abstract boolean fireSizingEvent(ComponentHandle var1);

    protected void fireSizedEvent() {
        if (this.sizingComponent != null) {
            this.fireComponentSized(this.gridView, this.sizingComponent);
        }
        this.sizingComponent = null;
    }

    protected boolean fireComponentSelecting(Object source, ComponentHandle id) {
        if (!this.gridView.isExporting()) {
            return super.fireComponentSelecting(source, id);
        }
        return false;
    }

    protected void fireComponentSelected(Object source, ComponentHandle id) {
        if (!this.gridView.isExporting()) {
            super.fireComponentSelected(source, id);
        }
    }

    protected MouseEvent getMouseEvent() {
        return super.getMouseEvent();
    }

    protected abstract ComponentHandle getComponentFromGrid(Object var1, boolean var2);

    protected abstract ComponentHandle getComponentFromGrid(Object var1, int var2, int var3, boolean var4);

    protected boolean isSpecialSelectedObject(ComponentHandle c) {
        if (c == null) {
            return false;
        }
        if (c instanceof DataComponentHandle) {
            switch (c.getID()) {
                case 12: {
                    return true;
                }
            }
        } else if (c instanceof EdgeComponentHandle) {
            switch (c.getID()) {
                case 10: 
                case 11: {
                    return true;
                }
            }
        } else if (c instanceof RowComponentHandle || c instanceof ColumnComponentHandle) {
            return true;
        }
        return false;
    }

    protected void setCursor(Component component, Cursor c) {
        DataviewUtils.setCursor((Component)component, (Cursor)c);
    }

    protected abstract void unselectGridView();
}

