/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import oracle.dss.gridView.GridViewDatabodyAttributes;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GridViewDatabodyXML {
    public static String a_visible = "visible";
    protected boolean d_visible = GridViewDefaultValues.isDatabodyVisible();
    private GridViewDatabodyAttributes _databody;

    public GridViewDatabodyXML(GridViewDatabodyAttributes databody) {
        this._databody = databody;
    }

    public void setXML(ObjectNode node, String version, int reset) {
        ObjectNode viewStyle;
        PropertyNode pNode = node.getProperty(a_visible);
        if (pNode != null) {
            this._databody.setVisible(pNode.getValueAsBoolean());
        }
        if ((viewStyle = node.getPropertyValueAsObjectNode("ViewStyle", true)) != null) {
            this._databody.getViewStyle().setXML(viewStyle, version, reset);
        }
    }

    public ObjectNode getXML(boolean allProperties) {
        ObjectNode viewStyle;
        ObjectNode node = new ObjectNode("Databody");
        boolean nodeExists = false;
        if (allProperties || this.d_visible != this._databody.isVisible()) {
            node.addProperty(a_visible, this._databody.isVisible());
            nodeExists = true;
        }
        if ((viewStyle = this._databody.getViewStyle().getXML(allProperties)) != null) {
            node.addProperty(viewStyle);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    public void resetToDefault() {
        this._databody.setVisible(this.d_visible);
    }
}

