/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DimensionMetadata;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.UIBundle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.ASFormatModel;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.FormatModel;
import oracle.dss.gridView.GridView;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.UIFormat;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;

public class GridViewFormatUtils {
    private static final String dimNameType = "layerName";
    private static final String memberNameType = "value";

    public static Discriminator getStoplightDiscriminator(GridViewCommon gridView) {
        Discriminator qdrDisc = GridViewFormatUtils.getQDRDiscriminator(gridView);
        if (qdrDisc == null) {
            qdrDisc = new QDRDiscriminator(new QDR(), 4);
        }
        return qdrDisc;
    }

    public static FormatModel getFormatModel(GridViewCommon gridView) {
        if (gridView.getFormatModel() == null) {
            gridView.setFormatModel(new ASFormatModel(gridView));
        }
        return gridView.getFormatModel();
    }

    protected static RuleBundle getRuleBundle(UIBundle manager) {
        RuleBundle ruleBundle = manager.getUIBundle();
        if (ruleBundle == null) {
            ruleBundle = new RuleBundle();
        }
        return ruleBundle;
    }

    public static void applyFormat(GridViewCommon gridView, Mergeable mergeable) {
        Discriminator qdrDisc = GridViewFormatUtils.getQDRDiscriminator(gridView);
        if (qdrDisc != null) {
            if (mergeable instanceof ViewStyle) {
                GridViewFormatUtils.applyFormat(gridView, gridView.getGridViewDatabodyStyleManager(), qdrDisc, mergeable);
            } else if (mergeable instanceof ViewFormat) {
                GridViewFormatUtils.applyFormat(gridView, (UIBundle)gridView.getGridViewFormatManager(), qdrDisc, mergeable);
            }
        }
    }

    public static void applyFormat(GridViewCommon gridView, UIBundle manager, Discriminator qdrDisc, Mergeable mergeable) {
        FormatModel formatModel = GridViewFormatUtils.getFormatModel(gridView);
        UIFormat lastFormat = manager instanceof GridViewHeaderStyleManager ? GridViewFormatUtils.findLastFormat(gridView, qdrDisc, 1) : GridViewFormatUtils.findLastFormat(gridView, qdrDisc, 4);
        boolean isNew = false;
        if (lastFormat != null) {
            if (lastFormat.getMergeableType() == 1 && mergeable instanceof ViewFormat) {
                lastFormat.setMergeableType(3);
                lastFormat.setViewFormat((ViewFormat)mergeable);
            } else if (lastFormat.getMergeableType() == 2 && mergeable instanceof ViewStyle) {
                lastFormat.setMergeableType(3);
                lastFormat.setViewStyle((ViewStyle)mergeable);
            } else if (mergeable instanceof ViewFormat) {
                lastFormat.getViewFormat().merge(mergeable);
            } else if (mergeable instanceof ViewStyle) {
                ViewStyle vs = (ViewStyle)mergeable;
                if (vs.isFontBold()) {
                    vs.setFontBold(!lastFormat.getViewStyle().isFontBold());
                } else if (vs.isFontItalic()) {
                    vs.setFontItalic(!lastFormat.getViewStyle().isFontItalic());
                } else if (vs.isUnderline()) {
                    vs.setUnderline(!lastFormat.getViewStyle().isUnderline());
                }
                lastFormat.getViewStyle().merge((Mergeable)vs);
            }
        } else {
            isNew = true;
            lastFormat = manager instanceof GridViewHeaderStyleManager ? formatModel.createHeaderSelectionFormat() : formatModel.createSelectionFormat();
            lastFormat.setDiscriminator(qdrDisc);
            if (mergeable instanceof ViewFormat) {
                lastFormat.setViewFormat((ViewFormat)mergeable);
                lastFormat.setMergeableType(2);
            } else if (mergeable instanceof ViewStyle) {
                lastFormat.setViewStyle((ViewStyle)mergeable);
            }
        }
        if (mergeable instanceof ViewFormat) {
            GridViewFormatUtils.setNumberOrDateCategory(gridView, (ViewFormat)mergeable, lastFormat);
        }
        formatModel.applyFormat(isNew ? lastFormat : null);
    }

    public static UIFormat findLastFormat(GridViewCommon gridView, Discriminator qdrDisc, int formatType) {
        FormatModel formatModel;
        UIFormat lastFormat;
        if (qdrDisc == null) {
            qdrDisc = GridViewFormatUtils.getQDRDiscriminator(gridView);
        }
        if (qdrDisc != null && (lastFormat = (formatModel = GridViewFormatUtils.getFormatModel(gridView)).getLastFormat(formatType)) != null && lastFormat.getDiscriminator().equals(qdrDisc)) {
            return lastFormat;
        }
        return null;
    }

    public static void setNumberOrDateCategory(GridViewCommon gridView, ViewFormat viewFormat, UIFormat format) {
        if (viewFormat != null && viewFormat.isAnythingOverridden()) {
            String dataType = null;
            if (viewFormat.getNumberType() == 1) {
                if (dataType == null) {
                    format.setNumberOrDateCategory(48);
                } else if (dataType.equals("Double")) {
                    format.setNumberOrDateCategory(63);
                } else {
                    format.setNumberOrDateCategory(32);
                }
            } else if (viewFormat.getNumberType() == 2) {
                if (dataType == null) {
                    format.setNumberOrDateCategory(64);
                } else if (dataType.equals("Double")) {
                    format.setNumberOrDateCategory(79);
                } else {
                    format.setNumberOrDateCategory(32);
                }
            } else if (dataType == null) {
                format.setNumberOrDateCategory(32);
            } else if (dataType.equals("Double")) {
                format.setNumberOrDateCategory(47);
            } else {
                format.setNumberOrDateCategory(32);
            }
        }
    }

    public static void applyFormat(GridViewCommon gridView, UIFormat uiFormat) {
        boolean isNewFormat;
        Discriminator qdrDisc = GridViewFormatUtils.getStoplightDiscriminator(gridView);
        uiFormat.setDiscriminator(qdrDisc);
        FormatModel formatModel = GridViewFormatUtils.getFormatModel(gridView);
        UIFormat lastFormat = GridViewFormatUtils.findLastFormat(gridView, qdrDisc, 4);
        if (lastFormat == null) {
            isNewFormat = true;
            lastFormat = uiFormat;
        } else {
            isNewFormat = false;
            ViewFormat viewFormat = uiFormat.getViewFormat();
            if (viewFormat.isAnythingOverridden()) {
                lastFormat.getViewFormat().merge((Mergeable)viewFormat);
                if (lastFormat.getMergeableType() == 1) {
                    lastFormat.setMergeableType(3);
                }
                GridViewFormatUtils.setNumberOrDateCategory(gridView, viewFormat, lastFormat);
            }
            lastFormat.setNegativeRed(uiFormat.isNegativeRed());
            ViewStyle viewStyle = uiFormat.getViewStyle();
            if (viewStyle.isAnythingOverridden()) {
                lastFormat.getViewStyle().merge((Mergeable)viewStyle);
                if (lastFormat.getMergeableType() == 2) {
                    lastFormat.setMergeableType(3);
                }
            }
        }
        formatModel.applyFormat(isNewFormat ? lastFormat : null);
    }

    public static String[] applyStoplightFormat(GridViewCommon gridView, String badValue, String goodValue, boolean desireGreater) {
        Discriminator qdrDisc = GridViewFormatUtils.getStoplightDiscriminator(gridView);
        FormatModel formatModel = GridViewFormatUtils.getFormatModel(gridView);
        String[] datatypes = GridViewFormatUtils.getMeasureDatatypes(formatModel, qdrDisc);
        return GridViewFormatUtils._applyStoplightFormat(gridView, formatModel, qdrDisc, datatypes, badValue, goodValue, desireGreater);
    }

    public static String[] applyStoplightFormat(GridViewCommon gridView, String badValue, String goodValue, String memberID, boolean desireGreater) {
        FormatModel formatModel = GridViewFormatUtils.getFormatModel(gridView);
        DimensionMetadata measureData = formatModel.getMeasureMetadata();
        ArrayList<String> midList = new ArrayList<String>();
        QDRDiscriminator qdrDisc = null;
        if (memberID == null || memberID.length() == 0) {
            qdrDisc = new QDRDiscriminator(new QDR(), 4);
        } else {
            String dimID = measureData.getDimID();
            qdrDisc = new QDRDiscriminator(new QDR(dimID, dimID, memberID), 4);
            midList.add(memberID);
        }
        String[] datatypes = GridViewFormatUtils.getMeasureDatatypes(formatModel, measureData, midList);
        return GridViewFormatUtils._applyStoplightFormat(gridView, formatModel, (Discriminator)qdrDisc, datatypes, badValue, goodValue, desireGreater);
    }

    private static String[] _applyStoplightFormat(GridViewCommon gridView, FormatModel formatModel, Discriminator qdrDisc, String[] datatypes, String badValue, String goodValue, boolean desireGreater) {
        Object[] values = new Object[2];
        String[] errors = formatModel.validateValues(datatypes, new String[]{badValue, goodValue}, values);
        if (values[0] == null || values[1] == null) {
            return errors;
        }
        String datatype = ConditionElement.getDatatype((Object)values[0]);
        UIFormat lastFormat = GridViewFormatUtils.findLastFormat(gridView, qdrDisc, 16);
        boolean isNewFormat = true;
        if (lastFormat != null && lastFormat.getValueCondition().getValueType().equals(datatype)) {
            isNewFormat = false;
        }
        if (isNewFormat) {
            lastFormat = formatModel.createSelectionStoplightFormat(datatype);
            lastFormat.setDiscriminator(qdrDisc);
        }
        lastFormat.setDesirableGreaterThanThreshold(desireGreater);
        ConditionElement condition = lastFormat.getValueCondition();
        if (qdrDisc instanceof QDRDiscriminator) {
            condition.setMeasure(((QDRDiscriminator)qdrDisc).getQDR().getMeasureDim());
        } else {
            condition.setMeasure(null);
        }
        condition.setBadThreshold(values[0]);
        condition.setGoodThreshold(values[1]);
        if (datatype.equals("Double")) {
            lastFormat.setNumberOrDateCategory(47);
        } else if (datatype.equals("Date")) {
            lastFormat.setNumberOrDateCategory(240);
        }
        formatModel.applyFormat(isNewFormat ? lastFormat : null);
        return null;
    }

    public static void applyStoplightFormat(GridViewCommon gridView, UIFormat uiFormat) {
        Discriminator qdrDisc = GridViewFormatUtils.getStoplightDiscriminator(gridView);
        uiFormat.setDiscriminator(qdrDisc);
        GridViewFormatUtils.getFormatModel(gridView).applyFormat(uiFormat);
    }

    public static void applyStoplightFormat(GridViewCommon gridView, UIFormat uiFormat, String badValue, String goodValue) {
        GridViewFormatUtils.applyStoplightFormat(gridView, uiFormat, badValue, goodValue, false);
    }

    public static void applyStoplightFormat(GridViewCommon gridView, UIFormat uiFormat, String badValue, String goodValue, boolean useDisc) {
        Discriminator qdrDisc;
        if (useDisc) {
            qdrDisc = uiFormat.getDiscriminator();
        } else {
            qdrDisc = GridViewFormatUtils.getStoplightDiscriminator(gridView);
            uiFormat.setDiscriminator(qdrDisc);
        }
        String[] datatypes = GridViewFormatUtils.getMeasureDatatypes(GridViewFormatUtils.getFormatModel(gridView), qdrDisc);
        GridViewFormatUtils._applyStoplightFormat(gridView, uiFormat, qdrDisc, datatypes, badValue, goodValue);
    }

    public static void applyStoplightFormat(GridViewCommon gridView, UIFormat uiFormat, String badValue, String goodValue, String memberID) {
        FormatModel formatModel = GridViewFormatUtils.getFormatModel(gridView);
        DimensionMetadata measureData = formatModel.getMeasureMetadata();
        ArrayList<String> midList = new ArrayList<String>();
        QDRDiscriminator qdrDisc = null;
        if (memberID == null || memberID.length() == 0) {
            qdrDisc = new QDRDiscriminator(new QDR(), 4);
        } else {
            String dimID = measureData.getDimID();
            qdrDisc = new QDRDiscriminator(new QDR(dimID, dimID, memberID), 4);
            midList.add(memberID);
        }
        uiFormat.setDiscriminator((Discriminator)qdrDisc);
        String[] datatypes = GridViewFormatUtils.getMeasureDatatypes(formatModel, measureData, midList);
        GridViewFormatUtils._applyStoplightFormat(gridView, uiFormat, (Discriminator)qdrDisc, datatypes, badValue, goodValue);
    }

    public static void _applyStoplightFormat(GridViewCommon gridView, UIFormat uiFormat, Discriminator qdrDisc, String[] dataTypes, String badValue, String goodValue) {
        Object[] values = new Object[2];
        String[] errors = GridViewFormatUtils.getFormatModel(gridView).validateValues(dataTypes, new String[]{badValue, goodValue}, values);
        ConditionElement condition = uiFormat.getValueCondition();
        if (qdrDisc instanceof QDRDiscriminator) {
            condition.setMeasure(((QDRDiscriminator)qdrDisc).getQDR().getMeasureDim());
        } else {
            condition.setMeasure(null);
        }
        condition.setBadThreshold(values[0]);
        condition.setGoodThreshold(values[1]);
        if (dataTypes[0].equals("Double")) {
            uiFormat.setNumberOrDateCategory(47);
        } else if (dataTypes[0].equals("Date")) {
            uiFormat.setNumberOrDateCategory(240);
        }
        GridViewFormatUtils.getFormatModel(gridView).applyFormat(uiFormat);
    }

    public static String[] getMeasureDatatypes(FormatModel formatModel, List conditionList) {
        if (conditionList != null) {
            DimensionMetadata measureMetadata = formatModel.getMeasureMetadata();
            ConditionElement condition = (ConditionElement)((Object)conditionList.get(measureMetadata.getDimIndex()));
            if (condition == null) {
                return null;
            }
            return GridViewFormatUtils.getMeasureDatatypes(formatModel, measureMetadata, condition.getSelectedMemberIDList());
        }
        return formatModel.getMeasureDatatypes();
    }

    public static String[] getMeasureDatatypes(FormatModel formatModel, Discriminator qdrDisc) {
        UIFormat format = UIFormat.createDefaultConditionalFormat();
        format.setDiscriminator(qdrDisc);
        List conditionList = format.getDimensionList(formatModel.getDimensionList());
        return GridViewFormatUtils.getMeasureDatatypes(formatModel, conditionList);
    }

    private static String[] getMeasureDatatypes(FormatModel formatModel, DimensionMetadata measureMetadata, List memberIDs) {
        int count = memberIDs.size();
        if (count == 0) {
            return formatModel.getMeasureDatatypes();
        }
        if (measureMetadata == null) {
            measureMetadata = formatModel.getMeasureMetadata();
        }
        String[] datatypes = new String[count];
        String[] typeForAll = new String[1];
        datatypes[0] = measureMetadata.getMemberDatatype((String)memberIDs.get(0));
        typeForAll[0] = datatypes[0];
        for (int i = 1; i < count; ++i) {
            datatypes[i] = measureMetadata.getMemberDatatype((String)memberIDs.get(i));
            if (typeForAll[0] == null || datatypes[i].equals(typeForAll[0])) continue;
            typeForAll[0] = null;
        }
        return typeForAll[0] == null ? datatypes : typeForAll;
    }

    protected static Discriminator getQDRDiscriminator(GridViewCommon gridView) {
        GridView _gridView = (GridView)gridView;
        ComponentHandle _handle = _gridView.getSelectedObject();
        ComponentInfo[] components = null;
        if (_handle instanceof DataComponentHandle || _handle instanceof RowComponentHandle || _handle instanceof ColumnComponentHandle) {
            components = new ComponentInfo[]{_handle.getComponentInfo()};
        } else if (_handle instanceof DataRangeComponentHandle) {
            components = ((DataRangeComponentHandle)_handle).getLocationList();
        } else if (_handle instanceof RowRangeComponentHandle) {
            components = ((RowRangeComponentHandle)_handle).getLocationList();
        } else if (_handle instanceof ColumnRangeComponentHandle) {
            components = ((ColumnRangeComponentHandle)_handle).getLocationList();
        }
        if (components == null) {
            return null;
        }
        DataAccess dataAccess = gridView.getModel().getDataAccess();
        Discriminator qdrDisc = GridViewFormatUtils.getCompositeDiscriminator(dataAccess, components);
        return qdrDisc;
    }

    public static List getMeasures(DataAccess dataAccess, String type) {
        ArrayList<Object> members = new ArrayList<Object>();
        try {
            for (int i = 0; i < dataAccess.getEdgeCount(); ++i) {
                int layerCount = dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    QDR qdr = dataAccess.getLayerQDR(i, j, 1);
                    String measure = qdr.getMeasureDim();
                    if (measure == null || measure == "") continue;
                    if (type == dimNameType) {
                        members.add(measure);
                        continue;
                    }
                    for (int k = 0; k < dataAccess.getEdgeCount(); ++k) {
                        int count = dataAccess.getLayerCount(k);
                        for (int l = 0; l < count; ++l) {
                            if (!dataAccess.getLayerMetadata(k, l, dimNameType).equals(measure)) continue;
                            members.add(dataAccess.getLayerMetadata(k, l, "dimShortName"));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return members;
    }

    private static Discriminator getCompositeDiscriminator(DataAccess dataAccess, ComponentInfo[] components) {
        Object qdrDisc = null;
        QDRDiscriminator qdrDisc1 = null;
        for (int c = 0; c < components.length; ++c) {
            ComponentInfo componentInfo = components[c];
            QDR qdr = componentInfo.getQDR(dataAccess, 0);
            qdrDisc1 = new QDRDiscriminator(qdr, 4);
            qdrDisc = qdrDisc == null ? qdrDisc1 : new CompositeDiscriminator((Discriminator)qdrDisc, (Discriminator)qdrDisc1, 1);
        }
        return qdrDisc;
    }

    private static boolean equalList(List first, List second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            Object firstelement = first.get(i);
            Object secondelement = second.get(i);
            if (firstelement != null && secondelement != null && firstelement.equals(secondelement)) continue;
            return false;
        }
        return true;
    }

    private static List getAllMembers(DataAccess dataAccess, int edge, int layer, int startslice, int endslice, int[] selectedData) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        ArrayList<Object> members = new ArrayList<Object>();
        while (startslice <= endslice) {
            int start = startslice;
            int end = startslice + dataAccess.getMemberExtent(edge, layer, startslice) - 1;
            boolean find = false;
            for (int j = 0; j < selectedData.length; ++j) {
                if (selectedData[j] < start || selectedData[j] > end) continue;
                find = true;
                break;
            }
            if (find && dataAccess.getMemberStartLayer(edge, layer, startslice) == layer) {
                Object member = dataAccess.getMemberMetadata(edge, layer, startslice, memberNameType);
                members.add(member);
            }
            startslice = end + 1;
        }
        return members;
    }

    public static String getColorValue(Color color) {
        int value = color.getRGB();
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        String poundStr = "#";
        StringBuffer buff = new StringBuffer(poundStr);
        buff.append(hexStr);
        return buff.toString();
    }
}

