/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.text.WrappedText;

public class GridViewWrappingTextPainter
extends TextPainter {
    private TextWrapper _wrapper;
    private WrappedText _wrappedText;

    public GridViewWrappingTextPainter() {
        this(WordWrapper.getTextWrapper());
    }

    public GridViewWrappingTextPainter(TextWrapper wrapper) {
        this._wrapper = wrapper;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        String text;
        FontMetrics metrics;
        int width = 0;
        int height = 0;
        Font font = context.getPaintFont();
        if (font != null && (metrics = context.getFontMetrics(font)) != null && (text = this.getStringData(context)) != null) {
            WrappedTextHandle handle = this.getWrappedTextHandle(text, availableWidth, metrics, context.getPaintLocale(), context, 0);
            WrappedText wrappedText = handle.wrappedText;
            availableWidth = handle.width;
            int numLines = wrappedText.getLineCount();
            width = numLines == 1 ? metrics.stringWidth(text) : availableWidth;
            height = numLines * metrics.getHeight() - metrics.getLeading();
        }
        return new Dimension(width, height);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int stringHeight;
        String text = this.getStringData(context);
        if (text == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        WrappedTextHandle handle = this.getWrappedTextHandle(text, width, metrics, context.getPaintLocale(), context, x);
        WrappedText wrappedText = handle.wrappedText;
        width = handle.width;
        x = handle.x;
        int numLines = wrappedText.getLineCount();
        float alignmentX = context.getInteriorAlignmentX();
        float alignmentY = context.getInteriorAlignmentY();
        int bottom = y + height - 1;
        if (alignmentY != 0.0f && (stringHeight = numLines * metrics.getHeight()) < height) {
            y = (int)((float)y + (float)(height - stringHeight) * alignmentY);
        }
        y += metrics.getAscent();
        int lineHeight = metrics.getHeight();
        for (int i = 0; i < numLines; ++i) {
            String lineText = wrappedText.getLine(i);
            if (y + lineHeight > bottom && i < numLines - 1) {
                lineText = this.getPaintText(context, lineText + wrappedText.getLine(i + 1), metrics, width);
            }
            this.paintText(context, g, metrics, lineText, x, y, width, alignmentX, -1);
            if ((y += lineHeight) > bottom) break;
        }
    }

    protected synchronized WrappedText _getWrappedText(String text, int width, FontMetrics metrics, Locale locale) {
        WrappedText wrappedText = this._wrappedText;
        if (wrappedText == null || wrappedText.getWrapWidth() != width || wrappedText.getText() != text || wrappedText.getFontMetrics() != metrics) {
            this._wrappedText = wrappedText = new WrappedText(text, this._wrapper, width, metrics, locale, false);
        }
        return wrappedText;
    }

    protected WrappedTextHandle getWrappedTextHandle(String text, int width, FontMetrics metrics, Locale locale, PaintContext context, int x) {
        return new WrappedTextHandle(x, width, this._getWrappedText(text, width, metrics, locale));
    }

    protected class WrappedTextHandle {
        public int x = 0;
        public int width = 0;
        public WrappedText wrappedText = null;

        public WrappedTextHandle(int x, int width, WrappedText wrappedText) {
            this.x = x;
            this.width = width;
            this.wrappedText = wrappedText;
        }
    }
}

