/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import oracle.ide.print.api.PrintPage;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.print.core.Graphix;
import oracle.ide.print.core.edit.Page;
import oracle.ide.print.core.edit.Provider;
import oracle.ide.print.misc.Util;

public final class Factory
extends PrintProvider.Factory {
    @Override
    public PrintProvider[] createProviders(Object[] editor, Component top, String name, Object[][] selection) {
        if (editor != null) {
            return new PrintProvider[]{this.createProvider(editor, name)};
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList<Component> components = new ArrayList<Component>();
        this.findObjectComponent(top, objects, components);
        if (!objects.isEmpty() || !components.isEmpty()) {
            return this.createProviders(name, objects, components);
        }
        PrintProvider[] providers = this.createProviders(selection);
        if (providers != null) {
            return providers;
        }
        return this.createProviders(this.getDefaultPrintComponent(top), name);
    }

    @Override
    public PrintProvider[] createProviders(Pageable pageable) {
        ArrayList<PrintProvider> providers = new ArrayList<PrintProvider>();
        int i = 0;
        while (true) {
            try {
                PrintProvider[] printables;
                for (PrintProvider provider : printables = this.createProviders(pageable.getPrintable(i))) {
                    providers.add(provider);
                }
            }
            catch (IndexOutOfBoundsException expected) {
                break;
            }
            ++i;
        }
        return this.toArray(providers);
    }

    @Override
    public PrintProvider[] createProviders(Printable printable) {
        int width = Util.getConfig().getPageWidth();
        int height = Util.getConfig().getPageHeight();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(width, height);
        paper.setImageableArea(0.0, 0.0, width, height);
        pageFormat.setPaper(paper);
        Dimension size = new Dimension(width, height);
        ArrayList<Page> pages = new ArrayList<Page>();
        int index = 0;
        try {
            Graphics g;
            Graphix graphix;
            while (printable.print(graphix = new Graphix((Graphics2D)(g = new BufferedImage(width, height, 1).getGraphics()).create(0, 0, width, height)), pageFormat, index++) != 1) {
                graphix.dispose();
                pages.add(new Page(graphix, size));
            }
        }
        catch (PrinterException g) {
            // empty catch block
        }
        PrintProvider[] providers = new PrintProvider[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            providers[i] = new oracle.ide.print.core.comp.Provider((PrintPage)pages.get(i));
        }
        return providers;
    }

    private void findObjectComponent(Component top, List<Object> objects, List<Component> components) {
        Component[] children;
        Object object = null;
        if (top instanceof JComponent) {
            object = ((JComponent)top).getClientProperty("print.printable");
        }
        if (object == Boolean.FALSE || Boolean.FALSE.toString().equals(object)) {
            return;
        }
        if (object == Boolean.TRUE || Boolean.TRUE.toString().equals(object)) {
            components.add(top);
        } else if (object instanceof Component) {
            Component component = (Component)object;
            component.validate();
            components.add(component);
        } else if (object != null) {
            objects.add(object);
        } else if (top instanceof PrintProvider || top instanceof Pageable || top instanceof PrintProvider.Text || top instanceof Printable) {
            objects.add(top);
        }
        if (!(top instanceof Container)) {
            return;
        }
        for (Component child : children = ((Container)top).getComponents()) {
            if (!(child instanceof Container)) continue;
            this.findObjectComponent(child, objects, components);
        }
    }

    private PrintProvider[] createProviders(String name, List<Object> objects, List<Component> components) {
        ArrayList<PrintProvider> providers = new ArrayList<PrintProvider>();
        for (Object object : objects) {
            PrintProvider[] list;
            for (PrintProvider provider : list = this.createProviders(object, name)) {
                providers.add(provider);
            }
        }
        providers.add(new oracle.ide.print.core.comp.Provider(components, name));
        return this.toArray(providers);
    }

    private PrintProvider[] createProviders(Object object, String name) {
        PrintProvider provider = null;
        if (object instanceof PrintProvider) {
            provider = (PrintProvider)object;
        } else if (object instanceof PrintProvider.Text) {
            provider = new oracle.ide.print.core.text.Provider(((PrintProvider.Text)object).getText(), name);
        } else {
            if (object instanceof Pageable) {
                return this.createProviders((Pageable)object);
            }
            if (object instanceof Printable) {
                return this.createProviders((Printable)object);
            }
            if (object instanceof char[]) {
                provider = new oracle.ide.print.core.text.Provider((char[])object, name);
            } else if (object instanceof String) {
                provider = new oracle.ide.print.core.text.Provider((String)object, name);
            } else if (object instanceof Component) {
                provider = new oracle.ide.print.core.comp.Provider((Component)object, name);
            }
        }
        if (provider != null) {
            return new PrintProvider[]{provider};
        }
        return new PrintProvider[0];
    }

    private PrintProvider createProvider(Object[] editor, String name) {
        int i = 0;
        return new Provider(name, (Component)editor[i++], (Component)editor[i++], (char[])editor[i++], (int[])editor[i++], (Color[])editor[i++], (Integer)editor[i++], (Integer)editor[i++]);
    }

    private PrintProvider[] createProviders(Object[][] selection) {
        ArrayList<PrintProvider> providers = new ArrayList<PrintProvider>();
        for (Object[] object : selection) {
            PrintProvider[] list;
            for (PrintProvider provider : list = this.createProviders(object[0], (String)object[1])) {
                providers.add(provider);
            }
        }
        if (providers.isEmpty()) {
            return null;
        }
        return this.toArray(providers);
    }

    private Component getDefaultPrintComponent(Component top) {
        Component tab;
        Component view;
        Component component = this.findTabOrViewport(top);
        if (component == null) {
            Component content = this.findContentWithScrollBars(top);
            if (content != null) {
                return content;
            }
            return top;
        }
        if (component instanceof JViewport && (view = ((JViewport)component).getView()) != null) {
            return view;
        }
        if (component instanceof JTabbedPane && (tab = ((JTabbedPane)component).getSelectedComponent()) != null) {
            return tab;
        }
        return component;
    }

    private Component findTabOrViewport(Component top) {
        Component[] components;
        if (top instanceof JViewport || top instanceof JTabbedPane) {
            return top;
        }
        if (!(top instanceof Container)) {
            return null;
        }
        for (Component c : components = ((Container)top).getComponents()) {
            Component component = this.findTabOrViewport(c);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    private Component findContentWithScrollBars(Component top) {
        Component[] components;
        if (!(top instanceof Container)) {
            return null;
        }
        Container container = (Container)top;
        Component content = this.getContent(container);
        if (content != null) {
            return content;
        }
        for (Component component : components = container.getComponents()) {
            content = this.findContentWithScrollBars(component);
            if (content == null) continue;
            return content;
        }
        return null;
    }

    private Component getContent(Container container) {
        Component[] components = container.getComponents();
        if (components.length != 3) {
            return null;
        }
        if (components[1] instanceof JScrollBar && components[2] instanceof JScrollBar) {
            return components[0];
        }
        if (components[0] instanceof JScrollBar && components[2] instanceof JScrollBar) {
            return components[1];
        }
        if (components[0] instanceof JScrollBar && components[1] instanceof JScrollBar) {
            return components[2];
        }
        return null;
    }

    private PrintProvider[] toArray(List<PrintProvider> providers) {
        return providers.toArray(new PrintProvider[providers.size()]);
    }

    private void show(Component top) {
        int i = 256;
        while (--i > 0) {
            Util.out();
        }
        Util.out("----------------------------------------");
        Util.out();
        this.show(top, "    ");
    }

    private void show(Component top, String indent) {
        Component[] components;
        String str = top.isShowing() ? " [[" : "  ";
        str = str + indent + top.getClass().getName() + ", " + top.hashCode();
        if (top.hasFocus()) {
            str = "!! FOCUS !! " + str;
        }
        Util.out(str);
        if (!(top instanceof Container)) {
            return;
        }
        for (Component component : components = ((Container)top).getComponents()) {
            this.show(component, "    " + indent);
        }
    }
}

